/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.webservice;

import com.jinfonet.dataservice.api.wsdl20.Binding;
import com.jinfonet.dataservice.api.wsdl20.BindingFault;
import com.jinfonet.dataservice.api.wsdl20.BindingOperation;
import com.jinfonet.dataservice.schema.relational.datasource.webservice.BindingFaultImpl;
import com.jinfonet.dataservice.schema.relational.datasource.webservice.BindingImpl;
import com.jinfonet.dataservice.schema.relational.datasource.webservice.BindingOperationImpl;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Vector;
import javax.xml.namespace.QName;
import jet.controls.JetString;
import jet.log.JRLogger;
import jet.universe.JetUResourceContainer;
import jet.universe.webservice.JetUBindingFault;
import jet.universe.webservice.JetUBindingOperation;
import jet.universe.webservice.JetUQName;
import jet.util.HashVector;

public class JetUBinding
extends JetUResourceContainer {
    public JetUQName qName = new JetUQName(this, "QName");
    public JetUQName refInterface = new JetUQName(this, "RefInterface");
    public JetString uri = new JetString(this, "URI");
    public JetString soapVersion = new JetString(this, "SoapVersion");
    private static JRLogger logger = JRLogger.getLogger(JetUBinding.class.getName());

    public JetUBinding() {
    }

    public JetUBinding(Binding binding) {
        super(binding.getName().getLocalPart(), "");
        this.setBinding(binding);
    }

    public Binding getBinding() {
        Vector children = this.getChildren();
        Vector<BindingFault> bindFaults = new Vector<BindingFault>();
        Vector<BindingOperation> bindingOPs = new Vector<BindingOperation>();
        for (int i = 0; i < children.size(); ++i) {
            if (children.get(i) instanceof JetUBindingFault) {
                JetUBindingFault jBindFault = (JetUBindingFault)children.get(i);
                BindingFault bindfault = jBindFault.getBindingFault();
                bindFaults.add(bindfault);
                continue;
            }
            if (!(children.get(i) instanceof JetUBindingOperation)) continue;
            JetUBindingOperation jBindOp = (JetUBindingOperation)children.get(i);
            BindingOperation bindOP = jBindOp.getBindingOperation();
            bindingOPs.add(bindOP);
        }
        BindingFaultImpl[] bindFaultImpls = new BindingFaultImpl[bindFaults.size()];
        bindFaults.toArray(bindFaultImpls);
        BindingOperationImpl[] bindOPImpls = new BindingOperationImpl[bindingOPs.size()];
        bindingOPs.toArray(bindOPImpls);
        BindingImpl bind = new BindingImpl();
        bind.setBindingFaults(bindFaultImpls);
        bind.setBindingOperations(bindOPImpls);
        bind.setInterfaceName(this.refInterface.get());
        bind.setName(this.getQName());
        bind.setType(this.getUri());
        bind.setSoapVersion(this.getSoapVersion());
        return bind;
    }

    public void setBinding(Binding binding) {
        BindingFault[] bindingFault = binding.getBindingFaults();
        for (int i = 0; i < bindingFault.length; ++i) {
            JetUBindingFault jBindingFault = new JetUBindingFault(bindingFault[i]);
            this.add(jBindingFault);
        }
        BindingOperation[] bindingOp = binding.getBindingOperations();
        for (int i = 0; i < bindingOp.length; ++i) {
            JetUBindingOperation jBindingOp = new JetUBindingOperation(bindingOp[i]);
            this.add(jBindingOp);
        }
        this.setQName(binding.getName());
        this.setUri(binding.getType());
        this.setRefInterface(binding.getInterface().getName());
        this.setSoapVersion(binding.getSoapVersion());
    }

    public QName getQName() {
        return this.qName.get();
    }

    public void setQName(QName name2) {
        this.qName.set(name2);
    }

    public URI getUri() {
        String strURI = this.uri.get();
        URI resultURI = null;
        try {
            resultURI = new URI(strURI);
        }
        catch (URISyntaxException e) {
            logger.debug("Create uri error by string " + strURI + "\n" + e);
        }
        return resultURI;
    }

    public void setUri(URI uri) {
        this.uri.set(uri.toString());
    }

    public QName getRefInterface() {
        return this.refInterface.get();
    }

    public void setRefInterface(QName refInterface) {
        this.refInterface.set(refInterface);
    }

    public String getSoapVersion() {
        return this.soapVersion.get();
    }

    public void setSoapVersion(String soapVersion) {
        this.soapVersion.set(soapVersion);
    }

    @Override
    public String getInstancePrefix() {
        return "Binding";
    }

    @Override
    public HashVector getPropertyGroups() {
        return new HashVector(0);
    }
}

