/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.webservice;

import com.jinfonet.dataservice.api.wsdl20.Binding;
import com.jinfonet.dataservice.api.wsdl20.Description;
import com.jinfonet.dataservice.api.wsdl20.Interface;
import com.jinfonet.dataservice.api.wsdl20.Service;
import com.jinfonet.dataservice.schema.relational.datasource.webservice.BindingImpl;
import com.jinfonet.dataservice.schema.relational.datasource.webservice.DescriptionImpl;
import com.jinfonet.dataservice.schema.relational.datasource.webservice.InterfaceImpl;
import com.jinfonet.dataservice.schema.relational.datasource.webservice.ServiceImpl;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Vector;
import javax.xml.namespace.QName;
import jet.controls.JetString;
import jet.controls.JetVector;
import jet.log.JRLogger;
import jet.universe.JetUResourceContainer;
import jet.universe.webservice.JetUBinding;
import jet.universe.webservice.JetUInterface;
import jet.universe.webservice.JetUService;
import jet.util.HashVector;

public class JetUDescription
extends JetUResourceContainer {
    public JetVector xmlschemas = new JetVector(this, "XMLSchemas");
    public JetString fTargetNamespace = new JetString(this, "TargetNamespace");
    private Description description;
    private static JRLogger logger = JRLogger.getLogger(JetUDescription.class.getName());

    public JetUDescription() {
    }

    public JetUDescription(Description descreption) {
        this.setDescription(descreption);
    }

    public Description getDescription() {
        if (this.description != null) {
            return this.description;
        }
        Vector<Service> services = new Vector<Service>();
        Vector<Binding> bindings = new Vector<Binding>();
        Vector<Interface> interfaces = new Vector<Interface>();
        Vector ch = this.getChildren();
        int size = ch.size();
        for (int i = 0; i < size; ++i) {
            Object c = ch.get(i);
            if (c instanceof JetUService) {
                services.add(((JetUService)c).getService());
                continue;
            }
            if (c instanceof JetUBinding) {
                bindings.add(((JetUBinding)c).getBinding());
                continue;
            }
            if (!(c instanceof JetUInterface)) continue;
            interfaces.add(((JetUInterface)c).getInterface());
        }
        ServiceImpl[] ss = new ServiceImpl[services.size()];
        services.toArray(ss);
        BindingImpl[] binds = new BindingImpl[bindings.size()];
        bindings.toArray(binds);
        InterfaceImpl[] theInterface = new InterfaceImpl[interfaces.size()];
        interfaces.toArray(theInterface);
        String[] schemas = this.getStrXmlschemas();
        DescriptionImpl ret = new DescriptionImpl();
        ret.setServices(ss);
        ret.setBindings(binds);
        ret.setInterfaces(theInterface);
        ret.setStrXmlSchemas(schemas);
        ret.setTargetNamespace(this.getFTargetNamespace());
        this.description = ret;
        return ret;
    }

    public void setDescription(Description desc) {
        Service[] ss = desc.getServices();
        for (int i = 0; i < ss.length; ++i) {
            JetUService js = new JetUService(ss[i]);
            this.add(js);
        }
        Binding[] bindings = desc.getBindings();
        for (int i = 0; i < bindings.length; ++i) {
            JetUBinding jbinding = new JetUBinding(bindings[i]);
            this.add(jbinding);
        }
        Interface[] interfaces = desc.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            JetUInterface jInterface = new JetUInterface(interfaces[i]);
            this.add(jInterface);
        }
        String[] strSchemas = desc.getStrXmlSchemas();
        this.setXmlschemas(strSchemas);
        this.setFTargetNamespace(desc.getTargetNamespace());
        this.description = desc;
    }

    public String[] getStrXmlschemas() {
        String[] tempXmlSchemas = this.xmlschemas.toStringArray();
        int size = tempXmlSchemas.length;
        String[] strSchemas = new String[size];
        for (int i = 0; i < size; ++i) {
            strSchemas[i] = tempXmlSchemas[i];
        }
        return strSchemas;
    }

    public void setXmlschemas(String[] strschemas) {
        for (int i = 0; i < strschemas.length; ++i) {
            this.xmlschemas.add(strschemas[i]);
        }
    }

    public Vector getServices() {
        Vector children = this.getChildren();
        Vector<JetUService> services = new Vector<JetUService>();
        for (int i = 0; i < children.size(); ++i) {
            if (!(children.get(i) instanceof JetUService)) continue;
            JetUService jService = (JetUService)children.get(i);
            services.add(jService);
        }
        return services;
    }

    public JetUInterface getInterface(QName interfaceName) {
        Vector children = this.getChildren();
        JetUInterface resultInterface = null;
        for (int i = 0; i < children.size(); ++i) {
            JetUInterface jInterface;
            if (!(children.get(i) instanceof JetUInterface) || !(jInterface = (JetUInterface)children.get(i)).getQName().equals(interfaceName)) continue;
            resultInterface = jInterface;
        }
        return resultInterface;
    }

    public URI getFTargetNamespace() {
        URI targetNS = null;
        try {
            targetNS = new URI(this.fTargetNamespace.get());
        }
        catch (URISyntaxException e) {
            logger.debug("New URI with " + this.fTargetNamespace.get() + " error.");
        }
        return targetNS;
    }

    public void setFTargetNamespace(URI targetNamespace) {
        this.fTargetNamespace.set(targetNamespace.toString());
    }

    @Override
    public String getInstancePrefix() {
        return "WebServiceDescription";
    }

    @Override
    public HashVector getPropertyGroups() {
        return new HashVector(0);
    }
}

