/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.webservice;

import com.jinfonet.dataservice.api.wsdl20.InterfaceFaultReference;
import com.jinfonet.dataservice.api.wsdl20.InterfaceMessageReference;
import com.jinfonet.dataservice.api.wsdl20.InterfaceOperation;
import com.jinfonet.dataservice.schema.relational.datasource.webservice.InterfaceFaultReferenceImpl;
import com.jinfonet.dataservice.schema.relational.datasource.webservice.InterfaceMessageReferenceImpl;
import com.jinfonet.dataservice.schema.relational.datasource.webservice.InterfaceOperationImpl;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Vector;
import javax.xml.namespace.QName;
import jet.controls.JetString;
import jet.controls.JetVector;
import jet.log.JRLogger;
import jet.universe.JetUResourceContainer;
import jet.universe.webservice.JetUInterfaceFaultReference;
import jet.universe.webservice.JetUInterfaceMessageReference;
import jet.universe.webservice.JetUQName;
import jet.util.HashVector;

public class JetUInterfaceOperation
extends JetUResourceContainer {
    public JetUQName qName = new JetUQName(this, "QName");
    public JetString messageExchangePatternURI = new JetString(this, "MessageExchangePatternURI");
    public JetVector styleURIs = new JetVector(this, "StyleURIs");
    private static JRLogger logger = JRLogger.getLogger(JetUInterfaceOperation.class.getName());

    public JetUInterfaceOperation() {
    }

    public JetUInterfaceOperation(InterfaceOperation interfaceOperation) {
        this.setInterfaceOperation(interfaceOperation);
    }

    public InterfaceOperation getInterfaceOperation() {
        Vector children = this.getChildren();
        Vector<InterfaceFaultReference> interfaceFRV = new Vector<InterfaceFaultReference>();
        Vector<InterfaceMessageReference> interfaceMRV = new Vector<InterfaceMessageReference>();
        for (int i = 0; i < children.size(); ++i) {
            if (children.get(i) instanceof JetUInterfaceFaultReference) {
                JetUInterfaceFaultReference jInterfaceFR = (JetUInterfaceFaultReference)children.get(i);
                interfaceFRV.add(jInterfaceFR.getInterfaceFaultReference());
            }
            if (!(children.get(i) instanceof JetUInterfaceMessageReference)) continue;
            JetUInterfaceMessageReference jInterfaceMR = (JetUInterfaceMessageReference)children.get(i);
            interfaceMRV.add(jInterfaceMR.getInterfaceMessageReference());
        }
        InterfaceFaultReferenceImpl[] interfaceFRArray = new InterfaceFaultReferenceImpl[interfaceFRV.size()];
        interfaceFRV.toArray(interfaceFRArray);
        InterfaceMessageReferenceImpl[] interfaceMRArray = new InterfaceMessageReferenceImpl[interfaceMRV.size()];
        interfaceMRV.toArray(interfaceMRArray);
        InterfaceOperationImpl interfaceOpImpl = new InterfaceOperationImpl();
        interfaceOpImpl.setInterfaceFaultReferences(interfaceFRArray);
        interfaceOpImpl.setInterfaceMessageReferences(interfaceMRArray);
        interfaceOpImpl.setName(this.getQName());
        interfaceOpImpl.setStyle(this.getStyleUris());
        interfaceOpImpl.setMessageExchangePattern(this.getMessageExchangePatternURI());
        return interfaceOpImpl;
    }

    public void setInterfaceOperation(InterfaceOperation interfaceOperation) {
        InterfaceFaultReference[] interfaceFRs = interfaceOperation.getInterfaceFaultReferences();
        for (int i = 0; i < interfaceFRs.length; ++i) {
            JetUInterfaceFaultReference jInterfaceFR = new JetUInterfaceFaultReference(interfaceFRs[i]);
            this.add(jInterfaceFR);
        }
        InterfaceMessageReference[] interfaceMRS = interfaceOperation.getInterfaceMessageReferences();
        for (int i = 0; i < interfaceMRS.length; ++i) {
            JetUInterfaceMessageReference jInterfaceMR = new JetUInterfaceMessageReference(interfaceMRS[i]);
            this.add(jInterfaceMR);
        }
        this.setMessageExchangePatternURI(interfaceOperation.getMessageExchangePattern());
        this.setQName(interfaceOperation.getName());
        this.setStyleURIs(interfaceOperation.getStyle());
    }

    public QName getQName() {
        return this.qName.get();
    }

    public void setQName(QName name2) {
        this.qName.set(name2);
    }

    public URI getMessageExchangePatternURI() {
        URI theURI = null;
        try {
            theURI = new URI(this.messageExchangePatternURI.get());
        }
        catch (URISyntaxException e) {
            logger.debug("Create uri error." + e);
        }
        return theURI;
    }

    public void setMessageExchangePatternURI(URI messageExchangePatternURI) {
        this.messageExchangePatternURI.set(messageExchangePatternURI.toString());
    }

    public URI[] getStyleUris() {
        URI newURI = null;
        Vector<URI> urisv = new Vector<URI>();
        String[] tempStrURI = this.styleURIs.toStringArray();
        int size = tempStrURI.length;
        for (int i = 0; i < size; ++i) {
            try {
                newURI = new URI(tempStrURI[i]);
            }
            catch (URISyntaxException e) {
                logger.debug("Create URI error.\n" + e);
            }
            urisv.add(newURI);
        }
        URI[] theURISArray = new URI[size];
        urisv.toArray(theURISArray);
        return theURISArray;
    }

    public void setStyleURIs(URI[] theURIs) {
        for (int i = 0; i < theURIs.length; ++i) {
            this.styleURIs.add(theURIs[i].toString());
        }
    }

    @Override
    public String getInstancePrefix() {
        return "InterfaceOperation";
    }

    public Vector<JetUInterfaceFaultReference> getAllInterfaceFaultRefs() {
        Vector<JetUInterfaceFaultReference> faults = new Vector<JetUInterfaceFaultReference>();
        Vector children = this.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            if (!(children.get(i) instanceof JetUInterfaceFaultReference)) continue;
            JetUInterfaceFaultReference childFault = (JetUInterfaceFaultReference)children.get(i);
            faults.add(childFault);
        }
        return faults;
    }

    public Vector<JetUInterfaceMessageReference> getAllInterfaceMessageRefs() {
        Vector<JetUInterfaceMessageReference> messageRefs = new Vector<JetUInterfaceMessageReference>();
        Vector children = this.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            if (!(children.get(i) instanceof JetUInterfaceMessageReference)) continue;
            JetUInterfaceMessageReference childMR = (JetUInterfaceMessageReference)children.get(i);
            messageRefs.add(childMR);
        }
        return messageRefs;
    }

    @Override
    public HashVector getPropertyGroups() {
        return new HashVector(0);
    }
}

