/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.webservice;

import com.jinfonet.dataservice.api.wsdl20.Endpoint;
import com.jinfonet.dataservice.api.wsdl20.Service;
import com.jinfonet.dataservice.schema.relational.datasource.webservice.EndpointImpl;
import com.jinfonet.dataservice.schema.relational.datasource.webservice.ServiceImpl;
import java.util.Vector;
import javax.xml.namespace.QName;
import jet.log.JRLogger;
import jet.universe.JetUResourceContainer;
import jet.universe.webservice.JetUDescription;
import jet.universe.webservice.JetUEndPoint;
import jet.universe.webservice.JetUInterface;
import jet.universe.webservice.JetUInterfaceOperation;
import jet.universe.webservice.JetUQName;
import jet.util.HashVector;

public class JetUService
extends JetUResourceContainer {
    public JetUQName qName = new JetUQName(this, "QName");
    public JetUQName refInterface = new JetUQName(this, "RefInterface");
    private static JRLogger logger = JRLogger.getLogger(JetUService.class.getName());

    public JetUService() {
    }

    public JetUService(Service ser) {
        super(ser.getName().getLocalPart(), "");
        this.setService(ser);
    }

    public Service getService() {
        Vector children = this.getChildren();
        Vector<Endpoint> endPointV = new Vector<Endpoint>();
        for (int i = 0; i < children.size(); ++i) {
            if (!(children.get(i) instanceof JetUEndPoint)) continue;
            JetUEndPoint jEndPoint = (JetUEndPoint)children.get(i);
            endPointV.add(jEndPoint.getEndPoint());
        }
        EndpointImpl[] endPointArray = new EndpointImpl[endPointV.size()];
        endPointV.toArray(endPointArray);
        ServiceImpl service = new ServiceImpl();
        service.setEndpoints(endPointArray);
        service.setName(this.getQName());
        service.setInterfaceName(this.getRefInterface());
        return service;
    }

    public void setService(Service service) {
        Endpoint[] endPoints = service.getEndpoints();
        for (int i = 0; i < endPoints.length; ++i) {
            JetUEndPoint jEndPoint = new JetUEndPoint(endPoints[i]);
            this.add(jEndPoint);
        }
        this.setRefInterface(service.getInterface().getName());
        this.setQName(service.getName());
    }

    public Vector<JetUInterfaceOperation> getRelatedOperations() {
        Vector<JetUInterfaceOperation> interfaceOPs = new Vector();
        JetUDescription desc = (JetUDescription)this.getParent();
        JetUInterface theInterface = desc.getInterface(this.getRefInterface());
        interfaceOPs = theInterface.getInterfaceOperations();
        return interfaceOPs;
    }

    public QName getRefInterface() {
        return this.refInterface.get();
    }

    public void setRefInterface(QName refInterface) {
        this.refInterface.set(refInterface);
    }

    public QName getQName() {
        return this.qName.get();
    }

    public void setQName(QName name2) {
        this.qName.set(name2);
    }

    @Override
    public String getInstancePrefix() {
        return "Service";
    }

    @Override
    public HashVector getPropertyGroups() {
        return new HashVector(0);
    }
}

