/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.webservice.policy;

import com.jinfonet.webservice.policy.All;
import com.jinfonet.webservice.policy.Assertion;
import com.jinfonet.webservice.policy.AssertionParameter;
import com.jinfonet.webservice.policy.ExactlyOne;
import com.jinfonet.webservice.policy.Policy;
import com.jinfonet.webservice.policy.PolicyComponent;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.xml.namespace.QName;
import jet.controls.JetBoolean;
import jet.controls.JetString;
import jet.controls.JetVector;
import jet.universe.webservice.JetUQName;
import jet.universe.webservice.policy.JetUAssertionParameter;
import jet.universe.webservice.policy.JetUExactlyOne;
import jet.universe.webservice.policy.JetUPolicy;
import jet.universe.webservice.policy.JetUPolicyAll;
import jet.universe.webservice.policy.JetUPolicyComponent;

public class JetUAssertion
extends JetUPolicyComponent {
    public JetUQName qName = new JetUQName(this, "QName");
    public JetString value = new JetString(this, "Value");
    public JetBoolean optional = new JetBoolean(this, "Optional");
    public JetBoolean ignorable = new JetBoolean(this, "Ignorable");
    public JetVector attributesQName = new JetVector(this, "AttributesQName");
    public JetVector attributesValue = new JetVector(this, "AttributesValue");

    public JetUAssertion() {
    }

    public JetUAssertion(Assertion assertion) {
        this.setAssertion(assertion);
    }

    public Assertion getAssertion() {
        Map<QName, String> attributes = this.getAttributesInfo();
        Assertion ass = new Assertion(this.getQName(), this.getValue(), attributes, this.getOptional(), this.getIgnorable());
        Vector children = this.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            JetUPolicyComponent upc = (JetUPolicyComponent)children.get(i);
            if (upc instanceof JetUPolicyAll) {
                JetUPolicyAll uAll = (JetUPolicyAll)upc;
                All all = uAll.getAll();
                ass.addSubComponent(all);
                continue;
            }
            if (upc instanceof JetUExactlyOne) {
                JetUExactlyOne uExactlyOne = (JetUExactlyOne)upc;
                ExactlyOne exactlyOne = uExactlyOne.getExactlyOne();
                ass.addSubComponent(exactlyOne);
                continue;
            }
            if (upc instanceof JetUAssertionParameter) {
                JetUAssertionParameter uAssParam = (JetUAssertionParameter)upc;
                AssertionParameter assParam = uAssParam.getAssertionParam();
                ass.addSubComponent(assParam);
                continue;
            }
            if (upc instanceof JetUAssertion) {
                JetUAssertion uAssertion = (JetUAssertion)upc;
                Assertion subAss = uAssertion.getAssertion();
                ass.addSubComponent(subAss);
                continue;
            }
            if (!(upc instanceof JetUPolicy)) continue;
            JetUPolicy uPolicy = (JetUPolicy)upc;
            Policy policy = uPolicy.getPolicy();
            ass.addSubComponent(policy);
        }
        return ass;
    }

    public void setAssertion(Assertion assertion) {
        this.setType(assertion.getComponentType());
        this.setQName(assertion.getName());
        this.setOptional(assertion.isOptional());
        this.setIgnorable(assertion.isIgnorable());
        this.setValue(assertion.getValue());
        this.setAttributesInfo(assertion.getAttributes());
        this.setPolicyComponent(assertion);
    }

    public void setSubComponent(Collection<PolicyComponent> subComs) {
        if (subComs.size() != 0) {
            for (PolicyComponent pc : subComs) {
                this.setPolicyComponent(pc);
            }
        }
    }

    private void setAttributesInfo(Map<QName, String> attributes) {
        if (!attributes.isEmpty()) {
            Set<QName> attQName = attributes.keySet();
            for (QName attributeName : attQName) {
                JetUQName uQName = new JetUQName();
                uQName.set(attributeName);
                this.setAttributesQName(uQName.toString());
            }
            Collection<String> attValue = attributes.values();
            for (String value : attValue) {
                this.setAttributesValue(value);
            }
        }
    }

    protected Map<QName, String> getAttributesInfo() {
        int valueSize;
        int keySize = this.getAttributesQName().size();
        if (keySize != (valueSize = this.getAttributesValue().size())) {
            return null;
        }
        HashMap<QName, String> attributes = new HashMap<QName, String>();
        for (int i = 0; i < keySize; ++i) {
            String strQName = (String)this.getAttributesQName().get(i);
            JetUQName uQName = new JetUQName();
            uQName.set(strQName);
            QName qName = uQName.get();
            String value = this.getAttributesValue().get(i).toString();
            attributes.put(qName, value);
        }
        return attributes;
    }

    public QName getQName() {
        return this.qName.get();
    }

    public void setQName(QName name2) {
        this.qName.set(name2);
    }

    public String getValue() {
        return this.value.get();
    }

    public void setValue(String value) {
        this.value.set(value);
    }

    public boolean getOptional() {
        return this.optional.get();
    }

    public void setOptional(boolean optional) {
        this.optional.set(optional);
    }

    public boolean getIgnorable() {
        return this.ignorable.get();
    }

    public void setIgnorable(boolean ignorable) {
        this.ignorable.set(ignorable);
    }

    public Vector getAttributesQName() {
        return this.attributesQName.get();
    }

    public void setAttributesQName(String attributesQName) {
        this.attributesQName.set(attributesQName);
    }

    public Vector getAttributesValue() {
        return this.attributesValue.get();
    }

    public void setAttributesValue(String attributesValue) {
        this.attributesValue.set(attributesValue);
    }

    @Override
    public String getInstancePrefix() {
        return "Assertion";
    }
}

