/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.webservice.policy;

import com.jinfonet.webservice.policy.All;
import com.jinfonet.webservice.policy.Assertion;
import com.jinfonet.webservice.policy.AssertionParameter;
import com.jinfonet.webservice.policy.ExactlyOne;
import com.jinfonet.webservice.policy.Policy;
import com.jinfonet.webservice.policy.PolicyComponent;
import com.jinfonet.webservice.policy.wspolicy.NamespaceVersion;
import java.util.Collection;
import java.util.Vector;
import jet.controls.JetString;
import jet.universe.webservice.policy.JetUAssertion;
import jet.universe.webservice.policy.JetUAssertionParameter;
import jet.universe.webservice.policy.JetUExactlyOne;
import jet.universe.webservice.policy.JetUPolicyAll;
import jet.universe.webservice.policy.JetUPolicyComponent;

public class JetUPolicy
extends JetUPolicyComponent {
    public JetString policyId = new JetString(this, "PolicyID");
    public JetString name = new JetString(this, "Name");
    public JetString namespaceVersion = new JetString(this, "NamespaceVersion");

    public JetUPolicy() {
    }

    public JetUPolicy(Policy po) {
        this.setPolicy(po);
    }

    public Policy getPolicy() {
        String policyID = this.getPolicyId();
        String name2 = this.getName();
        NamespaceVersion nsVersion = NamespaceVersion.resolveVersion(this.getNamespaceVersion());
        Policy policy = new Policy(policyID, name2, nsVersion);
        Vector children = this.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            JetUPolicyComponent upc = (JetUPolicyComponent)children.get(i);
            if (upc instanceof JetUPolicyAll) {
                JetUPolicyAll uAll = (JetUPolicyAll)upc;
                All all = uAll.getAll();
                policy.addSubComponent(all);
                continue;
            }
            if (upc instanceof JetUExactlyOne) {
                JetUExactlyOne uExactlyOne = (JetUExactlyOne)upc;
                ExactlyOne exactlyOne = uExactlyOne.getExactlyOne();
                policy.addSubComponent(exactlyOne);
                continue;
            }
            if (upc instanceof JetUAssertionParameter) {
                JetUAssertionParameter uAssParam = (JetUAssertionParameter)upc;
                AssertionParameter assParam = uAssParam.getAssertionParam();
                policy.addSubComponent(assParam);
                continue;
            }
            if (upc instanceof JetUAssertion) {
                JetUAssertion uAssertion = (JetUAssertion)upc;
                Assertion ass = uAssertion.getAssertion();
                policy.addSubComponent(ass);
                continue;
            }
            if (!(upc instanceof JetUPolicy)) continue;
            JetUPolicy uPolicy = (JetUPolicy)upc;
            Policy subPolicy = uPolicy.getPolicy();
            policy.addSubComponent(subPolicy);
        }
        return policy;
    }

    public void setPolicy(Policy po) {
        this.setType(po.getComponentType());
        this.setPolicyId(po.getId());
        this.setName(po.getName());
        NamespaceVersion nsv = po.getNamespaceVersion();
        if (nsv == null) {
            this.setNamespaceVersion("");
        } else {
            this.setNamespaceVersion(nsv.toString());
        }
        this.setPolicyComponent(po);
    }

    public void setSubComponent(Collection<PolicyComponent> subComponents) {
        if (!subComponents.isEmpty()) {
            for (PolicyComponent pc : subComponents) {
                this.setPolicyComponent(pc);
            }
        }
    }

    public String getPolicyId() {
        return this.policyId.get();
    }

    public void setPolicyId(String policyId) {
        this.policyId.set(policyId);
    }

    public String getName() {
        return this.name.get();
    }

    public void setName(String name2) {
        this.name.set(name2);
    }

    public String getNamespaceVersion() {
        return this.namespaceVersion.get();
    }

    public void setNamespaceVersion(String namespaceVersion) {
        this.namespaceVersion.set(namespaceVersion);
    }

    @Override
    public String getInstancePrefix() {
        return "WebServicePolicy";
    }
}

