/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.webservice.policy;

import com.jinfonet.webservice.policy.Policy;
import com.jinfonet.webservice.policy.PolicyException;
import com.jinfonet.webservice.policy.PolicyMap;
import com.jinfonet.webservice.policy.PolicyMapKey;
import com.jinfonet.webservice.policy.PolicySubject;
import java.util.Collection;
import java.util.Vector;
import jet.dataengine.util.DSLog;
import jet.universe.JetUResourceContainer;
import jet.universe.webservice.policy.JetUPolicy;
import jet.universe.webservice.policy.JetUPolicyInfo;
import jet.universe.webservice.policy.JetUPolicyMapKey;

public class JetUPolicyMap
extends JetUResourceContainer {
    public static final int service = 1;
    public static final int endpoint = 2;
    public static final int operation = 3;
    public static final int input_message = 4;
    public static final int output_message = 5;
    public static final int fault_message = 6;
    protected PolicyMap pm = null;
    private static DSLog log = DSLog.getDSLog(JetUPolicyMap.class.getName());

    public JetUPolicyMap() {
    }

    public JetUPolicyMap(PolicyMap pm) {
        this.setPolicyMap(pm);
    }

    public PolicyMap getPolicyMap() {
        if (this.pm == null) {
            this.pm = PolicyMap.createAttachments();
            Vector mapChildren = this.getChildren();
            for (int i = 0; i < mapChildren.size(); ++i) {
                JetUPolicyInfo policyInfo = (JetUPolicyInfo)mapChildren.get(i);
                int type = policyInfo.getScopeType();
                Vector children = policyInfo.getChildren();
                for (int j = 0; j < children.size(); ++j) {
                    JetUPolicyMapKey upmk = (JetUPolicyMapKey)children.get(j);
                    PolicyMapKey pmk = upmk.getPolicyMapKey();
                    JetUPolicy upo = (JetUPolicy)children.get(++j);
                    Policy po = upo.getPolicy();
                    PolicySubject ps = new PolicySubject(pmk, po);
                    if (type == 1) {
                        this.pm.putSubject(PolicyMap.ScopeType.SERVICE, pmk, ps);
                        continue;
                    }
                    if (type == 2) {
                        this.pm.putSubject(PolicyMap.ScopeType.ENDPOINT, pmk, ps);
                        continue;
                    }
                    if (type == 3) {
                        this.pm.putSubject(PolicyMap.ScopeType.OPERATION, pmk, ps);
                        continue;
                    }
                    if (type == 4) {
                        this.pm.putSubject(PolicyMap.ScopeType.INPUT_MESSAGE, pmk, ps);
                        continue;
                    }
                    if (type == 5) {
                        this.pm.putSubject(PolicyMap.ScopeType.OUTPUT_MESSAGE, pmk, ps);
                        continue;
                    }
                    if (type == 6) {
                        this.pm.putSubject(PolicyMap.ScopeType.FAULT_MESSAGE, pmk, ps);
                        continue;
                    }
                    log.debug("Unknow policy type " + type);
                }
            }
        }
        return this.pm;
    }

    public void setPolicyMap(PolicyMap pm) {
        if (pm != null) {
            Collection policyMapkey = pm.getAllServiceScopeKeys();
            this.addServicePolicyInfo(policyMapkey, pm, 1);
            policyMapkey = pm.getAllEndpointScopeKeys();
            this.addEndPointPolicyInfo(policyMapkey, pm, 2);
            policyMapkey = pm.getAllOperationScopeKeys();
            this.addOperationPolicyInfo(policyMapkey, pm, 3);
            policyMapkey = pm.getAllFaultMessageScopeKeys();
            this.addFaultMessagePolicyInfo(policyMapkey, pm, 6);
            policyMapkey = pm.getAllInputMessageScopeKeys();
            this.addInputMessagePolicyInfo(policyMapkey, pm, 4);
            policyMapkey = pm.getAllOutputMessageScopeKeys();
            this.addOutputMessagePolicyInfo(policyMapkey, pm, 5);
        }
    }

    private void addServicePolicyInfo(Collection<PolicyMapKey> pmk, PolicyMap po, int scopeType) {
        if (pmk != null) {
            JetUPolicyInfo policyKV = new JetUPolicyInfo(scopeType);
            for (PolicyMapKey mapKey : pmk) {
                JetUPolicyMapKey uMapKey = new JetUPolicyMapKey(mapKey);
                Policy pc = null;
                try {
                    pc = po.getServiceEffectivePolicy(mapKey);
                }
                catch (PolicyException e) {
                    log.debug("Get service effective policy error." + e);
                }
                if (pc == null) continue;
                JetUPolicy upc = new JetUPolicy(pc);
                policyKV.add(uMapKey);
                policyKV.add(upc);
            }
            if (!policyKV.getChildren().isEmpty()) {
                this.add(policyKV);
            }
        }
    }

    private void addEndPointPolicyInfo(Collection<PolicyMapKey> pmk, PolicyMap po, int scopeType) {
        if (pmk != null) {
            JetUPolicyInfo policyKV = new JetUPolicyInfo(scopeType);
            for (PolicyMapKey mapKey : pmk) {
                JetUPolicyMapKey uMapKey = new JetUPolicyMapKey(mapKey);
                Policy pc = null;
                try {
                    pc = po.getEndpointEffectivePolicy(mapKey);
                }
                catch (PolicyException e) {
                    log.debug("Get end point effective policy error." + e);
                }
                if (pc == null) continue;
                JetUPolicy upc = new JetUPolicy(pc);
                policyKV.add(uMapKey);
                policyKV.add(upc);
            }
            if (!policyKV.getChildren().isEmpty()) {
                this.add(policyKV);
            }
        }
    }

    private void addOperationPolicyInfo(Collection<PolicyMapKey> pmk, PolicyMap po, int scopeType) {
        if (pmk != null) {
            JetUPolicyInfo policyKV = new JetUPolicyInfo(scopeType);
            for (PolicyMapKey mapKey : pmk) {
                JetUPolicyMapKey uMapKey = new JetUPolicyMapKey(mapKey);
                Policy pc = null;
                try {
                    pc = po.getOperationEffectivePolicy(mapKey);
                }
                catch (PolicyException e) {
                    log.debug("Get operation effective policy error." + e);
                }
                if (pc == null) continue;
                JetUPolicy upc = new JetUPolicy(pc);
                policyKV.add(uMapKey);
                policyKV.add(upc);
            }
            if (!policyKV.getChildren().isEmpty()) {
                this.add(policyKV);
            }
        }
    }

    private void addFaultMessagePolicyInfo(Collection<PolicyMapKey> pmk, PolicyMap po, int scopeType) {
        if (pmk != null) {
            JetUPolicyInfo policyMapInfo = new JetUPolicyInfo(scopeType);
            for (PolicyMapKey mapKey : pmk) {
                JetUPolicyMapKey uMapKey = new JetUPolicyMapKey(mapKey);
                Policy pc = null;
                try {
                    pc = po.getFaultMessageEffectivePolicy(mapKey);
                }
                catch (PolicyException e) {
                    log.debug("Get fault message effective policy error." + e);
                }
                if (pc == null) continue;
                JetUPolicy upc = new JetUPolicy(pc);
                policyMapInfo.add(uMapKey);
                policyMapInfo.add(upc);
            }
            if (!policyMapInfo.getChildren().isEmpty()) {
                this.add(policyMapInfo);
            }
        }
    }

    private void addInputMessagePolicyInfo(Collection<PolicyMapKey> pmk, PolicyMap po, int scopeType) {
        if (pmk != null) {
            JetUPolicyInfo policyMapInfo = new JetUPolicyInfo(scopeType);
            for (PolicyMapKey mapKey : pmk) {
                JetUPolicyMapKey uMapKey = new JetUPolicyMapKey(mapKey);
                Policy pc = null;
                try {
                    pc = po.getInputMessageEffectivePolicy(mapKey);
                }
                catch (PolicyException e) {
                    log.debug("Get input message effective policy error." + e);
                }
                if (pc == null) continue;
                JetUPolicy upc = new JetUPolicy(pc);
                policyMapInfo.add(uMapKey);
                policyMapInfo.add(upc);
            }
            if (!policyMapInfo.getChildren().isEmpty()) {
                this.add(policyMapInfo);
            }
        }
    }

    private void addOutputMessagePolicyInfo(Collection<PolicyMapKey> pmk, PolicyMap po, int scopeType) {
        if (pmk != null) {
            JetUPolicyInfo policyInfo = new JetUPolicyInfo(scopeType);
            for (PolicyMapKey mapKey : pmk) {
                JetUPolicyMapKey uMapKey = new JetUPolicyMapKey(mapKey);
                Policy pc = null;
                try {
                    pc = po.getOutputMessageEffectivePolicy(mapKey);
                }
                catch (PolicyException e) {
                    log.debug("Get output message effective policy error." + e);
                }
                if (pc == null) continue;
                JetUPolicy upc = new JetUPolicy(pc);
                policyInfo.add(uMapKey);
                policyInfo.add(upc);
            }
            if (!policyInfo.getChildren().isEmpty()) {
                this.add(policyInfo);
            }
        }
    }

    @Override
    public String getInstancePrefix() {
        return "PolicyMap";
    }
}

