/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.webservice.wsdl_1;

import com.ibm.wsdl.AbstractWSDLElement;
import com.ibm.wsdl.extensions.soap.SOAPBindingImpl;
import com.ibm.wsdl.extensions.soap12.SOAP12BindingImpl;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.ExtensionSerializer;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.extensions.http.HTTPAddress;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.xml.namespace.QName;
import jet.dataengine.api.DSException;
import jet.log.JRLogger;
import jet.universe.webservice.wsdl_1.JetUBinding11;
import jet.universe.webservice.wsdl_1.JetUBindingOperation11;
import jet.universe.webservice.wsdl_1.JetUDefinitions;
import jet.universe.webservice.wsdl_1.JetUOperation;
import jet.universe.webservice.wsdl_1.JetUPort;
import jet.universe.webservice.wsdl_1.JetUPortType;
import jet.universe.webservice.wsdl_1.JetUService11;
import jet.util.StringOutputStream;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DefinitionComponentParser {
    private static JRLogger logger = JRLogger.getLogger(DefinitionComponentParser.class.getName());
    private static String STYLE_KEY = "style";
    private static String LOCATION = "location";
    private static String SOAPACTION = "soapAction";
    private static String SOAPPORTTYPE = "soap:address";
    private static String SOAP12PORTTYPE = "soap12:address";

    public static String[] getStrXmlschemas(Definition def) throws DSException {
        ArrayList<String> ret = new ArrayList<String>();
        ExtensionRegistry extReg = def.getExtensionRegistry();
        Map ns = def.getNamespaces();
        Types types = def.getTypes();
        if (types == null) {
            return new String[0];
        }
        List extElList = types.getExtensibilityElements();
        if (extElList != null && extElList.size() > 0) {
            for (UnknownExtensibilityElement extEl : extElList) {
                Element ele = extEl.getElement();
                Set prefixs = ns.keySet();
                for (String prefix : prefixs) {
                    String namespaceURI = (String)ns.get(prefix);
                    String attName = prefix.equals("") ? "xmlns" : "xmlns:" + prefix;
                    String att = ele.getAttribute(attName);
                    if (!att.equals("")) continue;
                    ele.setAttribute(attName, namespaceURI);
                }
                QName elementType = extEl.getElementType();
                try {
                    ExtensionSerializer extSer = extReg.querySerializer(Types.class, elementType);
                    StringOutputStream out = new StringOutputStream();
                    PrintWriter pw = new PrintWriter(out, true);
                    extSer.marshall(Types.class, elementType, (ExtensibilityElement)extEl, pw, def, extReg);
                    ret.add(out.getString());
                }
                catch (WSDLException e) {
                    throw new DSException(0, new Object[]{e.getMessage()}, (Throwable)e);
                }
            }
        }
        return ret.toArray(new String[ret.size()]);
    }

    public static QName getPortQName(Port port) {
        if (port != null) {
            Binding bing = port.getBinding();
            return bing.getQName();
        }
        return null;
    }

    public static String getBindingStyle(Binding binding) {
        String style = "document";
        List extElements = binding.getExtensibilityElements();
        if (extElements != null && extElements.size() > 0) {
            for (Object o : extElements) {
                UnknownExtensibilityElement extEl;
                Element ele;
                String att;
                SOAPBindingImpl a;
                if (o instanceof SOAPBindingImpl) {
                    a = (SOAPBindingImpl)o;
                    style = a.getStyle();
                    break;
                }
                if (o instanceof SOAP12BindingImpl) {
                    a = (SOAP12BindingImpl)o;
                    style = a.getStyle();
                    break;
                }
                if (!(o instanceof UnknownExtensibilityElement) || (att = (ele = (extEl = (UnknownExtensibilityElement)o).getElement()).getAttribute(STYLE_KEY)) == null || att.equals("")) continue;
                style = att;
                break;
            }
        }
        return style;
    }

    public static String[] getSoapActionAndStyle(BindingOperation bindingOperation) {
        String[] soapActionStyle = new String[]{"", "document"};
        List extElements = bindingOperation.getExtensibilityElements();
        if (extElements != null && extElements.size() > 0) {
            for (Object o : extElements) {
                if (!(o instanceof UnknownExtensibilityElement)) continue;
                UnknownExtensibilityElement extEl = (UnknownExtensibilityElement)o;
                Element ele = extEl.getElement();
                String soapActionAtt = ele.getAttribute(SOAPACTION);
                String styleAtt = ele.getAttribute(STYLE_KEY);
                if (soapActionAtt == null || soapActionAtt.equals("")) continue;
                soapActionStyle[0] = soapActionAtt;
                if (styleAtt == null || styleAtt.equals("")) break;
                soapActionStyle[1] = styleAtt;
                break;
            }
        }
        if ("".equals(soapActionStyle[0])) {
            return null;
        }
        return soapActionStyle;
    }

    public static QName getElementDecQName(AbstractWSDLElement IOPutsAndFault) {
        Iterator values;
        Map extElements;
        QName elementDecQName = null;
        if (IOPutsAndFault != null && (extElements = IOPutsAndFault.getExtensionAttributes()).size() > 0 && (values = extElements.values().iterator()).hasNext()) {
            elementDecQName = (QName)values.next();
        }
        return elementDecQName;
    }

    public static String getPortURIStr(Port port) {
        String uri = null;
        List extElements = port.getExtensibilityElements();
        if (extElements != null && extElements.size() > 0) {
            for (Object o : extElements) {
                Node attNode;
                HTTPAddress a;
                if (o instanceof HTTPAddress) {
                    a = (HTTPAddress)o;
                    uri = a.getLocationURI();
                    break;
                }
                if (o instanceof SOAP12Address) {
                    a = (SOAP12Address)o;
                    uri = a.getLocationURI();
                    break;
                }
                if (o instanceof SOAPAddress) {
                    a = (SOAPAddress)o;
                    uri = a.getLocationURI();
                    break;
                }
                if (!(o instanceof UnknownExtensibilityElement)) continue;
                UnknownExtensibilityElement extEl = (UnknownExtensibilityElement)o;
                Element ele = extEl.getElement();
                String att = ele.getAttribute(LOCATION);
                if (att != null && !att.equals("")) {
                    uri = att;
                    break;
                }
                Node node = ele.getFirstChild();
                NamedNodeMap nodeMap = null;
                if (node == null || ele.getAttributes() == null || (att = (attNode = (nodeMap = ele.getAttributes()).getNamedItem(LOCATION)).getNodeValue()) == null || att.equals("")) continue;
                uri = att;
                break;
            }
        }
        if (uri == null && logger.isErrorEnabled()) {
            logger.error("", new Exception("Can not get web service URI"));
        }
        return uri;
    }

    public static boolean isSoapPort(Port port) {
        List extElements = port.getExtensibilityElements();
        if (extElements != null && extElements.size() > 0) {
            for (Object o : extElements) {
                UnknownExtensibilityElement extEl;
                Element ele;
                if (!(o instanceof UnknownExtensibilityElement) || !SOAPPORTTYPE.equals((ele = (extEl = (UnknownExtensibilityElement)o).getElement()).getTagName()) && !SOAP12PORTTYPE.equals(ele.getTagName())) continue;
                return true;
            }
        }
        return false;
    }

    public static Vector getStyles(JetUPortType jPortType, JetUOperation jOperation) {
        Vector<String> vStyle = new Vector<String>();
        JetUDefinitions jDef = (JetUDefinitions)jPortType.getParent();
        Vector vServices = jDef.getServices();
        for (int i = 0; i < vServices.size(); ++i) {
            JetUService11 jService11 = (JetUService11)vServices.elementAt(i);
            Vector tempVPorts = jService11.getPorts();
            for (int j = 0; j < tempVPorts.size(); ++j) {
                JetUPort jPort = (JetUPort)tempVPorts.elementAt(j);
                JetUBinding11 jBinding11 = jDef.getBinding(jPort.getRefBinding());
                if (jBinding11 == null || !jBinding11.getRefPortType().equals(jPortType.getQName())) continue;
                if (!jBinding11.getStyle().equals("")) {
                    vStyle.add(jBinding11.getStyle());
                }
                Vector childs = jBinding11.getBindingOperations();
                for (int k = 0; k < childs.size(); ++k) {
                    JetUBindingOperation11 jBindingOperation = (JetUBindingOperation11)childs.elementAt(k);
                    if ("".equals(jBindingOperation.getSoapAction()) || !jBindingOperation.getName().equals(jOperation.getQName().getLocalPart())) continue;
                    vStyle.add(jBindingOperation.getStyle());
                }
            }
        }
        return vStyle;
    }
}

