/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.webservice.wsdl_1;

import com.jinfonet.dataservice.util.IntrinsicXmlSchema;
import java.io.ByteArrayInputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Message;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import jet.controls.JetObject;
import jet.controls.JetString;
import jet.controls.JetVector;
import jet.dataengine.api.DSException;
import jet.log.JRLogger;
import jet.universe.JetUResourceContainer;
import jet.universe.webservice.wsdl_1.DefinitionComponentParser;
import jet.universe.webservice.wsdl_1.JetUBinding11;
import jet.universe.webservice.wsdl_1.JetUMessage;
import jet.universe.webservice.wsdl_1.JetUPortType;
import jet.universe.webservice.wsdl_1.JetUService11;
import jet.util.HashVector;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaCollection;

public class JetUDefinitions
extends JetUResourceContainer {
    public JetVector xmlschemas = new JetVector(this, "XMLSchemas");
    public JetString fTargetNamespace = new JetString(this, "TargetNamespace");
    private XmlSchema[] schemas;
    private static JRLogger logger = JRLogger.getLogger(JetUDefinitions.class.getName());

    public JetUDefinitions() {
    }

    public JetUDefinitions(Definition definition) {
        this.setDefinitions(definition);
    }

    private void setDefinitions(Definition definition) {
        if (definition != null) {
            Map messages;
            Map portTypes;
            Map bindings;
            block11: {
                this.setFTargetNamespace(definition.getTargetNamespace());
                try {
                    this.setXmlschemas(DefinitionComponentParser.getStrXmlschemas(definition));
                }
                catch (DSException e) {
                    if (!logger.isErrorEnabled()) break block11;
                    logger.error("", e);
                }
            }
            Map services = definition.getServices();
            if (services != null) {
                for (Service service : services.values()) {
                    JetUService11 jService = new JetUService11(service);
                    this.add(jService);
                }
            }
            if ((bindings = definition.getBindings()) != null) {
                for (Binding binding : bindings.values()) {
                    JetUBinding11 jBinding = new JetUBinding11(binding);
                    this.add(jBinding);
                }
            }
            if ((portTypes = definition.getPortTypes()) != null) {
                for (PortType portType : portTypes.values()) {
                    JetUPortType jPortType = new JetUPortType(portType);
                    this.add(jPortType);
                }
            }
            if ((messages = definition.getMessages()) != null) {
                for (Message message : messages.values()) {
                    JetUMessage jMessage = new JetUMessage(message);
                    this.add(jMessage);
                }
            }
        }
    }

    public Vector getServices() {
        Vector<JetObject> services = new Vector<JetObject>();
        Vector children = this.getChildren();
        int iSize = children.size();
        JetObject re = null;
        for (int i = 0; i < iSize; ++i) {
            re = (JetObject)children.elementAt(i);
            if (!(re instanceof JetUService11)) continue;
            services.addElement(re);
        }
        return services;
    }

    public JetUService11 getService(QName qName) {
        if (qName == null) {
            return null;
        }
        Vector children = this.getChildren();
        int iSize = children.size();
        JetObject re = null;
        for (int i = 0; i < iSize; ++i) {
            JetUService11 jService;
            re = (JetObject)children.elementAt(i);
            if (!(re instanceof JetUService11) || !qName.equals((jService = (JetUService11)re).getQName())) continue;
            return jService;
        }
        return null;
    }

    public Vector getPortTypes() {
        Vector<JetObject> portTypes = new Vector<JetObject>();
        Vector children = this.getChildren();
        int iSize = children.size();
        JetObject re = null;
        for (int i = 0; i < iSize; ++i) {
            re = (JetObject)children.elementAt(i);
            if (!(re instanceof JetUPortType)) continue;
            portTypes.addElement(re);
        }
        return portTypes;
    }

    public JetUPortType getPortType(QName qName) {
        if (qName == null) {
            return null;
        }
        Vector children = this.getChildren();
        int iSize = children.size();
        JetObject re = null;
        for (int i = 0; i < iSize; ++i) {
            JetUPortType jPortType;
            re = (JetObject)children.elementAt(i);
            if (!(re instanceof JetUPortType) || !qName.equals((jPortType = (JetUPortType)re).getQName())) continue;
            return jPortType;
        }
        return null;
    }

    public Vector getMessages() {
        Vector<JetObject> messages = new Vector<JetObject>();
        Vector children = this.getChildren();
        int iSize = children.size();
        JetObject re = null;
        for (int i = 0; i < iSize; ++i) {
            re = (JetObject)children.elementAt(i);
            if (!(re instanceof JetUMessage)) continue;
            messages.addElement(re);
        }
        return messages;
    }

    public JetUMessage getMessage(QName qName) {
        if (qName == null) {
            return null;
        }
        Vector children = this.getChildren();
        int iSize = children.size();
        JetObject re = null;
        for (int i = 0; i < iSize; ++i) {
            JetUMessage jMessage;
            re = (JetObject)children.elementAt(i);
            if (!(re instanceof JetUMessage) || !qName.equals((jMessage = (JetUMessage)re).getQName())) continue;
            return jMessage;
        }
        return null;
    }

    public Vector getBindings() {
        Vector<JetObject> services = new Vector<JetObject>();
        Vector children = this.getChildren();
        int iSize = children.size();
        JetObject re = null;
        for (int i = 0; i < iSize; ++i) {
            re = (JetObject)children.elementAt(i);
            if (!(re instanceof JetUBinding11)) continue;
            services.addElement(re);
        }
        return services;
    }

    public JetUBinding11 getBinding(QName qName) {
        if (qName == null) {
            return null;
        }
        Vector children = this.getChildren();
        int iSize = children.size();
        JetObject re = null;
        for (int i = 0; i < iSize; ++i) {
            JetUBinding11 jBinding;
            re = (JetObject)children.elementAt(i);
            if (!(re instanceof JetUBinding11) || !qName.equals((jBinding = (JetUBinding11)re).getQName())) continue;
            return jBinding;
        }
        return null;
    }

    public String[] getStrXmlschemas() {
        String[] tempXmlSchemas = this.xmlschemas.toStringArray();
        int size = tempXmlSchemas.length;
        String[] strSchemas = new String[size];
        for (int i = 0; i < size; ++i) {
            strSchemas[i] = tempXmlSchemas[i];
        }
        return strSchemas;
    }

    public void setXmlschemas(String[] strschemas) {
        if (strschemas == null) {
            return;
        }
        for (int i = 0; i < strschemas.length; ++i) {
            this.xmlschemas.add(strschemas[i]);
        }
        this.buildSchemas(strschemas);
    }

    @Override
    public String getInstancePrefix() {
        return "WebServiceDefinitions";
    }

    public URI getFTargetNamespace() {
        URI targetNS = null;
        try {
            targetNS = new URI(this.fTargetNamespace.get());
        }
        catch (URISyntaxException e) {
            logger.debug("New URI with " + this.fTargetNamespace.get() + " error.");
        }
        return targetNS;
    }

    public void setFTargetNamespace(String targetNamespace) {
        this.fTargetNamespace.set(targetNamespace);
    }

    @Override
    public HashVector getPropertyGroups() {
        return new HashVector(0);
    }

    public XmlSchema[] getXmlSchemas() {
        if (this.schemas == null) {
            this.buildSchemas(this.getStrXmlschemas());
        }
        return this.schemas;
    }

    private void buildSchemas(String[] strSchemas) {
        XmlSchema[] xs;
        block3: {
            xs = new XmlSchema[strSchemas.length + 1];
            XmlSchemaCollection schemaCol = new XmlSchemaCollection();
            try {
                for (int i = 0; i < strSchemas.length; ++i) {
                    ByteArrayInputStream is = new ByteArrayInputStream(strSchemas[i].getBytes());
                    xs[i + 1] = schemaCol.read((Source)new StreamSource(is), null);
                }
            }
            catch (Exception e) {
                xs = new XmlSchema[1];
                if (!logger.isWarnEnabled()) break block3;
                logger.warn("Fail to load all refered Schemas,Make sure you can access those uri or IP address", e);
            }
        }
        xs[0] = IntrinsicXmlSchema.getIntrinsicXmlSchema();
        this.schemas = xs;
    }
}

