/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.webservice.wsdl_1;

import com.ibm.wsdl.AbstractWSDLElement;
import com.ibm.wsdl.FaultImpl;
import com.ibm.wsdl.InputImpl;
import com.ibm.wsdl.OutputImpl;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.xml.namespace.QName;
import jet.controls.JetObject;
import jet.controls.JetString;
import jet.log.JRLogger;
import jet.universe.JetUResourceContainer;
import jet.universe.webservice.JetUQName;
import jet.universe.webservice.wsdl_1.DefinitionComponentParser;
import jet.universe.webservice.wsdl_1.JetUFault;
import jet.universe.webservice.wsdl_1.JetUInput;
import jet.universe.webservice.wsdl_1.JetUMessage;
import jet.universe.webservice.wsdl_1.JetUOutput;
import jet.universe.webservice.wsdl_1.JetUPortType;
import jet.universe.webservice.wsdl_1.JetUPortTypeFaultMessageReference;
import jet.universe.webservice.wsdl_1.JetUPortTypeMessageReference;
import jet.util.HashVector;

public class JetUOperation
extends JetUResourceContainer {
    public JetString name = new JetString(this, "Name");
    public JetUQName qName = new JetUQName(this, "QName");
    public JetString displayName = new JetString(this, "DisplayName");
    private static JRLogger logger = JRLogger.getLogger(JetUOperation.class.getName());

    public JetUOperation() {
    }

    public JetUOperation(Operation operation, QName qName) {
        this.setOperation(operation, qName);
    }

    public void setOperation(Operation operation, QName qName) {
        if (operation != null) {
            Iterator faultItor;
            Map faults;
            OutputImpl outputImpl;
            this.setName(operation.getName());
            this.setQName(new QName(qName.getNamespaceURI(), operation.getName()));
            InputImpl inputImpl = (InputImpl)operation.getInput();
            if (inputImpl != null) {
                JetUInput jInput = new JetUInput((Input)inputImpl);
                this.setInputMessageReference(jInput, DefinitionComponentParser.getElementDecQName((AbstractWSDLElement)inputImpl));
                this.add(jInput);
            }
            if ((outputImpl = (OutputImpl)operation.getOutput()) != null) {
                JetUOutput jOutput = new JetUOutput((Output)outputImpl);
                this.setOutputMessageReference(jOutput, DefinitionComponentParser.getElementDecQName((AbstractWSDLElement)inputImpl));
                this.add(jOutput);
            }
            if ((faults = operation.getFaults()) != null && (faultItor = faults.values().iterator()).hasNext()) {
                FaultImpl faultImpl = (FaultImpl)faultItor.next();
                JetUFault jFault = new JetUFault((Fault)faultImpl);
                this.setFaultMessageReference(jFault, DefinitionComponentParser.getElementDecQName((AbstractWSDLElement)faultImpl));
                this.add(jFault);
            }
        }
    }

    public Vector getRelatedMessageRefs() {
        Vector<JetObject> relatedMessageRefs = new Vector<JetObject>();
        Vector children = this.getChildren();
        int iSize = children.size();
        JetObject re = null;
        for (int i = 0; i < iSize; ++i) {
            re = (JetObject)children.elementAt(i);
            if (!(re instanceof JetUPortTypeMessageReference)) continue;
            relatedMessageRefs.addElement(re);
        }
        return relatedMessageRefs;
    }

    public Vector getFaults() {
        Vector<JetObject> faults = new Vector<JetObject>();
        Vector children = this.getChildren();
        int iSize = children.size();
        JetObject re = null;
        for (int i = 0; i < iSize; ++i) {
            re = (JetObject)children.elementAt(i);
            if (!(re instanceof JetUFault)) continue;
            faults.addElement(re);
        }
        return faults;
    }

    public Vector getFaultRefs() {
        Vector<JetObject> faultRefs = new Vector<JetObject>();
        Vector children = this.getChildren();
        int iSize = children.size();
        JetObject re = null;
        for (int i = 0; i < iSize; ++i) {
            re = (JetObject)children.elementAt(i);
            if (!(re instanceof JetUPortTypeFaultMessageReference)) continue;
            faultRefs.addElement(re);
        }
        return faultRefs;
    }

    private void setInputMessageReference(JetUInput jInput, QName elementDecQName) {
        JetUPortTypeMessageReference inputMsgRef = new JetUPortTypeMessageReference("in", jInput.getRefMessage(), elementDecQName);
        this.add(inputMsgRef);
    }

    private void setOutputMessageReference(JetUOutput jOutput, QName elementDecQName) {
        JetUPortTypeMessageReference outputMsgRef = new JetUPortTypeMessageReference("out", jOutput.getRefMessage(), elementDecQName);
        this.add(outputMsgRef);
    }

    private void setFaultMessageReference(JetUFault jFault, QName elementDecQName) {
        JetUPortTypeFaultMessageReference faultMsgRef = new JetUPortTypeFaultMessageReference("fault", jFault.getRefMessage(), elementDecQName);
        this.add(faultMsgRef);
    }

    public JetUMessage getInputMessage() {
        JetUMessage inputMsg = null;
        Vector children = this.getChildren();
        int iSize = children.size();
        JetObject re = null;
        for (int i = 0; i < iSize; ++i) {
            re = (JetObject)children.elementAt(i);
            if (!(re instanceof JetUInput)) continue;
            ((JetUInput)re).getRefMessage();
        }
        return inputMsg;
    }

    public JetUMessage getOutputMessage() {
        JetUMessage outMsg = null;
        Vector children = this.getChildren();
        int iSize = children.size();
        JetObject re = null;
        for (int i = 0; i < iSize; ++i) {
            re = (JetObject)children.elementAt(i);
            if (!(re instanceof JetUOutput)) continue;
            ((JetUInput)re).getRefMessage();
        }
        return outMsg;
    }

    public JetUPortType getPortType() {
        JetUPortType jportType = null;
        if (this.getParent() instanceof JetUPortType) {
            jportType = (JetUPortType)this.getParent();
        } else if (logger.isErrorEnabled()) {
            logger.error("", new Exception("JetUoperation parent is not JetUPortType"));
        }
        return jportType;
    }

    public String getName() {
        return this.name.get();
    }

    public void setName(String name2) {
        this.name.set(name2);
    }

    public String getDisplayName() {
        return this.displayName.get();
    }

    public void setDisplayName(String displayName) {
        this.displayName.set(displayName);
    }

    public QName getQName() {
        return this.qName.get();
    }

    public void setQName(QName qName) {
        this.qName.set(qName);
    }

    @Override
    public String getInstancePrefix() {
        return "PortTypeOperation";
    }

    @Override
    public HashVector getPropertyGroups() {
        return new HashVector(0);
    }
}

