/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.webservice.wsdl_1;

import java.net.URI;
import java.net.URISyntaxException;
import javax.wsdl.Port;
import javax.xml.namespace.QName;
import jet.controls.JetBoolean;
import jet.controls.JetObject;
import jet.controls.JetString;
import jet.log.JRLogger;
import jet.universe.webservice.JetUQName;
import jet.universe.webservice.wsdl_1.DefinitionComponentParser;
import jet.util.HashVector;

public class JetUPort
extends JetObject {
    public JetString name = new JetString(this, "Name");
    public JetUQName refBinding = new JetUQName(this, "RefBinding");
    public JetString uri = new JetString(this, "URI");
    public JetUQName qName = new JetUQName(this, "QName");
    public JetBoolean isSoap = new JetBoolean(this, "IsSoap", true);
    private static JRLogger logger = JRLogger.getLogger(JetUPort.class.getName());

    public JetUPort() {
    }

    public JetUPort(Port port, QName qname) {
        this.setPort(port, qname);
    }

    public void setPort(Port port, QName qname) {
        if (port != null) {
            this.setName(port.getName());
            this.setQName(new QName(qname.getNamespaceURI(), port.getName()));
            this.setUri(DefinitionComponentParser.getPortURIStr(port));
            this.setRefBinding(DefinitionComponentParser.getPortQName(port));
            this.setIsSoap(DefinitionComponentParser.isSoapPort(port));
        }
    }

    public String getName() {
        return this.name.get();
    }

    public void setName(String name2) {
        this.name.set(name2);
    }

    public boolean getIsSoap() {
        return this.isSoap.get();
    }

    public void setIsSoap(boolean isSoap) {
        this.isSoap.set(isSoap);
    }

    public QName getRefBinding() {
        return this.refBinding.get();
    }

    public void setRefBinding(QName refBinding) {
        this.refBinding.set(refBinding);
    }

    public URI getUri() {
        URI theURI = null;
        try {
            theURI = new URI(this.uri.get());
        }
        catch (URISyntaxException e) {
            logger.debug("Create URI error." + e);
        }
        return theURI;
    }

    public void setUri(String uri) {
        this.uri.set(uri);
    }

    @Override
    public String getInstancePrefix() {
        return "Port";
    }

    public QName getQName() {
        return this.qName.get();
    }

    public void setQName(QName qName) {
        this.qName.set(qName);
    }

    @Override
    public HashVector getPropertyGroups() {
        return new HashVector(0);
    }
}

