/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.webservice.wsdl_1;

import java.util.Vector;
import javax.xml.namespace.QName;
import jet.controls.JetObject;
import jet.controls.JetString;
import jet.dataengine.api.DSException;
import jet.dataengine.api.datasource.xml.MetadataContainer;
import jet.dataengine.api.datasource.xml.ModelCreator;
import jet.dataengine.api.datasource.xml.ModelCreatorFactory;
import jet.dataengine.api.datasource.xml.SchemaSOAPInfo;
import jet.dataengine.api.datasource.xml.XMLModelSource;
import jet.dataengine.xml.MetadataContainerImpl;
import jet.log.JRLogger;
import jet.universe.JetUResourceContainer;
import jet.universe.webservice.JetUQName;
import jet.universe.webservice.wsdl_1.DefinitionComponentParser;
import jet.universe.webservice.wsdl_1.JetUDefinitions;
import jet.universe.webservice.wsdl_1.JetUOperation;
import jet.universe.webservice.wsdl_1.JetUPortType;
import jet.util.HashVector;

public class JetUPortTypeMessageReference
extends JetUResourceContainer {
    public JetString messageLabel = new JetString(this, "MessageLabel");
    public JetUQName refMessage = new JetUQName(this, "RefMessage");
    public JetUQName elementDecQName = new JetUQName(this, "ElementDecQName");
    private static JRLogger logger = JRLogger.getLogger(JetUPortTypeMessageReference.class.getName());

    public JetUPortTypeMessageReference() {
    }

    public JetUPortTypeMessageReference(String messageLabel, QName qName, QName elementDecQName) {
        this.setPortTypeMessageReference(messageLabel, qName, elementDecQName);
    }

    private void setPortTypeMessageReference(String messageLabel, QName qName, QName elementDecQName) {
        this.setMessageLabel(messageLabel);
        this.setRefMessage(qName);
        this.setElementDecQName(elementDecQName);
    }

    public QName getRefMessage() {
        return this.refMessage.get();
    }

    public void setRefMessage(QName refMessage) {
        this.refMessage.set(refMessage);
    }

    public QName getElementDecQName() {
        return this.elementDecQName.get();
    }

    public void setElementDecQName(QName elementDecQName) {
        this.elementDecQName.set(elementDecQName);
    }

    public MetadataContainer getRefMetaData() throws DSException {
        JetObject parent = this;
        while (!(parent instanceof JetUPortType)) {
            parent = (JetObject)((Object)parent.getParent());
        }
        JetUPortType jPortType = (JetUPortType)parent;
        while (!(parent instanceof JetUDefinitions)) {
            parent = (JetObject)((Object)parent.getParent());
        }
        JetUDefinitions def = (JetUDefinitions)parent;
        JetUOperation jOperation = (JetUOperation)this.getParent();
        SchemaSOAPInfo ssi = new SchemaSOAPInfo();
        ssi.setXmlSchemas(def.getXmlSchemas());
        ssi.setOperationQName(jOperation.getQName());
        Vector vSyles = DefinitionComponentParser.getStyles(jPortType, jOperation);
        if (vSyles.size() > 0) {
            ssi.setStyle(vSyles.elementAt(0).toString());
        }
        ModelCreator mcr = ModelCreatorFactory.create(new XMLModelSource(ssi));
        mcr.setMessage(def.getMessage(this.getRefMessage()));
        mcr.process();
        MetadataContainerImpl mc = (MetadataContainerImpl)mcr.getMetadataContainer();
        return mc;
    }

    public String getMessageLabel() {
        return this.messageLabel.get();
    }

    public void setMessageLabel(String messageLabel) {
        this.messageLabel.set(messageLabel);
    }

    @Override
    public String getInstancePrefix() {
        return "PortTypeMessageReference";
    }

    @Override
    public HashVector getPropertyGroups() {
        return new HashVector(0);
    }
}

