/*
 * Decompiled with CFR 0.152.
 */
package jet.upgrade;

import java.io.File;
import java.util.Hashtable;
import jet.controls.JetObject;
import jet.icontrols.QueryInfo;
import jet.ireport.IReport;
import jet.jetc.LoaderNoCache;
import jet.reportset.JetRptReportSet;
import jet.universe.JetUUniverse;

public final class UpgradeDataContext {
    private JetUUniverse SEDU;
    private boolean append = false;
    private QueryInfo exists;
    private IReport get = null;
    private Hashtable getAbsolutePath = new Hashtable();

    public UpgradeDataContext(JetUUniverse jetUUniverse) {
        this.SEDU = jetUUniverse;
    }

    public void setCurrentQueryInfo(boolean bl, QueryInfo queryInfo) {
        this.append = bl;
        this.exists = queryInfo;
    }

    public QueryInfo getCurrentQueryInfo() {
        return this.exists;
    }

    public JetUUniverse getCurrentUniverse() {
        return this.SEDU;
    }

    public void setCurrentUniverse(JetUUniverse jetUUniverse) {
        this.SEDU = jetUUniverse;
    }

    public IReport getCurrentIReport() {
        return this.get;
    }

    public void setCurrentIReport(IReport iReport) {
        this.get = iReport;
    }

    public boolean isHds() {
        return this.append;
    }

    public IReport getLinkedOrSubIReport(String string, String string2) {
        String string3 = this.SEDU != null ? this.SEDU.getFilePath() : "";
        File file = new File(string3, string);
        JetObject jetObject = (JetObject)this.getAbsolutePath.get(file);
        if (jetObject == null) {
            String string4 = file.getAbsolutePath();
            try {
                LoaderNoCache loaderNoCache = new LoaderNoCache(string4);
                jetObject = loaderNoCache.load();
            }
            catch (Throwable throwable) {
                return null;
            }
            this.getAbsolutePath.put(file, jetObject);
        }
        if (jetObject instanceof IReport) {
            return (IReport)((Object)jetObject);
        }
        if (jetObject instanceof JetRptReportSet) {
            if (string2 == null || string2.isEmpty()) {
                return ((JetRptReportSet)jetObject).getCurReport();
            }
            return ((JetRptReportSet)jetObject).getReport(string2);
        }
        if ((jetObject = jetObject.nameToObject(string2)) instanceof IReport) {
            return (IReport)((Object)jetObject);
        }
        return null;
    }

    public void setPreLoadedLinkedOrSubObject(File file, JetObject jetObject) {
        if (file == null || !file.exists() || jetObject == null) {
            return;
        }
        this.getAbsolutePath.put(file, jetObject);
    }

    public UpgradeDataContext cloneIt(boolean bl, boolean bl2) {
        UpgradeDataContext upgradeDataContext = new UpgradeDataContext(this.SEDU);
        if (bl) {
            upgradeDataContext.setCurrentIReport(this.get);
        }
        if (bl2) {
            upgradeDataContext.setCurrentQueryInfo(this.append, this.exists);
        }
        upgradeDataContext.getAbsolutePath = this.getAbsolutePath;
        return upgradeDataContext;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("universe:").append(this.SEDU).append("; ");
        if (this.exists == null) {
            stringBuilder.append("QueryInfo:null; ");
        } else {
            stringBuilder.append("QueryInfo:");
            stringBuilder.append(this.append ? "HDS," : ",");
            stringBuilder.append(this.exists.getCatalogName()).append(",");
            stringBuilder.append(this.exists.getDatasourceName()).append(",");
            stringBuilder.append(this.exists.getQueryName()).append(",");
            if (this.exists.getDataResoureType() == 2) {
                stringBuilder.append(this.exists.getBLName()).append(",{BV};");
            } else if (this.exists.getDataResoureType() == 1) {
                stringBuilder.append(this.exists.getBLName()).append(",{BL};");
            } else {
                stringBuilder.append("{Query}; ");
            }
        }
        return stringBuilder.toString();
    }
}

