/*
 * Decompiled with CFR 0.152.
 */
package jet.upgrade;

import com.jinfonet.resstore.ResourceStore;
import com.jinfonet.util.JRLog;
import java.io.File;
import jet.BuildEnv;
import jet.report.JetRptObject;
import jet.report.JetRptReportPanel;
import jet.reportset.JetRptReportSet;
import jet.universe.JetUUniverse;
import jet.upgrade.JUpgradeFailtureException;
import jet.upgrade.JUpgradeNotSupportedException;
import jet.upgrade.UpgradeContext;
import jet.upgrade.UpgradeDataContext;
import jet.upgrade.UpgradeResContext;
import jet.upgrade.UpgradeResult;
import jet.upgrade.UpgradeVersion;
import jet.upgrade.impl.URptReportSetTask;
import jet.upgrade.impl.v7x.URptV7ReportPanelTask;
import jet.util.image.ImageProvider;
import jet.util.image.ImageProviderFactory;
import timer.Clocker;

public class UpgradeUtil {
    public static final JetRptObject upgradeRpt(JetRptObject jetRptObject, JetUUniverse jetUUniverse, int n) throws JUpgradeNotSupportedException, JUpgradeFailtureException {
        return UpgradeUtil.upgradeRpt(jetRptObject, jetUUniverse, n, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final JetRptObject upgradeRpt(JetRptObject jetRptObject, JetUUniverse jetUUniverse, int n, ResourceStore resourceStore) throws JUpgradeNotSupportedException, JUpgradeFailtureException {
        if (jetRptObject instanceof JetRptReportPanel && jetRptObject.getParent() == null) {
            Object object;
            Clocker clocker = null;
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "ReportPanel upgrade start, reportpanel=" + jetRptObject);
                clocker = new Clocker();
                clocker.reset();
            }
            UpgradeDataContext upgradeDataContext = new UpgradeDataContext(jetUUniverse);
            UpgradeResContext upgradeResContext = new UpgradeResContext();
            ImageProvider imageProvider = null;
            if (jetUUniverse == null) {
                imageProvider = ImageProviderFactory.createDefaultImageProvider(null, resourceStore == null ? null : resourceStore.getMemoryStore());
            } else {
                object = new File(jetUUniverse.getFullFileName());
                imageProvider = ImageProviderFactory.createDefaultImageProvider((File)object, resourceStore == null ? null : resourceStore.getMemoryStore());
            }
            upgradeResContext.setCurrentImageProvider(imageProvider);
            upgradeResContext.setCurrentResourceStore(resourceStore);
            object = new UpgradeContext(6, upgradeDataContext, upgradeResContext);
            URptV7ReportPanelTask uRptV7ReportPanelTask = new URptV7ReportPanelTask((JetRptReportPanel)jetRptObject, (UpgradeContext)object);
            try {
                ((JetRptReportPanel)jetRptObject).refer();
                UpgradeResult upgradeResult = uRptV7ReportPanelTask.call();
                JetRptObject jetRptObject2 = (JetRptObject)upgradeResult.newObject;
                return jetRptObject2;
            }
            finally {
                ((JetRptReportPanel)jetRptObject).free();
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "ReportPanel upgrade end; reportpanel=" + jetRptObject + ",Elapsed:" + clocker.elapsed());
                }
            }
        }
        if (jetRptObject instanceof JetRptReportSet) {
            Object object;
            UpgradeVersion upgradeVersion;
            int n2;
            JetRptReportSet jetRptReportSet = (JetRptReportSet)jetRptObject;
            int n3 = jetRptReportSet.major.intValue();
            int n4 = jetRptReportSet.BuildNumber.intValue();
            if (n3 <= 0 || n4 < 800) {
                if (JRLog.isError(3)) {
                    JRLog.error(3, "[Upgrade WARNING log]:Try to use upgrade from V800 rule to upgrade a report with version is 0.0.0.0000,");
                }
                n3 = 8;
                n4 = 800;
            }
            if ((n2 = (upgradeVersion = UpgradeVersion.createUVersion(n3, jetRptReportSet.minor.intValue(), n4, jetRptReportSet.ServicePack.intValue())).compareTo(UpgradeVersion.MAXSUPPORT)) > 0) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(jetRptReportSet.major.get()).append('.');
                stringBuffer.append(jetRptReportSet.minor.get()).append('.');
                stringBuffer.append(jetRptReportSet.dot3.get()).append('.');
                stringBuffer.append(jetRptReportSet.BuildNumber.get()).append(".SP");
                stringBuffer.append(jetRptReportSet.ServicePack.get());
                StringBuffer stringBuffer2 = new StringBuffer();
                stringBuffer2.append(BuildEnv.getMajor()).append('.');
                stringBuffer2.append(BuildEnv.getMinor()).append('.');
                stringBuffer2.append(BuildEnv.getDot3()).append('.');
                stringBuffer2.append(BuildEnv.getBuildNumber()).append(".SP");
                stringBuffer2.append(BuildEnv.getServicepack());
                throw new JUpgradeNotSupportedException(219001, (Object[])new String[]{stringBuffer.toString(), stringBuffer2.toString()}, null);
            }
            if (n2 == 0) {
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "ReportSet built in same Version, need not upgrade, reportset=" + jetRptObject);
                }
                return jetRptObject;
            }
            Clocker clocker = null;
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "ReportSet upgrade start, For Reportset=" + jetRptObject + ", " + upgradeVersion);
                clocker = new Clocker();
            } else if (JRLog.isTrace(4)) {
                JRLog.trace(4, "ReportSet upgrade start, For Reportset=" + jetRptObject + ", " + upgradeVersion);
            }
            UpgradeDataContext upgradeDataContext = new UpgradeDataContext(jetUUniverse);
            String string = jetRptReportSet.getFullFileName();
            if (string != null) {
                upgradeDataContext.setPreLoadedLinkedOrSubObject(new File(string), jetRptReportSet);
            }
            UpgradeResContext upgradeResContext = new UpgradeResContext();
            ImageProvider imageProvider = null;
            if (jetUUniverse == null) {
                imageProvider = ImageProviderFactory.createDefaultImageProvider(null, resourceStore == null ? null : resourceStore.getMemoryStore());
            } else {
                object = new File(jetUUniverse.getFullFileName());
                imageProvider = ImageProviderFactory.createDefaultImageProvider((File)object, resourceStore == null ? null : resourceStore.getMemoryStore());
            }
            upgradeResContext.setCurrentImageProvider(imageProvider);
            upgradeResContext.setCurrentResourceStore(resourceStore);
            object = new UpgradeContext(n, upgradeDataContext, upgradeResContext);
            URptReportSetTask uRptReportSetTask = new URptReportSetTask(jetRptReportSet, upgradeVersion, (UpgradeContext)object);
            try {
                jetRptReportSet.refer();
                UpgradeResult upgradeResult = uRptReportSetTask.call();
                JetRptObject jetRptObject3 = (JetRptObject)upgradeResult.newObject;
                return jetRptObject3;
            }
            finally {
                jetRptReportSet.free();
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "Reportset upgrade end; For Reportset=" + jetRptObject + ",Elapsed:" + clocker.elapsed());
                } else if (JRLog.isTrace(4)) {
                    JRLog.trace(4, "Reportset upgrade end; For Reportset=" + jetRptObject);
                }
            }
        }
        if (JRLog.isError(1)) {
            JRLog.error(1, "[Upgrade Fatal log]:Unkown Object, can not start upgrade. object=" + jetRptObject);
        }
        return jetRptObject;
    }
}

