/*
 * Decompiled with CFR 0.152.
 */
package jet.upgrade.impl;

import com.jinfonet.util.JRLog;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import jet.controls.JetContainable;
import jet.controls.JetObject;
import jet.upgrade.JUpgradeFailtureException;
import jet.upgrade.UpgradeContext;
import jet.upgrade.UpgradeDataContext;
import jet.upgrade.UpgradeResContext;
import jet.upgrade.UpgradeResult;
import jet.upgrade.UpgradeTask;
import jet.upgrade.UpgradeVersion;
import jet.upgrade.impl.UpgradeAdapter;
import jet.upgrade.kit.UpgradeToolkit;

public class DefaultUpgradeTask
implements UpgradeTask {
    protected JetObject oldrptObject;
    private UpgradeContext SEDU;
    protected UpgradeVersion srcVersion;

    protected DefaultUpgradeTask(JetObject jetObject, UpgradeVersion upgradeVersion, UpgradeContext upgradeContext) {
        this.oldrptObject = jetObject;
        this.srcVersion = upgradeVersion;
        this.resetContext(upgradeContext);
    }

    protected final void resetContext(UpgradeContext upgradeContext) {
        this.SEDU = upgradeContext;
    }

    protected final UpgradeContext getContext() {
        return this.SEDU;
    }

    protected final UpgradeDataContext getDataContext() {
        return this.SEDU.getDataContext();
    }

    protected final UpgradeResContext getResourceContext() {
        return this.SEDU.getResourceContext();
    }

    @Override
    public UpgradeResult call() throws JUpgradeFailtureException {
        String string = null;
        if (JRLog.isTrace(7)) {
            string = "[Upgrade Proc] Task for " + this.oldrptObject.getClass() + "[" + this.oldrptObject.getInstNameDirectly() + "] from " + this.srcVersion;
            JRLog.trace(7, string + ", START.");
        }
        this.beforeUpgradeStart();
        List list = new Vector();
        Hashtable<JetObject, JetObject> hashtable = new Hashtable<JetObject, JetObject>();
        List list2 = new Vector();
        JetObject jetObject = this.createNewBasicStructure(list2, list);
        if (jetObject != null) {
            Vector vector;
            JetObject jetObject2 = this.getMainEditObject(jetObject);
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, string + ",[1/4] Upgrade to:" + jetObject.getClass().getName() + "|" + jetObject2.getClass().getName());
            }
            hashtable.put(this.oldrptObject, jetObject2);
            this.copyProperties(jetObject2, list2, list);
            this.afterCopyProperties(jetObject2, list2);
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, string + ",[2/4]");
            }
            if ((vector = this.oldrptObject.getChildren()) != null) {
                this.fillStructureViaChildren(jetObject2, vector, hashtable, list2, list);
            }
            this.fillStructureViaOldProperties(jetObject2, list2, list);
            this.afterFillStructure(jetObject2, hashtable, list2, list);
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, string + ",[3/4]");
            }
            list2 = this.handleOuterReferences(list2, hashtable);
            list = this.handleAdditionalObjs(jetObject, list);
            this.beforeUpgradeEnd(jetObject, jetObject2);
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, string + ", ACCOMPLISH");
            }
            return new UpgradeResult(jetObject, hashtable, list2, list);
        }
        if (JRLog.isTrace(7)) {
            JRLog.trace(7, string + ", Upgrade to: null");
        }
        this.beforeUpgradeEnd(jetObject, null);
        if (JRLog.isTrace(7)) {
            JRLog.trace(7, string + ", ACCOMPLISH");
        }
        return null;
    }

    protected void afterCopyProperties(JetObject jetObject, List list) throws JUpgradeFailtureException {
        if (this.srcVersion.compareTo(UpgradeVersion.V7X) > 0 && this.srcVersion.compareTo(UpgradeVersion.V13D5) < 0) {
            UpgradeToolkit.adjustBLColumnablesBeforeV13D5(jetObject, this.oldrptObject, this.getDataContext());
        }
    }

    protected void fillStructureViaChildren(JetObject jetObject, List list, Map map, List list2, List list3) throws JUpgradeFailtureException {
        if (list != null) {
            for (JetObject jetObject2 : list) {
                UpgradeResult upgradeResult = this.getChildUpgradeResult(jetObject2);
                if (upgradeResult == null) continue;
                map.putAll(upgradeResult.oldToNew);
                list3.addAll(upgradeResult.addtionalObjs);
                list2.addAll(upgradeResult.outerRefers);
                this.handleConvertedChild(jetObject, upgradeResult.newObject);
            }
        }
    }

    protected void fillStructureViaOldProperties(JetObject jetObject, List list, List list2) throws JUpgradeFailtureException {
    }

    protected void afterFillStructure(JetObject jetObject, Map map, List list, List list2) throws JUpgradeFailtureException {
    }

    protected void beforeUpgradeStart() throws JUpgradeFailtureException {
    }

    protected void beforeUpgradeEnd(JetObject jetObject, JetObject jetObject2) {
    }

    protected JetObject createNewBasicStructure(List list, List list2) throws JUpgradeFailtureException {
        try {
            JetObject jetObject = (JetObject)this.oldrptObject.getClass().newInstance();
            jetObject.setEditable();
            jetObject.setInstNameDirectly(this.oldrptObject.getInstName());
            return jetObject;
        }
        catch (Throwable throwable) {
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, "[Upgrade Proc]:Create new structure failed: ", throwable);
            }
            throw new JUpgradeFailtureException(throwable);
        }
    }

    protected JetObject getMainEditObject(JetObject jetObject) {
        return jetObject;
    }

    protected void copyProperties(JetObject jetObject, List list, List list2) throws JUpgradeFailtureException {
        UpgradeToolkit.copyProperties(jetObject, this.oldrptObject, list, new String[0]);
    }

    protected final void copyProperties(JetObject jetObject, List list, List list2, String ... stringArray) throws JUpgradeFailtureException {
        if (JRLog.isTrace(7) && stringArray != null) {
            JRLog.trace(7, "[Upgrade Proc] Move context-free properties, Ingore: " + Arrays.toString(stringArray));
        }
        UpgradeToolkit.copyProperties(jetObject, this.oldrptObject, list, stringArray);
    }

    protected UpgradeResult getChildUpgradeResult(JetObject jetObject) throws JUpgradeFailtureException {
        UpgradeTask upgradeTask = UpgradeAdapter.createUpgradeTask(jetObject, this.srcVersion, this.getContext());
        return upgradeTask.call();
    }

    protected void handleConvertedChild(JetObject jetObject, JetObject jetObject2) {
        if (jetObject instanceof JetContainable) {
            ((JetContainable)((Object)jetObject)).add(jetObject2);
        } else if (JRLog.isTrace(7)) {
            JRLog.trace(7, "[Upgrade Proc] :can not insert posterity to non-container");
        }
    }

    protected List handleAdditionalObjs(JetObject jetObject, List list) {
        return list;
    }

    protected List handleOuterReferences(List list, Map map) {
        return list;
    }
}

