/*
 * Decompiled with CFR 0.152.
 */
package jet.upgrade.impl;

import com.jinfonet.util.JRLog;
import java.util.List;
import java.util.Map;
import jet.ReportEnv;
import jet.controls.JetObject;
import jet.controls.JetProperty;
import jet.controls.JetReference;
import jet.controls.JetReferences;
import jet.naming.PropertyNames;
import jet.reportset.JetRptDataSet;
import jet.reportset.JetRptDataSets;
import jet.reportset.JetRptReportSet;
import jet.universe.JetUUniverse;
import jet.upgrade.JUpgradeFailtureException;
import jet.upgrade.UpgradeContext;
import jet.upgrade.UpgradeDataContext;
import jet.upgrade.UpgradeResult;
import jet.upgrade.UpgradeVersion;
import jet.upgrade.impl.DefaultUpgradeTask;
import jet.upgrade.kit.UpgradeToolkit;

public class URptReportSetTask
extends DefaultUpgradeTask {
    public URptReportSetTask(JetRptReportSet jetRptReportSet, UpgradeVersion upgradeVersion, UpgradeContext upgradeContext) {
        super(jetRptReportSet, upgradeVersion, upgradeContext);
    }

    @Override
    protected void beforeUpgradeStart() throws JUpgradeFailtureException {
        if (((JetRptReportSet)this.oldrptObject).isBoundled()) {
            JetUUniverse jetUUniverse = ((JetRptReportSet)this.oldrptObject).getBindUniverse();
            if (jetUUniverse != null) {
                UpgradeDataContext upgradeDataContext = this.getContext().getDataContext();
                upgradeDataContext.setCurrentUniverse(jetUUniverse);
            } else {
                throw new JUpgradeFailtureException(219002, "There is no Catalog in Self-Contained Report.");
            }
        }
    }

    protected void fillStructureViaChildren(JetRptReportSet jetRptReportSet, List list, Map map, List list2, List list3) throws JUpgradeFailtureException {
        JetObject jetObject;
        Object object;
        int n;
        int n2 = -1;
        int n3 = list.size();
        for (n = 0; n < n3; ++n) {
            object = list.get(n);
            if (!(object instanceof JetRptDataSets)) continue;
            n2 = n;
        }
        if (n2 >= 0 && (object = this.getChildUpgradeResult(jetObject = (JetObject)list.get(n2))) != null) {
            map.putAll(((UpgradeResult)object).oldToNew);
            list3.addAll(((UpgradeResult)object).addtionalObjs);
            list2.addAll(((UpgradeResult)object).outerRefers);
            jetRptReportSet.add(((UpgradeResult)object).newObject);
        }
        for (n = 0; n < n3; ++n) {
            Object object2;
            if (n == n2) continue;
            object = (JetObject)list.get(n);
            Object object3 = null;
            if (object instanceof JetUUniverse) {
                object2 = (JetUUniverse)((JetUUniverse)object).deepDupWithName();
                ((JetUUniverse)object2).InitAfterLoad();
                map.put(object, object2);
                object3 = object2;
            } else {
                object2 = this.getChildUpgradeResult((JetObject)object);
                if (object2 != null) {
                    map.putAll(((UpgradeResult)object2).oldToNew);
                    list3.addAll(((UpgradeResult)object2).addtionalObjs);
                    list2.addAll(((UpgradeResult)object2).outerRefers);
                    object3 = ((UpgradeResult)object2).newObject;
                } else {
                    object3 = null;
                }
            }
            if (object3 == null) continue;
            if (n < n2) {
                jetRptReportSet.add((JetObject)object3, n);
                continue;
            }
            jetRptReportSet.add((JetObject)object3);
        }
    }

    protected void beforeUpgradeEnd(JetObject jetObject, JetRptReportSet jetRptReportSet) {
        jetObject.createNamingSystem(true);
        JetObject.afterNewTree(jetObject);
    }

    protected void copyProperties(JetRptReportSet jetRptReportSet, List list, List list2) throws JUpgradeFailtureException {
        super.copyProperties(jetRptReportSet, list, list2, PropertyNames.getDefinitionName(PropertyNames.major), PropertyNames.getDefinitionName(PropertyNames.minor), PropertyNames.getDefinitionName(PropertyNames.dot3), PropertyNames.getDefinitionName(PropertyNames.BuildNumber), PropertyNames.getDefinitionName(PropertyNames.ServicePack));
        jetRptReportSet.major.set(ReportEnv.major);
        jetRptReportSet.minor.set(ReportEnv.minor);
        jetRptReportSet.dot3.set(ReportEnv.dot3);
        jetRptReportSet.BuildNumber.set(ReportEnv.BuildNumber);
        jetRptReportSet.ServicePack.set(ReportEnv.servicepack);
        jetRptReportSet.setDefaultReportLevelResourcesPath(((JetRptReportSet)this.oldrptObject).getDefaultReportLevelResourcesPath());
        jetRptReportSet.setFullFileName(((JetRptReportSet)this.oldrptObject).getFullFileName());
        jetRptReportSet.setEditableFlag(((JetRptReportSet)this.oldrptObject).isEditable());
        jetRptReportSet.setInnerType(((JetRptReportSet)this.oldrptObject).isDemoSample() ? 1 : 0);
    }

    @Override
    protected List handleAdditionalObjs(JetObject jetObject, List list) {
        JetRptReportSet jetRptReportSet = (JetRptReportSet)jetObject;
        JetRptDataSets jetRptDataSets = jetRptReportSet.getDataSets();
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            JetObject jetObject2 = (JetObject)list.get(n2);
            if (jetObject2 instanceof JetRptDataSet) {
                jetRptDataSets.add((JetRptDataSet)jetObject2);
                list.remove(n2);
                --n;
                continue;
            }
            ++n2;
        }
        if (JRLog.isTrace(7)) {
            JRLog.trace(7, "[Upgrade Proc] " + list.size() + " additional objects left.");
        }
        return list;
    }

    @Override
    protected List handleOuterReferences(List list, Map map) {
        int n = list.size();
        int n2 = (list = UpgradeToolkit.handleOuterReferences(list, map)).size();
        if (n2 > 0) {
            if (JRLog.isTrace(7)) {
                StringBuilder stringBuilder = new StringBuilder();
                for (JetObject[] jetObjectArray : list) {
                    if (jetObjectArray instanceof JetReference) {
                        stringBuilder.append(jetObjectArray.getName() + "(JetReference of " + jetObjectArray.getParent().getClass() + "):" + jetObjectArray.toUnitString());
                    } else {
                        stringBuilder.append(jetObjectArray.getName() + "(JetReferences of " + jetObjectArray.getParent().getClass() + "):" + jetObjectArray.toUnitString());
                    }
                    stringBuilder.append(",");
                }
                JRLog.trace(7, "[Upgrade Proc] " + (n - n2) + " properties(out-referTo) handed, " + n2 + " properties(out-referTo) left: " + stringBuilder.substring(0, stringBuilder.length() - 1));
            }
            for (Object object : list) {
                JetObject[] jetObjectArray;
                if (object instanceof JetReference) {
                    ((JetProperty)object).set(null);
                    continue;
                }
                for (JetObject jetObject : jetObjectArray = ((JetReferences)object).get()) {
                    ((JetReferences)object).removeReference(jetObject);
                }
            }
        } else if (JRLog.isTrace(7)) {
            JRLog.trace(7, "[Upgrade Proc] " + (n - n2) + " properties(out-referTo) handed, 0 properties(out-referTo) left.");
        }
        return list;
    }
}

