/*
 * Decompiled with CFR 0.152.
 */
package jet.upgrade.impl;

import com.jinfonet.util.JRLog;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import jet.controls.JetBoolean;
import jet.controls.JetObject;
import jet.controls.JetProperty;
import jet.controls.JetReference;
import jet.ireport.IReport;
import jet.naming.PropertyNames;
import jet.report.JetRptBnFilterCtrlContainer;
import jet.report.conditionalFormatting.ConditionalFormattingManager;
import jet.reportset.JetRptReport;
import jet.upgrade.JUpgradeFailtureException;
import jet.upgrade.UpgradeContext;
import jet.upgrade.UpgradeDataContext;
import jet.upgrade.UpgradeVersion;
import jet.upgrade.impl.DefaultUpgradeTask;
import jet.upgrade.kit.UpgradeToolkit;

public class URptReportTask
extends DefaultUpgradeTask {
    private int NoPageBreak = 0;

    URptReportTask(JetRptReport jetRptReport, UpgradeVersion upgradeVersion, UpgradeContext upgradeContext) {
        super(jetRptReport, upgradeVersion, upgradeContext);
    }

    @Override
    protected void beforeUpgradeStart() throws JUpgradeFailtureException {
        super.beforeUpgradeStart();
        UpgradeDataContext upgradeDataContext = this.getDataContext().cloneIt(false, false);
        upgradeDataContext.setCurrentIReport((IReport)((Object)this.oldrptObject));
        upgradeDataContext.setCurrentQueryInfo(false, null);
        this.resetContext(new UpgradeContext(this.getContext().getOverallUseType(), upgradeDataContext, this.getContext().getResourceContext()));
    }

    @Override
    protected JetObject createNewBasicStructure(List list, List list2) throws JUpgradeFailtureException {
        JetRptReport jetRptReport = (JetRptReport)super.createNewBasicStructure(list, list2);
        if (this.srcVersion.compareTo(UpgradeVersion.V10GA) < 0) {
            JetRptBnFilterCtrlContainer jetRptBnFilterCtrlContainer = new JetRptBnFilterCtrlContainer();
            jetRptBnFilterCtrlContainer.setEditable();
            jetRptReport.add(jetRptBnFilterCtrlContainer);
        }
        return jetRptReport;
    }

    protected void beforeUpgradeEnd(JetObject jetObject, JetRptReport jetRptReport) {
        ConditionalFormattingManager conditionalFormattingManager = jetRptReport.getConditionalFormattingManager();
        try {
            conditionalFormattingManager.compileCfFormula(this.getDataContext().getCurrentUniverse(), this.getResourceContext().getResourceStore());
        }
        catch (IOException iOException) {
            conditionalFormattingManager.forceRecompile(true);
        }
        super.beforeUpgradeEnd(jetObject, jetRptReport);
    }

    protected void handleConvertedChild(JetRptReport jetRptReport, JetObject jetObject) {
        jetRptReport.add(jetObject, this.NoPageBreak++);
    }

    protected void afterCopyProperties(JetRptReport jetRptReport, List list) throws JUpgradeFailtureException {
        if (this.srcVersion.compareTo(UpgradeVersion.V11D1) < 0) {
            ((JetBoolean)jetRptReport.nameToProperty(PropertyNames.getDefinitionName(PropertyNames.NoPageBreak))).set(this.getContext().getOverallUseType() == 9);
        }
        if (this.srcVersion.compareTo(UpgradeVersion.V12) < 0) {
            if (this.getContext().getOverallUseType() == 9) {
                jetRptReport.setClickPriorityOrder(new String[]{"link", "go_down"});
            } else {
                jetRptReport.setClickPriorityOrder(new String[]{"link", "drill_down", "go_to_detail"});
            }
        }
        if (this.srcVersion.compareTo(UpgradeVersion.V13D5) < 0) {
            UpgradeToolkit.adjustOnParameterValueChangeBeforeV13D5(jetRptReport, this.getDataContext().getCurrentUniverse(), (IReport)((Object)this.oldrptObject));
        }
    }

    @Override
    protected List handleAdditionalObjs(JetObject jetObject, List list) {
        return UpgradeToolkit.insertAdditionalObjectsToReport((JetRptReport)jetObject, list);
    }

    @Override
    protected List handleOuterReferences(List list, Map map) {
        int n = list.size();
        int n2 = (list = UpgradeToolkit.handleOuterReferences(list, map)).size();
        if (n2 > 0) {
            if (JRLog.isTrace(7)) {
                StringBuilder stringBuilder = new StringBuilder();
                for (JetProperty jetProperty : list) {
                    if (jetProperty instanceof JetReference) {
                        stringBuilder.append(jetProperty.getName() + "(JetReference of " + jetProperty.getParent().getClass() + "):" + jetProperty.toUnitString());
                    } else {
                        stringBuilder.append(jetProperty.getName() + "(JetReferences of " + jetProperty.getParent().getClass() + "):" + jetProperty.toUnitString());
                    }
                    stringBuilder.append(",");
                }
                JRLog.trace(7, "[Upgrade Proc] " + (n - n2) + " properties(out-referTo) handed, " + n2 + " properties(out-referTo) left: " + stringBuilder.substring(0, stringBuilder.length() - 1));
            }
        } else if (JRLog.isTrace(7)) {
            JRLog.trace(7, "[Upgrade Proc] " + (n - n2) + " properties(out-referTo) handed, 0 properties(out-referTo) left.");
        }
        return list;
    }
}

