/*
 * Decompiled with CFR 0.152.
 */
package jet.upgrade.impl;

import com.jinfonet.util.JRLog;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import jet.controls.JetContainable;
import jet.controls.JetObject;
import jet.controls.JetProperty;
import jet.controls.JetReference;
import jet.controls.JetReferences;
import jet.icontrols.QueryInfo;
import jet.ireport.IReport;
import jet.report.JRObjectTemplate;
import jet.report.JetRptDBField;
import jet.report.JetRptField;
import jet.report.JetRptObject;
import jet.report.JetRptPicture;
import jet.report.paragraph.build.JetRptParaReplaceElement;
import jet.report.paragraph.build.JetRptParagraph;
import jet.report.table.JetRptNewTable;
import jet.report.table.JetRptTableCell;
import jet.report.table.JetRptTableColumn;
import jet.report.table.JetRptTableDetailColumn;
import jet.report.table.JetRptTableSummaryColumn;
import jet.reportLogic.objectInfo.MeasureInfo;
import jet.reportLogic.objectLogic.BasicComponentLogic;
import jet.reportLogic.objectLogic.ObjectLogicFactory;
import jet.reportLogic.objectLogic.ParagraphLogic;
import jet.reportset.DataSet;
import jet.rptservice.util.ReportTools;
import jet.universe.JetUFormula;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUSummary;
import jet.universe.JetUUniverse;
import jet.upgrade.JUpgradeFailtureException;
import jet.upgrade.UpgradeContext;
import jet.upgrade.UpgradeDataContext;
import jet.upgrade.UpgradeVersion;
import jet.upgrade.impl.UIDataContainerTask;
import jet.upgrade.kit.UpgradeToolkit;
import jet.util.IntKeyHashtable;
import jet.util.IntVector;
import jet.util.TreeIterater;

public class URptV8XTableTask
extends UIDataContainerTask {
    URptV8XTableTask(JetRptNewTable jetRptNewTable, UpgradeVersion upgradeVersion, UpgradeContext upgradeContext) {
        super(jetRptNewTable, upgradeVersion, upgradeContext);
    }

    protected void afterFillStructure(JetRptNewTable jetRptNewTable, Map map, List list, List list2) throws JUpgradeFailtureException {
        super.afterFillStructure(jetRptNewTable, map, list, list2);
        if (this.srcVersion.compareTo(UpgradeVersion.V10GA) < 0) {
            JetObject jetObject2;
            jetRptNewTable.afterInit();
            jetRptNewTable.nameToProperty("AutoExpands").setUnitValue("false");
            DataSet dataSet = ObjectLogicFactory.getDataContainerLogic().getUsedDataSet((JetRptNewTable)this.oldrptObject);
            this.V13D5(jetRptNewTable, dataSet, this.getDataContext().getCurrentUniverse());
            this.V10GA(jetRptNewTable, this.getDataContext().getCurrentUniverse());
            this.colWidth(jetRptNewTable);
            Vector vector = jetRptNewTable.getTableHeaders();
            if (vector != null && vector.size() > 0) {
                for (JetObject jetObject2 : vector) {
                    ((JRObjectTemplate)jetObject2).getProperty("RepeatHeaderForExcel").setUnitValue("true");
                    ((JRObjectTemplate)jetObject2).getProperty("RepeatHeaderForTxt").setUnitValue("true");
                    ((JRObjectTemplate)jetObject2).getProperty("RepeatHeaderForXML").setUnitValue("true");
                }
            }
            this.SEDU(jetRptNewTable);
            TreeIterater treeIterater = new TreeIterater(jetRptNewTable, false);
            jetObject2 = (JetObject)treeIterater.next();
            while (jetObject2 != null) {
                this.compareTo(jetObject2, list2);
                jetObject2 = (JetObject)treeIterater.next();
            }
        } else if (this.srcVersion.compareTo(UpgradeVersion.V13D5) < 0) {
            this.createParagraphObject(jetRptNewTable, this.getDataContext());
        }
    }

    private void SEDU(JetRptNewTable jetRptNewTable) {
        int n;
        int n2 = jetRptNewTable.getColumNum();
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            n3 += jetRptNewTable.getColumWidth(n).getUnit();
        }
        n3 = n3 + ObjectLogicFactory.getTableLogic().getTableBorderWidth(jetRptNewTable, 2) + ObjectLogicFactory.getTableLogic().getTableBorderWidth(jetRptNewTable, 3);
        if (jetRptNewTable.width.getUnit() != n3) {
            jetRptNewTable.width.setUnitValue(String.valueOf(n3));
        }
        n = jetRptNewTable.getRowNum();
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            n4 += jetRptNewTable.getRowHeight(i).getUnit();
        }
        n4 = n4 + ObjectLogicFactory.getTableLogic().getTableBorderWidth(jetRptNewTable, 0) + ObjectLogicFactory.getTableLogic().getTableBorderWidth(jetRptNewTable, 1);
        if (jetRptNewTable.height.getUnit() != n4) {
            jetRptNewTable.height.setUnitValue(String.valueOf(n4));
        }
    }

    private void V10GA(JetRptNewTable jetRptNewTable, JetUUniverse jetUUniverse) {
        ObjectLogicFactory.getTableLogic().processGroups(jetUUniverse, jetRptNewTable);
    }

    private void V13D5(JetRptNewTable jetRptNewTable, DataSet dataSet, JetUUniverse jetUUniverse) {
        int n;
        Vector vector = jetRptNewTable.getTableColumns();
        for (int i = n = jetRptNewTable.getInlinePanels().size(); i < vector.size(); ++i) {
            Object object;
            JetRptTableColumn jetRptTableColumn = (JetRptTableColumn)vector.elementAt(i);
            Vector vector2 = jetRptNewTable.getTableCells(jetRptTableColumn);
            JetRptDBField jetRptDBField = this.afterInit(vector2);
            int n2 = -1;
            String string = "";
            String string2 = "";
            if (jetRptDBField == null) continue;
            if (dataSet.getDataResourceType() == 0) {
                int n3;
                string = jetRptDBField.columnName.get();
                if (jetUUniverse == null || (object = jetUUniverse.getResourceByName(string)) == null) continue;
                string = ((JetUResourceEntity)object).name.get();
                if (object instanceof JetUSummary) {
                    n2 = 0;
                }
                n2 = object instanceof JetUFormula ? ((n3 = ReportTools.getFormulaType(jetUUniverse, dataSet.getDataSourceName(), (JetUFormula)object)) == 103 ? 0 : 1) : 1;
            } else if (dataSet.getDataResourceType() == 1) {
                string2 = jetRptDBField.blColumnName.get();
                if (jetUUniverse == null || (object = ObjectLogicFactory.getDataSetLogic().getRefDataElement(jetUUniverse, null, dataSet, string2)) == null) continue;
                n2 = object instanceof MeasureInfo ? 0 : 1;
            }
            this.add(jetRptNewTable, jetRptTableColumn, n2, string, string2, vector);
        }
    }

    private void add(JetRptNewTable jetRptNewTable, JetRptTableColumn jetRptTableColumn, int n, String string, String string2, Vector vector) {
        String string3 = string;
        if (string == null || string.trim().length() == 0) {
            string3 = string2;
        }
        JetRptTableColumn jetRptTableColumn2 = null;
        switch (n) {
            case 0: {
                jetRptTableColumn2 = new JetRptTableSummaryColumn(string3);
                break;
            }
            case 1: {
                jetRptTableColumn2 = new JetRptTableDetailColumn(string3);
                break;
            }
            default: {
                return;
            }
        }
        JetContainable jetContainable = jetRptTableColumn.getParent();
        this.afterFillStructure(jetRptTableColumn2, jetRptTableColumn);
        int n2 = vector.indexOf(jetRptTableColumn);
        ObjectLogicFactory.getBasicComponentLogic().add(jetContainable, jetRptTableColumn2, n2);
        ObjectLogicFactory.getBasicComponentLogic().remove(jetRptTableColumn);
    }

    private void afterFillStructure(JetRptTableColumn jetRptTableColumn, JetRptTableColumn jetRptTableColumn2) {
        jetRptTableColumn.colWidth.set(jetRptTableColumn2.colWidth.get());
        jetRptTableColumn.getInvisible().loadFullChangeBy(jetRptTableColumn2.hide.saveFullChangeBy());
        jetRptTableColumn.getInvisible().set(jetRptTableColumn2.hide.get());
        jetRptTableColumn.suppressed.loadFullChangeBy(jetRptTableColumn2.suppressed.saveFullChangeBy());
        jetRptTableColumn.suppressed.set(jetRptTableColumn2.suppressed.get());
    }

    private JetRptDBField afterInit(Vector vector) {
        JetRptTableCell jetRptTableCell;
        JetRptDBField jetRptDBField = null;
        for (int i = 0; i < vector.size() && (jetRptDBField = this.append(jetRptTableCell = (JetRptTableCell)vector.elementAt(i))) == null; ++i) {
        }
        return jetRptDBField;
    }

    private JetRptDBField append(JetRptTableCell jetRptTableCell) {
        JetRptDBField jetRptDBField = null;
        Vector vector = jetRptTableCell.getChildren();
        for (int i = 0; i < vector.size(); ++i) {
            JetRptObject jetRptObject = (JetRptObject)vector.elementAt(i);
            if (jetRptObject instanceof JetRptParagraph) {
                jetRptDBField = this.blColumnName((JetRptParagraph)jetRptObject);
                if (jetRptDBField == null) continue;
                break;
            }
            if (!(jetRptObject instanceof JetRptDBField)) continue;
            jetRptDBField = (JetRptDBField)jetRptObject;
            break;
        }
        return jetRptDBField;
    }

    private JetRptDBField blColumnName(JetRptParagraph jetRptParagraph) {
        JetRptDBField jetRptDBField = null;
        Vector vector = jetRptParagraph.getChildren();
        for (int i = 0; vector != null && i < vector.size(); ++i) {
            if (!(vector.get(i) instanceof JetRptParaReplaceElement) || !(((JetRptParaReplaceElement)vector.get(i)).getObject() instanceof JetRptDBField)) continue;
            return jetRptDBField;
        }
        return null;
    }

    private void colWidth(JetRptNewTable jetRptNewTable) {
        ParagraphLogic paragraphLogic = ObjectLogicFactory.getParagraphLogic();
        BasicComponentLogic basicComponentLogic = ObjectLogicFactory.getBasicComponentLogic();
        IntKeyHashtable intKeyHashtable = jetRptNewTable.getTableCells();
        IntVector intVector = intKeyHashtable.keys();
        JetRptParagraph jetRptParagraph = null;
        for (int i = 0; i < intVector.size(); ++i) {
            int n = intVector.elementAt(i);
            JetRptTableCell jetRptTableCell = (JetRptTableCell)intKeyHashtable.get(n);
            Vector vector = jetRptTableCell.getChildren();
            jetRptParagraph = this.columnName(jetRptTableCell);
            int n2 = 0;
            while (n2 < vector.size()) {
                Object e = vector.elementAt(n2);
                if (e instanceof JetRptField || e instanceof JetRptPicture) {
                    if (jetRptParagraph == null) {
                        jetRptParagraph = paragraphLogic.createParagraphObject();
                        basicComponentLogic.add(jetRptTableCell, jetRptParagraph);
                    }
                    ((JRObjectTemplate)e).position.set(2);
                    JetRptParaReplaceElement jetRptParaReplaceElement = new JetRptParaReplaceElement();
                    jetRptParaReplaceElement.setEditable();
                    paragraphLogic.insertReplaceObjectAtPosition(jetRptParagraph, jetRptParaReplaceElement, 0);
                    JetRptObject jetRptObject = (JetRptObject)e;
                    if (jetRptObject instanceof JRObjectTemplate) {
                        ((JRObjectTemplate)jetRptObject).display.set(1);
                    }
                    jetRptObject.setParentDirectly(jetRptParaReplaceElement);
                    vector.remove(jetRptObject);
                    jetRptParaReplaceElement.getChildren().add(jetRptObject);
                    continue;
                }
                ++n2;
            }
        }
    }

    private JetRptParagraph columnName(JetRptTableCell jetRptTableCell) {
        Vector vector = jetRptTableCell.getChildren();
        for (int i = 0; i < vector.size(); ++i) {
            if (!(vector.elementAt(i) instanceof JetRptParagraph)) continue;
            return (JetRptParagraph)vector.elementAt(i);
        }
        return null;
    }

    private void compareTo(JetObject jetObject, List list) {
        for (JetProperty jetProperty : jetObject.getProperties().values()) {
            JetObject[] jetObjectArray;
            if (jetProperty instanceof JetReference) {
                jetObjectArray = ((JetReference)jetProperty).getObject();
                if (jetObjectArray == null || ((JetObject)jetObjectArray).getParent() != null) continue;
                list.add((JetObject)jetObjectArray);
                continue;
            }
            if (!(jetProperty instanceof JetReferences) || (jetObjectArray = ((JetReferences)jetProperty).get()) == null) continue;
            for (JetObject jetObject2 : jetObjectArray) {
                if (jetObject2 == null || jetObject2.getParent() != null) continue;
                list.add(jetObject2);
            }
        }
    }

    private void createParagraphObject(JetRptNewTable jetRptNewTable, UpgradeDataContext upgradeDataContext) throws JUpgradeFailtureException {
        QueryInfo queryInfo = upgradeDataContext.getCurrentQueryInfo();
        if (queryInfo == null) {
            return;
        }
        int n = queryInfo.getDataResoureType();
        if (n == 0) {
            return;
        }
        JetUUniverse jetUUniverse = upgradeDataContext.getCurrentUniverse();
        IReport iReport = upgradeDataContext.getCurrentIReport();
        Vector vector = jetRptNewTable.getTableColumns();
        int n2 = vector.size();
        for (int i = 0; i < n2; ++i) {
            JetRptTableColumn jetRptTableColumn = (JetRptTableColumn)vector.get(i);
            String string = jetRptTableColumn.getBindDataName();
            if (string == null || string.trim().isEmpty()) continue;
            String string2 = UpgradeToolkit.getQualifyDisplayNameByQualifyName(jetUUniverse, iReport, queryInfo, string);
            if (string2 == null) {
                if (JRLog.isTrace(7)) {
                    JRLog.trace(7, "[Upgrade proc]V13.5 Feature 105211(63810), org='" + string + "', obj=TableColumn[" + jetRptTableColumn.getInstNameDirectly() + ":BindData]");
                }
                string2 = string;
                if (!JRLog.isError(2)) continue;
                JRLog.error(2, 2210800, new Object[]{string, jetRptTableColumn.getInstNameDirectly(), "BindDataName"}, null);
                continue;
            }
            jetRptTableColumn.setBindDataName(string2);
        }
    }
}

