/*
 * Decompiled with CFR 0.152.
 */
package jet.upgrade.impl.v7x;

import com.jinfonet.util.JRLog;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import jet.ReportEnv;
import jet.controls.JetObject;
import jet.controls.JetProperty;
import jet.controls.JetReference;
import jet.controls.QueryInfoImpl;
import jet.naming.PropertyNames;
import jet.report.JetRptBnFilterCtrlContainer;
import jet.report.JetRptDataSource;
import jet.report.JetRptFilterContainer;
import jet.report.JetRptHDSDataSource;
import jet.report.JetRptPagePanel;
import jet.report.JetRptReportBody;
import jet.report.JetRptReportPanel;
import jet.report.JetRptSectionFooter;
import jet.report.JetRptSectionHeader;
import jet.report.JetRptSectionObject;
import jet.report.JetRptSectionPagePanel;
import jet.report.JetRptSortContainer;
import jet.report.JetRptTOC;
import jet.report.JetRptView;
import jet.report.JetRptViews;
import jet.report.conditionalFormatting.JetRptConditionalFormatSet;
import jet.report.conditionalFormatting.JetRptReportFormulaClassSet;
import jet.report.conditionallink.JetRptConditionalLinkSet;
import jet.report.filter.JetFilterExpression;
import jet.report.filter.JetRptTypedFilterExpression;
import jet.report.mode.JetRptModeContainer;
import jet.report.mode.actions.JetRptActionContainer;
import jet.reportset.JetRptDataSet;
import jet.reportset.JetRptDataSets;
import jet.reportset.JetRptHDSDataSet;
import jet.reportset.JetRptQueryDataSet;
import jet.reportset.JetRptReport;
import jet.reportset.JetRptReportSet;
import jet.reportset.JetRptReports;
import jet.universe.JetUHierDataSource;
import jet.universe.JetUQueriable;
import jet.universe.JetUUniverse;
import jet.upgrade.JUpgradeFailtureException;
import jet.upgrade.UpgradeContext;
import jet.upgrade.UpgradeDataContext;
import jet.upgrade.UpgradeResult;
import jet.upgrade.UpgradeVersion;
import jet.upgrade.impl.DefaultUpgradeTask;
import jet.upgrade.impl.v7x.URptV7XFilterContainerTask;
import jet.upgrade.kit.UpgradeToolkit;
import jet.upgrade.kit.V7XObjectUtil;

public final class URptV7ReportPanelTask
extends DefaultUpgradeTask {
    private boolean BuildNumber = false;
    private int ClickPriority = 0;
    private int InitAfterLoad = 0;
    private int NoPageBreak = 0;

    public URptV7ReportPanelTask(JetRptReportPanel jetRptReportPanel, UpgradeContext upgradeContext) {
        super(jetRptReportPanel, UpgradeVersion.V7X, upgradeContext);
    }

    @Override
    protected void beforeUpgradeStart() throws JUpgradeFailtureException {
        super.beforeUpgradeStart();
        JetRptDataSource jetRptDataSource = V7XObjectUtil.getDataSource((JetRptReportPanel)this.oldrptObject);
        if (jetRptDataSource == null) {
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, "[Upgrade Proc(V7X)] Error structure: Can not get DataSource");
            }
            throw new JUpgradeFailtureException(219002, "There is no DataSource in V7X Report.");
        }
        UpgradeDataContext upgradeDataContext = this.getContext().getDataContext();
        if (V7XObjectUtil.isBundled(jetRptDataSource)) {
            JetUUniverse jetUUniverse = V7XObjectUtil.getBindUniverse(jetRptDataSource);
            if (jetUUniverse == null) {
                if (JRLog.isTrace(7)) {
                    JRLog.trace(7, "[Upgrade Proc(V7X)] Error structure: Can not get Universe from BUNDLED Catalog Report");
                }
                throw new JUpgradeFailtureException(219002, "There is no Catalog in Self-Contained Report.");
            }
            upgradeDataContext.setCurrentUniverse(jetUUniverse);
            String string = jetRptDataSource.getDataSourceName();
            String string2 = jetRptDataSource.getQueryName();
            JetUQueriable jetUQueriable = jetUUniverse == null ? null : jetUUniverse.getQueriableByResourceName(string, string2);
            upgradeDataContext.setCurrentQueryInfo(jetUQueriable instanceof JetUHierDataSource, new QueryInfoImpl(((JetRptReportPanel)this.oldrptObject).getCatalogName(), string, string2, null, 0));
            this.BuildNumber = true;
        } else {
            JetUUniverse jetUUniverse = this.getDataContext().getCurrentUniverse();
            String string = jetRptDataSource.getDataSourceName();
            String string3 = jetRptDataSource.getQueryName();
            JetUQueriable jetUQueriable = jetUUniverse == null ? null : jetUUniverse.getQueriableByResourceName(string, string3);
            upgradeDataContext.setCurrentQueryInfo(jetUQueriable instanceof JetUHierDataSource, new QueryInfoImpl(((JetRptReportPanel)this.oldrptObject).getCatalogName(), string, string3, null, 0));
            this.BuildNumber = false;
        }
    }

    protected void beforeUpgradeEnd(JetObject jetObject, JetRptSectionObject jetRptSectionObject) {
        jetObject.createNamingSystem(true);
        JetObject.afterNewTree(jetObject);
        super.beforeUpgradeEnd(jetObject, jetRptSectionObject);
    }

    @Override
    protected JetRptReportSet createNewBasicStructure(List list, List list2) {
        JetRptReportPanel jetRptReportPanel = (JetRptReportPanel)this.oldrptObject;
        JetRptReportSet jetRptReportSet = new JetRptReportSet();
        jetRptReportSet.setEditable();
        jetRptReportSet.setInstNameDirectly(jetRptReportPanel.getInstName());
        jetRptReportSet.key.set(jetRptReportPanel.key.get());
        jetRptReportSet.restrict.set(jetRptReportPanel.restrict.get());
        jetRptReportSet.importParamValues.set(jetRptReportPanel.importParamValues.get());
        jetRptReportSet.sortParameter.setUnitValue(jetRptReportPanel.nameToProperty("SortParameter").toUnitString());
        jetRptReportSet.paraListAuto.set(jetRptReportPanel.paraListAuto.get());
        jetRptReportSet.major.set(ReportEnv.major);
        jetRptReportSet.minor.set(ReportEnv.minor);
        jetRptReportSet.dot3.set(ReportEnv.dot3);
        jetRptReportSet.BuildNumber.set(ReportEnv.BuildNumber);
        jetRptReportSet.ServicePack.set(ReportEnv.servicepack);
        JetRptReports jetRptReports = new JetRptReports();
        jetRptReports.setEditable();
        jetRptReportSet.add(jetRptReports);
        JetRptDataSets jetRptDataSets = new JetRptDataSets();
        jetRptDataSets.setEditable();
        jetRptReportSet.add(jetRptDataSets);
        JetRptReport jetRptReport = this.BuildNumber(list);
        jetRptReports.add(jetRptReport);
        jetRptReportSet.setCurReportId(jetRptReport.getInstName());
        if (this.BuildNumber) {
            JetUUniverse jetUUniverse = this.getDataContext().getCurrentUniverse();
            jetUUniverse = (JetUUniverse)jetUUniverse.deepDupWithName();
            jetUUniverse.InitAfterLoad();
            jetRptReportSet.setBoundUniverse(jetUUniverse);
        }
        return jetRptReportSet;
    }

    private JetRptReport BuildNumber(List list) {
        JetRptReport jetRptReport = new JetRptReport();
        jetRptReport.setEditable();
        jetRptReport.setInstName(((JetRptReportPanel)this.oldrptObject).getInstName() + "_report");
        UpgradeToolkit.copyProperties(jetRptReport, this.oldrptObject, list, PropertyNames.getDefinitionName(PropertyNames.NoPageBreak), PropertyNames.getDefinitionName(PropertyNames.key), PropertyNames.getDefinitionName(PropertyNames.restrict), PropertyNames.getDefinitionName(PropertyNames.ClickPriority));
        jetRptReport.setStatus(0);
        jetRptReport.setType(0);
        jetRptReport.setClickPriorityOrder(new String[]{"link", "drill_down", "go_to_detail"});
        JetRptReportBody jetRptReportBody = new JetRptReportBody();
        jetRptReportBody.setEditable();
        jetRptReportBody.width.set(-1);
        jetRptReportBody.height.set(-1);
        jetRptReportBody.dataInherit.set(false);
        jetRptReport.add(jetRptReportBody);
        JetRptSectionObject jetRptSectionObject = new JetRptSectionObject();
        jetRptSectionObject.setEditable();
        jetRptSectionObject.setInstNameDirectly("convert_sectionObject");
        jetRptReportBody.add(jetRptSectionObject);
        JetRptViews jetRptViews = new JetRptViews();
        jetRptViews.setEditable();
        JetRptView jetRptView = new JetRptView();
        jetRptView.setEditable();
        jetRptView.setInstNameDirectly(((JetRptReportPanel)this.oldrptObject).getInstName() + "_report" + "_view");
        jetRptViews.add(jetRptView);
        jetRptReport.add(jetRptViews);
        JetRptModeContainer jetRptModeContainer = new JetRptModeContainer();
        jetRptModeContainer.setEditable();
        jetRptReport.add(jetRptModeContainer);
        JetRptActionContainer jetRptActionContainer = new JetRptActionContainer();
        jetRptActionContainer.setEditable();
        jetRptReport.add(jetRptActionContainer);
        JetRptBnFilterCtrlContainer jetRptBnFilterCtrlContainer = new JetRptBnFilterCtrlContainer();
        jetRptBnFilterCtrlContainer.setEditable();
        jetRptReport.add(jetRptBnFilterCtrlContainer);
        JetRptConditionalFormatSet jetRptConditionalFormatSet = new JetRptConditionalFormatSet();
        jetRptConditionalFormatSet.setEditable();
        jetRptReport.add(jetRptConditionalFormatSet);
        JetRptReportFormulaClassSet jetRptReportFormulaClassSet = new JetRptReportFormulaClassSet();
        jetRptReportFormulaClassSet.setEditable();
        jetRptReport.add(jetRptReportFormulaClassSet);
        JetRptConditionalLinkSet jetRptConditionalLinkSet = new JetRptConditionalLinkSet();
        jetRptConditionalLinkSet.setEditable();
        jetRptReport.add(jetRptConditionalLinkSet);
        jetRptReport.beforeSave(null, null);
        return jetRptReport;
    }

    @Override
    protected JetRptSectionObject getMainEditObject(JetObject jetObject) {
        JetRptReportSet jetRptReportSet = (JetRptReportSet)jetObject;
        JetRptReport jetRptReport = jetRptReportSet.getCurReport();
        JetRptReportBody jetRptReportBody = jetRptReport.getRptBody();
        return (JetRptSectionObject)jetRptReportBody.getChildren().get(0);
    }

    protected void copyProperties(JetRptSectionObject jetRptSectionObject, List list, List list2) {
        JetRptSectionObject jetRptSectionObject2 = jetRptSectionObject;
        jetRptSectionObject2.position.set(0);
        jetRptSectionObject2.noRecordTip.set(((JetRptReportPanel)this.oldrptObject).noRecordTip.get());
        jetRptSectionObject2.compressIfNoRecord.set(((JetRptReportPanel)this.oldrptObject).compressIfNoRecord.get());
        jetRptSectionObject2.horizontal.set(((JetRptReportPanel)this.oldrptObject).horizontal.get());
        jetRptSectionObject2.showSubHeaderFooter.set(((JetRptReportPanel)this.oldrptObject).showSubHeaderFooter.get());
        jetRptSectionObject2.sortBy.set(((JetRptReportPanel)this.oldrptObject).sortBy.get());
        jetRptSectionObject2.sortOrder.set(((JetRptReportPanel)this.oldrptObject).sortOrder.get());
        if (((JetRptReportPanel)this.oldrptObject).topN.isChangeByOther()) {
            jetRptSectionObject2.selectType.set(1);
            jetRptSectionObject2.selectN.setChangeByObject(((JetRptReportPanel)this.oldrptObject).topN.getChangeByObject(), (short)0);
        } else if (((JetRptReportPanel)this.oldrptObject).topN.intValue() != -1) {
            jetRptSectionObject2.selectType.set(1);
            jetRptSectionObject2.selectN.set(((JetRptReportPanel)this.oldrptObject).topN.get());
        }
        jetRptSectionObject2.branch.set(((JetRptReportPanel)this.oldrptObject).branch.get());
        JetRptPagePanel jetRptPagePanel = V7XObjectUtil.getPage((JetRptReportPanel)this.oldrptObject);
        jetRptSectionObject2.width.setUnitValue(jetRptPagePanel.getUnitPageWidth());
        if (((JetRptReportPanel)this.oldrptObject).columned.get()) {
            jetRptSectionObject2.rowIndex.set(1);
            jetRptSectionObject2.columnIndex.set(1);
        }
        jetRptSectionObject2.cache.set(false);
    }

    protected void afterCopyProperties(JetRptSectionObject jetRptSectionObject, List list) throws JUpgradeFailtureException {
    }

    private static JetRptDataSet ClickPriority(JetRptReportPanel jetRptReportPanel, JetRptDataSource jetRptDataSource, JetUUniverse jetUUniverse) {
        String string = jetRptDataSource.getDataSourceName();
        String string2 = jetRptDataSource.getQueryName();
        JetUQueriable jetUQueriable = jetUUniverse == null ? null : jetUUniverse.getQueriableByResourceName(string, string2);
        JetRptDataSet jetRptDataSet = null;
        jetRptDataSet = jetUQueriable != null && jetUQueriable instanceof JetUHierDataSource ? URptV7ReportPanelTask.InitAfterLoad(jetRptReportPanel, jetRptDataSource, string, string2) : URptV7ReportPanelTask.NoPageBreak(jetRptReportPanel, jetRptDataSource, string, string2);
        return jetRptDataSet;
    }

    private static JetRptHDSDataSet InitAfterLoad(JetRptReportPanel jetRptReportPanel, JetRptDataSource jetRptDataSource, String string, String string2) {
        JetRptHDSDataSet jetRptHDSDataSet = new JetRptHDSDataSet();
        jetRptHDSDataSet.setEditable();
        jetRptHDSDataSet.setInstNameDirectly("convert_dataset");
        jetRptHDSDataSet.setDataSourceName(string);
        jetRptHDSDataSet.setQueryName(string2);
        jetRptHDSDataSet.setMappingListType(1);
        jetRptHDSDataSet.recordsPerPage.set(jetRptReportPanel.recordsPerPage.get());
        jetRptHDSDataSet.maxPageNumber.set(jetRptReportPanel.maxPageNumber.get());
        jetRptHDSDataSet.recordsPerPage.set(jetRptReportPanel.dataDriver.get());
        jetRptHDSDataSet.maxRecords.set(jetRptReportPanel.maxRecords.get());
        UpgradeToolkit.copyProperties(jetRptHDSDataSet, jetRptDataSource, null, jetRptHDSDataSet.recordsPerPage.getName(), jetRptHDSDataSet.maxPageNumber.getName(), jetRptHDSDataSet.recordsPerPage.getName(), jetRptHDSDataSet.maxRecords.getName());
        Vector vector = jetRptDataSource.getChildren();
        for (int i = 0; i < vector.size(); ++i) {
            JetObject jetObject = (JetObject)vector.get(i);
            if (jetObject instanceof JetRptHDSDataSource) {
                UpgradeToolkit.copyProperties(jetRptHDSDataSet, (JetRptHDSDataSource)jetObject, null, new String[0]);
                continue;
            }
            JetObject jetObject2 = jetObject.deepDupWithName();
            jetRptHDSDataSet.add(jetObject2);
        }
        return jetRptHDSDataSet;
    }

    private static JetRptQueryDataSet NoPageBreak(JetRptReportPanel jetRptReportPanel, JetRptDataSource jetRptDataSource, String string, String string2) {
        JetRptQueryDataSet jetRptQueryDataSet = new JetRptQueryDataSet();
        jetRptQueryDataSet.setEditable();
        jetRptQueryDataSet.setDataSourceName(string);
        jetRptQueryDataSet.setQueryName(string2);
        jetRptQueryDataSet.setDataResourceType(0);
        jetRptQueryDataSet.setInstNameDirectly("convert_dataset");
        jetRptQueryDataSet.setMappingListType(1);
        jetRptQueryDataSet.recordsPerPage.set(jetRptReportPanel.recordsPerPage.get());
        jetRptQueryDataSet.maxPageNumber.set(jetRptReportPanel.maxPageNumber.get());
        jetRptQueryDataSet.dataDriver.set(jetRptReportPanel.dataDriver.get());
        jetRptQueryDataSet.maxRecords.set(jetRptReportPanel.maxRecords.get());
        UpgradeToolkit.copyProperties(jetRptQueryDataSet, jetRptDataSource, null, jetRptQueryDataSet.recordsPerPage.getName(), jetRptQueryDataSet.maxPageNumber.getName(), jetRptQueryDataSet.dataDriver.getName(), jetRptQueryDataSet.maxRecords.getName());
        Vector vector = jetRptDataSource.getChildren();
        for (int i = 0; i < vector.size(); ++i) {
            JetObject jetObject = (JetObject)vector.get(i);
            if (jetObject instanceof JetRptFilterContainer || jetObject instanceof JetRptSortContainer) continue;
            JetObject jetObject2 = jetObject.deepDupWithName();
            jetRptQueryDataSet.add(jetObject2);
        }
        return jetRptQueryDataSet;
    }

    protected void fillStructureViaChildren(JetRptSectionObject jetRptSectionObject, List list, Map map, List list2, List list3) throws JUpgradeFailtureException {
        JetRptDataSource jetRptDataSource = null;
        JetObject jetObject = null;
        Vector<JetObject> vector = new Vector<JetObject>();
        for (JetObject jetObject2 : list) {
            if (jetObject2 instanceof JetRptTOC) {
                jetObject = (JetRptTOC)jetObject2;
                continue;
            }
            if (jetObject2 instanceof JetRptDataSource) {
                jetRptDataSource = (JetRptDataSource)jetObject2;
                continue;
            }
            vector.add(jetObject2);
        }
        super.fillStructureViaChildren(jetRptSectionObject, vector, map, list2, list3);
        JetRptTOC jetRptTOC = (JetRptTOC)jetObject.deepDupWithName();
        jetRptTOC.rootLabel.set(((JetRptReportPanel)this.oldrptObject).rootLabel.get());
        jetRptTOC.underline.set(((JetRptReportPanel)this.oldrptObject).haveUnderline.get());
        map.put(jetObject, jetRptTOC);
        list3.add(jetRptTOC);
        this.SEDU(jetRptSectionObject, jetRptDataSource, map, list2, list3);
    }

    protected void handleConvertedChild(JetRptSectionObject jetRptSectionObject, JetObject jetObject) {
        if (jetObject instanceof JetRptSectionHeader) {
            jetRptSectionObject.add(jetObject, this.ClickPriority);
            ++this.ClickPriority;
            ++this.InitAfterLoad;
            ++this.NoPageBreak;
        } else if (jetObject instanceof JetRptSectionFooter) {
            jetRptSectionObject.add(jetObject, this.InitAfterLoad);
            ++this.InitAfterLoad;
        } else if (jetObject instanceof JetRptSectionPagePanel) {
            jetRptSectionObject.add(jetObject, this.NoPageBreak);
            ++this.NoPageBreak;
            ++this.InitAfterLoad;
        } else {
            super.handleConvertedChild(jetRptSectionObject, jetObject);
        }
    }

    private void SEDU(JetRptSectionObject jetRptSectionObject, JetRptDataSource jetRptDataSource, Map map, List list, List list2) throws JUpgradeFailtureException {
        URptV7XFilterContainerTask uRptV7XFilterContainerTask;
        Object object;
        JetRptDataSet jetRptDataSet = URptV7ReportPanelTask.ClickPriority((JetRptReportPanel)this.oldrptObject, jetRptDataSource, this.getDataContext().getCurrentUniverse());
        jetRptSectionObject.dataInherit.set(false);
        jetRptSectionObject.dataSet.setObject(jetRptDataSet);
        list2.add(jetRptDataSet);
        Vector vector = jetRptDataSource.getChildren();
        JetRptFilterContainer jetRptFilterContainer = null;
        JetObject jetObject = null;
        int n = vector.size();
        while (n-- > 0) {
            object = vector.elementAt(n);
            if (object instanceof JetRptFilterContainer) {
                if (jetRptFilterContainer != null) continue;
                jetRptFilterContainer = (JetRptFilterContainer)object;
                continue;
            }
            if (!(object instanceof JetRptSortContainer) || jetObject != null) continue;
            jetObject = (JetRptSortContainer)object;
        }
        if (jetRptFilterContainer != null && (object = (uRptV7XFilterContainerTask = new URptV7XFilterContainerTask(jetRptFilterContainer, this.getContext())).call()) != null) {
            map.putAll(((UpgradeResult)object).oldToNew);
            list2.addAll(((UpgradeResult)object).addtionalObjs);
            list.addAll(((UpgradeResult)object).outerRefers);
            JetFilterExpression jetFilterExpression = (JetFilterExpression)((UpgradeResult)object).newObject;
            JetRptTypedFilterExpression jetRptTypedFilterExpression = new JetRptTypedFilterExpression();
            jetRptTypedFilterExpression.setEditable();
            jetRptTypedFilterExpression.setUsedType(4098);
            jetRptTypedFilterExpression.add(jetFilterExpression);
            jetRptSectionObject.add(jetRptTypedFilterExpression);
        }
        if (jetObject != null) {
            JetRptSortContainer jetRptSortContainer = (JetRptSortContainer)jetObject.deepDupWithName();
            map.put(jetObject, jetRptSortContainer);
            jetRptSectionObject.add(jetRptSortContainer);
        }
    }

    @Override
    protected List handleOuterReferences(List list, Map map) {
        int n = list.size();
        int n2 = (list = UpgradeToolkit.handleOuterReferences(list, map)).size();
        if (n2 > 0) {
            if (JRLog.isTrace(7)) {
                StringBuilder stringBuilder = new StringBuilder();
                for (JetProperty jetProperty : list) {
                    if (jetProperty instanceof JetReference) {
                        stringBuilder.append(jetProperty.getName() + "(JetReference of " + jetProperty.getParent().getClass() + "):" + jetProperty.toUnitString());
                    } else {
                        stringBuilder.append(jetProperty.getName() + "(JetReferences of " + jetProperty.getParent().getClass() + "):" + jetProperty.toUnitString());
                    }
                    stringBuilder.append(",");
                }
                JRLog.trace(7, "[Upgrade Proc(V7X)] " + (n - n2) + " properties(out-referTo) handed, " + n2 + " properties(out-referTo) left: " + stringBuilder.substring(0, stringBuilder.length() - 1));
            }
        } else if (JRLog.isTrace(7)) {
            JRLog.trace(7, "[Upgrade Proc(V7X)] " + (n - n2) + " properties(out-referTo) handed, 0 properties(out-referTo) left.");
        }
        return list;
    }

    @Override
    protected List handleAdditionalObjs(JetObject jetObject, List list) {
        JetRptReportSet jetRptReportSet = (JetRptReportSet)jetObject;
        JetRptReport jetRptReport = jetRptReportSet.getCurReport();
        JetRptDataSets jetRptDataSets = jetRptReportSet.getDataSets();
        list = UpgradeToolkit.insertAdditionalObjectsToReport(jetRptReport, list);
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            JetObject jetObject2 = (JetObject)list.get(n2);
            if (jetObject2 instanceof JetRptDataSet) {
                jetRptDataSets.add((JetRptDataSet)jetObject2);
                list.remove(n2);
                --n;
                continue;
            }
            ++n2;
        }
        if (JRLog.isTrace(7)) {
            JRLog.trace(7, "[Upgrade Proc(V7X)] " + list.size() + " additional objects left.");
        }
        return list;
    }
}

