/*
 * Decompiled with CFR 0.152.
 */
package jet.upgrade.impl.v7x;

import java.util.List;
import java.util.Map;
import java.util.Vector;
import jet.controls.JetObject;
import jet.controls.QueryInfoImpl;
import jet.naming.PropertyNames;
import jet.report.JetRptCTCrossTab;
import jet.report.JetRptCompDetailPanel;
import jet.report.JetRptDataSource;
import jet.report.JetRptGroupPanel;
import jet.report.JetRptHDSDataSource;
import jet.report.JetRptObject;
import jet.report.JetRptPagePanel;
import jet.report.JetRptQueryComponent;
import jet.report.JetRptSectionObject;
import jet.report.JetRptSectionPagePanel;
import jet.report.chart.JetRptChartConvertTool;
import jet.report.chart.JetRptChartPlatform;
import jet.report.tabular.JetRptTabular;
import jet.report.tabular.JetRptTabularCell;
import jet.reportLogic.objectLogic.ObjectLogicFactory;
import jet.reportset.JetRptDataSet;
import jet.reportset.JetRptHDSDataSet;
import jet.reportset.JetRptQueryDataSet;
import jet.universe.JetUUniverse;
import jet.upgrade.JUpgradeFailtureException;
import jet.upgrade.UpgradeContext;
import jet.upgrade.UpgradeDataContext;
import jet.upgrade.UpgradeResult;
import jet.upgrade.UpgradeVersion;
import jet.upgrade.impl.DefaultUpgradeTask;
import jet.upgrade.kit.UpgradeDataObjUtil;
import jet.upgrade.kit.UpgradeToolkit;
import jet.upgrade.kit.V7XObjectUtil;

public class URptV7XDataObjectTask
extends DefaultUpgradeTask {
    private static final int CompressIfNoRecord = 1;
    private static final int SEDU = 2;
    private static final int V7X = 3;
    private int add = 1;

    public URptV7XDataObjectTask(JetRptQueryComponent jetRptQueryComponent, UpgradeContext upgradeContext) {
        super(jetRptQueryComponent, UpgradeVersion.V7X, upgradeContext);
    }

    @Override
    protected void beforeUpgradeStart() throws JUpgradeFailtureException {
        Object object;
        super.beforeUpgradeStart();
        UpgradeDataContext upgradeDataContext = this.getDataContext().cloneIt(false, false);
        JetRptDataSource jetRptDataSource = V7XObjectUtil.getDataSource((JetRptQueryComponent)this.oldrptObject);
        JetUUniverse jetUUniverse = V7XObjectUtil.getBindUniverse(jetRptDataSource);
        if (jetUUniverse != null) {
            upgradeDataContext.setCurrentUniverse(jetUUniverse);
        } else {
            object = this.getDataContext();
            upgradeDataContext.setCurrentUniverse(((UpgradeDataContext)object).getCurrentUniverse());
        }
        upgradeDataContext.setCurrentQueryInfo(V7XObjectUtil.getHDSDataSource(jetRptDataSource) != null, new QueryInfoImpl("", jetRptDataSource.getDataSourceName(), jetRptDataSource.getQualifyName()));
        object = new UpgradeContext(6, upgradeDataContext, this.getResourceContext());
        this.resetContext((UpgradeContext)object);
    }

    @Override
    protected JetObject createNewBasicStructure(List list, List list2) {
        if (this.CompressIfNoRecord((JetRptQueryComponent)this.oldrptObject)) {
            this.add = 1;
            JetRptSectionObject jetRptSectionObject = new JetRptSectionObject();
            jetRptSectionObject.setEditable();
            jetRptSectionObject.setInstNameDirectly(((JetRptQueryComponent)this.oldrptObject).getInstName());
            return jetRptSectionObject;
        }
        jet.report.JetRptChartPlatform jetRptChartPlatform = UpgradeDataObjUtil.getChart((JetRptQueryComponent)this.oldrptObject);
        if (jetRptChartPlatform != null) {
            this.add = 2;
            JetRptChartPlatform jetRptChartPlatform2 = JetRptChartConvertTool.convert(jetRptChartPlatform, this.getDataContext().getCurrentQueryInfo(), this.getDataContext().getCurrentUniverse());
            jetRptChartPlatform2.setInstNameDirectly(((JetRptQueryComponent)this.oldrptObject).getInstName());
            return jetRptChartPlatform2;
        }
        JetRptCTCrossTab jetRptCTCrossTab = UpgradeDataObjUtil.getCrosstab((JetRptQueryComponent)this.oldrptObject);
        if (jetRptCTCrossTab != null) {
            this.add = 3;
            return ObjectLogicFactory.getTabularLogic().createTabular(1, 1);
        }
        return jetRptCTCrossTab;
    }

    private boolean CompressIfNoRecord(JetRptQueryComponent jetRptQueryComponent) {
        int n = UpgradeDataObjUtil.getTemplateType(jetRptQueryComponent);
        return n == 16385 || n == 45;
    }

    protected void fillStructureViaChildren(JetRptObject jetRptObject, List list, Map map, List list2, List list3) throws JUpgradeFailtureException {
        if (this.add == 2) {
            JetRptDataSet jetRptDataSet = URptV7XDataObjectTask.SEDU((JetRptQueryComponent)this.oldrptObject, this.getDataContext().getCurrentUniverse(), list2);
            if (jetRptDataSet != null) {
                ((JetRptChartPlatform)jetRptObject).dataInherit.set(false);
                ((JetRptChartPlatform)jetRptObject).dataSet.setObject(jetRptDataSet);
                list3.add(jetRptDataSet);
            }
        } else if (this.add == 1) {
            JetRptSectionObject jetRptSectionObject = (JetRptSectionObject)jetRptObject;
            JetRptDataSet jetRptDataSet = URptV7XDataObjectTask.SEDU((JetRptQueryComponent)this.oldrptObject, this.getDataContext().getCurrentUniverse(), list2);
            if (jetRptDataSet != null) {
                jetRptSectionObject.dataInherit.set(false);
                jetRptSectionObject.dataSet.setObject(jetRptDataSet);
                list3.add(jetRptDataSet);
            }
            JetRptSectionPagePanel jetRptSectionPagePanel = null;
            for (JetObject jetObject : list) {
                UpgradeResult upgradeResult;
                if (jetObject instanceof JetRptDataSource) continue;
                if (jetObject instanceof JetRptCompDetailPanel || jetObject instanceof JetRptGroupPanel) {
                    upgradeResult = this.getChildUpgradeResult((JetRptObject)jetObject);
                    if (upgradeResult == null) continue;
                    map.putAll(upgradeResult.oldToNew);
                    list3.addAll(upgradeResult.addtionalObjs);
                    list2.addAll(upgradeResult.outerRefers);
                    if (jetRptSectionPagePanel == null) {
                        jetRptSectionPagePanel = new JetRptSectionPagePanel();
                        jetRptSectionPagePanel.setEditable();
                        jetRptSectionPagePanel.afterInit();
                        jetRptSectionObject.add(jetRptSectionPagePanel);
                    }
                    jetRptSectionPagePanel.add(upgradeResult.newObject);
                    continue;
                }
                upgradeResult = this.getChildUpgradeResult((JetRptObject)jetObject);
                if (upgradeResult == null) continue;
                map.putAll(upgradeResult.oldToNew);
                list3.addAll(upgradeResult.addtionalObjs);
                list2.addAll(upgradeResult.outerRefers);
                jetRptSectionObject.add(upgradeResult.newObject);
                if (!(jetObject instanceof JetRptPagePanel)) continue;
                jetRptSectionPagePanel = (JetRptSectionPagePanel)upgradeResult.newObject;
            }
            if (jetRptSectionPagePanel == null) {
                jetRptSectionPagePanel = new JetRptSectionPagePanel();
                jetRptSectionPagePanel.setEditable();
                jetRptSectionPagePanel.afterInit();
                jetRptSectionObject.add(jetRptSectionPagePanel);
            }
        } else {
            JetRptCTCrossTab jetRptCTCrossTab = UpgradeDataObjUtil.getCrosstab((JetRptQueryComponent)this.oldrptObject);
            UpgradeResult upgradeResult = this.getChildUpgradeResult(jetRptCTCrossTab);
            if (upgradeResult != null) {
                map.putAll(upgradeResult.oldToNew);
                list3.addAll(upgradeResult.addtionalObjs);
                list2.addAll(upgradeResult.outerRefers);
                ((JetRptTabular)jetRptObject).getTabularCells()[0].add(upgradeResult.newObject);
                JetRptDataSet jetRptDataSet = URptV7XDataObjectTask.SEDU((JetRptQueryComponent)this.oldrptObject, this.getDataContext().getCurrentUniverse(), list2);
                if (jetRptDataSet != null) {
                    ((JetRptCTCrossTab)upgradeResult.newObject).dataInherit.set(false);
                    ((JetRptCTCrossTab)upgradeResult.newObject).dataSet.setObject(jetRptDataSet);
                    list3.add(jetRptDataSet);
                }
            }
        }
    }

    protected void copyProperties(JetRptObject jetRptObject, List list, List list2) throws JUpgradeFailtureException {
        if (this.add == 2) {
            ((JetRptChartPlatform)jetRptObject).x.setUnitValue(((JetRptQueryComponent)this.oldrptObject).x.getUnit());
            ((JetRptChartPlatform)jetRptObject).y.setUnitValue(((JetRptQueryComponent)this.oldrptObject).y.getUnit());
        } else if (this.add == 1) {
            super.copyProperties(jetRptObject, list, list2, PropertyNames.getDefinitionName(PropertyNames.dataInherit), PropertyNames.getDefinitionName(PropertyNames.dataSet), PropertyNames.getDefinitionName(PropertyNames.CompressIfNoRecord));
            ((JetRptSectionObject)jetRptObject).compressIfNoRecord.set(((JetRptQueryComponent)this.oldrptObject).suppressEmpty.get());
        } else {
            super.copyProperties(jetRptObject, list, list2);
            JetRptTabular jetRptTabular = (JetRptTabular)jetRptObject;
            ObjectLogicFactory.getTabularLogic().setTotalHeight(jetRptTabular, ((JetRptQueryComponent)this.oldrptObject).height.getUnit());
            ObjectLogicFactory.getTabularLogic().setTotalWidth(jetRptTabular, ((JetRptQueryComponent)this.oldrptObject).width.getUnit());
            JetRptTabularCell jetRptTabularCell = jetRptTabular.getTabularCell(0);
            UpgradeToolkit.copyProperties(jetRptTabularCell, this.oldrptObject, list, new String[0]);
            jetRptTabular.borderWidth.setUnitValue(0);
            UpgradeToolkit.handleBorderProperty(jetRptTabular);
        }
    }

    protected void afterCopyProperties(JetRptObject jetRptObject, List list) throws JUpgradeFailtureException {
    }

    private static JetRptDataSet SEDU(JetRptQueryComponent jetRptQueryComponent, JetUUniverse jetUUniverse, List list) {
        Object object;
        JetRptDataSet jetRptDataSet = null;
        JetRptDataSource jetRptDataSource = V7XObjectUtil.getDataSource(jetRptQueryComponent);
        if (jetRptDataSource == null) {
            return jetRptDataSet;
        }
        String string = jetUUniverse == null ? null : jetUUniverse.getName();
        String string2 = jetRptDataSource.sourceName.get();
        String string3 = jetRptDataSource.uQueryName.get();
        JetRptHDSDataSource jetRptHDSDataSource = V7XObjectUtil.getHDSDataSource(jetRptDataSource);
        if (jetRptHDSDataSource != null) {
            object = new JetRptHDSDataSet();
            ((JetObject)object).setEditable();
            ((JetRptHDSDataSet)object).setDataSourceName(string2);
            ((JetRptHDSDataSet)object).setQueryName(string3);
            jetRptDataSet = object;
        } else {
            object = new JetRptQueryDataSet();
            ((JetObject)object).setEditable();
            ((JetRptQueryDataSet)object).setDataSourceName(string2);
            ((JetRptQueryDataSet)object).setQueryName(string3);
            ((JetRptDataSet)object).setDataResourceType(0);
            jetRptDataSet = object;
        }
        jetRptDataSet.setMappingListType(1);
        jetRptDataSet.setInstNameDirectly(jetRptQueryComponent.getInstName() + "_" + "convert_dataset");
        jetRptDataSet.recordsPerPage.set(jetRptQueryComponent.recordsPerPage.get());
        jetRptDataSet.maxPageNumber.set(jetRptQueryComponent.maxPageNumber.get());
        UpgradeToolkit.copyProperties(jetRptDataSet, jetRptDataSource, list, jetRptDataSet.recordsPerPage.getName(), jetRptDataSet.maxPageNumber.getName());
        object = jetRptDataSource.getChildren();
        for (int i = 0; i < ((Vector)object).size(); ++i) {
            JetObject jetObject = (JetObject)((Vector)object).get(i);
            if (jetObject instanceof JetRptHDSDataSource) {
                UpgradeToolkit.copyProperties(jetRptDataSet, (JetRptObject)jetObject, list, new String[0]);
                continue;
            }
            JetObject jetObject2 = jetObject.deepDupWithName();
            jetRptDataSet.add(jetObject2);
        }
        return jetRptDataSet;
    }
}

