/*
 * Decompiled with CFR 0.152.
 */
package jet.upgrade.impl.v7x;

import com.jinfonet.awt.JFont;
import com.jinfonet.util.JRLog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.imageio.ImageIO;
import jet.controls.JetObject;
import jet.naming.EnumerationConstant;
import jet.report.JetRptField;
import jet.report.JetRptObject;
import jet.report.JetRptPicture;
import jet.report.JetRptTextBox;
import jet.report.JetRptTextField;
import jet.report.JetRptTextObject;
import jet.report.paragraph.build.JetRptParaReplaceElement;
import jet.report.paragraph.build.JetRptParagraph;
import jet.reportLogic.objectLogic.ObjectLogicFactory;
import jet.reportLogic.objectLogic.ParagraphLogic;
import jet.reportLogic.objectLogic.paragraphLogic.ParagraphConstant;
import jet.reportLogic.objectLogic.paragraphLogic.StyleTypeDef;
import jet.textobj.ChrObj;
import jet.textobj.DblLinkable;
import jet.textobj.DestVect;
import jet.textobj.DocObj;
import jet.textobj.FieldDest;
import jet.textobj.KwdObj;
import jet.textobj.Obj;
import jet.textobj.ObjVect;
import jet.textobj.ParObj;
import jet.textobj.PictDest;
import jet.textobj.RtfDest;
import jet.textobj.SecObj;
import jet.upgrade.JUpgradeFailtureException;
import jet.upgrade.UpgradeContext;
import jet.upgrade.UpgradeResult;
import jet.upgrade.UpgradeTask;
import jet.upgrade.UpgradeVersion;
import jet.upgrade.impl.DefaultUpgradeTask;
import jet.upgrade.impl.UpgradeAdapter;
import jet.upgrade.kit.UpgradeToolkit;
import jet.util.FontSets;
import jet.util.ValueToUnit;

public class URptV7XTextObjTask
extends DefaultUpgradeTask {
    private Hashtable SEDU = null;
    private Vector STRIKETHROUGH_NAME = null;

    public URptV7XTextObjTask(JetRptTextObject jetRptTextObject, UpgradeContext upgradeContext) {
        super(jetRptTextObject, UpgradeVersion.V7X, upgradeContext);
    }

    @Override
    protected JetObject createNewBasicStructure(List list, List list2) {
        JetRptTextBox jetRptTextBox = new JetRptTextBox();
        jetRptTextBox.setEditable();
        jetRptTextBox.setInstNameDirectly(((JetRptTextObject)this.oldrptObject).getInstName());
        return jetRptTextBox;
    }

    protected void fillStructureViaChildren(JetRptTextBox jetRptTextBox, List list, Map map, List list2, List list3) {
    }

    protected void fillStructureViaOldProperties(JetRptTextBox jetRptTextBox, List list, List list2) throws JUpgradeFailtureException {
        DocObj docObj;
        RtfDest rtfDest = ((JetRptTextObject)this.oldrptObject).rtfProp.get();
        this.SEDU = this.SEDU(rtfDest);
        this.STRIKETHROUGH_NAME = this.STRIKETHROUGH_NAME(rtfDest);
        this.SUPERSUBSCRIPT_NAME(jetRptTextBox, docObj);
        for (docObj = (DocObj)rtfDest.getHead(); docObj != null; docObj = (DocObj)docObj.getNext()) {
            for (SecObj secObj = (SecObj)docObj.getHead(); secObj != null; secObj = (SecObj)secObj.getNext()) {
                for (ParObj parObj = (ParObj)secObj.getHead(); parObj != null; parObj = (ParObj)parObj.getNext()) {
                    JetRptParagraph jetRptParagraph = new JetRptParagraph();
                    jetRptParagraph.setEditable();
                    this.TRUE(jetRptParagraph, rtfDest);
                    this.TYPE_NAME(jetRptParagraph, docObj);
                    this.UNDERLINE_STYLE_NAME(jetRptParagraph, secObj);
                    this.V7X(jetRptParagraph, parObj);
                    DblLinkable dblLinkable = parObj.getHead();
                    this.abs(jetRptParagraph, dblLinkable, list, list2);
                    jetRptTextBox.add(jetRptParagraph);
                }
            }
        }
    }

    private Hashtable SEDU(RtfDest rtfDest) {
        DestVect destVect = (DestVect)rtfDest.getObjValue("fonttbl");
        int n = destVect.size();
        Hashtable<Integer, String> hashtable = new Hashtable<Integer, String>();
        for (int i = 0; i < n; ++i) {
            Obj obj = destVect.getSubProp(i);
            Integer n2 = obj.getIntValue("f");
            String string = obj.getCharsValue("fontname").toString();
            if (string.endsWith(";") && string.length() > 1) {
                string = string.substring(0, string.length() - 1);
            }
            hashtable.put(n2, string);
        }
        return hashtable;
    }

    private Vector STRIKETHROUGH_NAME(RtfDest rtfDest) {
        DestVect destVect = (DestVect)rtfDest.getObjValue("colortbl");
        int n = destVect.size();
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < n; ++i) {
            Obj obj = destVect.getSubProp(i);
            String string = Integer.toHexString(obj.getIntValue("red"));
            String string2 = Integer.toHexString(obj.getIntValue("green"));
            String string3 = Integer.toHexString(obj.getIntValue("blue"));
            if (string.length() < 2) {
                string = '0' + string;
            }
            if (string2.length() < 2) {
                string2 = '0' + string2;
            }
            if (string3.length() < 2) {
                string3 = '0' + string3;
            }
            vector.add("0x" + string + string2 + string3);
        }
        return vector;
    }

    private void SUPERSUBSCRIPT_NAME(JetRptTextBox jetRptTextBox, DocObj docObj) {
        if (docObj.hasValue("docfmt.txtvalign")) {
            switch (docObj.getIntValue("docfmt.txtvalign")) {
                case 0: {
                    jetRptTextBox.vAlignment.set(1);
                    break;
                }
                case 1: {
                    jetRptTextBox.vAlignment.set(2);
                    break;
                }
                case 2: {
                    jetRptTextBox.vAlignment.set(0);
                    break;
                }
            }
        }
    }

    private void TRUE(JetRptParagraph jetRptParagraph, RtfDest rtfDest) {
        int n;
        if (rtfDest.hasProp("deff") && (n = ((Integer)rtfDest.getPropValue("deff")).intValue()) >= 0 && n < this.SEDU.size()) {
            jetRptParagraph.fontFace.set((String)this.SEDU.get(n));
        }
    }

    private void TYPE_NAME(JetRptParagraph jetRptParagraph, DocObj docObj) {
        int n = -1;
        if (docObj.hasValue("docfmt.deftab") && (n = (int)ValueToUnit.convertTwipToUnit(docObj.getIntValue("docfmt.deftab"))) != 0) {
            jetRptParagraph.tabDefaultStop.setUnitValue(n);
        }
        if (docObj.hasValue("docfmt.margb")) {
            n = (int)ValueToUnit.convertTwipToUnit(docObj.getIntValue("docfmt.margb"));
            jetRptParagraph.bottomMargin.setUnitValue(n);
        }
        if (docObj.hasValue("docfmt.margl")) {
            n = (int)ValueToUnit.convertTwipToUnit(docObj.getIntValue("docfmt.margl"));
            jetRptParagraph.leftMargin.setUnitValue(n);
        }
        if (docObj.hasValue("docfmt.margr")) {
            n = (int)ValueToUnit.convertTwipToUnit(docObj.getIntValue("docfmt.margr"));
            jetRptParagraph.rightMargin.setUnitValue(n);
        }
        if (docObj.hasValue("docfmt.margt")) {
            n = (int)ValueToUnit.convertTwipToUnit(docObj.getIntValue("docfmt.margt"));
            jetRptParagraph.topMargin.setUnitValue(n);
        }
        jetRptParagraph.backColor.set("Transparent");
    }

    private void UNDERLINE_STYLE_NAME(JetRptParagraph jetRptParagraph, SecObj secObj) {
    }

    private void V7X(JetRptParagraph jetRptParagraph, ParObj parObj) {
        int n;
        int n2;
        if (parObj.hasValue("parfmt.paraalign")) {
            switch (parObj.getIntValue("parfmt.paraalign")) {
                case 0: {
                    jetRptParagraph.horiAlignment.set(0);
                    break;
                }
                case 1: {
                    jetRptParagraph.horiAlignment.set(1);
                    break;
                }
                case 3: {
                    jetRptParagraph.horiAlignment.set(2);
                    break;
                }
                default: {
                    jetRptParagraph.horiAlignment.set(3);
                }
            }
        }
        if (parObj.hasValue("parfmt.fi")) {
            n2 = (int)ValueToUnit.convertTwipToUnit(parObj.getIntValue("parfmt.fi"));
            if (n2 >= 0) {
                jetRptParagraph.lineIndentation.setUnitValue(n2);
            } else {
                jetRptParagraph.hangIndentation.setUnitValue(Math.abs(n2));
            }
        }
        if (parObj.hasValue("parfmt.li")) {
            n2 = (int)ValueToUnit.convertTwipToUnit(parObj.getIntValue("parfmt.li"));
            jetRptParagraph.leftIndentation.setUnitValue(n2);
        }
        if (parObj.hasValue("parfmt.ri")) {
            n2 = (int)ValueToUnit.convertTwipToUnit(parObj.getIntValue("parfmt.ri"));
            jetRptParagraph.rightIndentation.setUnitValue(n2);
        }
        if (parObj.hasValue("parfmt.sl")) {
            n2 = parObj.getIntValue("parfmt.sl");
            n = (int)ValueToUnit.convertTwipToUnit(n2);
            jetRptParagraph.lineSpacing.setUnitValue(n);
        }
        if (parObj.hasValue("parfmt.slmult")) {
            switch (parObj.getIntValue("parfmt.slmult")) {
                case 0: {
                    jetRptParagraph.lineSpacingType.set(false);
                    break;
                }
                case 1: {
                    jetRptParagraph.lineSpacingType.set(true);
                    break;
                }
            }
        }
        if (parObj.hasValue("parfmt.sa")) {
            n2 = (int)ValueToUnit.convertTwipToUnit(parObj.getIntValue("parfmt.sa"));
            jetRptParagraph.afterSpacing.setUnitValue(n2);
        }
        if (parObj.hasValue("parfmt.sb")) {
            n2 = (int)ValueToUnit.convertTwipToUnit(parObj.getIntValue("parfmt.sb"));
            jetRptParagraph.beforeSpacing.setUnitValue(n2);
        }
        if (parObj.hasValue("parfmt.tabdefs")) {
            ObjVect objVect = (ObjVect)parObj.getObjValue("parfmt.tabdefs");
            n = objVect.size();
            for (int i = 0; i < n; ++i) {
                Obj obj = objVect.getSubProp(i);
                int n3 = obj.getIntValue("tabstyle");
                double d = obj.getFlagValue("tabstyle");
                int n4 = obj.getIntValue("tablead");
                if (n3 == 1) {
                    n3 = 0;
                } else if (n3 == 2) {
                    n3 = 0;
                }
                d = ValueToUnit.convertTwipToUnit(d);
                switch (n4) {
                    case 1: {
                        n4 = 1;
                        break;
                    }
                    case 2: {
                        n4 = 0;
                        break;
                    }
                    case 3: {
                        n4 = 3;
                        break;
                    }
                    case 4: {
                        n4 = 2;
                        break;
                    }
                    case 5: {
                        n4 = 4;
                    }
                }
                jetRptParagraph.tabAlignmentSet.add("" + n3);
                jetRptParagraph.tabStopPosition.add("" + (int)d);
                jetRptParagraph.tabLeaderSet.add("" + n4);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void abs(JetRptParagraph jetRptParagraph, DblLinkable dblLinkable, List list, List list2) {
        ParagraphLogic paragraphLogic = ObjectLogicFactory.getParagraphLogic();
        int n = 0;
        while (dblLinkable != null) {
            block20: {
                if (dblLinkable instanceof ChrObj) {
                    Object object;
                    ChrObj chrObj = (ChrObj)dblLinkable;
                    if (chrObj.getFldOwner() != null) {
                        object = chrObj.getFldOwner();
                        JetRptObject jetRptObject = (JetRptObject)((Object)((FieldDest)object).getField());
                        try {
                            UpgradeTask upgradeTask = UpgradeAdapter.createUpgradeTask((JetRptField)jetRptObject, UpgradeVersion.V7X, this.getContext());
                            UpgradeResult upgradeResult = upgradeTask.call();
                            if (upgradeResult != null) {
                                list2.addAll(upgradeResult.addtionalObjs);
                                list.addAll(upgradeResult.outerRefers);
                                JetRptParaReplaceElement jetRptParaReplaceElement = paragraphLogic.createReplaceElement((JetRptObject)upgradeResult.newObject);
                                ((JetRptField)upgradeResult.newObject).position.set(0);
                                this.addAll((JetRptField)upgradeResult.newObject);
                                paragraphLogic.insertReplaceObjectAtPosition(jetRptParagraph, jetRptParaReplaceElement, n);
                                ++n;
                            }
                            break block20;
                        }
                        catch (JUpgradeFailtureException jUpgradeFailtureException) {
                            if (JRLog.isTrace(7)) {
                                JRLog.trace(7, "[Upgrade proc(V7X)] error on upgrade FieldDest:", (Throwable)jUpgradeFailtureException);
                            }
                            break block20;
                        }
                    }
                    if (chrObj.getHead() instanceof PictDest) {
                        try {
                            Object object2;
                            object = new JetRptPicture();
                            ((JetRptPicture)object).setEditable();
                            Image image = ((PictDest)chrObj.getHead()).getImg();
                            BufferedImage bufferedImage = null;
                            int n2 = image.getWidth(null);
                            int n3 = image.getHeight(null);
                            if (image instanceof BufferedImage) {
                                bufferedImage = (BufferedImage)image;
                            } else {
                                bufferedImage = new BufferedImage(n2, n3, 1);
                                object2 = bufferedImage.createGraphics();
                                ((Graphics)object2).drawImage(image, 0, 0, null);
                            }
                            object2 = new ByteArrayOutputStream();
                            try {
                                ImageIO.write((RenderedImage)bufferedImage, "JPG", (OutputStream)object2);
                                ((OutputStream)object2).flush();
                            }
                            finally {
                                ((ByteArrayOutputStream)object2).close();
                            }
                            image = ImageIO.read(new ByteArrayInputStream(((ByteArrayOutputStream)object2).toByteArray()));
                            ((JetRptPicture)object).setEmbedImage(image, 0);
                            if (n2 == 0 || n3 == 0) {
                                ((JetRptPicture)object).autosize.set(true);
                            } else {
                                float f = (float)((PictDest)chrObj.getHead()).getIntValue("picscalex") / 100.0f;
                                float f2 = (float)((PictDest)chrObj.getHead()).getIntValue("picscaley") / 100.0f;
                                int n4 = ((PictDest)chrObj.getHead()).getIntValue("picwgoal");
                                int n5 = ((PictDest)chrObj.getHead()).getIntValue("pichgoal");
                                ((JetRptPicture)object).width.setUnitValue((int)ValueToUnit.convertTwipToUnit((float)n4 * f));
                                ((JetRptPicture)object).height.setUnitValue((int)ValueToUnit.convertTwipToUnit((float)n5 * f2));
                            }
                            JetRptParaReplaceElement jetRptParaReplaceElement = paragraphLogic.createReplaceElement((JetRptObject)object);
                            ((JetRptPicture)object).position.set("static");
                            paragraphLogic.insertReplaceObjectAtPosition(jetRptParagraph, jetRptParaReplaceElement, n);
                            ++n;
                        }
                        catch (IOException iOException) {
                            if (JRLog.isTrace(7)) {
                                JRLog.trace(7, "[Upgrade proc(V7X)] error on upgrade PictDest:", (Throwable)iOException);
                            }
                            break block20;
                        }
                    }
                    object = chrObj.getText().toString();
                    int n6 = ((String)object).length();
                    int n7 = paragraphLogic.getParagraphSize(jetRptParagraph);
                    paragraphLogic.insertText(jetRptParagraph, n7, (String)object);
                    this.add(paragraphLogic, jetRptParagraph, n, n + n6, chrObj);
                    n += n6;
                } else {
                    if (((KwdObj)dblLinkable).isKwd(630)) break;
                    if (((KwdObj)dblLinkable).isKwd(895)) {
                        paragraphLogic.insertText(jetRptParagraph, n, "\t");
                        ++n;
                    }
                }
            }
            dblLinkable = ((Obj)dblLinkable).getNextLeaf();
        }
    }

    private void add(ParagraphLogic paragraphLogic, JetRptParagraph jetRptParagraph, int n, int n2, ChrObj chrObj) {
        int n3;
        String string = "";
        String string2 = "";
        if (chrObj.hasValue("chrfmt.b")) {
            string2 = StyleTypeDef.TYPE_NAME[1];
            string = "" + chrObj.getBooleanValue("chrfmt.b");
            paragraphLogic.applyTextStyle(jetRptParagraph, n, n2, string2, string);
        }
        if (chrObj.hasValue("chrfmt.i")) {
            string2 = StyleTypeDef.TYPE_NAME[2];
            string = "" + chrObj.getBooleanValue("chrfmt.i");
            paragraphLogic.applyTextStyle(jetRptParagraph, n, n2, string2, string);
        }
        if (chrObj.hasValue("chrfmt.f") && (string = (String)this.SEDU.get(n3 = chrObj.getIntValue("chrfmt.f"))) != null) {
            string2 = StyleTypeDef.TYPE_NAME[0];
            paragraphLogic.applyTextStyle(jetRptParagraph, n, n2, string2, string);
        }
        if (chrObj.hasValue("chrfmt.fs")) {
            double d = chrObj.getIntValue("chrfmt.fs") / 2;
            string = "" + ValueToUnit.convertPointToUnit(d);
            string2 = StyleTypeDef.TYPE_NAME[3];
            paragraphLogic.applyTextStyle(jetRptParagraph, n, n2, string2, string);
        }
        if (chrObj.hasValue("chrfmt.cb") && (n3 = chrObj.getIntValue("chrfmt.cb")) >= 0 && n3 < this.STRIKETHROUGH_NAME.size()) {
            string = (String)this.STRIKETHROUGH_NAME.get(n3);
            if (string == null) {
                string = "Transparent";
            }
            string2 = StyleTypeDef.TYPE_NAME[4];
            paragraphLogic.applyTextStyle(jetRptParagraph, n, n2, string2, string);
        }
        if (chrObj.hasValue("chrfmt.cf") && (n3 = chrObj.getIntValue("chrfmt.cf")) < this.STRIKETHROUGH_NAME.size() && n3 >= 0 && (string = (String)this.STRIKETHROUGH_NAME.get(n3)) != null) {
            string2 = StyleTypeDef.TYPE_NAME[5];
            paragraphLogic.applyTextStyle(jetRptParagraph, n, n2, string2, string);
        }
        if (chrObj.hasValue("chrfmt.chcbpat") && (n3 = chrObj.getIntValue("chrfmt.chcbpat")) >= 0 && n3 < this.STRIKETHROUGH_NAME.size()) {
            string = (String)this.STRIKETHROUGH_NAME.get(n3);
            if (string == null) {
                string = "Transparent";
            }
            string2 = StyleTypeDef.TYPE_NAME[4];
            paragraphLogic.applyTextStyle(jetRptParagraph, n, n2, string2, string);
        }
        if (chrObj.hasValue("chrfmt.highlight") && (n3 = chrObj.getIntValue("chrfmt.highlight")) >= 0 && n3 < this.STRIKETHROUGH_NAME.size()) {
            string = (String)this.STRIKETHROUGH_NAME.get(n3);
            if (string == null) {
                string = "Transparent";
            }
            string2 = StyleTypeDef.TYPE_NAME[4];
            paragraphLogic.applyTextStyle(jetRptParagraph, n, n2, string2, string);
        }
        if (!chrObj.hasValue("chrfmt.nosupersub")) {
            if (chrObj.hasValue("chrfmt.super") || chrObj.hasValue("chrfmt.up")) {
                string2 = StyleTypeDef.TYPE_NAME[13];
                string = ParagraphConstant.SUPERSUBSCRIPT_NAME[1];
                paragraphLogic.applyTextStyle(jetRptParagraph, n, n2, string2, string);
            } else if (chrObj.hasValue("chrfmt.sub") || chrObj.hasValue("chrfmt.dn")) {
                string2 = StyleTypeDef.TYPE_NAME[13];
                string = ParagraphConstant.SUPERSUBSCRIPT_NAME[2];
                paragraphLogic.applyTextStyle(jetRptParagraph, n, n2, string2, string);
            }
        }
        if (chrObj.hasValue("chrfmt.ul") && chrObj.getBooleanValue("chrfmt.ul") || chrObj.hasValue("chrfmt.ulstyle") && chrObj.getIntValue("chrfmt.ulstyle") != 0) {
            n3 = 1;
            int n4 = 1;
            if (chrObj.hasValue("chrfmt.ulstyle")) {
                switch (chrObj.getIntValue("chrfmt.ulstyle")) {
                    case 0: {
                        n4 = 1;
                        break;
                    }
                    case 1: {
                        n4 = 4;
                        break;
                    }
                    case 2: {
                        n4 = 2;
                        break;
                    }
                    case 3: {
                        n4 = 0;
                        break;
                    }
                    case 4: {
                        n4 = 6;
                        break;
                    }
                    case 5: {
                        n4 = 10;
                        break;
                    }
                    case 6: {
                        n4 = 12;
                        break;
                    }
                    case 7: {
                        n4 = 15;
                        break;
                    }
                    case 8: {
                        n4 = 8;
                        break;
                    }
                    case 9: {
                        n3 = 0;
                        break;
                    }
                    case 10: {
                        n4 = 3;
                        break;
                    }
                    case 11: {
                        n4 = 5;
                        break;
                    }
                    case 12: {
                        n4 = 7;
                        break;
                    }
                    case 13: {
                        n4 = 11;
                        break;
                    }
                    case 14: {
                        n4 = 13;
                        break;
                    }
                    case 15: {
                        n4 = 9;
                        break;
                    }
                    case 16: {
                        n4 = 16;
                        break;
                    }
                    case 17: {
                        n4 = 14;
                        break;
                    }
                    default: {
                        n3 = 0;
                    }
                }
            }
            if (n3 != 0) {
                string2 = StyleTypeDef.TYPE_NAME[8];
                string = Boolean.TRUE.toString();
                paragraphLogic.applyTextStyle(jetRptParagraph, n, n2, string2, string);
                string2 = StyleTypeDef.TYPE_NAME[9];
                string = ParagraphConstant.UNDERLINE_STYLE_NAME[n4];
                paragraphLogic.applyTextStyle(jetRptParagraph, n, n2, string2, string);
            }
        }
        if (chrObj.hasValue("chrfmt.ulc") && (n3 = chrObj.getIntValue("chrfmt.ulc")) >= 0 && n3 < this.STRIKETHROUGH_NAME.size()) {
            string = (String)this.STRIKETHROUGH_NAME.get(n3);
            if (string == null) {
                string = "0x000000";
            }
            string2 = StyleTypeDef.TYPE_NAME[6];
            paragraphLogic.applyTextStyle(jetRptParagraph, n, n2, string2, string);
        }
        if (chrObj.hasValue("chrfmt.strike")) {
            string2 = StyleTypeDef.TYPE_NAME[10];
            string = String.valueOf(chrObj.getBooleanValue("chrfmt.strike"));
            paragraphLogic.applyTextStyle(jetRptParagraph, n, n2, string2, string);
            string2 = StyleTypeDef.TYPE_NAME[11];
            string = EnumerationConstant.STRIKETHROUGH_NAME[0];
            paragraphLogic.applyTextStyle(jetRptParagraph, n, n2, string2, string);
        }
        if (chrObj.hasValue("chrfmt.strikedl")) {
            string2 = StyleTypeDef.TYPE_NAME[10];
            string = "true";
            paragraphLogic.applyTextStyle(jetRptParagraph, n, n2, string2, string);
            string2 = StyleTypeDef.TYPE_NAME[11];
            string = EnumerationConstant.STRIKETHROUGH_NAME[0];
            paragraphLogic.applyTextStyle(jetRptParagraph, n, n2, string2, string);
        }
    }

    private void addAll(JetRptField jetRptField) {
        int n = 0;
        if (jetRptField.bold.get()) {
            n |= 1;
        }
        if (jetRptField.italic.get()) {
            n |= 2;
        }
        float f = jetRptField.fontSize.get();
        String string = jetRptField.fontName.get();
        Font font = FontSets.getFont(string, n, f);
        FontMetrics fontMetrics = font instanceof JFont ? ((JFont)((Object)font)).getFontMetrics() : Toolkit.getDefaultToolkit().getFontMetrics(font);
        String string2 = jetRptField instanceof JetRptTextField ? ((JetRptTextField)jetRptField).text.get() : jetRptField.format.get();
        jetRptField.width.set(fontMetrics.stringWidth(string2));
        jetRptField.height.set(fontMetrics.getHeight());
    }

    protected void copyProperties(JetRptTextBox jetRptTextBox, List list, List list2) throws JUpgradeFailtureException {
        super.copyProperties(jetRptTextBox, list, list2);
        UpgradeToolkit.handleBorderProperty(jetRptTextBox);
    }
}

