/*
 * Decompiled with CFR 0.152.
 */
package jet.upgrade.kit;

import com.jinfonet.util.JRLog;
import com.jinfonet.web.beans.Atom;
import com.jinfonet.web.beans.Expression;
import com.jinfonet.web.beans.LinkConditionDef;
import com.jinfonet.web.beans.LinkDef;
import com.jinfonet.web.beans.OperatorMapper;
import com.jinfonet.web.beans.ResourceTypes;
import com.jinfonet.web.util.FileUtil;
import com.jinfonet.web.util.json.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jet.controls.JetBLColumnName;
import jet.controls.JetBLColumnVector;
import jet.controls.JetObject;
import jet.controls.JetProperty;
import jet.controls.JetString;
import jet.controls.JetVector;
import jet.controls.QueryInfoImpl;
import jet.icontrols.PropValueInfo;
import jet.icontrols.QueryInfo;
import jet.ireport.IDataContainer;
import jet.ireport.IReport;
import jet.lc.LCAidObjects;
import jet.lc.LCObject;
import jet.lc.impl.JetLCContent;
import jet.lc.impl.JetLCObject;
import jet.naming.PropertyNames;
import jet.report.JetRptParamLink;
import jet.report.JetRptSubLink;
import jet.report.JetRptSubLinkContainer;
import jet.report.JetRptSubReturnValue;
import jet.report.JetRptSubReturnValueContainer;
import jet.report.link.JetLinkProperties;
import jet.report.link.NormalLinkValue;
import jet.report.link.SimpleLinkValue;
import jet.report.link.ToContentValue;
import jet.report.link.ToReportValue;
import jet.report.link.ToURLValue;
import jet.report.link.URLPattern;
import jet.report.onTheFlyFormula.JetRptFlyFormulaMeasureSet;
import jet.reportLogic.objectInfo.JPropValueInfoImpl;
import jet.reportLogic.objectLogic.ObjectLogicFactory;
import jet.reportset.DataSet;
import jet.reportset.JetRptReport;
import jet.universe.JetUUniverse;
import jet.universe.businesslogic.BLNode;
import jet.upgrade.JUpgradeFailtureException;
import jet.upgrade.UpgradeBV;
import jet.upgrade.UpgradeDataContext;
import jet.upgrade.kit.UpgradeToolkit;

class BeforeV13D5OnlyToolkit {
    BeforeV13D5OnlyToolkit() {
    }

    public static int getBusinessType(JetUUniverse jetUUniverse, QueryInfo queryInfo) {
        int n = -1;
        if (queryInfo.getDataResoureType() == 1) {
            n = jetUUniverse == null ? 2 : UpgradeBV.getBusinessType(jetUUniverse, queryInfo.getDatasourceName(), queryInfo.getQueryName());
        } else if (queryInfo.getDataResoureType() == 2) {
            n = 3;
        }
        return n;
    }

    public static QueryInfo upgradeQueryInfoBeforeV13D5(JetUUniverse jetUUniverse, QueryInfo queryInfo) throws JUpgradeFailtureException {
        if (queryInfo == null) {
            return null;
        }
        int n = queryInfo.getDataResoureType();
        if (n == 1 || n == 2) {
            int n2 = BeforeV13D5OnlyToolkit.getBusinessType(jetUUniverse, queryInfo);
            String string = UpgradeBV.getNewBV(jetUUniverse, queryInfo.getDatasourceName(), queryInfo.getQueryName(), n2, queryInfo.getBLName());
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, "[Upgrade proc]V13.5 Feature 105211(63810), getNewBV(" + jetUUniverse + "," + queryInfo.getDatasourceName() + "," + queryInfo.getQueryName() + "," + n2 + "," + queryInfo.getBLName() + ") return " + string);
            }
            if (string == null) {
                string = queryInfo.getBLName();
                if (JRLog.isError(2)) {
                    JRLog.error(2, 2210801, new Object[]{queryInfo.getBLName(), "QINFO"}, null);
                }
            }
            return new QueryInfoImpl(queryInfo.getCatalogName(), queryInfo.getDatasourceName(), "", string, 2);
        }
        return new QueryInfoImpl(queryInfo.getCatalogName(), queryInfo.getDatasourceName(), queryInfo.getQueryName(), queryInfo.getBLName(), queryInfo.getDataResoureType());
    }

    public static String getQualifyDisplayNameByQualifyName(JetUUniverse jetUUniverse, IReport iReport, QueryInfo queryInfo, String string) {
        BLNode bLNode;
        JetRptFlyFormulaMeasureSet jetRptFlyFormulaMeasureSet;
        String string2 = null;
        if (iReport != null && (jetRptFlyFormulaMeasureSet = BeforeV13D5OnlyToolkit.getJetRptFlyFormulaMeasureSet(iReport, queryInfo)) != null && (bLNode = jetRptFlyFormulaMeasureSet.getBLNodeByBLQualifyName(string)) != null) {
            string2 = bLNode.getQualifyDisplayName();
        }
        if (string2 == null) {
            if (jetUUniverse == null) {
                string2 = null;
            } else {
                int n = BeforeV13D5OnlyToolkit.getBusinessType(jetUUniverse, queryInfo);
                string2 = UpgradeBV.getQDNameByQualifyName(jetUUniverse, queryInfo.getDatasourceName(), queryInfo.getQueryName(), n, queryInfo.getBLName(), string);
            }
        }
        if (JRLog.isTrace(7)) {
            JRLog.trace(7, "[Upgrade proc]V13.5 Feature 105211(63810), getQualifyDisplayNameByQualifyName(" + jetUUniverse + "," + iReport + "," + queryInfo + "," + string + ") return " + string2);
        }
        return string2;
    }

    public static JetRptFlyFormulaMeasureSet getJetRptFlyFormulaMeasureSet(IReport iReport, QueryInfo queryInfo) {
        LCAidObjects lCAidObjects;
        if (iReport == null || queryInfo == null) {
            return null;
        }
        Vector vector = null;
        vector = iReport instanceof JetRptReport ? ((JetRptReport)iReport).getChildren() : ((lCAidObjects = ((LCObject)iReport).getAidObjects()) == null ? null : lCAidObjects.getChildren());
        int n = vector == null ? 0 : vector.size();
        for (int i = 0; i < n; ++i) {
            JetRptFlyFormulaMeasureSet jetRptFlyFormulaMeasureSet;
            Object e = vector.get(i);
            if (!(e instanceof JetRptFlyFormulaMeasureSet) || !BeforeV13D5OnlyToolkit.checkQueryInfoEqual(queryInfo, (jetRptFlyFormulaMeasureSet = (JetRptFlyFormulaMeasureSet)e).getQueryInfo())) continue;
            return jetRptFlyFormulaMeasureSet;
        }
        return null;
    }

    protected static boolean checkQueryInfoEqual(QueryInfo queryInfo, QueryInfo queryInfo2) {
        int n;
        if (queryInfo2 == null) {
            return false;
        }
        int n2 = queryInfo.getDataResoureType();
        if (n2 == (n = queryInfo2.getDataResoureType())) {
            String string;
            String string2 = queryInfo.getDatasourceName();
            if (string2.equalsIgnoreCase(string = queryInfo2.getDatasourceName())) {
                String string3 = queryInfo.getQueryName();
                String string4 = queryInfo2.getQueryName();
                if (string3 == null && string4 == null || string3 != null && string3.equalsIgnoreCase(string4)) {
                    if (n2 == 0) {
                        return true;
                    }
                    String string5 = queryInfo.getBLName();
                    String string6 = queryInfo2.getBLName();
                    return string5 == null && string6 == null || string5 != null && string5.equalsIgnoreCase(string6);
                }
                return false;
            }
            return false;
        }
        return false;
    }

    public static void adjustNormalLinkValueBV13D5(JetLinkProperties jetLinkProperties, JetLinkProperties jetLinkProperties2, UpgradeDataContext upgradeDataContext) throws JUpgradeFailtureException {
        SimpleLinkValue simpleLinkValue = jetLinkProperties2.toSimpleLinkValue();
        if (upgradeDataContext == null || simpleLinkValue == null || simpleLinkValue.isNormalLinkEmpty()) {
            return;
        }
        int n = simpleLinkValue.getNormalLinkType();
        if (n == 0 || n == 2) {
            Object object;
            Object object2;
            List list;
            QueryInfo queryInfo = upgradeDataContext.getCurrentQueryInfo();
            if (queryInfo == null) {
                return;
            }
            int n2 = queryInfo.getDataResoureType();
            if (n2 != 1 && n2 != 2) {
                return;
            }
            ToReportValue toReportValue = (ToReportValue)simpleLinkValue.getNormalLinkValue();
            JetUUniverse jetUUniverse = upgradeDataContext.getCurrentUniverse();
            IReport iReport = upgradeDataContext.getCurrentIReport();
            IReport iReport2 = upgradeDataContext.getLinkedOrSubIReport(toReportValue.getReportFileName(), toReportValue.getReportInstName());
            if (iReport2 == null && JRLog.isError(3)) {
                JRLog.error(3, "[Upgrade proc] The Linked report " + toReportValue.getReportInstName() + " OF " + toReportValue.getReportFileName() + " can not loaded");
            }
            if ((list = toReportValue.getTargetConditions()) != null) {
                object2 = list.iterator();
                while (object2.hasNext()) {
                    object = (JetRptSubLinkContainer)object2.next();
                    BeforeV13D5OnlyToolkit.adjustBLColumnableInSubLinkContainer((JetRptSubLinkContainer)object, jetUUniverse, iReport, queryInfo, iReport2);
                }
                toReportValue.setTargetConditions(toReportValue.getDefaultTargetCompInstName(), list);
            }
            if ((object2 = toReportValue.getParameterLinks()) != null) {
                object = object2.iterator();
                while (object.hasNext()) {
                    JetRptParamLink jetRptParamLink = (JetRptParamLink)object.next();
                    BeforeV13D5OnlyToolkit.adjustBlColumnableInSubLinkBeforeV13D5(jetRptParamLink, jetUUniverse, iReport, queryInfo, null);
                }
                toReportValue.setParameterLinks((List)object2);
            }
            jetLinkProperties.setSimpleLinkValue(simpleLinkValue, true, null);
        } else if (n == 1 || n == 3) {
            QueryInfo queryInfo = upgradeDataContext.getCurrentQueryInfo();
            if (queryInfo == null) {
                return;
            }
            int n3 = queryInfo.getDataResoureType();
            if (n3 != 1 && n3 != 2) {
                return;
            }
            ToURLValue toURLValue = (ToURLValue)simpleLinkValue.getNormalLinkValue();
            JetUUniverse jetUUniverse = upgradeDataContext.getCurrentUniverse();
            IReport iReport = upgradeDataContext.getCurrentIReport();
            List list = toURLValue.getURLPatterns();
            if (list != null) {
                for (URLPattern uRLPattern : list) {
                    if (uRLPattern.getPatternType() != 2) continue;
                    String string = uRLPattern.getBLPatternValue();
                    String string2 = BeforeV13D5OnlyToolkit.getQualifyDisplayNameByQualifyName(jetUUniverse, iReport, queryInfo, string);
                    if (string2 == null) {
                        string2 = string;
                        if (!JRLog.isError(2)) continue;
                        JRLog.error(2, 2210800, new Object[]{string, "Linkable", "URLPATTERN"}, null);
                        continue;
                    }
                    uRLPattern.resetInstance(uRLPattern.getPatternValue(), string2);
                }
                toURLValue.setURLPatterns(list);
                jetLinkProperties.setSimpleLinkValue(simpleLinkValue, true, null);
            }
        } else if (n == 6) {
            Object object;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            ToContentValue toContentValue = (ToContentValue)simpleLinkValue.getNormalLinkValue();
            QueryInfo queryInfo = toContentValue.getTargetQueryInfo();
            if (queryInfo == null) {
                return;
            }
            int n4 = queryInfo.getDataResoureType();
            if (n4 != 1 && n4 != 2) {
                return;
            }
            JetUUniverse jetUUniverse = upgradeDataContext.getCurrentUniverse();
            IReport iReport = upgradeDataContext.getCurrentIReport();
            int n5 = BeforeV13D5OnlyToolkit.getBusinessType(jetUUniverse, queryInfo);
            String string = UpgradeBV.getNewBV(jetUUniverse, queryInfo.getDatasourceName(), queryInfo.getQueryName(), n5, queryInfo.getBLName());
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, "[Upgrade proc]V13.5 Feature 105211(63810), getNewBV(" + jetUUniverse + "," + queryInfo.getDatasourceName() + "," + queryInfo.getQueryName() + "," + n5 + "," + queryInfo.getBLName() + ") return " + string);
            }
            QueryInfoImpl queryInfoImpl = new QueryInfoImpl(queryInfo.getCatalogName(), queryInfo.getDatasourceName(), "", string, 2);
            PropValueInfo propValueInfo = toContentValue.getTargetContentType();
            if (propValueInfo.getValueType() == -3) {
                object6 = (String)propValueInfo.getValueObj();
                object5 = BeforeV13D5OnlyToolkit.getQualifyDisplayNameByQualifyName(jetUUniverse, iReport, queryInfo, (String)object6);
                if (object5 == null) {
                    object5 = object6;
                    if (JRLog.isError(2)) {
                        JRLog.error(2, 2210800, new Object[]{object6, "Linkable", "CONTENTTYPE"}, null);
                    }
                }
                propValueInfo = JPropValueInfoImpl.createOtherQueryResourceValueInfo((String)object5, queryInfoImpl);
            }
            if ((object6 = toContentValue.getTargetFileName()).getValueType() == -3) {
                object5 = (String)object6.getValueObj();
                object4 = BeforeV13D5OnlyToolkit.getQualifyDisplayNameByQualifyName(jetUUniverse, iReport, queryInfo, (String)object5);
                if (object4 == null) {
                    object4 = object5;
                    if (JRLog.isError(2)) {
                        JRLog.error(2, 2210800, new Object[]{object5, "Linkable", "FILENAME"}, null);
                    }
                }
                object6 = JPropValueInfoImpl.createOtherQueryResourceValueInfo((String)object4, queryInfoImpl);
            }
            if ((object4 = BeforeV13D5OnlyToolkit.getQualifyDisplayNameByQualifyName(jetUUniverse, iReport, queryInfo, (String)(object5 = toContentValue.getTargetContent()))) == null) {
                object4 = object5;
                if (JRLog.isError(2)) {
                    JRLog.error(2, 2210800, new Object[]{object5, "Linkable", "TARGETCONTENT"}, null);
                }
            } else {
                object5 = object4;
            }
            toContentValue.setLinkedContent(queryInfoImpl, (PropValueInfo)object6, propValueInfo, (String)object5);
            List list = toContentValue.getTargetConditions();
            if (list != null) {
                object3 = list.iterator();
                while (object3.hasNext()) {
                    object = (JetRptSubLink)object3.next();
                    BeforeV13D5OnlyToolkit.adjustBlColumnableInSubLinkBeforeV13D5((JetRptSubLink)object, jetUUniverse, iReport, upgradeDataContext.getCurrentQueryInfo(), queryInfo);
                }
                toContentValue.setTargetConditions(list);
            }
            if ((object3 = toContentValue.getParameterLinks()) != null) {
                object = object3.iterator();
                while (object.hasNext()) {
                    JetRptParamLink jetRptParamLink = (JetRptParamLink)object.next();
                    BeforeV13D5OnlyToolkit.adjustBlColumnableInSubLinkBeforeV13D5(jetRptParamLink, jetUUniverse, iReport, upgradeDataContext.getCurrentQueryInfo(), queryInfo);
                }
                toContentValue.setParameterLinks((List)object3);
            }
            jetLinkProperties.setSimpleLinkValue(simpleLinkValue, true, null);
        }
    }

    public static void adjustBLColumnableInSubLinkContainer(JetRptSubLinkContainer jetRptSubLinkContainer, JetUUniverse jetUUniverse, IReport iReport, QueryInfo queryInfo, IReport iReport2) throws JUpgradeFailtureException {
        List list;
        QueryInfo queryInfo2 = null;
        if (iReport2 != null) {
            list = jetRptSubLinkContainer.targetCompInst.get();
            int n = list != null ? list.size() : 0;
            for (int i = 0; i < n; ++i) {
                DataSet dataSet;
                JetObject jetObject = iReport2.nameToObject((String)list.get(i));
                if (!(jetObject instanceof IDataContainer) || (dataSet = ((IDataContainer)((Object)jetObject)).getBindedDataSet()) == null) continue;
                queryInfo2 = dataSet.getQueryInfo();
                break;
            }
        }
        list = jetRptSubLinkContainer.getSubLinks();
        for (JetRptSubLink jetRptSubLink : list) {
            BeforeV13D5OnlyToolkit.adjustBlColumnableInSubLinkBeforeV13D5(jetRptSubLink, jetUUniverse, iReport, queryInfo, queryInfo2);
        }
    }

    public static void adjustBLColumnableInSubReturnValueContainer(JetRptSubReturnValueContainer jetRptSubReturnValueContainer, JetUUniverse jetUUniverse, IReport iReport, QueryInfo queryInfo, IReport iReport2) throws JUpgradeFailtureException {
        Object object;
        Object object2;
        Object object3;
        QueryInfo queryInfo2 = null;
        if (iReport2 != null && (object3 = iReport2.nameToObject((String)(object2 = jetRptSubReturnValueContainer.returnValueComponent.get()))) instanceof IDataContainer && (object = ((IDataContainer)object3).getBindedDataSet()) != null) {
            queryInfo2 = object.getQueryInfo();
        }
        object2 = jetRptSubReturnValueContainer.getReturnVlaues();
        object3 = object2.iterator();
        while (object3.hasNext()) {
            object = (JetRptSubReturnValue)object3.next();
            BeforeV13D5OnlyToolkit.adjustBlColumnableInSubLinkBeforeV13D5((JetRptSubLink)object, jetUUniverse, iReport, queryInfo, queryInfo2);
        }
    }

    public static void adjustBlColumnableInSubLinkBeforeV13D5(JetRptSubLink jetRptSubLink, JetUUniverse jetUUniverse, IReport iReport, QueryInfo queryInfo, QueryInfo queryInfo2) throws JUpgradeFailtureException {
        if (jetRptSubLink instanceof JetRptParamLink) {
            JetRptParamLink jetRptParamLink = (JetRptParamLink)jetRptSubLink;
            String string = jetRptParamLink.blMainColumn.get();
            if (!(string == null || string.isEmpty() || string.startsWith("[") && string.contains("]["))) {
                int n = BeforeV13D5OnlyToolkit.getBusinessType(jetUUniverse, queryInfo);
                String string2 = UpgradeBV.getQDNameByQualifyName(jetUUniverse, queryInfo.getDatasourceName(), queryInfo.getQueryName(), n, queryInfo.getBLName(), string);
                if (JRLog.isTrace(7)) {
                    JRLog.trace(7, "[Upgrade proc]V13.5 Feature 105211(63810), [SUBLINK0Main] getQDNameByQualifyName(" + jetUUniverse + "," + queryInfo.getDatasourceName() + "," + queryInfo.getQueryName() + "," + n + "," + queryInfo.getBLName() + "," + string + ") return " + string2);
                }
                if (string2 == null) {
                    string2 = string.substring(string.indexOf(46) + 1);
                }
                jetRptParamLink.blMainColumn.set(string2);
            }
        } else if (jetRptSubLink instanceof JetRptSubReturnValue) {
            if (queryInfo2 != null) {
                JetRptSubReturnValue jetRptSubReturnValue = (JetRptSubReturnValue)jetRptSubLink;
                String string = jetRptSubReturnValue.blSubColumn.get();
                if (!(string == null || string.isEmpty() || string.startsWith("[") && string.contains("]["))) {
                    String string3 = BeforeV13D5OnlyToolkit.I(jetUUniverse, queryInfo2, string);
                    if (string3 == null) {
                        string3 = string.substring(string.indexOf(46) + 1);
                    }
                    jetRptSubReturnValue.blSubColumn.set(string3);
                }
            }
        } else {
            String string;
            String string4 = jetRptSubLink.blMainColumn.get();
            if (string4 != null && !string4.isEmpty()) {
                string = UpgradeToolkit.getQualifyDisplayNameByQualifyName(jetUUniverse, iReport, queryInfo, string4);
                if (string == null) {
                    if (queryInfo.getDataResoureType() == 1) {
                        if (JRLog.isError(3)) {
                            JRLog.error(3, "[Upgrade proc] Clear Query resource named '" + string4 + "' that bad been set as RC/BL on SubLink. The report may build in developing version.");
                        }
                        jetRptSubLink.blMainColumn.set("");
                    } else {
                        jetRptSubLink.blMainColumn.set(string4);
                        if (JRLog.isError(2)) {
                            JRLog.error(2, 2210800, new Object[]{string4, "SUBLINK", "MAINCOLUMN"}, null);
                        }
                    }
                } else {
                    jetRptSubLink.blMainColumn.set(string);
                }
            }
            if (!(queryInfo2 == null || (string4 = jetRptSubLink.blSubColumn.get()).startsWith("[") && string4.contains("]["))) {
                string = BeforeV13D5OnlyToolkit.I(jetUUniverse, queryInfo2, string4);
                if (string == null) {
                    string = string4.substring(string4.indexOf(46) + 1);
                }
                jetRptSubLink.blSubColumn.set(string);
            }
        }
    }

    private static String I(JetUUniverse jetUUniverse, QueryInfo queryInfo, String string) {
        int n = BeforeV13D5OnlyToolkit.getBusinessType(jetUUniverse, queryInfo);
        String string2 = UpgradeBV.getQDNameByQualifyName(jetUUniverse, queryInfo.getDatasourceName(), queryInfo.getQueryName(), n, queryInfo.getBLName(), string);
        if (JRLog.isTrace(7)) {
            JRLog.trace(7, "[Upgrade proc]V13.5 Feature 105211(63810), [SUBLINK0Sub] getQDNameByQualifyName(" + jetUUniverse + "," + queryInfo.getDatasourceName() + "," + queryInfo.getQueryName() + "," + n + "," + queryInfo.getBLName() + "," + string + ") return " + string2);
        }
        if (string2 == null) {
            BLNode bLNode = UpgradeBV.getBLNodeByQualifyName(jetUUniverse.getBV(queryInfo.getDatasourceName(), queryInfo.getBLName()), string);
            if (bLNode != null) {
                string2 = bLNode.getQualifyDisplayName();
            }
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, "[Upgrade proc]V13.5 Feature 105211(63810), [SUBLINK0Sub] getBLNodeByQualifyName(" + jetUUniverse + "," + queryInfo.getDatasourceName() + "," + queryInfo.getQueryName() + "," + n + "," + queryInfo.getBLName() + "," + string + ") return " + string2);
            }
        }
        return string2;
    }

    public static void adjustBLColumnablesBeforeV13D5(JetObject jetObject, JetObject jetObject2, UpgradeDataContext upgradeDataContext) throws JUpgradeFailtureException {
        int n;
        Object object22;
        if (upgradeDataContext == null || jetObject == null || jetObject2 == null) {
            return;
        }
        Vector<Object> vector = new Vector<Object>();
        Vector<Object> vector2 = new Vector<Object>();
        for (Object object22 : jetObject.getProperties().values()) {
            if (object22 instanceof JetBLColumnName) {
                String string = ((JetBLColumnName)object22).get();
                if (string == null || string.isEmpty()) continue;
                vector.add(object22);
                continue;
            }
            if (object22 instanceof JetBLColumnVector) {
                Vector vector3 = ((JetBLColumnVector)object22).get();
                if (vector3 == null || vector3.isEmpty()) continue;
                vector.add(object22);
                continue;
            }
            if (!((JetProperty)object22).isChangeByBL()) continue;
            if (jetObject instanceof IDataContainer) {
                int n2 = ObjectLogicFactory.getDataContainerLogic().getDataControlType(jetObject, ((JetProperty)object22).getName());
                if (n2 == 0) {
                    vector2.add(object22);
                    continue;
                }
                vector.add(object22);
                continue;
            }
            vector.add(object22);
        }
        object22 = upgradeDataContext.getCurrentQueryInfo();
        int n2 = n = object22 != null ? object22.getDataResoureType() : 0;
        if (n == 1 || n == 2) {
            String string;
            Object object;
            IReport iReport;
            if (!vector.isEmpty()) {
                iReport = ObjectLogicFactory.getBasicComponentLogic().getIReportOf(jetObject2);
                IDataContainer iDataContainer = ObjectLogicFactory.getDataContainerLogic().getNearestDataContainer(jetObject2);
                object = upgradeDataContext.getCurrentUniverse();
                for (Object object3 : vector) {
                    Object object4;
                    Object object5;
                    if (object3 instanceof JetBLColumnName) {
                        object5 = ((JetBLColumnName)object3).get();
                        String string4 = BeforeV13D5OnlyToolkit.getQualifyDisplayNameByQualifyName((JetUUniverse)object, iReport, (QueryInfo)object22, (String)object5);
                        if (string4 == null) {
                            ((JetBLColumnName)object3).set((String)object5);
                            if (!JRLog.isError(2)) continue;
                            JRLog.error(2, 2210800, new Object[]{object5, jetObject2.getInstNameDirectly(), ((JetProperty)object3).getName()}, null);
                            continue;
                        }
                        ((JetBLColumnName)object3).set(string4);
                        continue;
                    }
                    if (object3 instanceof JetBLColumnVector) {
                        object5 = ((JetBLColumnVector)object3).get();
                        Vector<String> vector3 = new Vector<String>(((Vector)object5).size());
                        object4 = ((Vector)object5).iterator();
                        while (object4.hasNext()) {
                            string = (String)object4.next();
                            if (string == null || string.trim().isEmpty()) {
                                vector3.add(string);
                                continue;
                            }
                            String string2 = BeforeV13D5OnlyToolkit.getQualifyDisplayNameByQualifyName((JetUUniverse)object, iReport, (QueryInfo)object22, string);
                            if (string2 == null) {
                                string2 = string;
                                if (JRLog.isError(2)) {
                                    JRLog.error(2, 2210800, new Object[]{string, jetObject2.getInstNameDirectly(), ((JetProperty)object3).getName()}, null);
                                }
                            }
                            vector3.add(string2);
                        }
                        ((JetBLColumnVector)object3).set(vector3);
                        continue;
                    }
                    object5 = (String)((JetProperty)object3).getChangeByBL();
                    short s = ((JetProperty)object3).getChangeByBLType();
                    object4 = BeforeV13D5OnlyToolkit.OnParameterValueChange(s, (String)object5, (JetUUniverse)object, iReport, iDataContainer, (QueryInfo)object22);
                    if (object4 == null) {
                        object4 = object5;
                        if (JRLog.isError(2)) {
                            JRLog.error(2, 2210800, new Object[]{object5, jetObject2.getInstNameDirectly(), ((JetProperty)object3).getName()}, null);
                        }
                    }
                    ((JetProperty)object3).setChangeByBL(object4, s);
                }
            }
            if (!vector2.isEmpty()) {
                Object object3;
                iReport = ObjectLogicFactory.getBasicComponentLogic().getIReportOf(jetObject2);
                IDataContainer jetProperty = ObjectLogicFactory.getDataContainerLogic().getNearestDataContainer((JetObject)((Object)jetObject2.getParent()));
                object = ObjectLogicFactory.getDataContainerLogic().getUsedDataSet(jetProperty).getQueryInfo();
                object3 = upgradeDataContext.getCurrentUniverse();
                for (Object object5 : vector2) {
                    String string3 = (String)((JetProperty)object5).getChangeByBL();
                    short s = ((JetProperty)object5).getChangeByBLType();
                    string = BeforeV13D5OnlyToolkit.OnParameterValueChange(s, string3, (JetUUniverse)object3, iReport, jetProperty, (QueryInfo)object);
                    if (string == null) {
                        string = string3;
                        if (JRLog.isError(2)) {
                            JRLog.error(2, 2210800, new Object[]{string3, jetObject2.getInstNameDirectly(), ((JetProperty)object5).getName()}, null);
                        }
                    }
                    ((JetProperty)object5).setChangeByBL(string, s);
                }
            }
        } else if (!vector.isEmpty() || !vector2.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(jetObject2.getInstNameDirectly()).append(" 's ");
            for (JetProperty jetProperty : vector) {
                if (jetProperty instanceof JetBLColumnName || jetProperty instanceof JetBLColumnVector) {
                    stringBuilder.append(jetProperty.getName()).append(",");
                    jetProperty.set("");
                    continue;
                }
                stringBuilder.append(jetProperty.getName()).append("[ByS],");
                jetProperty.setChangeByBL(null, (short)0);
            }
            for (JetProperty jetProperty : vector2) {
                stringBuilder.append(jetProperty.getName()).append("[ByP],");
                jetProperty.setChangeByBL(null, (short)0);
            }
            if (JRLog.isError(3)) {
                if (object22 == null) {
                    JRLog.error(3, 219006);
                } else {
                    JRLog.error(3, 219007);
                }
            }
            if (JRLog.isTrace(6)) {
                if (object22 == null) {
                    JRLog.trace(6, "[UpgradeProc]Warnning#219006, details=" + stringBuilder.toString());
                } else {
                    JRLog.trace(6, "[UpgradeProc]Warnning#219007, details=" + stringBuilder.toString());
                }
            }
            stringBuilder.setLength(0);
            stringBuilder = null;
        }
    }

    private static String OnParameterValueChange(short s, String string, JetUUniverse jetUUniverse, IReport iReport, IDataContainer iDataContainer, QueryInfo queryInfo) {
        if (s == 0) {
            return BeforeV13D5OnlyToolkit.getQualifyDisplayNameByQualifyName(jetUUniverse, iReport, queryInfo, string);
        }
        if (iDataContainer == null) {
            return null;
        }
        JetRptFlyFormulaMeasureSet jetRptFlyFormulaMeasureSet = iDataContainer.getFlyFormulaMeasureSet();
        if (jetRptFlyFormulaMeasureSet == null) {
            return null;
        }
        BLNode bLNode = jetRptFlyFormulaMeasureSet.getBLNodeByBLQualifyName(string);
        return bLNode == null ? null : bLNode.getQualifyDisplayName();
    }

    public static void adjustOnParameterValueChangeBeforeV13D5(IReport iReport, JetUUniverse jetUUniverse, IReport iReport2) throws JUpgradeFailtureException {
        if (iReport instanceof JetRptReport) {
            BeforeV13D5OnlyToolkit.OnParameterValueChangeBLName((JetRptReport)iReport, jetUUniverse, iReport2);
        } else if (iReport instanceof JetLCObject) {
            Vector vector = ((JetLCObject)iReport).getChildren();
            JetObject jetObject = null;
            for (JetObject jetObject2 : vector) {
                if (!(jetObject2 instanceof JetLCContent)) continue;
                jetObject = jetObject2;
                break;
            }
            if (jetObject != null) {
                BeforeV13D5OnlyToolkit.OnParameterValueChangeBLName(jetObject, jetUUniverse, iReport2);
            }
        } else {
            return;
        }
    }

    private static void OnParameterValueChangeBLName(JetObject jetObject, JetUUniverse jetUUniverse, IReport iReport) throws JUpgradeFailtureException {
        int n;
        JetVector jetVector = (JetVector)jetObject.nameToProperty(PropertyNames.getDefinitionName(PropertyNames.OnParameterValueChange));
        Vector vector = jetVector.get();
        int n2 = n = vector != null ? vector.size() : 0;
        if (n > 0) {
            JetVector jetVector2 = (JetVector)jetObject.nameToProperty(PropertyNames.getDefinitionName(PropertyNames.OnParameterValueChangeDSName));
            JetVector jetVector3 = (JetVector)jetObject.nameToProperty(PropertyNames.getDefinitionName(PropertyNames.OnParameterValueChangeQueryName));
            JetVector jetVector4 = (JetVector)jetObject.nameToProperty(PropertyNames.getDefinitionName(PropertyNames.OnParameterValueChangeBLName));
            JetVector jetVector5 = (JetVector)jetObject.nameToProperty(PropertyNames.getDefinitionName(PropertyNames.OnParameterValueChangeDataResourceType));
            Vector vector2 = jetVector2.get();
            Vector vector3 = jetVector3.get();
            Vector vector4 = jetVector4.get();
            Vector vector5 = jetVector5.get();
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                String string;
                String string2 = (String)vector.get(i);
                String string3 = (String)vector2.get(i);
                String string4 = (String)vector3.get(i);
                String string5 = (String)vector4.get(i);
                int n3 = Integer.parseInt((String)vector5.get(i));
                if (n3 != 1 && n3 != 2) continue;
                QueryInfoImpl queryInfoImpl = new QueryInfoImpl("", string3, string4, string5, n3);
                int n4 = BeforeV13D5OnlyToolkit.getBusinessType(jetUUniverse, queryInfoImpl);
                String string6 = UpgradeBV.getNewBV(jetUUniverse, string3, string4, n4, string5);
                if (JRLog.isTrace(7)) {
                    JRLog.trace(7, "[Upgrade proc]V13.5 Feature 105211(63810), getNewBV(" + jetUUniverse + "," + string3 + "," + string4 + "," + n4 + "," + string5 + ") return " + string6);
                }
                if (string6 == null) {
                    string6 = string5;
                    if (JRLog.isError(2)) {
                        JRLog.error(2, 2210801, new Object[]{string5, "IREPORT.OnParameterValueChange"}, null);
                    }
                }
                if ((string = BeforeV13D5OnlyToolkit.getQualifyDisplayNameByQualifyName(jetUUniverse, iReport, queryInfoImpl, string2)) == null) {
                    string = string2;
                    if (JRLog.isError(2)) {
                        JRLog.error(2, 2210800, new Object[]{string2, "IREPORT", "OnParameterValueChange"}, null);
                    }
                }
                vector.set(i, string);
                vector3.set(i, "");
                vector4.set(i, string6);
                vector5.set(i, String.valueOf(2));
                bl = true;
            }
            if (bl) {
                jetVector.set(vector);
                jetVector2.set(vector2);
                jetVector3.set(vector3);
                jetVector4.set(vector4);
                jetVector5.set(vector5);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SimpleLinkValue createSimpleLinkValueFromChartHyperLink(JetString jetString, JetString jetString2, boolean bl, JetUUniverse jetUUniverse, IReport iReport, QueryInfo queryInfo) throws JUpgradeFailtureException {
        if (jetString.isSetAnyChangeBy()) {
            String string;
            Vector<URLPattern> vector = new Vector<URLPattern>(1);
            if (bl) {
                if (!jetString.isChangeByBL()) return null;
                string = (String)jetString.getChangeByBL();
                String string2 = string;
                if (string2 == null) {
                    string2 = string;
                    if (JRLog.isError(2)) {
                        JRLog.error(2, 2210800, new Object[]{string, "ChartO", jetString.getName()}, null);
                    }
                }
                vector.add(new URLPattern(2, "", string2));
            } else {
                if (!jetString.isChangeByOther()) return null;
                vector.add(new URLPattern(2, (String)jetString.getChangeByObject(), ""));
            }
            string = jetString2.get();
            return new SimpleLinkValue(new ToURLValue(vector, BeforeV13D5OnlyToolkit.OnParameterValueChangeDSName(string), string), null);
        }
        String string = jetString.get();
        if (string == null || string.trim().isEmpty()) {
            return null;
        }
        try {
            SimpleLinkValue simpleLinkValue = BeforeV13D5OnlyToolkit.OnParameterValueChangeDataResourceType(string.trim(), bl, jetUUniverse, iReport, queryInfo);
            if (simpleLinkValue != null) return simpleLinkValue;
            Vector<URLPattern> vector = new Vector<URLPattern>(1);
            vector.add(new URLPattern(1, string, ""));
            String string3 = jetString2.get();
            return new SimpleLinkValue(new ToURLValue(vector, BeforeV13D5OnlyToolkit.OnParameterValueChangeDSName(string3), string3), null);
        }
        catch (Throwable throwable) {
            if (!JRLog.isError(3)) return null;
            JRLog.error(3, "[Upgrade Proc] Ignore error definition used Chart-HyperLink: " + throwable.getMessage());
            return null;
        }
    }

    private static int OnParameterValueChangeDSName(String string) {
        if (string.equals("")) {
            return 4;
        }
        if (string.equals("_blank")) {
            return 0;
        }
        if (string.equals("_top")) {
            return 3;
        }
        if (string.equals("_self")) {
            return 2;
        }
        if (string.equals("_parent")) {
            return 1;
        }
        return 5;
    }

    private static SimpleLinkValue OnParameterValueChangeDataResourceType(String string, boolean bl, JetUUniverse jetUUniverse, IReport iReport, QueryInfo queryInfo) throws JUpgradeFailtureException {
        JSONObject jSONObject = null;
        try {
            jSONObject = new JSONObject(string);
        }
        catch (Throwable throwable) {
            return null;
        }
        LinkDef linkDef = LinkDef.parse(jSONObject);
        NormalLinkValue normalLinkValue = null;
        switch (linkDef.getType()) {
            case 0: {
                normalLinkValue = BeforeV13D5OnlyToolkit.OnParameterValueChangeQueryName(linkDef, bl, jetUUniverse, iReport, queryInfo);
                break;
            }
            case 2: {
                throw new RuntimeException("Chart does not support link of Master/Detail before version 13.5.");
            }
            case 1: {
                normalLinkValue = BeforeV13D5OnlyToolkit.PARAMETER(linkDef, 1, bl, jetUUniverse, iReport, queryInfo);
                break;
            }
            case 3: {
                normalLinkValue = BeforeV13D5OnlyToolkit.PARAMETER(linkDef, 3, bl, jetUUniverse, iReport, queryInfo);
                break;
            }
            case 6: {
                throw new RuntimeException("Chart does not support link of content before version 13.5.");
            }
            case -1: {
                throw new RuntimeException("Invalid link type " + linkDef.getType());
            }
            default: {
                throw new RuntimeException("Unknown link type " + linkDef.getType());
            }
        }
        SimpleLinkValue simpleLinkValue = new SimpleLinkValue(normalLinkValue, null);
        return simpleLinkValue;
    }

    private static ToReportValue OnParameterValueChangeQueryName(LinkDef linkDef, boolean bl, JetUUniverse jetUUniverse, IReport iReport, QueryInfo queryInfo) throws JUpgradeFailtureException {
        String string = linkDef.getLinkedReportName();
        string = FileUtil.getFileName(string);
        String string2 = linkDef.getLinkedSheetName();
        List list = BeforeV13D5OnlyToolkit.SEDU(linkDef, bl, jetUUniverse, iReport, queryInfo);
        List list2 = BeforeV13D5OnlyToolkit.addTargetComponetInstName(linkDef.getParameterExpression(), bl, jetUUniverse, iReport, queryInfo);
        String string3 = linkDef.getDefaultLinkedComponent();
        if (string3 == null) {
            Collection collection = linkDef.getLinkedContditions();
            if (collection != null && !collection.isEmpty()) {
                LinkConditionDef linkConditionDef = (LinkConditionDef)collection.iterator().next();
                string3 = (String)linkConditionDef.getLinkedComponentNames().iterator().next();
            } else {
                string3 = "";
            }
        }
        boolean bl2 = linkDef.isTransferStyle();
        int n = linkDef.getTarget();
        String string4 = linkDef.getCustomizedTarget();
        ToReportValue toReportValue = new ToReportValue(0, string, string2, null);
        toReportValue.setParameterLinks(list2);
        toReportValue.setTargetConditions(string3, list);
        toReportValue.setTargetFrame(n, string4);
        toReportValue.setTrasferStyle(bl2);
        return toReportValue;
    }

    private static NormalLinkValue PARAMETER(LinkDef linkDef, int n, boolean bl, JetUUniverse jetUUniverse, IReport iReport, QueryInfo queryInfo) throws JUpgradeFailtureException {
        ToURLValue toURLValue = null;
        if (linkDef.getPrefix() != null && linkDef.getPrefix().trim().length() != 0) {
            List list = BeforeV13D5OnlyToolkit.adjustBLColumnableInSubLinkContainer(linkDef.getPrefix());
            String string = linkDef.getPrefix();
            ArrayList<URLPattern> arrayList = new ArrayList<URLPattern>();
            URLPattern uRLPattern = null;
            String string2 = null;
            String string3 = null;
            if (list != null) {
                for (String string4 : list) {
                    String string5 = string.substring(0, string.indexOf(string4));
                    if (string5 != null && string5.length() > 0) {
                        uRLPattern = new URLPattern(1, string5, new String[0]);
                        arrayList.add(uRLPattern);
                    }
                    string2 = string4.substring(2, string4.length() - 1);
                    Collection collection = linkDef.getDynamicResList();
                    for (Atom atom : collection) {
                        if (!atom.getDispName().equals(string2) && (atom.getResourceType() != ResourceTypes.PARAMETER.intType() || !atom.getDispName().equalsIgnoreCase(string2))) continue;
                        string3 = atom.getInstName();
                        if (string3 == null) break;
                        if (atom.getResourceType() == ResourceTypes.PARAMETER.intType()) {
                            uRLPattern = new URLPattern(4, string2, string3);
                        } else {
                            String string6 = atom.getCondRef();
                            if (string6 != null && string6.trim().length() != 0) {
                                string2 = string6;
                            }
                            if (bl) {
                                String string7 = BeforeV13D5OnlyToolkit.getQualifyDisplayNameByQualifyName(jetUUniverse, iReport, queryInfo, string3);
                                if (string7 == null) {
                                    string7 = string3;
                                    if (JRLog.isError(2)) {
                                        JRLog.error(2, 2210800, new Object[]{string3, "ChartO", "JSONHYPERLINK"}, null);
                                    }
                                } else {
                                    string3 = string7;
                                }
                            }
                            uRLPattern = new URLPattern(2, string2, string3);
                        }
                        arrayList.add(uRLPattern);
                        string3 = null;
                        break;
                    }
                    string = string.substring(string.indexOf(string4) + string4.length());
                }
            }
            if (string.length() > 0) {
                uRLPattern = new URLPattern(1, string, new String[0]);
                arrayList.add(uRLPattern);
            }
            if (n == 1) {
                String string4;
                int n2 = linkDef.getTarget();
                string4 = linkDef.getCustomizedTarget();
                toURLValue = new ToURLValue(arrayList, n2, string4);
            } else if (n == 3) {
                toURLValue = new ToURLValue(arrayList);
            }
        }
        return toURLValue;
    }

    private static List SEDU(LinkDef linkDef, boolean bl, JetUUniverse jetUUniverse, IReport iReport, QueryInfo queryInfo) throws JUpgradeFailtureException {
        ArrayList<JetRptSubLinkContainer> arrayList = new ArrayList<JetRptSubLinkContainer>();
        Collection collection = linkDef.getLinkedContditions();
        if (collection == null) {
            return arrayList;
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object object2;
            JetRptSubLinkContainer jetRptSubLinkContainer = new JetRptSubLinkContainer();
            LinkConditionDef linkConditionDef = (LinkConditionDef)iterator.next();
            Collection collection2 = linkConditionDef.getLinkedComponentNames();
            for (Object object2 : collection2) {
                jetRptSubLinkContainer.addTargetComponetInstName((String)object2);
            }
            object2 = BeforeV13D5OnlyToolkit.add(linkConditionDef.getConditionExpression(), bl, jetUUniverse, iReport, queryInfo);
            Iterator iterator2 = object2.iterator();
            while (iterator2.hasNext()) {
                JetRptSubLink jetRptSubLink = (JetRptSubLink)iterator2.next();
                jetRptSubLinkContainer.add(jetRptSubLink);
            }
            arrayList.add(jetRptSubLinkContainer);
        }
        return arrayList;
    }

    private static List add(Expression expression, boolean bl, JetUUniverse jetUUniverse, IReport iReport, QueryInfo queryInfo) throws JUpgradeFailtureException {
        ArrayList<JetRptSubLink> arrayList = new ArrayList<JetRptSubLink>();
        if (expression == null) {
            return arrayList;
        }
        List list = expression.getExpressions();
        int n = list != null ? list.size() : 0;
        for (int i = 0; i < n; ++i) {
            JetRptSubLink jetRptSubLink = new JetRptSubLink();
            jetRptSubLink.setEditable();
            Expression expression2 = (Expression)list.get(i);
            List list2 = expression2.getExpressions();
            String string = OperatorMapper.getOpByName(expression2.getOP());
            Atom atom = ((Expression)list2.get(0)).getAtom();
            Atom atom2 = ((Expression)list2.get(1)).getAtom();
            jetRptSubLink.operator.set(string);
            jetRptSubLink.subColumn.set(atom.getMappingName());
            String string2 = atom2.getCondRef();
            if (string2 == null || string2.trim().length() == 0) {
                jetRptSubLink.mainColumn.set(atom2.getMappingName());
            } else {
                jetRptSubLink.mainColumn.set(atom2.getCondRef());
            }
            String string3 = atom.getInstName();
            String string4 = atom2.getInstName();
            if (bl) {
                String string5 = BeforeV13D5OnlyToolkit.getQualifyDisplayNameByQualifyName(jetUUniverse, iReport, queryInfo, string3);
                if (string5 == null) {
                    jetRptSubLink.blSubColumn.set(string3);
                    if (JRLog.isError(2)) {
                        JRLog.error(2, 2210800, new Object[]{string3, "ChartO", "JSONHYPERLINK"}, null);
                    }
                } else {
                    jetRptSubLink.blSubColumn.set(string5);
                }
                if (string4 != null && string4.trim().length() > 0) {
                    string5 = BeforeV13D5OnlyToolkit.getQualifyDisplayNameByQualifyName(jetUUniverse, iReport, queryInfo, string4);
                    if (string5 == null) {
                        jetRptSubLink.blMainColumn.set(string4);
                        if (JRLog.isError(2)) {
                            JRLog.error(2, 2210800, new Object[]{string3, "ChartO", "JSONHYPERLINK"}, null);
                        }
                    } else {
                        jetRptSubLink.blMainColumn.set(string5);
                    }
                }
            } else {
                jetRptSubLink.blSubColumn.set(string3);
                jetRptSubLink.blMainColumn.set(string4);
            }
            arrayList.add(jetRptSubLink);
        }
        return arrayList;
    }

    private static List addTargetComponetInstName(Expression expression, boolean bl, JetUUniverse jetUUniverse, IReport iReport, QueryInfo queryInfo) throws JUpgradeFailtureException {
        ArrayList<JetRptParamLink> arrayList = new ArrayList<JetRptParamLink>();
        if (expression == null) {
            return arrayList;
        }
        List list = expression.getExpressions();
        int n = list != null ? list.size() : 0;
        for (int i = 0; i < n; ++i) {
            String string;
            JetRptParamLink jetRptParamLink = new JetRptParamLink();
            jetRptParamLink.setEditable();
            Expression expression2 = (Expression)list.get(i);
            List list2 = expression2.getExpressions();
            String string2 = OperatorMapper.getOpByName(expression2.getOP());
            Atom atom = ((Expression)list2.get(0)).getAtom();
            Atom atom2 = ((Expression)list2.get(1)).getAtom();
            jetRptParamLink.operator.set(string2);
            jetRptParamLink.blSubColumn.set(atom.getInstName());
            jetRptParamLink.subColumn.set(atom.getMappingName());
            if (atom2.getResourceType() != ResourceTypes.PARAMETER.intType()) {
                string = atom2.getInstName();
                if (bl) {
                    if (string != null && string.trim().length() > 0) {
                        String string3 = BeforeV13D5OnlyToolkit.getQualifyDisplayNameByQualifyName(jetUUniverse, iReport, queryInfo, string);
                        if (string3 == null) {
                            jetRptParamLink.blMainColumn.set(string);
                            if (JRLog.isError(2)) {
                                JRLog.error(2, 2210800, new Object[]{string, "ChartO", "JSONHYPERLINK"}, null);
                            }
                        } else {
                            jetRptParamLink.blMainColumn.set(string3);
                        }
                    }
                } else {
                    jetRptParamLink.blMainColumn.set(string);
                }
            }
            if ((string = atom2.getCondRef()) != null && string.trim().length() > 0) {
                jetRptParamLink.mainColumn.set(string);
            } else {
                jetRptParamLink.mainColumn.set(atom2.getMappingName());
            }
            arrayList.add(jetRptParamLink);
        }
        return arrayList;
    }

    private static List adjustBLColumnableInSubLinkContainer(String string) {
        Pattern pattern = Pattern.compile("\\$\\{((\\w*)|(\\W*))([^\\}])*\\}");
        Matcher matcher = pattern.matcher(string);
        ArrayList<String> arrayList = null;
        while (matcher.find()) {
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
            }
            arrayList.add(matcher.group());
        }
        return arrayList;
    }
}

