/*
 * Decompiled with CFR 0.152.
 */
package jet.upgrade.kit;

import com.jinfonet.util.JRLog;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import jet.controls.JetMappingTable;
import jet.controls.JetObject;
import jet.controls.JetProperty;
import jet.controls.JetQualifyReference;
import jet.controls.JetReference;
import jet.controls.JetReferences;
import jet.controls.JetString;
import jet.controls.JetVector;
import jet.formula.FormulaInfo;
import jet.icontrols.QueryInfo;
import jet.naming.PropertyNames;
import jet.report.JetLink;
import jet.report.JetRptDataSourceProperty;
import jet.report.JetRptRectangle;
import jet.report.JetRptSubLink;
import jet.report.JetRptTOC;
import jet.report.JetRptView;
import jet.report.JetRptViews;
import jet.report.conditionalFormatting.JetRptConditionalFormatList;
import jet.report.conditionalFormatting.JetRptConditionalFormatSet;
import jet.report.conditionallink.JetRptConditionalLinkList;
import jet.report.conditionallink.JetRptConditionalLinkSet;
import jet.report.mode.JetRptMode;
import jet.report.mode.JetRptModeContainer;
import jet.report.mode.actions.JetRptAction;
import jet.report.mode.actions.JetRptActionContainer;
import jet.report.mode.actions.JetRptAtomicAction;
import jet.reportLogic.objectLogic.ObjectLogicFactory;
import jet.reportset.JetRptReport;
import jet.universe.JetUUniverse;
import jet.upgrade.kit.BeforeV13D5OnlyToolkit;

public class UpgradeToolkit
extends BeforeV13D5OnlyToolkit {
    public static final String SUFFIX_REPORT = "_report";
    public static final String SUFFIX_VIEW = "_view";
    public static final String CONVERT_DATASET_INST_NAME = "convert_dataset";
    public static final String CONVERT_SECTION_OBJECT_INST_NAME = "convert_sectionObject";

    public static void copyProperties(JetObject jetObject, JetObject jetObject2, List list, String ... stringArray) {
        Vector vector = new Vector(jetObject.getProperties().keySet());
        if (stringArray != null) {
            vector.removeAll(Arrays.asList(stringArray));
        }
        for (String string : vector) {
            JetObject[] jetObjectArray;
            Object object;
            JetProperty jetProperty = jetObject.nameToProperty(string);
            JetProperty jetProperty2 = jetObject2.nameToProperty(string);
            if (jetProperty2 == null) continue;
            if (jetProperty instanceof JetReference) {
                if (jetProperty instanceof JetRptDataSourceProperty || (object = ((JetReference)jetProperty).getObject()) != null || (jetObjectArray = ((JetReference)jetProperty2).getObject()) == null) continue;
                jetProperty.setObject(jetObjectArray);
                list.add(jetProperty);
                continue;
            }
            if (jetProperty instanceof JetReferences) {
                object = ((JetReferences)jetProperty).get();
                if (!UpgradeToolkit.I(object) || UpgradeToolkit.I(jetObjectArray = ((JetReferences)jetProperty2).get())) continue;
                for (JetObject jetObject3 : jetObjectArray) {
                    ((JetReferences)jetProperty).set(jetObject3);
                }
                list.add(jetProperty);
                continue;
            }
            if (jetProperty instanceof FormulaInfo) {
                ((FormulaInfo)jetProperty2).copyTo((FormulaInfo)jetProperty);
                continue;
            }
            object = jetProperty2.toUnitString();
            jetProperty.setUnitValue((String)object);
            if (jetProperty2.isChangeByOther()) {
                jetProperty.setChangeByObject(jetProperty2.getChangeByObject(), jetProperty2.getChangeByOtherType());
            }
            if (jetProperty2.isChangeByBL()) {
                jetProperty.setChangeByBL(jetProperty2.getChangeByBL(), jetProperty2.getChangeByBLType());
            }
            if (jetProperty2.isChagneByFmtt()) {
                jetProperty.setChangeByFmtt(jetProperty2.getChangeByFmtt());
            }
            if (!jetProperty2.isCurrentAutoValue() || !jetProperty.isEnableAutoValue()) continue;
            jetProperty.setAsAutoValue(true);
        }
    }

    public static void handleBorderProperty(JetRptRectangle jetRptRectangle) {
        int n = jetRptRectangle.borderWidth.getUnit();
        jetRptRectangle.bottomBorderWidth.setUnitValue(n);
        jetRptRectangle.topBorderWidth.setUnitValue(n);
        jetRptRectangle.leftBorderWidth.setUnitValue(n);
        jetRptRectangle.rightBorderWidth.setUnitValue(n);
        Color color = jetRptRectangle.borderColor.get();
        jetRptRectangle.topBorderColor.set(color);
        jetRptRectangle.bottomBorderColor.set(color);
        jetRptRectangle.leftBorderColor.set(color);
        jetRptRectangle.rightBorderColor.set(color);
    }

    public static int[] sperate12TypeAlignments(int n) {
        int n2 = 0;
        int n3 = 0;
        switch (n) {
            case 1: {
                n2 = 0;
                n3 = 1;
                break;
            }
            case 2: {
                n2 = 2;
                n3 = 1;
                break;
            }
            case 3: {
                n2 = 1;
                n3 = 1;
                break;
            }
            case 4: {
                n2 = 0;
                n3 = 0;
                break;
            }
            case 5: {
                n2 = 2;
                n3 = 0;
                break;
            }
            case 6: {
                n2 = 1;
                n3 = 0;
                break;
            }
            case 7: {
                n2 = 0;
                n3 = 2;
                break;
            }
            case 8: {
                n2 = 2;
                n3 = 2;
                break;
            }
            case 9: {
                n2 = 1;
                n3 = 2;
                break;
            }
            case 10: {
                n2 = 3;
                n3 = 1;
                break;
            }
            case 11: {
                n2 = 3;
                n3 = 0;
                break;
            }
            case 12: {
                n2 = 3;
                n3 = 2;
            }
        }
        return new int[]{n2, n3};
    }

    private static boolean I(JetObject[] jetObjectArray) {
        if (jetObjectArray == null) {
            return true;
        }
        if (jetObjectArray.length == 0) {
            return true;
        }
        boolean bl = true;
        for (JetObject jetObject : jetObjectArray) {
            if (jetObject == null) continue;
            bl = false;
        }
        return bl;
    }

    public static void handleLinkBuildBeforeV10(JetObject jetObject, JetUUniverse jetUUniverse) {
        JetLink jetLink = (JetLink)jetObject.nameToProperty(PropertyNames.getDefinitionName(PropertyNames.Link));
        if (jetLink.getLinkType() == 2 || jetLink.getLinkType() == 0) {
            Object object;
            Vector vector = jetLink.getLink().links;
            Vector<String> vector2 = new Vector<String>();
            int n = 0;
            while (n < vector.size()) {
                object = (JetRptSubLink)vector.get(n);
                if (jetUUniverse != null && jetUUniverse.getAnyResourceByName(((JetRptSubLink)object).getSubColumn()) != null) {
                    ++n;
                    continue;
                }
                vector2.add(((JetRptSubLink)object).encodeToString());
                vector.remove(n);
            }
            JetMappingTable jetMappingTable = (JetMappingTable)jetObject.nameToProperty("LinkTargetCompCondition");
            jetMappingTable.addMapping(String.valueOf(0), vector2);
            object = (JetVector)jetObject.nameToProperty(PropertyNames.getDefinitionName(PropertyNames.LinkTargetComponent));
            Vector vector3 = ((JetVector)object).get();
            StringBuffer stringBuffer = new StringBuffer();
            if (vector3.size() > 0) {
                String string = (String)vector3.get(0);
                stringBuffer.append(string);
                for (int i = 1; i < vector3.size(); ++i) {
                    stringBuffer.append(";").append(vector3.get(i));
                }
                ((JetVector)object).set(stringBuffer.toString());
                JetString jetString = (JetString)jetObject.nameToProperty("LinkDefTargetCompInst");
                jetString.set(string);
            }
        }
    }

    public static List insertAdditionalObjectsToReport(JetRptReport jetRptReport, List list) {
        JetRptModeContainer jetRptModeContainer = jetRptReport.getModeContainer();
        JetRptActionContainer jetRptActionContainer = jetRptReport.getActionContainer();
        JetRptViews jetRptViews = jetRptReport.getViews();
        JetRptConditionalFormatSet jetRptConditionalFormatSet = jetRptReport.getConditionalFormatSet();
        JetRptConditionalLinkSet jetRptConditionalLinkSet = jetRptReport.getConditionalLinkSet();
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            JetObject jetObject = (JetObject)list.get(n2);
            if (jetObject instanceof JetRptTOC) {
                jetRptReport.add((JetRptTOC)jetObject);
                list.remove(n2);
                --n;
                continue;
            }
            if (jetObject instanceof JetRptMode) {
                jetRptModeContainer.add((JetRptMode)jetObject);
                list.remove(n2);
                --n;
                continue;
            }
            if (jetObject instanceof JetRptAction) {
                jetRptActionContainer.add((JetRptAction)jetObject);
                list.remove(n2);
                --n;
                continue;
            }
            if (jetObject instanceof JetRptAtomicAction) {
                jetRptActionContainer.add((JetRptAtomicAction)jetObject);
                list.remove(n2);
                --n;
                continue;
            }
            if (jetObject instanceof JetRptView) {
                jetRptViews.add((JetRptView)jetObject);
                list.remove(n2);
                --n;
                continue;
            }
            if (jetObject instanceof JetRptConditionalFormatList) {
                jetRptConditionalFormatSet.add((JetRptConditionalFormatList)jetObject);
                list.remove(n2);
                --n;
                continue;
            }
            if (jetObject instanceof JetRptConditionalLinkList) {
                jetRptConditionalLinkSet.add((JetRptConditionalLinkList)jetObject);
                list.remove(n2);
                --n;
                continue;
            }
            ++n2;
        }
        ObjectLogicFactory.getModeRendererLogic().regroupModeContainer(jetRptModeContainer);
        return list;
    }

    public static List handleOuterReferences(List list, Map map) {
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            int n3;
            Object object;
            JetObject[] jetObjectArray;
            JetProperty jetProperty = (JetProperty)list.get(n2);
            if (jetProperty instanceof JetReference) {
                jetObjectArray = (JetObject[])jetProperty.getObject();
                object = (JetObject)map.get(jetObjectArray);
                if (object != null) {
                    jetProperty.setObject(object);
                    list.remove(n2);
                    --n;
                    if (!JRLog.isTrace(7)) continue;
                    JRLog.trace(7, "[Upgrade Proc] reference property: " + jetProperty.getName() + "[parent=" + jetProperty.getParent().getClass() + "] handled");
                    continue;
                }
                ++n2;
                continue;
            }
            jetObjectArray = ((JetReferences)jetProperty).get();
            object = new JetObject[jetObjectArray.length];
            boolean bl = true;
            for (n3 = 0; n3 < jetObjectArray.length; ++n3) {
                object[n3] = (JetObject)map.get(jetObjectArray[n3]);
                if (object[n3] != null) continue;
                bl = false;
                break;
            }
            if (bl) {
                for (n3 = 0; n3 < jetObjectArray.length; ++n3) {
                    ((JetReferences)jetProperty).removeReference(jetObjectArray[n3]);
                    ((JetReferences)jetProperty).set(object[n3]);
                }
                list.remove(n2);
                --n;
                if (!JRLog.isTrace(7)) continue;
                JRLog.trace(7, "[Upgrade Proc] reference array property: " + jetProperty.getName() + "[parent=" + jetProperty.getParent().getClass() + "] handled");
                continue;
            }
            ++n2;
        }
        return list;
    }

    public static void moveOuterReferenceValue(List list, JetQualifyReference jetQualifyReference, JetQualifyReference jetQualifyReference2) {
        if (jetQualifyReference.getObject() != null) {
            jetQualifyReference2.setObject(jetQualifyReference.getObject());
            list.add(jetQualifyReference2);
            jetQualifyReference.set(null);
        }
        list.remove(jetQualifyReference);
    }

    public static boolean checkQueryInfoEqual(boolean bl, QueryInfo queryInfo, QueryInfo queryInfo2) {
        if (queryInfo == null) {
            return queryInfo2 == null;
        }
        if (queryInfo2 == null) {
            return false;
        }
        if (bl) {
            return BeforeV13D5OnlyToolkit.checkQueryInfoEqual(queryInfo, queryInfo2);
        }
        return queryInfo.isEquals(queryInfo2);
    }
}

