/*
 * Decompiled with CFR 0.152.
 */
package jet.util;

import com.jinfonet.util.JRLog;
import java.util.Vector;
import jet.JRStopEngineException;
import jet.bean.JREngine;
import jet.util.TokenKey;
import jet.util.tokenChecker;

public class CPUToken {
    int license;
    static Vector alive = new Vector();
    static Vector jrEng = new Vector();
    static CPUToken token;
    static Vector aliveThread;
    static Vector yieldThread;
    static double[] factor;
    static final Object LOCK;

    public static synchronized CPUToken buildToken(int n, int n2, JREngine jREngine) {
        if (n == 0 || n >= n2) {
            return null;
        }
        if (token != null) {
            return token;
        }
        double d = 1.6;
        double d2 = Math.log(d);
        double d3 = Math.log(2.0);
        token = new CPUToken(n2 + 1);
        factor = new double[n2];
        for (int i = 1; i <= n2; ++i) {
            CPUToken.factor[i - 1] = i <= n || n == 0 ? 0.0 : 0.0 + Math.exp(Math.log((double)i / (double)n) * d2 / d3) - 1.0;
            if (!JRLog.isTrace(6)) continue;
            JRLog.trace(6, "CPUToken buildToken cpus: " + n2 + " license = " + n + " current i is:" + i + " factor[i-1]:" + factor[i - 1]);
        }
        return token;
    }

    public synchronized double getFactor() {
        int n = jrEng.size() - 1;
        if (n < 0) {
            n = 0;
        }
        if (n > factor.length - 1) {
            return factor[factor.length - 1];
        }
        return factor[n];
    }

    public static synchronized CPUToken getToken() {
        return token;
    }

    CPUToken(int n) {
        this.license = n;
    }

    public synchronized void register(tokenChecker tokenChecker2) {
        if (!alive.contains(tokenChecker2)) {
            alive.addElement(tokenChecker2);
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "CPUToken register method , engine: " + tokenChecker2);
        }
        if (tokenChecker2 instanceof JREngine && !jrEng.contains(tokenChecker2)) {
            jrEng.addElement(tokenChecker2);
        }
    }

    public synchronized void release(tokenChecker tokenChecker2) {
        jrEng.removeElement(tokenChecker2);
        if (alive.removeElement(tokenChecker2)) {
            int n = this.add(tokenChecker2);
            this.aliveThread(tokenChecker2);
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "CPUToken release method, engine: " + tokenChecker2 + " hasToken:" + n + " alivethread =" + aliveThread + " yieldThread =" + yieldThread);
            }
            if (n > 0 && yieldThread.size() > 0) {
                this.notifyAll();
            }
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "CPUToken release method after deal with, engine: " + tokenChecker2 + " alivethread =" + aliveThread + " yieldThread =" + yieldThread);
        }
    }

    public synchronized void interrupte(tokenChecker tokenChecker2) {
        Thread thread = Thread.currentThread();
        int n = yieldThread.size();
        TokenKey tokenKey = null;
        for (int i = n - 1; i >= 0; --i) {
            tokenKey = (TokenKey)yieldThread.get(i);
            if (tokenKey.getChecker() != tokenChecker2 || tokenKey.getHolder() == thread) continue;
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "CPUToken interrupt the thread:" + tokenKey.getHolder() + " for engine: " + tokenChecker2 + ". Current thread is " + thread);
            }
            tokenKey.getHolder().interrupt();
        }
    }

    private synchronized void LOCK(tokenChecker tokenChecker2) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "CPUToken freeToken method enter, engine: " + tokenChecker2 + " alivethread =" + aliveThread + " yieldThread =" + yieldThread);
        }
        this.alive(tokenChecker2);
        if (yieldThread.size() > 0) {
            this.notifyAll();
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "CPUToken freeToken method after deal with, engine: " + tokenChecker2 + " alivethread =" + aliveThread + " yieldThread =" + yieldThread);
        }
    }

    private boolean SEDU(tokenChecker tokenChecker2) {
        TokenKey tokenKey = new TokenKey(Thread.currentThread(), tokenChecker2);
        return aliveThread.contains(tokenKey);
    }

    private int add(tokenChecker tokenChecker2) {
        int n = 0;
        int n2 = aliveThread.size();
        TokenKey tokenKey = null;
        for (int i = n2 - 1; i >= 0; --i) {
            tokenKey = (TokenKey)aliveThread.get(i);
            if (!tokenKey.engineEqual(tokenChecker2)) continue;
            aliveThread.remove(tokenKey);
            ++n;
        }
        return n;
    }

    private void addElement(tokenChecker tokenChecker2) {
        TokenKey tokenKey = new TokenKey(Thread.currentThread(), tokenChecker2);
        aliveThread.add(tokenKey);
        yieldThread.remove(tokenKey);
    }

    private void alive(tokenChecker tokenChecker2) {
        TokenKey tokenKey = new TokenKey(Thread.currentThread(), tokenChecker2);
        aliveThread.remove(tokenKey);
    }

    private int aliveThread(tokenChecker tokenChecker2) {
        int n = 0;
        int n2 = yieldThread.size();
        TokenKey tokenKey = null;
        for (int i = n2 - 1; i >= 0; --i) {
            tokenKey = (TokenKey)yieldThread.get(i);
            if (!tokenKey.engineEqual(tokenChecker2)) continue;
            yieldThread.remove(tokenKey);
            ++n;
        }
        return n;
    }

    private boolean append(tokenChecker tokenChecker2) {
        TokenKey tokenKey = new TokenKey(Thread.currentThread(), tokenChecker2);
        return yieldThread.contains(tokenKey);
    }

    private void contains(tokenChecker tokenChecker2) {
        TokenKey tokenKey = new TokenKey(Thread.currentThread(), tokenChecker2);
        yieldThread.add(tokenKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkToken(tokenChecker tokenChecker2, long l, boolean bl) throws JRStopEngineException {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "CPUToken checkToken method , engine: " + tokenChecker2 + " waitT:" + l + " reqTok:" + bl + " alivethread =" + aliveThread + " yieldThread =" + yieldThread);
        }
        InterruptedException interruptedException = null;
        Object object = LOCK;
        synchronized (object) {
            long l2 = Math.round((double)l * this.getFactor());
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "CPUToken checkToken method synchronized (LOCK), wt: " + l2 + " getFactor():" + this.getFactor() + ", engine: " + tokenChecker2);
            }
            if (l2 > 0L) {
                try {
                    LOCK.wait(l2);
                }
                catch (InterruptedException interruptedException2) {
                    interruptedException = interruptedException2;
                }
            }
        }
        object = this;
        synchronized (object) {
            boolean bl2 = this.SEDU(tokenChecker2);
            int n = yieldThread.size();
            int n2 = aliveThread.size();
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "CPUToken checkToken method synchronized (this), hasToken: " + bl2 + " , engine: " + tokenChecker2);
            }
            if (!bl || interruptedException != null) {
                if (bl2) {
                    this.LOCK(tokenChecker2);
                }
                if (interruptedException != null) {
                    throw new JRStopEngineException(interruptedException);
                }
                return false;
            }
            if (n > 0 && bl2) {
                this.notifyAll();
                this.alive(tokenChecker2);
                try {
                    this.contains(tokenChecker2);
                    while (n2 >= this.license) {
                        this.wait();
                        n = yieldThread.size();
                        n2 = aliveThread.size();
                    }
                    this.addElement(tokenChecker2);
                }
                catch (InterruptedException interruptedException3) {
                    throw new JRStopEngineException(interruptedException3);
                }
                return true;
            }
            if (!bl2) {
                if (n2 >= this.license) {
                    try {
                        this.contains(tokenChecker2);
                        while (n2 >= this.license) {
                            this.wait();
                            n = yieldThread.size();
                            n2 = aliveThread.size();
                        }
                        this.addElement(tokenChecker2);
                    }
                    catch (InterruptedException interruptedException4) {
                        throw new JRStopEngineException(interruptedException4);
                    }
                    return true;
                }
                this.addElement(tokenChecker2);
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "CPUToken checkToken method synchronized (this), engine.setHasToken(1), engine is: " + tokenChecker2);
                }
            }
        }
        return true;
    }

    public synchronized int getTokenNumber() {
        return this.license;
    }

    public int getLicense() {
        return this.license;
    }

    public synchronized void setTokenFactor(float f) {
    }

    static {
        aliveThread = new Vector();
        yieldThread = new Vector();
        LOCK = new Object();
    }
}

