/*
 * Decompiled with CFR 0.152.
 */
package jet.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import jet.util.CrossRefException;
import jet.util.ReferObject;
import jet.util.ReferRelation;
import jet.util.ReferRelationConstants;

public class CrossRefManager
extends ReferRelationConstants {
    public static final String REFER_TABLE = "Reference";
    public static final String TYPE_TABLE = "RefType";
    public static final String DATASOURCE_TABLE = "RefDataSource";
    public static final String CATALOG_TMP_TABLE = "Catalog_TempTable";
    public static final String REPORT_TMP_TABLE = "Report_TempTable";
    public static final String REF_SUFFIX = "_ref";
    public static final String DATABASE_SYMBOL_SUFFIX = "_ref.script";
    String dataSetID = null;
    Vector vDataSource = null;
    Vector vReferType = null;
    Vector vCurrReport = new Vector();
    boolean bDebug = false;
    FileOutputStream fm = null;
    protected transient Connection c = null;
    PreparedStatement ps = null;
    static boolean needexception = false;
    static boolean needout = false;

    private static void I(String string) {
    }

    public CrossRefManager(String string, String string2, Vector vector, Vector vector2) throws CrossRefException {
        if (needexception) {
            // empty if block
        }
        CrossRefManager.I("Begine create CrossRefManager!###################");
        String string3 = "CrossRefManager initial : ( catalogName = " + string + " ; catalogPath = " + string2 + " ; dataSourceVec = " + vector + " ; referTypeVec = " + vector2 + ")";
        this.setDataSetID(string, string2);
        CrossRefManager.deleteDatabase(this.dataSetID);
        if (!this.isConnecting()) {
            this.connect();
        }
        this.vDataSource = vector;
        this.vReferType = vector2;
        this.createCrossRefTable(REFER_TABLE);
        this.createRefInfosTable();
        this.init();
        CrossRefManager.I("End create CrossRefManager!###################");
    }

    public CrossRefManager(String string, String string2) throws CrossRefException {
        if (needexception) {
            // empty if block
        }
        CrossRefManager.I("Begine create CrossRefManager!###################");
        String string3 = "CrossRefManager initial : ( catalogName = " + string + " ; catalogPath = " + string2 + " )";
        this.setDataSetID(string, string2);
        if (!this.isConnecting()) {
            this.connect();
        }
        this.getOriReferInfos();
        this.init();
        CrossRefManager.I("End create CrossRefManager!###################");
    }

    void init() throws CrossRefException {
        if (needexception) {
            // empty if block
        }
        this.createCrossRefTable(CATALOG_TMP_TABLE);
        this.copyData(REFER_TABLE, CATALOG_TMP_TABLE, null);
        this.createCrossRefTableIdx(CATALOG_TMP_TABLE);
        this.createCrossRefTable(REPORT_TMP_TABLE);
        this.createCrossRefTableIdx(REPORT_TMP_TABLE);
    }

    public void createCrossRefTable(String string) throws CrossRefException {
        if (needexception) {
            // empty if block
        }
        String string2 = string;
        String string3 = "CREATE CACHED TABLE \"" + string2 + "\" ( " + "DataSource VARCHAR NOT NULL, " + "FromObjName VARCHAR NOT NULL, " + "FromObjType INT  NOT NULL, " + "ToObjName VARCHAR NOT NULL, " + "ToObjType INT NOT NULL, " + "ReferCount INT NOT NULL) ";
        String string4 = "createCrossRefTable: " + string2;
        try {
            Object object;
            if (!this.isConnecting()) {
                this.connect();
            }
            if (this.bDebug) {
                this.writeMessage("create table ..... \n");
                object = "SQL ==> " + string3 + " \n";
                this.writeMessage((String)object);
            }
            try {
                CrossRefManager.I("createCrossRefTable SQL:[DROP TABLE \"" + string2 + "\" IF EXISTS]");
                object = "DROP TABLE \"" + string2 + "\" IF EXISTS ";
                PreparedStatement preparedStatement = this.c.prepareStatement((String)object);
                preparedStatement.execute();
            }
            catch (SQLException sQLException) {
                boolean bl = false;
            }
            CrossRefManager.I("createCrossRefTable SQL[" + string3 + "]");
            object = this.c.prepareStatement(string3);
            object.execute();
        }
        catch (SQLException sQLException) {
            throw new CrossRefException("SQLException ON " + string4 + " : ErrorCode = " + sQLException.getErrorCode() + " \n ErrorMessage = " + sQLException.getMessage());
        }
        catch (Exception exception) {
            throw new CrossRefException("Exception ON " + string4 + " \n ErrorMessage = " + exception.getMessage());
        }
    }

    public void createCrossRefTableIdx(String string) throws CrossRefException {
        if (needexception) {
            // empty if block
        }
        String string2 = string;
        String string3 = "CREATE INDEX \"" + string2 + "_Index\" " + "ON \"" + string2 + "\" (DataSource, ToObjName, ToObjType)";
        String string4 = "CREATE UNIQUE INDEX \"" + string2 + "_UIndex\" " + "ON \"" + string2 + "\" (DataSource, FromObjName, FromObjType, ToObjName, ToObjType)";
        String string5 = "createCrossRefTableIdx: \"" + string2 + "_Index\" And \"" + string2 + "_UIndex\" ";
        try {
            if (!this.isConnecting()) {
                this.connect();
            }
            if (this.bDebug) {
                this.writeMessage("create index ..... \n");
                String string6 = "SQL ==> " + string3 + " \n";
                this.writeMessage(string6);
                String string7 = "SQL ==> " + string4 + " \n";
                this.writeMessage(string7);
            }
            CrossRefManager.I("createCrossRefTableIdx SQL[" + string3 + "]");
            this.ps = this.c.prepareStatement(string3);
            this.ps.execute();
            CrossRefManager.I("createCrossRefTableIdx SQL[" + string4 + "]");
            this.ps = this.c.prepareStatement(string4);
            this.ps.execute();
        }
        catch (SQLException sQLException) {
            throw new CrossRefException("SQLException ON " + string5 + " : ErrorCode = " + sQLException.getErrorCode() + " \n ErrorMessage = " + sQLException.getMessage());
        }
        catch (Exception exception) {
            throw new CrossRefException("Exception ON " + string5 + " \n ErrorMessage = " + exception.getMessage());
        }
    }

    public void dropTable(String string) throws CrossRefException {
        if (needexception) {
            // empty if block
        }
        String string2 = string;
        String string3 = "DROP TABLE \"" + string2 + "\" IF EXISTS ";
        String string4 = "dropTable: " + string2;
        try {
            if (!this.isConnecting()) {
                this.connect();
            }
            if (this.bDebug) {
                this.writeMessage("drop table ..... \n");
                String string5 = "SQL ==> " + string3 + " \n";
                this.writeMessage(string5);
            }
            CrossRefManager.I("dropTable SQL[" + string3 + "]");
            this.ps = this.c.prepareStatement(string3);
            this.ps.execute();
        }
        catch (SQLException sQLException) {
            throw new CrossRefException("SQLException ON " + string4 + " : ErrorCode = " + sQLException.getErrorCode() + " \n ErrorMessage = " + sQLException.getMessage());
        }
        catch (Exception exception) {
            throw new CrossRefException("Exception ON " + string4 + " \n ErrorMessage = " + exception.getMessage());
        }
    }

    public void copyData(String string, String string2, String string3) throws CrossRefException {
        if (needexception) {
            // empty if block
        }
        String string4 = "INSERT INTO \"" + string2 + "\" " + "SELECT * FROM \"" + string + "\" ";
        if (string3 != null && string3.trim().length() > 0) {
            string4 = string4 + string3;
        }
        String string5 = "copyData: from table : " + string + ", to table : " + string2 + ", where cause : " + string3 + " )";
        try {
            if (!this.isConnecting()) {
                this.connect();
            }
            if (this.bDebug) {
                this.writeMessage("----- Copy Data ..... \n");
                String string6 = "SQL ==> " + string4 + " \n";
                this.writeMessage(string6);
            }
            CrossRefManager.I("copyData SQL[" + string4 + "]");
            this.ps = this.c.prepareStatement(string4);
            this.ps.execute();
            this.c.commit();
        }
        catch (SQLException sQLException) {
            throw new CrossRefException("SQLException ON " + string5 + " : ErrorCode = " + sQLException.getErrorCode() + " \n ErrorMessage = " + sQLException.getMessage());
        }
        catch (Exception exception) {
            throw new CrossRefException("Exception ON " + string5 + " \n ErrorMessage = " + exception.getMessage());
        }
    }

    public void deleteData(String string, String string2) throws CrossRefException {
        if (needexception) {
            // empty if block
        }
        String string3 = string;
        String string4 = "DELETE FROM \"" + string3 + "\" ";
        if (string2 != null && string2.trim().length() > 0) {
            string4 = string4 + string2;
        }
        String string5 = "delTable: " + string3 + ", where " + string2;
        try {
            if (!this.isConnecting()) {
                this.connect();
            }
            if (this.bDebug) {
                this.writeMessage("----- Delete Table ..... \n");
                String string6 = "SQL ==> " + string4 + " \n";
                this.writeMessage(string6);
            }
            CrossRefManager.I("deleteData SQL[" + string4 + "]");
            this.ps = this.c.prepareStatement(string4);
            this.ps.execute();
            this.c.commit();
        }
        catch (SQLException sQLException) {
            throw new CrossRefException("SQLException ON " + string5 + " : ErrorCode = " + sQLException.getErrorCode() + " \n ErrorMessage = " + sQLException.getMessage());
        }
        catch (Exception exception) {
            throw new CrossRefException("Exception ON " + string5 + " \n ErrorMessage = " + exception.getMessage());
        }
    }

    public void updateData(String string, String string2, String string3) throws CrossRefException {
        if (needexception) {
            // empty if block
        }
        String string4 = string;
        String string5 = "UPDATE \"" + string4 + "\" ";
        if (string2 != null && string2.trim().length() > 0) {
            string5 = string5 + string2;
        }
        if (string3 != null && string3.trim().length() > 0) {
            string5 = string5 + string3;
        }
        String string6 = "updateData : " + string + "( setCause = " + string2 + ", whereCause = " + string3 + " )";
        try {
            if (!this.isConnecting()) {
                this.connect();
            }
            if (this.bDebug) {
                this.writeMessage("\n****************** Update Reference ..... \n");
                String string7 = "SQL ==> " + string5 + " \n";
                this.writeMessage(string7);
            }
            CrossRefManager.I("updateData SQL[" + string5 + "]");
            this.ps = this.c.prepareStatement(string5);
            this.ps.execute();
            this.c.commit();
        }
        catch (SQLException sQLException) {
            throw new CrossRefException("SQLException ON " + string6 + " : ErrorCode = " + sQLException.getErrorCode() + " \n ErrorMessage = " + sQLException.getMessage());
        }
        catch (Exception exception) {
            throw new CrossRefException("Exception ON " + string6 + " \n ErrorMessage = " + exception.getMessage());
        }
    }

    public void importReferences(Vector vector) throws CrossRefException {
        if (needexception) {
            // empty if block
        }
        String string = CATALOG_TMP_TABLE;
        String string2 = "INSERT INTO \"" + string + "\" " + "(DataSource, FromObjName, FromObjType, ToObjName, ToObjType, ReferCount) " + "VALUES (?, ?, ?, ?, ?, 1)";
        String string3 = "addRefResources ";
        PreparedStatement preparedStatement = null;
        try {
            if (!this.isConnecting()) {
                this.connect();
            }
            CrossRefManager.I("importReferences SQL[" + string2 + "]");
            preparedStatement = this.c.prepareStatement(string2);
            if (this.bDebug) {
                this.writeMessage("\n****************** Add Refer Resources..... \n");
            }
            for (int i = 0; i < vector.size(); ++i) {
                String string4;
                ReferRelation referRelation;
                block12: {
                    referRelation = (ReferRelation)vector.elementAt(i);
                    string4 = string3 + ": dataSource = " + referRelation.dataSource + ", " + referRelation.fromObj + "[" + this.refTypeDesc(referRelation.fromObjType) + "]" + " => " + referRelation.toObj + "[" + this.refTypeDesc(referRelation.toObjType) + "]";
                    try {
                        if (!this.checkValidity(referRelation.dataSource, new Integer(referRelation.fromObjType)) || !this.checkValidity(referRelation.dataSource, new Integer(referRelation.toObjType))) {
                            throw new CrossRefException("Exception ON " + string4 + " \n ErrorMessage = INVALID_OPERATION, This TYPE or DATASOURCE is not monitored.");
                        }
                    }
                    catch (CrossRefException crossRefException) {
                        continue;
                    }
                    CrossRefManager.I("importReferences SQL Parameter[1=" + referRelation.dataSource + "]");
                    preparedStatement.setString(1, referRelation.dataSource);
                    CrossRefManager.I("importReferences SQL Parameter[2=" + referRelation.fromObj + "]");
                    preparedStatement.setString(2, referRelation.fromObj);
                    CrossRefManager.I("importReferences SQL Parameter[3=" + referRelation.fromObjType + "]");
                    preparedStatement.setInt(3, referRelation.fromObjType);
                    CrossRefManager.I("importReferences SQL Parameter[4=" + referRelation.toObj + "]");
                    preparedStatement.setString(4, referRelation.toObj);
                    CrossRefManager.I("importReferences SQL Parameter[5=" + referRelation.toObjType + "]");
                    preparedStatement.setInt(5, referRelation.toObjType);
                    CrossRefManager.I(">>>>" + preparedStatement.toString());
                    CrossRefManager.I("******************************************************************");
                    try {
                        preparedStatement.executeUpdate();
                    }
                    catch (SQLException sQLException) {
                        if (sQLException.getErrorCode() != -9) break block12;
                        String string5 = "SET ReferCount = ReferCount + 1 ";
                        String string6 = "WHERE DataSource = '" + referRelation.dataSource + "' AND FromObjName = '" + referRelation.fromObj + "' AND FromObjType = " + referRelation.fromObjType + " AND ToObjName = '" + referRelation.toObj + "' AND ToObjType = " + referRelation.toObjType;
                        this.updateData(string, string5, string6);
                    }
                }
                if (!this.bDebug) continue;
                this.writeMessage(string4 + "\n");
                String string7 = " ==> parameter = ( " + referRelation.fromObj + ", " + referRelation.fromObjType + ", " + referRelation.toObj + ", " + referRelation.toObjType + ") datasource = " + referRelation.dataSource + " \n";
                this.writeMessage(string7);
            }
            this.c.commit();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            throw new CrossRefException("SQLException ON " + string3 + " : ErrorCode = " + sQLException.getErrorCode() + " \n ErrorMessage = " + sQLException.getMessage());
        }
        catch (Exception exception) {
            throw new CrossRefException("Exception ON " + string3 + " \n ErrorMessage = " + exception.getMessage());
        }
    }

    public void addReference(String string, int n, String string2, int n2, String string3) throws CrossRefException {
        if (needexception) {
            // empty if block
        }
        String string4 = "addReference: dataSource = " + string3 + " ( " + string + "[" + this.refTypeDesc(n) + "] => " + string2 + "[" + this.refTypeDesc(n2) + "] )";
        if (!this.checkValidity(string3, new Integer(n)) || !this.checkValidity(string3, new Integer(n2))) {
            throw new CrossRefException("Exception ON " + string4 + " \n ErrorMessage = INVALID_OPERATION, This TYPE or DATASOURCE is not monitored.");
        }
        String string5 = null;
        if (n == 11) {
            string5 = REPORT_TMP_TABLE;
            if (this.vCurrReport.indexOf(string) < 0) {
                String string6 = "WHERE DataSource = '" + string3 + "' AND FromObjName = '" + string + "' AND FromObjType = " + n;
                this.copyData(CATALOG_TMP_TABLE, REPORT_TMP_TABLE, string6);
                this.vCurrReport.addElement(string);
            }
        } else {
            string5 = CATALOG_TMP_TABLE;
        }
        int n3 = 1;
        String string7 = "INSERT INTO \"" + string5 + "\" " + "(DataSource, FromObjName, FromObjType, ToObjName, ToObjType, ReferCount) " + "VALUES ( '" + string3 + "', " + "'" + string + "', " + n + ", " + "'" + string2 + "', " + n2 + ", " + n3 + " )";
        try {
            block12: {
                if (!this.isConnecting()) {
                    this.connect();
                }
                if (this.bDebug) {
                    this.writeMessage("\n****************** Insert Reference ..... \n");
                    this.writeMessage(string4 + "\n");
                    String string8 = "SQL ==> " + string7 + " \n";
                    this.writeMessage(string8);
                }
                try {
                    CrossRefManager.I("addReference SQL[" + string7 + "]");
                    this.ps = this.c.prepareStatement(string7);
                    this.ps.execute();
                }
                catch (SQLException sQLException) {
                    if (sQLException.getErrorCode() != -9) break block12;
                    String string9 = "SET ReferCount = ReferCount + 1 ";
                    String string10 = "WHERE DataSource = '" + string3 + "' AND FromObjName = '" + string + "' AND FromObjType = " + n + " AND ToObjName = '" + string2 + "' AND ToObjType = " + n2;
                    this.updateData(string5, string9, string10);
                }
            }
            this.c.commit();
        }
        catch (SQLException sQLException) {
            throw new CrossRefException("SQLException ON " + string4 + " : ErrorCode = " + sQLException.getErrorCode() + " \n ErrorMessage = " + sQLException.getMessage());
        }
        catch (Exception exception) {
            throw new CrossRefException("Exception ON " + string4 + " \n ErrorMessage = " + exception.getMessage());
        }
    }

    public void delReference(String string, int n, String string2, int n2, String string3) throws CrossRefException {
        String string4;
        if (needexception) {
            // empty if block
        }
        String string5 = "delReference : dataSource = " + string3 + "( " + string + "[" + this.refTypeDesc(n) + "] => " + string2 + "[" + this.refTypeDesc(n2) + "] )";
        if (!this.checkValidity(string3, new Integer(n)) || !this.checkValidity(string3, new Integer(n2))) {
            throw new CrossRefException("Exception ON " + string5 + " \n ErrorMessage = INVALID_OPERATION, This TYPE or DATASOURCE is not monitored.");
        }
        String string6 = null;
        if (n == 11) {
            string6 = REPORT_TMP_TABLE;
            if (this.vCurrReport.indexOf(string) < 0) {
                string4 = "WHERE DataSource = '" + string3 + "' AND FromObjName = '" + string + "' AND FromObjType = " + 11;
                this.copyData(CATALOG_TMP_TABLE, REPORT_TMP_TABLE, string4);
                this.vCurrReport.addElement(string);
            }
        } else {
            string6 = CATALOG_TMP_TABLE;
        }
        string4 = "SELECT ReferCount FROM \"" + string6 + "\" " + "WHERE DataSource = '" + string3 + "' " + "AND FromObjName = '" + string + "' AND FromObjType = " + n + " " + "AND ToObjName = '" + string2 + "' AND ToObjType = " + n2;
        String string7 = "DELETE FROM \"" + string6 + "\" " + "WHERE DataSource = '" + string3 + "' " + "AND FromObjName = '" + string + "' AND FromObjType = " + n + " " + "AND ToObjName = '" + string2 + "' AND ToObjType = " + n2;
        String string8 = "UPDATE \"" + string6 + "\" " + "SET ReferCount = ReferCount - 1 " + "WHERE DataSource = '" + string3 + "' " + "AND FromObjName = '" + string + "' AND FromObjType = " + n + " " + "AND ToObjName = '" + string2 + "' AND ToObjType = " + n2;
        ResultSet resultSet = null;
        try {
            if (!this.isConnecting()) {
                this.connect();
            }
            if (this.bDebug) {
                this.writeMessage("\n****************** Delete Reference ..... \n");
                this.writeMessage(string5 + "\n");
                String string9 = "SQL ==> " + string7 + " \n";
                this.writeMessage(string9);
            }
            int n3 = 0;
            CrossRefManager.I("delReference SQL[" + string4 + "]");
            this.ps = this.c.prepareStatement(string4);
            resultSet = this.ps.executeQuery();
            if (resultSet.next()) {
                n3 = resultSet.getInt(1);
            }
            if (n3 > 1) {
                CrossRefManager.I("delReference SQL[" + string8 + "]");
                this.ps = this.c.prepareStatement(string8);
                this.ps.execute();
            } else if (n3 == 1) {
                CrossRefManager.I("delReference SQL[" + string7 + "]");
                this.ps = this.c.prepareStatement(string7);
                this.ps.execute();
            }
            this.c.commit();
        }
        catch (SQLException sQLException) {
            throw new CrossRefException("SQLException ON " + string5 + " : ErrorCode = " + sQLException.getErrorCode() + " \n ErrorMessage = " + sQLException.getMessage());
        }
        catch (Exception exception) {
            throw new CrossRefException("Exception ON " + string5 + " \n ErrorMessage = " + exception.getMessage());
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                    resultSet = null;
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    public void alterObjName(String string, int n, String string2, String string3) throws CrossRefException {
        if (needexception) {
            // empty if block
        }
        String string4 = "alterObjName : dataSource = " + string3 + " ( oldName = " + string + ", objType = " + n + ", newName = " + string2 + " )";
        if (!this.checkValidity(string3, new Integer(n))) {
            throw new CrossRefException("Exception ON " + string4 + " \n ErrorMessage = INVALID_OPERATION, This TYPE or DATASOURCE is not monitored.");
        }
        if (this.bDebug) {
            this.writeMessage("\n****************** Rename Object ......\n");
            this.writeMessage(string4 + "\n");
        }
        String string5 = "SET FromObjName = '" + string2 + "' ";
        String string6 = "WHERE FromObjName = '" + string + "' AND FromObjType = " + n;
        this.updateData(CATALOG_TMP_TABLE, string5, string6);
        this.updateData(REPORT_TMP_TABLE, string5, string6);
        String string7 = "SET ToObjName = '" + string2 + "' ";
        String string8 = "WHERE ToObjName = '" + string + "' AND ToObjType = " + n;
        this.updateData(CATALOG_TMP_TABLE, string7, string8);
        this.updateData(REPORT_TMP_TABLE, string7, string8);
    }

    public void delObject(String string, int n, String string2) throws CrossRefException {
        if (needexception) {
            // empty if block
        }
        String string3 = "delObject : dataSource = " + string2 + "( objName = " + string + ", objType = " + n + " )";
        if (!this.checkValidity(string2, new Integer(n))) {
            throw new CrossRefException("Exception ON " + string3 + " \n ErrorMessage = INVALID_OPERATION, This TYPE or DATASOURCE is not monitored.");
        }
        if (this.bDebug) {
            this.writeMessage("\n****************** Delete Object ......\n");
            this.writeMessage(string3 + "\n");
        }
        String string4 = "WHERE DataSource = '" + string2 + "' " + "AND ((FromObjName = '" + string + "' AND FromObjType = " + n + ") " + "OR (ToObjName = '" + string + "' AND ToObjType = " + n + "))";
        this.deleteData(CATALOG_TMP_TABLE, string4);
        this.deleteData(REPORT_TMP_TABLE, string4);
    }

    public void clearup() throws CrossRefException {
        if (needexception) {
            // empty if block
        }
        if (this.bDebug) {
            this.writeMessage("\n****************** DataBase ClearUp begin ... \n");
        }
        this.deleteData(CATALOG_TMP_TABLE, null);
        this.deleteData(REPORT_TMP_TABLE, null);
        this.vCurrReport.removeAllElements();
        if (this.bDebug) {
            this.writeMessage("\n****************** DataBase ClearUp end! \n");
        }
    }

    public void addType(int n) {
        if (needexception) {
            // empty if block
        }
        String string = "addType : ( objType = " + this.refTypeDesc(n) + " )";
        if (this.bDebug) {
            this.writeMessage("\n****************** Add Type ...... \n");
            this.writeMessage(string + "\n");
        }
        this.vReferType.addElement(new Integer(n));
    }

    public void delType(int n) throws CrossRefException {
        if (needexception) {
            // empty if block
        }
        String string = "delType : ( objType = " + this.refTypeDesc(n) + " )";
        if (this.bDebug) {
            this.writeMessage("\n****************** Delete Type ...... \n");
            this.writeMessage(string + "\n");
        }
        if (!this.checkValidity(null, new Integer(n))) {
            throw new CrossRefException("Exception ON " + string + " \n ErrorMessage = INVALID_OPERATION, This TYPE or DATASOURCE is not monitored.");
        }
        this.vReferType.removeElement(new Integer(n));
        String string2 = "WHERE FromObjType = " + n + " OR ToObjType = " + n;
        this.deleteData(CATALOG_TMP_TABLE, string2);
        this.deleteData(REPORT_TMP_TABLE, string2);
        if (n == 11) {
            this.vCurrReport.removeAllElements();
        }
    }

    public void addDataSource(String string) {
        if (needexception) {
            // empty if block
        }
        String string2 = "addDataSource : ( dataSource = " + string + " )";
        if (this.bDebug) {
            this.writeMessage("\n****************** Add DataSource ...... \n");
            this.writeMessage(string2 + "\n");
        }
        this.vDataSource.addElement(string);
    }

    public void delDataSource(String string) throws CrossRefException {
        if (needexception) {
            // empty if block
        }
        String string2 = "delDataSource : ( dataSource = " + string + " )";
        if (this.bDebug) {
            this.writeMessage("\n****************** Delete DataSource ......\n");
            this.writeMessage(string2 + "\n");
        }
        if (!this.checkValidity(string, null)) {
            throw new CrossRefException("Exception ON " + string2 + " \n ErrorMessage = INVALID_OPERATION, This TYPE or DATASOURCE is not monitored.");
        }
        this.vDataSource.removeElement(string);
        String string3 = "WHERE Datasource = '" + string + "' ";
        this.deleteData(CATALOG_TMP_TABLE, string3);
        this.deleteData(REPORT_TMP_TABLE, string3);
    }

    public Vector getReferredByObject(String string, int n, String string2) throws CrossRefException {
        if (needexception) {
            // empty if block
        }
        String string3 = "getReferredByObject : dataSource = " + string2 + "( toObj = " + string + ", toObjType = " + n + " )";
        if (!this.checkValidity(string2, new Integer(n))) {
            throw new CrossRefException("Exception ON " + string3 + " \n ErrorMessage = INVALID_OPERATION, This TYPE or DATASOURCE is not monitored.");
        }
        String string4 = REPORT_TMP_TABLE;
        String string5 = CATALOG_TMP_TABLE;
        String string6 = "";
        String string7 = "";
        for (int i = 0; i < this.vCurrReport.size(); ++i) {
            string6 = i == 0 ? "'" + this.vCurrReport.elementAt(i) + "' " : string6 + ", '" + this.vCurrReport.elementAt(i) + "' ";
        }
        string7 = this.vCurrReport.size() > 0 ? "SELECT FromObjName, FromObjType FROM \"" + string4 + "\" " + "WHERE DataSource = '" + string2 + "' AND ToObjName = '" + string + "' AND ToObjType = " + n + " UNION " + "SELECT FromObjName, FromObjType FROM \"" + string5 + "\" " + "WHERE DataSource = '" + string2 + "' AND ToObjName = '" + string + "' AND ToObjType = " + n + " AND ( FromObjName NOT IN (" + string6 + ") OR FromObjType <> " + 11 + " ) " : "SELECT FromObjName, FromObjType FROM \"" + string5 + "\" " + "WHERE DataSource = '" + string2 + "' AND ToObjName = '" + string + "' AND ToObjType = " + n;
        string7 = string7 + " ORDER BY FromObjType, FromObjName";
        ResultSet resultSet = null;
        try {
            ReferObject referObject;
            int n2;
            Object object;
            if (!this.isConnecting()) {
                this.connect();
            }
            CrossRefManager.I("getReferredByObject SQL[" + string7 + "]");
            this.ps = this.c.prepareStatement(string7);
            resultSet = this.ps.executeQuery();
            Vector<ReferObject> vector = new Vector<ReferObject>();
            while (resultSet.next()) {
                object = resultSet.getString(1);
                n2 = resultSet.getInt(2);
                referObject = new ReferObject((String)object, n2);
                vector.addElement(referObject);
            }
            if (this.bDebug) {
                this.writeMessage("\n****************** Get Referenced By Object .....\n");
                this.writeMessage(string3 + "\n");
                object = "SQL ==> " + string7 + " \n" + "======ReferObjectName=====ReferObjectType=====";
                this.writeMessage((String)object);
                for (n2 = 0; n2 < vector.size(); ++n2) {
                    referObject = (ReferObject)vector.elementAt(n2);
                    this.writeMessage("   " + referObject.objName + "   " + referObject.objType);
                }
            }
            object = vector;
            return object;
        }
        catch (SQLException sQLException) {
            throw new CrossRefException("SQLException ON " + string3 + " : ErrorCode = " + sQLException.getErrorCode() + " \n ErrorMessage = " + sQLException.getMessage());
        }
        catch (Exception exception) {
            throw new CrossRefException("Exception ON " + string3 + " \n ErrorMessage = " + exception.getMessage());
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    public Vector getReferObjects(String string, int n, String string2) throws CrossRefException {
        if (needexception) {
            // empty if block
        }
        String string3 = "getReferObjects : dataSource = " + string2 + "( fromObj = " + string + ", fromObjType = " + n + " )";
        if (!this.checkValidity(string2, new Integer(n))) {
            throw new CrossRefException("Exception ON " + string3 + " \n ErrorMessage = INVALID_OPERATION, This TYPE or DATASOURCE is not monitored.");
        }
        String string4 = REPORT_TMP_TABLE;
        String string5 = CATALOG_TMP_TABLE;
        String string6 = "";
        String string7 = "";
        for (int i = 0; i < this.vCurrReport.size(); ++i) {
            string6 = i == 0 ? "'" + this.vCurrReport.elementAt(i) + "' " : string6 + ", '" + this.vCurrReport.elementAt(i) + "' ";
        }
        string7 = this.vCurrReport.size() > 0 ? "SELECT ToObjName, ToObjType FROM \"" + string4 + "\" " + "WHERE DataSource = '" + string2 + "' AND FromObjName = '" + string + "' AND FromObjType = " + n + " UNION " + "SELECT ToObjName, ToObjType FROM \"" + string5 + "\" " + "WHERE DataSource = '" + string2 + "' AND FromObjName = '" + string + "' AND FromObjType = " + n + " AND ( FromObjName NOT IN (" + string6 + ") OR FromObjType <> " + 11 + " ) " : "SELECT ToObjName, ToObjType FROM \"" + string5 + "\" " + "WHERE DataSource = '" + string2 + "' AND FromObjName = '" + string + "' AND FromObjType = " + n;
        string7 = string7 + " ORDER BY ToObjType, ToObjName";
        ResultSet resultSet = null;
        try {
            ReferObject referObject;
            int n2;
            Object object;
            if (!this.isConnecting()) {
                this.connect();
            }
            CrossRefManager.I("getReferObjects SQL[" + string7 + "]");
            this.ps = this.c.prepareStatement(string7);
            resultSet = this.ps.executeQuery();
            Vector<ReferObject> vector = new Vector<ReferObject>();
            while (resultSet.next()) {
                object = resultSet.getString(1);
                n2 = resultSet.getInt(2);
                referObject = new ReferObject((String)object, n2);
                vector.addElement(referObject);
            }
            if (this.bDebug) {
                this.writeMessage("\n****************** Get GetReferObjects .....\n");
                this.writeMessage(string3 + "\n");
                object = "SQL ==> " + string7 + " \n" + "=======ReferObjectName=====ReferObjectType=====";
                this.writeMessage((String)object);
                for (n2 = 0; n2 < vector.size(); ++n2) {
                    referObject = (ReferObject)vector.elementAt(n2);
                    this.writeMessage("   " + referObject.objName + "   " + referObject.objType);
                }
            }
            object = vector;
            return object;
        }
        catch (SQLException sQLException) {
            throw new CrossRefException("SQLException ON " + string3 + " : ErrorCode = " + sQLException.getErrorCode() + " \n ErrorMessage = " + sQLException.getMessage());
        }
        catch (Exception exception) {
            throw new CrossRefException("Exception ON " + string3 + " \n ErrorMessage = " + exception.getMessage());
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    public void exportReferences(String string) throws CrossRefException {
        if (needexception) {
            // empty if block
        }
        String string2 = "exportReferences : " + string;
        ResultSet resultSet = null;
        FileOutputStream fileOutputStream = null;
        FilterOutputStream filterOutputStream = null;
        String string3 = REPORT_TMP_TABLE;
        String string4 = CATALOG_TMP_TABLE;
        String string5 = "";
        String string6 = "";
        for (int i = 0; i < this.vCurrReport.size(); ++i) {
            string5 = i == 0 ? "'" + this.vCurrReport.elementAt(i) + "' " : string5 + ", '" + this.vCurrReport.elementAt(i) + "' ";
        }
        string6 = this.vCurrReport.size() > 0 ? "SELECT DataSource, FromObjName, FromObjType, ToObjName, ToObjType FROM \"" + string3 + "\" " + "UNION " + "SELECT DataSource, FromObjName, FromObjType, ToObjName, ToObjType FROM \"" + string4 + "\" " + "WHERE FromObjName NOT IN (" + string5 + ") OR FromObjType <> " + 11 + " ORDER BY DataSource, FromObjName " : "SELECT DataSource, FromObjName, FromObjType, ToObjName, ToObjType FROM \"" + string4 + "\" ORDER BY DataSource, FromObjName, FromObjType ";
        try {
            String string7;
            if (!this.isConnecting()) {
                this.connect();
            }
            Vector<ReferRelation> vector = new Vector<ReferRelation>();
            CrossRefManager.I("exportReferences SQL[" + string6 + "]");
            this.ps = this.c.prepareStatement(string6);
            resultSet = this.ps.executeQuery();
            if (this.bDebug) {
                this.writeMessage("\n****************** Export References to \"" + string + "\" \n");
                string7 = "SQL ==> " + string6 + " \n";
                this.writeMessage(string7);
            }
            while (resultSet.next()) {
                string7 = resultSet.getString(1);
                String string8 = resultSet.getString(2);
                int n = resultSet.getInt(3);
                String string9 = resultSet.getString(4);
                int n2 = resultSet.getInt(5);
                ReferRelation referRelation = new ReferRelation(string7, string8, n, string9, n2);
                vector.addElement(referRelation);
                if (!this.bDebug) continue;
                String string10 = "getData ==> ( " + string7 + ", " + string8 + "[" + this.refTypeDesc(n) + "] -> " + string9 + "[ " + this.refTypeDesc(n2) + "] ) \n";
                this.writeMessage(string10);
            }
            if (string.length() > 0) {
                fileOutputStream = new FileOutputStream(string);
                filterOutputStream = new BufferedOutputStream(fileOutputStream);
                string7 = "DataSource  FromObject[Type] => ToObject[Type] \n";
                filterOutputStream.write(string7.getBytes());
                for (int i = 0; i < vector.size(); ++i) {
                    ReferRelation referRelation = (ReferRelation)vector.elementAt(i);
                    filterOutputStream.write(referRelation.toString().getBytes());
                }
                filterOutputStream.close();
                filterOutputStream = null;
                fileOutputStream.close();
                fileOutputStream = null;
            }
        }
        catch (IOException iOException) {
            throw new CrossRefException("IOException ON " + string2 + " \n ErrorMessage = " + iOException.getMessage());
        }
        catch (SQLException sQLException) {
            throw new CrossRefException("SQLException ON " + string2 + " : ErrorCode = " + sQLException.getErrorCode() + " \n ErrorMessage = " + sQLException.getMessage());
        }
        catch (Exception exception) {
            throw new CrossRefException("Exception ON " + string2 + " \n ErrorMessage = " + exception.getMessage());
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                if (filterOutputStream != null) {
                    filterOutputStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    void createRefInfosTable() throws CrossRefException {
        if (needexception) {
            // empty if block
        }
        String string = TYPE_TABLE;
        String string2 = DATASOURCE_TABLE;
        String string3 = "CREATE CACHED TABLE \"" + string + "\" ( " + "TypeID INT NOT NULL, " + "TypeName VARCHAR NOT NULL) ";
        String string4 = "CREATE CACHED TABLE \"" + string2 + "\" ( " + "DataSource VARCHAR NOT NULL) ";
        String string5 = "createRefInfosTable: " + string + ", " + string2;
        try {
            String string6;
            if (!this.isConnecting()) {
                this.connect();
            }
            if (this.bDebug) {
                this.writeMessage("create ref type table ..... \n");
                string6 = "SQL ==> " + string3 + " \n" + "SQL ==> " + string4 + " \n";
                this.writeMessage(string6);
            }
            try {
                CrossRefManager.I("createRefInfosTable SQL[DROP TABLE \"" + string + "\" IF EXISTS " + "]");
                string6 = "DROP TABLE \"" + string + "\" IF EXISTS ";
                this.ps = this.c.prepareStatement(string6);
                this.ps.execute();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                CrossRefManager.I("createRefInfosTable SQL[DROP TABLE \"" + string2 + "\" IF EXISTS " + "]");
                string6 = "DROP TABLE \"" + string2 + "\" IF EXISTS ";
                this.ps = this.c.prepareStatement(string6);
                this.ps.execute();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            CrossRefManager.I("createRefInfosTable SQL[" + string3 + "]");
            this.ps = this.c.prepareStatement(string3);
            this.ps.execute();
            CrossRefManager.I("createRefInfosTable SQL[" + string4 + "]");
            this.ps = this.c.prepareStatement(string4);
            this.ps.execute();
        }
        catch (SQLException sQLException) {
            throw new CrossRefException("SQLException ON " + string5 + " : ErrorCode = " + sQLException.getErrorCode() + " \n ErrorMessage = " + sQLException.getMessage());
        }
        catch (Exception exception) {
            throw new CrossRefException("Exception ON " + string5 + " \n ErrorMessage = " + exception.getMessage());
        }
    }

    void logRefInfos() throws CrossRefException {
        if (needexception) {
            // empty if block
        }
        String string = TYPE_TABLE;
        String string2 = DATASOURCE_TABLE;
        String string3 = "INSERT INTO \"" + string + "\" " + "(TypeID, TypeName) " + "VALUES (?,?)";
        String string4 = "INSERT INTO \"" + string2 + "\" " + "(DataSource) " + "VALUES (?)";
        String string5 = "logRefInfos: ( " + string + ", " + string2 + " )";
        Statement statement = null;
        try {
            String string6;
            int n;
            if (!this.isConnecting()) {
                this.connect();
            }
            this.deleteData(string, null);
            CrossRefManager.I("logRefInfos SQL[" + string3 + "]");
            statement = this.c.prepareStatement(string3);
            if (this.bDebug) {
                this.writeMessage("----- Insert Reference Type Information..... \n");
            }
            for (n = 0; n < this.vReferType.size(); ++n) {
                int n2 = (Integer)this.vReferType.elementAt(n);
                CrossRefManager.I("logRefInfos SQL parameter[1=" + n2 + "]");
                statement.setInt(1, n2);
                CrossRefManager.I("logRefInfos SQL parameter[1=" + this.refTypeDesc(n2) + "]");
                statement.setString(2, this.refTypeDesc(n2));
                statement.execute();
                if (!this.bDebug) continue;
                string6 = " ==> parameter = ( " + n2 + ", " + this.refTypeDesc(n2) + ") \n";
                this.writeMessage(string6);
            }
            this.c.commit();
            statement = null;
            this.deleteData(string2, null);
            CrossRefManager.I("logRefInfos SQL[" + string4 + "]");
            statement = this.c.prepareStatement(string4);
            if (this.bDebug) {
                this.writeMessage("----- Insert Reference DataSource Information..... \n");
            }
            for (n = 0; n < this.vDataSource.size(); ++n) {
                String string7 = (String)this.vDataSource.elementAt(n);
                CrossRefManager.I("logRefInfos SQL parameter[1=" + string7 + "]");
                statement.setString(1, string7);
                statement.execute();
                if (!this.bDebug) continue;
                string6 = " ==> parameter = ( " + string7 + ") \n";
                this.writeMessage(string6);
            }
            this.c.commit();
        }
        catch (SQLException sQLException) {
            throw new CrossRefException("SQLException ON " + string5 + " : ErrorCode = " + sQLException.getErrorCode() + " \n ErrorMessage = " + sQLException.getMessage());
        }
        catch (Exception exception) {
            throw new CrossRefException("Exception ON " + string5 + " \n ErrorMessage = " + exception.getMessage());
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                    statement = null;
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    void setDataSetID(String string, String string2) {
        if (needexception) {
            // empty if block
        }
        this.dataSetID = string2 + string + REF_SUFFIX;
    }

    public String getDataSetID() {
        if (needexception) {
            // empty if block
        }
        return this.dataSetID;
    }

    public Vector getDataSources() {
        if (needexception) {
            // empty if block
        }
        return this.vDataSource;
    }

    public Vector getReferTypes() {
        if (needexception) {
            // empty if block
        }
        return this.vReferType;
    }

    void getOriReferInfos() throws CrossRefException {
        if (needexception) {
            // empty if block
        }
        String string = TYPE_TABLE;
        String string2 = DATASOURCE_TABLE;
        String string3 = "SELECT TypeID FROM \"" + string + "\" ";
        String string4 = "SELECT DataSource FROM \"" + string2 + "\" ";
        String string5 = "getOriReferInfos";
        ResultSet resultSet = null;
        Vector<Integer> vector = new Vector<Integer>();
        Vector<String> vector2 = new Vector<String>();
        try {
            if (!this.isConnecting()) {
                this.connect();
            }
            CrossRefManager.I("getOriReferInfos SQL[" + string3 + "]");
            this.ps = this.c.prepareStatement(string3);
            resultSet = this.ps.executeQuery();
            while (resultSet.next()) {
                int n = resultSet.getInt(1);
                vector.addElement(new Integer(n));
            }
            if (this.bDebug) {
                this.writeMessage("get reference type ..... \n");
                String string6 = "SQL ==> " + string3 + " \n";
                this.writeMessage(string6);
                this.writeMessage("   types = " + vector + " \n");
            }
            resultSet = null;
            CrossRefManager.I("getOriReferInfos SQL[" + string4 + "]");
            this.ps = this.c.prepareStatement(string4);
            resultSet = this.ps.executeQuery();
            while (resultSet.next()) {
                String string7 = resultSet.getString(1);
                vector2.addElement(string7);
            }
            if (this.bDebug) {
                this.writeMessage("get reference datasource ..... \n");
                String string8 = "SQL ==> " + string4 + " \n";
                this.writeMessage(string8);
                this.writeMessage("   datasources = " + vector2 + " \n");
            }
            this.vReferType = vector;
            this.vDataSource = vector2;
        }
        catch (SQLException sQLException) {
            throw new CrossRefException("SQLException ON " + string5 + " : ErrorCode = " + sQLException.getErrorCode() + " \n ErrorMessage = " + sQLException.getMessage());
        }
        catch (Exception exception) {
            throw new CrossRefException("Exception ON " + string5 + " \n ErrorMessage = " + exception.getMessage());
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    boolean isConnecting() {
        return this.c != null;
    }

    void connect() throws CrossRefException {
        if (needexception) {
            // empty if block
        }
        String string = "org.hsqldb.jdbcDriver";
        String string2 = "jdbc:hsqldb:" + this.dataSetID;
        String string3 = "sa";
        String string4 = null;
        String string5 = "Connect : ( url = " + string2 + " ; user = " + string3 + " ; password = " + string4 + ")";
        try {
            Class.forName(string);
            this.c = DriverManager.getConnection(string2, string3, string4);
            this.c.setAutoCommit(false);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new CrossRefException("ClassNotFoundException ON " + string5 + " \n ErrorMessage = " + classNotFoundException.getMessage());
        }
        catch (SQLException sQLException) {
            throw new CrossRefException("SQLException ON " + string5 + " : ErrorCode = " + sQLException.getErrorCode() + " \n ErrorMessage = " + sQLException.getMessage());
        }
        catch (Exception exception) {
            throw new CrossRefException("Exception ON " + string5 + " \n ErrorMessage = " + exception.getMessage());
        }
    }

    void disconnect() throws SQLException {
        if (needexception) {
            // empty if block
        }
        if (this.bDebug) {
            this.writeMessage("----- disconnect ..... \n");
        }
        Statement statement = this.c.createStatement();
        statement.execute("SHUTDOWN COMPACT");
        statement.close();
        if (this.c != null) {
            this.c.close();
            this.c = null;
        }
        if (this.ps != null) {
            this.ps.close();
            this.ps = null;
        }
    }

    public void saveCatalog() throws CrossRefException {
        if (needexception) {
            // empty if block
        }
        CrossRefManager.I("Begine save catalog!###################");
        if (this.bDebug) {
            this.writeMessage("\n****************** Save Catalog ..... \n");
        }
        this.deleteData(REFER_TABLE, null);
        this.copyData(CATALOG_TMP_TABLE, REFER_TABLE, null);
        this.logRefInfos();
        CrossRefManager.I("End save catalog!###################");
    }

    public void saveReport(String string) throws CrossRefException {
        if (needexception) {
            // empty if block
        }
        CrossRefManager.I("Begine save report!###################");
        if (this.bDebug) {
            this.writeMessage("\n****************** Save Report (" + string + ")..... \n");
        }
        if (this.vCurrReport.indexOf(string) != -1) {
            String string2 = "WHERE FromObjName = '" + string + "' AND FromObjType = " + 11;
            this.deleteData(CATALOG_TMP_TABLE, string2);
            this.copyData(REPORT_TMP_TABLE, CATALOG_TMP_TABLE, string2);
        }
        this.saveCatalog();
        CrossRefManager.I("End save report!###################");
    }

    public void closeReport(String string, boolean bl) throws CrossRefException {
        if (needexception) {
            // empty if block
        }
        if (this.bDebug) {
            this.writeMessage("\n****************** Close Report (" + string + ")..... \n");
        }
        if (this.vCurrReport.indexOf(string) != -1) {
            if (bl) {
                this.saveReport(string);
            }
            String string2 = "WHERE FromObjName = '" + string + "' ";
            this.deleteData(REPORT_TMP_TABLE, string2);
            this.vCurrReport.removeElement(string);
        }
    }

    public void exit() throws CrossRefException {
        if (needexception) {
            // empty if block
        }
        if (this.bDebug) {
            this.writeMessage("\n****************** Exit..... \n");
        }
        this.dropTable(CATALOG_TMP_TABLE);
        this.dropTable(REPORT_TMP_TABLE);
        this.vCurrReport.removeAllElements();
        try {
            this.disconnect();
        }
        catch (SQLException sQLException) {
            CrossRefManager.I("SQLException : (shut down DB failed) " + sQLException.getMessage());
        }
        if (this.bDebug) {
            try {
                this.fm.close();
                this.bDebug = false;
            }
            catch (IOException iOException) {
                CrossRefManager.I("IOException : (close debug file failed) " + iOException.getMessage());
            }
        }
    }

    boolean checkValidity(String string, Integer n) {
        if (needexception) {
            // empty if block
        }
        boolean bl = false;
        boolean bl2 = false;
        if (string == null || this.vDataSource.indexOf(string) >= 0) {
            bl = true;
        }
        if (n == null || this.vReferType.indexOf(n) >= 0) {
            bl2 = true;
        }
        return bl && bl2;
    }

    public static void delete(String string) {
        if (needexception) {
            // empty if block
        }
        try {
            new File(string).delete();
            CrossRefManager.I("Delete File: " + string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void deleteDatabase(String string) {
        if (needexception) {
            // empty if block
        }
        CrossRefManager.delete(string + ".backup");
        CrossRefManager.delete(string + ".properties");
        CrossRefManager.delete(string + ".script");
        CrossRefManager.delete(string + ".data");
    }

    public void setDebug() {
        if (!this.bDebug) {
            try {
                this.fm = new FileOutputStream(this.dataSetID + ".log");
                this.bDebug = true;
                if (this.bDebug) {
                    this.writeMessage("****************** Initial : ");
                    String string = " ( dataSetID = \"" + this.dataSetID + "\" ; dataSourceVec = " + this.vDataSource + " ; referTypeVec = " + this.vReferType + ") \n";
                    this.writeMessage(string);
                }
            }
            catch (IOException iOException) {
                CrossRefManager.I("IOException : (create debug file failed) " + iOException.getMessage());
            }
        }
    }

    void writeMessage(String string) {
        try {
            if (string.length() > 0 && this.fm != null) {
                this.fm.write(string.getBytes());
            }
        }
        catch (IOException iOException) {
            CrossRefManager.I("IOException : (write debug info error)" + iOException.getMessage());
        }
    }

    public void updataDataSource(String string, String string2) throws CrossRefException {
        String string3;
        if (needexception) {
            // empty if block
        }
        String string4 = CATALOG_TMP_TABLE;
        String string5 = "SET DataSource = '" + string2 + "'";
        String string6 = " WHERE DataSource = '" + string + "'";
        String string7 = "UPDATE \"" + string4 + "\" " + string5 + string6;
        String string8 = "SET FromObjName = '" + string2 + "' , ToObjName = '" + string2 + "'";
        String string9 = " WHERE DataSource = '" + string2 + "' and FromObjType = " + 20 + " and ToObjType = " + 20;
        String string10 = "UPDATE \"" + string4 + "\" " + string8 + string9;
        String string11 = "updateData : " + string4 + "( setCause = " + string5 + ", whereCause = " + string6 + " )";
        String string12 = "updateData : " + string4 + "( setCause = " + string8 + ", whereCause = " + string9 + " )";
        try {
            if (!this.isConnecting()) {
                this.connect();
            }
            if (this.bDebug) {
                this.writeMessage("\n****************** Update Reference ..... \n");
                string3 = "SQL ==> " + string7 + " \n";
                this.writeMessage(string3);
            }
            CrossRefManager.I("update DataSource Name SQL[" + string7 + "]");
            this.ps = this.c.prepareStatement(string7);
            this.ps.execute();
            this.c.commit();
        }
        catch (SQLException sQLException) {
            throw new CrossRefException("SQLException ON " + string11 + " : ErrorCode = " + sQLException.getErrorCode() + " \n ErrorMessage = " + sQLException.getMessage());
        }
        try {
            if (this.bDebug) {
                this.writeMessage("\n****************** Update Reference ..... \n");
                string3 = "SQL ==> " + string10 + " \n";
                this.writeMessage(string3);
            }
            CrossRefManager.I("update DataSource Name SQL[" + string10 + "]");
            this.ps = this.c.prepareStatement(string10);
            this.ps.execute();
            this.c.commit();
        }
        catch (SQLException sQLException) {
            throw new CrossRefException("SQLException ON " + string12 + " : ErrorCode = " + sQLException.getErrorCode() + " \n ErrorMessage = " + sQLException.getMessage());
        }
        this.delDataSource(string);
        this.addDataSource(string2);
    }

    public Vector getReportByDataSourceName(String string, int n, String string2) throws CrossRefException {
        if (needexception) {
            // empty if block
        }
        String string3 = "getReferredByObject : dataSource = " + string2 + "and toObjType = " + n;
        if (!this.checkValidity(string2, new Integer(n))) {
            throw new CrossRefException("Exception ON " + string3 + " \n ErrorMessage = INVALID_OPERATION, This TYPE or DATASOURCE is not monitored.");
        }
        String string4 = REPORT_TMP_TABLE;
        String string5 = CATALOG_TMP_TABLE;
        String string6 = "";
        String string7 = "";
        for (int i = 0; i < this.vCurrReport.size(); ++i) {
            string6 = i == 0 ? "'" + this.vCurrReport.elementAt(i) + "' " : string6 + ", '" + this.vCurrReport.elementAt(i) + "' ";
        }
        string7 = this.vCurrReport.size() > 0 ? "SELECT FromObjName, FromObjType FROM \"" + string4 + "\" " + "WHERE DataSource = '" + string2 + "' AND ToObjName = '" + string + "' AND ToObjType = " + n + " UNION " + "SELECT FromObjName, FromObjType FROM \"" + string5 + "\" " + "WHERE DataSource = '" + string2 + "' AND ToObjName = '" + string + "' AND ToObjType = " + n + " AND ( FromObjName NOT IN (" + string6 + ") OR FromObjType <> " + 11 + " ) " : "SELECT FromObjName, FromObjType FROM \"" + string5 + "\" " + "WHERE DataSource = '" + string2 + "' AND FromObjType = " + 11;
        string7 = string7 + "ORDER BY FromObjType, FromObjName";
        ResultSet resultSet = null;
        try {
            ReferObject referObject;
            int n2;
            Object object;
            if (!this.isConnecting()) {
                this.connect();
            }
            CrossRefManager.I("getReferredByObject SQL[" + string7 + "]");
            this.ps = this.c.prepareStatement(string7);
            resultSet = this.ps.executeQuery();
            Vector<ReferObject> vector = new Vector<ReferObject>();
            while (resultSet.next()) {
                object = resultSet.getString(1);
                n2 = resultSet.getInt(2);
                referObject = new ReferObject((String)object, n2);
                vector.addElement(referObject);
            }
            if (this.bDebug) {
                this.writeMessage("\n****************** Get Referenced By Object .....\n");
                this.writeMessage(string3 + "\n");
                object = "SQL ==> " + string7 + " \n" + "======ReferObjectName=====ReferObjectType=====";
                this.writeMessage((String)object);
                for (n2 = 0; n2 < vector.size(); ++n2) {
                    referObject = (ReferObject)vector.elementAt(n2);
                    this.writeMessage("   " + referObject.objName + "   " + referObject.objType);
                }
            }
            object = vector;
            return object;
        }
        catch (SQLException sQLException) {
            throw new CrossRefException("SQLException ON " + string3 + " : ErrorCode = " + sQLException.getErrorCode() + " \n ErrorMessage = " + sQLException.getMessage());
        }
        catch (Exception exception) {
            throw new CrossRefException("Exception ON " + string3 + " \n ErrorMessage = " + exception.getMessage());
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    public void delReferResource(String string, String string2, int n) throws CrossRefException {
        String string3 = null;
        String string4 = null;
        string4 = n == 11 ? REPORT_TMP_TABLE : CATALOG_TMP_TABLE;
        String string5 = null;
        if (string == null) {
            string3 = "delReference : " + string2 + "[" + this.refTypeDesc(n) + "] ";
            string5 = "DELETE FROM \"" + string4 + "\" " + "WHERE FromObjName = '" + string2 + "' AND FromObjType = " + n;
        } else {
            string3 = "delReference : dataSource = " + string + "( " + string2 + "[" + this.refTypeDesc(n) + "] )";
            string5 = "DELETE FROM \"" + string4 + "\" " + "WHERE DataSource = '" + string + "' " + "AND FromObjName = '" + string2 + "' AND FromObjType = " + n;
        }
        try {
            if (!this.isConnecting()) {
                this.connect();
            }
            CrossRefManager.I("delReference SQL[" + string5 + "]");
            this.ps = this.c.prepareStatement(string5);
            this.ps.execute();
            this.c.commit();
        }
        catch (Exception exception) {
            throw new CrossRefException("Exception ON " + string3 + " \n ErrorMessage = " + exception.getMessage());
        }
    }
}

