/*
 * Decompiled with CFR 0.152.
 */
package jet.util;

import java.math.BigDecimal;
import java.util.StringTokenizer;
import java.util.Vector;
import jet.connect.DbArray;
import jet.connect.DbBigInt;
import jet.connect.DbBit;
import jet.connect.DbChar;
import jet.connect.DbColDesc;
import jet.connect.DbDate;
import jet.connect.DbDouble;
import jet.connect.DbNumber;
import jet.connect.DbTime;
import jet.connect.DbTimestamp;
import jet.connect.DbValue;
import jet.connect.Record;
import jet.formula.fArray;
import jet.formula.fCurrency;
import jet.formula.fText;
import jet.parameter.runtime.valuelist.item.EvalueatedValueListItem;
import jet.parameter.util.ValueListItemUtil;

public class DbValueComparer {
    public static final String[] opers = new String[]{"Equal,NotEquals,Less,Great,LessEqual,GreatEqual,IN, NOT IN"};
    public static final int EQUALS = 0;
    public static final int NOTEQUALS = 1;
    public static final int LESS = 2;
    public static final int GREAT = 3;
    public static final int LESSEQUALS = 4;
    public static final int GREATEQUALS = 5;
    public static final int IN = 6;
    public static final int NOTIN = 7;
    public static final String[] strOper = new String[]{"=", "<>", "<", ">", "<=", ">=", "IN", "NOT IN"};
    public String columnName;
    public DbValue value;
    public int operator;

    public static int getOperatorForName(String string) {
        if (string.equals("=")) {
            return 0;
        }
        if (string.equals("<>")) {
            return 1;
        }
        if (string.equals("<")) {
            return 3;
        }
        if (string.equals(">")) {
            return 2;
        }
        if (string.equals("<=")) {
            return 5;
        }
        if (string.equals(">=")) {
            return 4;
        }
        if (string.equalsIgnoreCase("IN")) {
            return 6;
        }
        if (string.equalsIgnoreCase("NOT IN")) {
            return 7;
        }
        throw new RuntimeException();
    }

    public static int getOperatorForNameLeft(String string) {
        if (string.equals("=")) {
            return 0;
        }
        if (string.equals("<>")) {
            return 1;
        }
        if (string.equals(">")) {
            return 3;
        }
        if (string.equals("<")) {
            return 2;
        }
        if (string.equals(">=")) {
            return 5;
        }
        if (string.equals("<=")) {
            return 4;
        }
        if (string.equalsIgnoreCase("IN")) {
            return 6;
        }
        if (string.equalsIgnoreCase("NOT IN")) {
            return 7;
        }
        throw new RuntimeException();
    }

    private Vector<DbValue> D(DbArray dbArray) {
        DbColDesc dbColDesc = (DbColDesc)dbArray.getColDesc().clone();
        int n = dbColDesc.getSqlType();
        boolean bl = dbColDesc.isCurrency();
        Vector<DbValue> vector = new Vector<DbValue>();
        if (dbArray.isNull()) {
            return vector;
        }
        Object object = dbArray.getValue();
        if (object == null) {
            return vector;
        }
        switch (n) {
            case -7: {
                boolean[] blArray = (boolean[])object;
                for (int i = 0; i < blArray.length; ++i) {
                    DbBit dbBit = new DbBit(dbColDesc);
                    dbBit.value = blArray[i];
                    dbBit.bNull = false;
                    vector.add(dbBit);
                }
                break;
            }
            case -6: {
                byte[] byArray = (byte[])object;
                for (int i = 0; i < byArray.length; ++i) {
                    DbNumber dbNumber;
                    if (bl) {
                        dbNumber = new fCurrency(dbColDesc);
                        dbNumber.value = new BigDecimal(byArray[i]);
                        dbNumber.bNull = false;
                        vector.add(dbNumber);
                        continue;
                    }
                    dbNumber = new DbBigInt(dbColDesc);
                    ((DbBigInt)dbNumber).value = byArray[i];
                    ((DbBigInt)dbNumber).bNull = false;
                    vector.add(dbNumber);
                }
                break;
            }
            case 5: {
                short[] sArray = (short[])object;
                for (int i = 0; i < sArray.length; ++i) {
                    DbNumber dbNumber;
                    if (bl) {
                        dbNumber = new fCurrency(dbColDesc);
                        dbNumber.value = new BigDecimal(sArray[i]);
                        dbNumber.bNull = false;
                        vector.add(dbNumber);
                        continue;
                    }
                    dbNumber = new DbBigInt(dbColDesc);
                    ((DbBigInt)dbNumber).value = sArray[i];
                    ((DbBigInt)dbNumber).bNull = false;
                    vector.add(dbNumber);
                }
                break;
            }
            case 4: {
                int[] nArray = (int[])object;
                for (int i = 0; i < nArray.length; ++i) {
                    DbNumber dbNumber;
                    if (bl) {
                        dbNumber = new fCurrency(dbColDesc);
                        dbNumber.value = new BigDecimal(nArray[i]);
                        dbNumber.bNull = false;
                        vector.add(dbNumber);
                        continue;
                    }
                    dbNumber = new DbBigInt(dbColDesc);
                    ((DbBigInt)dbNumber).value = nArray[i];
                    ((DbBigInt)dbNumber).bNull = false;
                    vector.add(dbNumber);
                }
                break;
            }
            case -5: {
                long[] lArray = (long[])object;
                for (int i = 0; i < lArray.length; ++i) {
                    DbNumber dbNumber;
                    if (bl) {
                        dbNumber = new fCurrency(dbColDesc);
                        dbNumber.value = new BigDecimal(lArray[i]);
                        dbNumber.bNull = false;
                        vector.add(dbNumber);
                        continue;
                    }
                    dbNumber = new DbBigInt(dbColDesc);
                    ((DbBigInt)dbNumber).value = lArray[i];
                    ((DbBigInt)dbNumber).bNull = false;
                    vector.add(dbNumber);
                }
                break;
            }
            case 91: {
                long[] lArray = (long[])object;
                for (int i = 0; i < lArray.length; ++i) {
                    DbDate dbDate = new DbDate(dbColDesc);
                    dbDate.value = lArray[i];
                    dbDate.bNull = false;
                    vector.add(dbDate);
                }
                break;
            }
            case 92: {
                long[] lArray = (long[])object;
                for (int i = 0; i < lArray.length; ++i) {
                    DbTime dbTime = new DbTime(dbColDesc);
                    dbTime.value = lArray[i];
                    dbTime.bNull = false;
                    vector.add(dbTime);
                }
                break;
            }
            case 93: {
                long[] lArray = (long[])object;
                int[] nArray = dbArray.getNanos();
                for (int i = 0; i < lArray.length; ++i) {
                    DbTimestamp dbTimestamp = new DbTimestamp(dbColDesc);
                    dbTimestamp.value = lArray[i];
                    if (nArray != null && lArray.length == nArray.length) {
                        dbTimestamp.value += (long)(nArray[i] / 1000000);
                    }
                    dbTimestamp.bNull = false;
                    vector.add(dbTimestamp);
                }
                break;
            }
            case 7: {
                float[] fArray2 = (float[])object;
                for (int i = 0; i < fArray2.length; ++i) {
                    DbNumber dbNumber;
                    if (bl) {
                        dbNumber = new fCurrency(dbColDesc);
                        dbNumber.value = new BigDecimal(fArray2[i]);
                        dbNumber.bNull = false;
                        vector.add(dbNumber);
                        continue;
                    }
                    dbNumber = new DbDouble(dbColDesc);
                    ((DbDouble)dbNumber).value = fArray2[i];
                    ((DbDouble)dbNumber).bNull = false;
                    vector.add(dbNumber);
                }
                break;
            }
            case 6: 
            case 8: {
                double[] dArray = (double[])object;
                for (int i = 0; i < dArray.length; ++i) {
                    DbNumber dbNumber;
                    if (bl) {
                        dbNumber = new fCurrency(dbColDesc);
                        dbNumber.value = new BigDecimal(dArray[i]);
                        dbNumber.bNull = false;
                        vector.add(dbNumber);
                        continue;
                    }
                    dbNumber = new DbDouble(dbColDesc);
                    ((DbDouble)dbNumber).value = dArray[i];
                    ((DbDouble)dbNumber).bNull = false;
                    vector.add(dbNumber);
                }
                break;
            }
            case 2: 
            case 3: {
                BigDecimal[] bigDecimalArray = (BigDecimal[])object;
                for (int i = 0; i < bigDecimalArray.length; ++i) {
                    DbNumber dbNumber;
                    if (bl) {
                        dbNumber = new fCurrency(dbColDesc);
                        dbNumber.value = bigDecimalArray[i];
                        dbNumber.bNull = false;
                        vector.add(dbNumber);
                        continue;
                    }
                    dbNumber = new DbDouble(dbColDesc);
                    ((DbDouble)dbNumber).value = bigDecimalArray[i].doubleValue();
                    ((DbDouble)dbNumber).bNull = false;
                    vector.add(dbNumber);
                }
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                String[] stringArray = (String[])object;
                for (int i = 0; i < stringArray.length; ++i) {
                    DbChar dbChar;
                    if (dbArray.getSqlType() == -1) {
                        dbChar = new fText(dbColDesc);
                        dbChar.value = stringArray[i];
                        dbChar.bNull = false;
                        vector.add(dbChar);
                        continue;
                    }
                    dbChar = new DbChar(dbColDesc);
                    dbChar.value = stringArray[i];
                    dbChar.bNull = false;
                    vector.add(dbChar);
                }
                break;
            }
            default: {
                return vector;
            }
        }
        return vector;
    }

    private Vector<DbValue> J(DbValue dbValue) {
        Vector<DbValue> vector = new Vector<DbValue>();
        if (dbValue.isNull()) {
            return vector;
        }
        if (dbValue instanceof fArray) {
            for (DbValue dbValue2 : ((fArray)dbValue).value) {
                if (dbValue2 instanceof EvalueatedValueListItem) {
                    dbValue2 = ValueListItemUtil.toDbValue((EvalueatedValueListItem)((Object)dbValue2));
                }
                vector.add(dbValue2);
            }
            return vector;
        }
        if (dbValue instanceof DbArray) {
            return this.D((DbArray)dbValue);
        }
        if (dbValue instanceof EvalueatedValueListItem) {
            DbValue dbValue3 = ValueListItemUtil.toDbValue((EvalueatedValueListItem)((Object)dbValue));
            vector.add(dbValue3);
        } else {
            vector.add(dbValue);
        }
        return vector;
    }

    private boolean in(DbValue dbValue, DbValue dbValue2) {
        Vector<DbValue> vector = null;
        if (dbValue2 instanceof fArray && ((fArray)dbValue2).isAll()) {
            return true;
        }
        vector = this.J(dbValue2);
        Vector<DbValue> vector2 = null;
        if (dbValue instanceof fArray && ((fArray)dbValue).isAll()) {
            return false;
        }
        vector2 = this.J(dbValue);
        return vector.containsAll(vector2);
    }

    private boolean isArray(DbValue dbValue) {
        return dbValue instanceof fArray || dbValue instanceof DbArray;
    }

    public boolean compare(Record record) {
        boolean bl = false;
        int n = record.indexOfCell(this.columnName);
        if (n == -1) {
            return false;
        }
        DbValue dbValue = record.getCell(n);
        if (this.isArray(this.value)) {
            bl = this.in(dbValue, this.value);
            switch (this.operator) {
                case 6: {
                    break;
                }
                case 7: {
                    bl = !bl;
                    break;
                }
                case 0: {
                    bl = bl && this.in(this.value, dbValue);
                    break;
                }
                case 1: {
                    bl = bl && this.in(this.value, dbValue);
                    bl = !bl;
                }
            }
            return bl;
        }
        if (this.operator == 6) {
            String string = this.value.toString();
            if (string.startsWith("(")) {
                string = string.substring(1, string.length() - 1);
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                String string2 = dbValue.toString();
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    if (!string3.equals(string2)) continue;
                    return true;
                }
                return false;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(dbValue.toString(), "|");
            while (stringTokenizer.hasMoreTokens()) {
                if (!stringTokenizer.nextToken().equals(string)) continue;
                return true;
            }
            return false;
        }
        int n2 = dbValue instanceof DbNumber ? ((DbNumber)dbValue).compare((DbNumber)this.value) : dbValue.compareTo(this.value);
        switch (this.operator) {
            case 0: {
                bl = n2 == 0;
                break;
            }
            case 1: {
                bl = n2 != 0;
                break;
            }
            case 2: {
                bl = n2 == -1;
                break;
            }
            case 3: {
                bl = n2 == 1;
                break;
            }
            case 4: {
                bl = n2 == 0 || n2 == -1;
                break;
            }
            case 5: {
                bl = n2 == 0 || n2 == 1;
                break;
            }
            default: {
                throw new Error("Unknow operator " + this.operator);
            }
        }
        return bl;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getOperString() {
        return strOper[this.operator];
    }

    public DbValue getValue() {
        return this.value;
    }

    public String getValueString() {
        String string = this.value.toString();
        if (DbValueComparer.SEDU(this.value.getSqlType())) {
            StringBuffer stringBuffer = new StringBuffer(string);
            int n = string.indexOf(39);
            int n2 = 0;
            while (n != -1) {
                stringBuffer.insert(n + n2, '\'');
                ++n2;
                ++n;
                n = string.indexOf(39, n);
            }
            string = new String(stringBuffer);
            n = string.indexOf(34);
            n2 = 0;
            while (n != -1) {
                stringBuffer.insert(n + n2, '\"');
                ++n2;
                ++n;
                n = string.indexOf(34, n);
            }
            string = "'" + string + "'";
        }
        return string;
    }

    public static boolean canCompare(int n, int n2) {
        boolean bl = false;
        switch (n) {
            case -1: 
            case 1: 
            case 12: {
                if (n2 != 1 && n2 != 12 && n2 != -1) break;
                bl = true;
                break;
            }
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                if (n2 != -5 && n2 != -6 && n2 != 2 && n2 != 3 && n2 != 4 && n2 != 5 && n2 != 6 && n2 != 7 && n2 != 8) break;
                bl = true;
                break;
            }
            case 91: {
                if (n2 != 91) break;
                bl = true;
                break;
            }
            case 92: {
                if (n2 != 92) break;
                bl = true;
                break;
            }
            case 93: {
                if (n2 != 93) break;
                bl = true;
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                break;
            }
            case -7: {
                if (n2 != -7) break;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public String toString() {
        return "dbvaluecom:" + this.columnName + " " + this.getOperString() + " " + this.getValueString();
    }

    private static boolean SEDU(int n) {
        return n == 1 || n == 12 || n == -1 || n == 91 || n == 92 || n == 93;
    }
}

