/*
 * Decompiled with CFR 0.152.
 */
package jet.util;

import com.jinfonet.common.api.JdbcDriversConfig;
import com.jinfonet.resstore.MemoryStore;
import com.jinfonet.util.JRLog;
import java.io.File;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import jet.ReportEnv;
import jet.bean.JREngine;
import jet.formula.ParamDesc;
import jet.formula.SumaryFuncs;
import jet.reportLogic.objectLogic.ObjectLogicFactory;
import jet.reportset.JetRptReportSet;
import jet.rptservice.util.ParameterTools;
import jet.rptservice.util.ReportTools;
import jet.universe.DataCollection;
import jet.universe.JetUUniverse;
import jet.universe.businesslogic.impl.UnifiedBusinessView;

public class EngineTools {
    private JREngine LoadNoCache;

    public EngineTools(JREngine jREngine) {
        this.LoadNoCache = jREngine;
    }

    public static Vector getBVs(String string) {
        JetUUniverse jetUUniverse;
        Vector vector;
        block3: {
            vector = new Vector();
            jetUUniverse = null;
            ReportEnv.checkEnv(new Object(), null, 1);
            try {
                jetUUniverse = JetUUniverse.LoadNoCache(string);
            }
            catch (Exception exception) {
                if (!JRLog.isError(2)) break block3;
                JRLog.error(2, exception);
            }
        }
        if (jetUUniverse != null) {
            vector = EngineTools.getBVs(jetUUniverse);
            jetUUniverse.free();
            jetUUniverse = null;
        }
        return vector;
    }

    public static Vector getBVs(JetUUniverse jetUUniverse) {
        Vector<String> vector = new Vector<String>();
        if (jetUUniverse != null) {
            Vector vector2 = jetUUniverse.getAllDatabaseNames();
            for (int i = 0; i < vector2.size(); ++i) {
                Vector vector3 = new Vector();
                String string = (String)vector2.elementAt(i);
                Vector<UnifiedBusinessView> vector4 = jetUUniverse.getDatabase(string).getBvs();
                UnifiedBusinessView unifiedBusinessView = null;
                for (int j = 0; vector4 != null && j < vector4.size(); ++j) {
                    unifiedBusinessView = vector4.get(j);
                    if (unifiedBusinessView == null) continue;
                    vector.add(unifiedBusinessView.getQualifyDisplayName());
                }
            }
        }
        return vector;
    }

    public ParamDesc[] getQueryParams(String string, String string2) throws Exception {
        return this.getQueryParams(string, string2, null);
    }

    public ParamDesc[] getQueryParams(String string, String string2, JdbcDriversConfig jdbcDriversConfig) throws Exception {
        if (this.LoadNoCache != null) {
            ParameterTools parameterTools = ParameterTools.getInstance();
            ParamDesc[] paramDescArray = parameterTools.getInstance().getParamsInQuery(this.LoadNoCache.getCatalog(), string, string2);
            paramDescArray = parameterTools.sort(paramDescArray);
            parameterTools.getShowValue(paramDescArray, this.LoadNoCache.getCatalog(), string, string2, jdbcDriversConfig);
            return paramDescArray;
        }
        return null;
    }

    public ParamDesc[] ParamValueChanged(String string, String string2, ParamDesc[] paramDescArray) {
        Vector vector;
        ParamDesc paramDesc = null;
        if (string != null) {
            boolean bl = false;
            for (int i = 0; i < paramDescArray.length; ++i) {
                if (!paramDescArray[i].name.equalsIgnoreCase(string)) continue;
                paramDesc = paramDescArray[i];
                bl = true;
                break;
            }
            if (!bl) {
                return null;
            }
        }
        if (string2 == null && paramDesc != null) {
            string2 = paramDesc.getDefaultValue();
        }
        if ((vector = paramDesc.getReferedBy()) != null && !vector.isEmpty()) {
            try {
                paramDesc.setValue(string2, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ParamDesc[] paramDescArray2 = new ParamDesc[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                paramDescArray2[i] = (ParamDesc)vector.get(i);
            }
            ParameterTools parameterTools = ParameterTools.getInstance();
            paramDescArray2 = parameterTools.sort(paramDescArray2);
            this.LoadNoCache(paramDescArray2, paramDesc, paramDescArray);
            return paramDescArray2;
        }
        return null;
    }

    private void LoadNoCache(ParamDesc[] paramDescArray, ParamDesc paramDesc, ParamDesc[] paramDescArray2) {
        int n;
        Vector[] vectorArray = new Vector[2];
        DataCollection dataCollection = new DataCollection();
        Hashtable<String, ParamDesc> hashtable = new Hashtable<String, ParamDesc>();
        for (n = 0; n < paramDescArray2.length; ++n) {
            hashtable.put(paramDescArray2[n].getName().toUpperCase(), paramDescArray2[n]);
        }
        for (n = 0; n < paramDescArray.length; ++n) {
            ParamDesc paramDesc2 = paramDescArray[n];
            if (paramDesc == null && paramDesc2.isValuesNotEmpty()) continue;
            try {
                String string = paramDesc2.getImportSql();
                if (!paramDesc2.isColumn() || string == null || string.trim().length() == 0) continue;
                Vector vector = paramDesc2.getColumns();
                String[] stringArray = new String[vector == null ? 0 : vector.size()];
                int n2 = stringArray.length;
                while (--n2 >= 0) {
                    stringArray[n2] = (String)vector.elementAt(n2);
                }
                vectorArray = dataCollection.getResultSet(this.LoadNoCache.getCatalog(), paramDesc2, hashtable);
                paramDesc2.setValues(vectorArray[0], Locale.getDefault());
                paramDesc2.setShowValues(vectorArray.length > 1 ? vectorArray[1] : vectorArray[0]);
                if (vectorArray[0].isEmpty()) {
                    paramDesc2.setValue("", Locale.getDefault());
                }
                if (vectorArray[0] == null || vectorArray[0].isEmpty()) continue;
                paramDesc2.setDefaultIndex(0);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Date getModifyDate() {
        return new Date(new File(this.LoadNoCache.getCatName() == null || this.LoadNoCache.getCatName().length() == 0 ? this.LoadNoCache.getReportName() : this.LoadNoCache.getCatName()).lastModified());
    }

    public static boolean isPortletReportSet(String string, String string2, MemoryStore memoryStore) throws Exception {
        JetUUniverse jetUUniverse = ReportTools.loadUniverse(string, memoryStore);
        JetRptReportSet jetRptReportSet = ReportTools.loadReportSet(string2, null, true, jetUUniverse, memoryStore);
        boolean bl = ObjectLogicFactory.getReportSetLogic().isPortletReportSet(jetRptReportSet);
        jetUUniverse.free();
        jetUUniverse = null;
        jetRptReportSet.free();
        jetRptReportSet = null;
        return bl;
    }

    public static boolean isPortletReportSet(JetUUniverse jetUUniverse, String string, MemoryStore memoryStore) throws Exception {
        JetRptReportSet jetRptReportSet = ReportTools.loadReportSet(string, null, true, jetUUniverse, memoryStore);
        boolean bl = ObjectLogicFactory.getReportSetLogic().isPortletReportSet(jetRptReportSet);
        jetRptReportSet.free();
        jetRptReportSet = null;
        return bl;
    }

    public static void getSupportAggreationsByType(int n, Vector<String> vector) {
        if (SumaryFuncs.justify("COUNT", n)) {
            vector.addElement("Count");
            vector.addElement("DistinctCount");
            vector.addElement("RunningCount");
            vector.addElement("RunningDistinctCount");
        }
        if (SumaryFuncs.justify("SUM", n)) {
            vector.addElement("Sum");
            vector.addElement("RunningSum");
        }
        if (SumaryFuncs.justify("AVERAGE", n)) {
            vector.addElement("Average");
            vector.addElement("RunningAvg");
        }
        if (SumaryFuncs.justify("MAXIMUM", n)) {
            vector.addElement("Maximum");
            vector.addElement("RunningMaximum");
        }
        if (SumaryFuncs.justify("MINIMUM", n)) {
            vector.addElement("Minimum");
            vector.addElement("RunningMinimum");
        }
        if (SumaryFuncs.justify("POPULATIONSTDDEV", n)) {
            vector.addElement("PopulationStdDev");
        }
        if (SumaryFuncs.justify("POPULATIONVARIANCE", n)) {
            vector.addElement("PopulationVariance");
        }
        if (SumaryFuncs.justify("STDDEV", n)) {
            vector.addElement("StdDev");
        }
        if (SumaryFuncs.justify("VARIANCE", n)) {
            vector.addElement("Variance");
        }
    }
}

