/*
 * Decompiled with CFR 0.152.
 */
package jet.util;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.Vector;
import jet.util.IntStack;
import jet.util.WildcardMatcher;

public class FileEnumerater
implements Enumeration {
    File root;
    FilenameFilter filter;
    File[] dirs;
    int dirPtr;
    File[] files;
    int filePtr;
    File next;
    Stack dirStk;
    IntStack ptrStk;

    public FileEnumerater(String string, FilenameFilter filenameFilter) {
        this.root = new File(string);
        this.filter = filenameFilter;
        this.reset();
    }

    public File getRoot() {
        return this.root;
    }

    public FileEnumerater(String string) {
        this.root = new File(string);
        this.filter = null;
        this.reset();
    }

    public FileEnumerater(File file) {
        this.root = file;
        this.filter = null;
        this.reset();
    }

    public FileEnumerater(File file, FilenameFilter filenameFilter) {
        this.root = file;
        this.filter = filenameFilter;
        this.reset();
    }

    public void reset() {
        if (!this.root.exists() || !this.root.isDirectory()) {
            this.dirs = null;
            this.files = null;
            return;
        }
        this.dirStk = new Stack();
        this.ptrStk = new IntStack();
        this.accept(this.root);
        this.next = this.SEDU();
    }

    private File SEDU() {
        while (this.dirs != null || this.files != null) {
            if (this.filePtr < this.files.length) {
                return this.files[this.filePtr++];
            }
            if (this.dirs.length > 0) {
                this.accept(this.dirs[0]);
                continue;
            }
            this.addElement();
            if (this.dirs == null) continue;
            this.accept(this.dirs[this.dirPtr]);
        }
        return null;
    }

    public File nextFile() {
        File file = this.next;
        if (file == null) {
            throw new NoSuchElementException();
        }
        this.next = this.SEDU();
        return file;
    }

    public Object nextElement() {
        return this.nextFile();
    }

    @Override
    public boolean hasMoreElements() {
        return this.next != null;
    }

    private void accept(File file) {
        if (this.dirs != null) {
            this.dirStk.push(this.dirs);
            this.ptrStk.push(++this.dirPtr);
        }
        String[] stringArray = file.list();
        Vector<File> vector = new Vector<File>();
        Vector<File> vector2 = new Vector<File>();
        for (String string : stringArray) {
            File file2 = new File(file, string);
            if (file2.isDirectory()) {
                vector.addElement(file2);
                continue;
            }
            if (this.filter != null && !this.filter.accept(file, string)) continue;
            vector2.addElement(file2);
        }
        this.dirs = new File[vector.size()];
        vector.copyInto(this.dirs);
        this.dirPtr = 0;
        this.files = new File[vector2.size()];
        vector2.copyInto(this.files);
        this.filePtr = 0;
    }

    private void addElement() {
        while (!this.dirStk.empty()) {
            this.dirs = (File[])this.dirStk.pop();
            this.dirPtr = this.ptrStk.pop();
            if (this.dirPtr >= this.dirs.length) continue;
            return;
        }
        this.dirs = null;
        this.files = null;
    }

    public static Vector findFiles(String string) {
        String string2 = System.getProperty("os.name");
        boolean bl = string2.toUpperCase().indexOf("WINDOWS") >= 0;
        WildcardMatcher wildcardMatcher = new WildcardMatcher(string, !bl);
        Vector<File> vector = new Vector<File>();
        if (!bl) {
            FileEnumerater fileEnumerater = new FileEnumerater(File.separator, (FilenameFilter)wildcardMatcher);
            while (fileEnumerater.hasMoreElements()) {
                vector.addElement(fileEnumerater.nextFile());
            }
        } else {
            for (int i = 65; i <= 90; ++i) {
                String string3 = (char)i + ":\\";
                if (!new File(string3).exists()) continue;
                FileEnumerater fileEnumerater = new FileEnumerater(string3, (FilenameFilter)wildcardMatcher);
                while (fileEnumerater.hasMoreElements()) {
                    vector.addElement(fileEnumerater.nextFile());
                }
            }
        }
        return vector;
    }
}

