/*
 * Decompiled with CFR 0.152.
 */
package jet.util;

import com.jinfonet.awt.JFont;
import com.jinfonet.awt.font.JMFont;
import com.jinfonet.util.JRLog;
import java.awt.Font;
import java.awt.FontFormatException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import jet.Env;
import jet.ReportEnv;
import jet.util.FontSets;
import jet.util.JRInterruptedException;
import jet.util.WildcardMatcher;

class FontSet {
    private static String SEDU = Env.getFontPath();
    private static HashMap<String, Font> append = new HashMap(7);
    private static HashMap<String, String> assembleFontFile = new HashMap(7);
    static HashMap<String, String> userFontNames_FileNames = new HashMap(7);
    private static HashMap<String, String> close = new HashMap(7);
    private static ReadWriteLock containsKey = new ReentrantReadWriteLock(true);
    private static ReadWriteLock createFont = new ReentrantReadWriteLock(true);

    FontSet() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void putFont(String string, Font font) throws JRInterruptedException {
        try {
            containsKey.writeLock().lockInterruptibly();
        }
        catch (InterruptedException interruptedException) {
            if (JRLog.isTrace(5)) {
                JRLog.trace(5, "InterruptedException on ufLock.write in FontSets");
            }
            throw new JRInterruptedException();
        }
        try {
            if (!append.containsKey(string)) {
                append.put(string, font);
                assembleFontFile.put(font.getName(), string);
            }
        }
        finally {
            containsKey.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getFontNameForBrowser(String string) throws JRInterruptedException {
        try {
            containsKey.readLock().lockInterruptibly();
        }
        catch (InterruptedException interruptedException) {
            if (JRLog.isTrace(5)) {
                JRLog.trace(5, "InterruptedException on ufLock.read in FontSets");
            }
            throw new JRInterruptedException();
        }
        try {
            Font font = append.get(string);
            String string2 = font == null ? string : font.getFontName();
            return string2;
        }
        finally {
            containsKey.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getFontFileName(String string) throws JRInterruptedException {
        String string2 = null;
        try {
            createFont.readLock().lockInterruptibly();
        }
        catch (InterruptedException interruptedException) {
            if (JRLog.isTrace(5)) {
                JRLog.trace(5, "InterruptedException on ufnlLock.read in FontSets");
            }
            throw new JRInterruptedException();
        }
        try {
            string2 = userFontNames_FileNames.get(string);
        }
        finally {
            createFont.readLock().unlock();
        }
        if (string2 == null) {
            try {
                createFont.writeLock().lockInterruptibly();
            }
            catch (InterruptedException interruptedException) {
                if (JRLog.isTrace(5)) {
                    JRLog.trace(5, "InterruptedException on ufnlLock.write in FontSets");
                }
                throw new JRInterruptedException();
            }
            try {
                string2 = userFontNames_FileNames.get(string);
                if (string2 == null) {
                    if (JRLog.isError(3)) {
                        JRLog.error(3, string + "'s font file is not in cache, try load it from " + Env.getFontPath());
                    }
                    FontSet.SEDU();
                    string2 = userFontNames_FileNames.get(string);
                }
                if (string2 == null) {
                    FontSet.initJFonts(string);
                    string2 = userFontNames_FileNames.get(string);
                }
            }
            finally {
                createFont.writeLock().unlock();
            }
        }
        if (string2 != null && new File(string2).exists()) {
            return string2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean exists(String string) throws JRInterruptedException {
        try {
            containsKey.readLock().lockInterruptibly();
        }
        catch (InterruptedException interruptedException) {
            if (JRLog.isTrace(5)) {
                JRLog.trace(5, "InterruptedException on ufLock.read in FontSets");
            }
            throw new JRInterruptedException();
        }
        try {
            boolean bl = append.containsKey(string);
            return bl;
        }
        finally {
            containsKey.readLock().unlock();
        }
    }

    private static void SEDU() {
        try {
            String string = Env.getFontPath();
            if (string == null) {
                return;
            }
            File file = new File(string);
            String[] stringArray = null;
            try {
                stringArray = file.list(new WildcardMatcher("*.ttf", false));
            }
            catch (SecurityException securityException) {
                JRLog.error(2, securityException);
            }
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    String string2 = string + stringArray[i];
                    FontSet.assembleFontFile(string2);
                }
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    static void assembleFontFile(String string) {
        if (close.get(string) == null) {
            JFont jFont;
            String string2 = null;
            try {
                jFont = JMFont.prepareName(string);
                if (jFont == null) {
                    return;
                }
                string2 = "*" + jFont.getBaseName();
            }
            catch (SecurityException securityException) {
                jFont = null;
            }
            if (jFont != null && string2 != null && userFontNames_FileNames.get(string2) == null) {
                userFontNames_FileNames.put(string2, string);
                close.put(string, string2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void assembleFontFiles(String[] stringArray) throws JRInterruptedException {
        try {
            createFont.writeLock().lockInterruptibly();
        }
        catch (InterruptedException interruptedException) {
            if (JRLog.isTrace(5)) {
                JRLog.trace(5, "InterruptedException on ufnlLock.write in FontSets");
            }
            throw new JRInterruptedException();
        }
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                FontSet.assembleFontFile(stringArray[i]);
            }
        }
        finally {
            createFont.writeLock().unlock();
        }
    }

    static String getUserFontName(Font font) throws JRInterruptedException {
        return FontSet.getUserFontName(font.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getUserFontName(String string) throws JRInterruptedException {
        try {
            containsKey.readLock().lockInterruptibly();
        }
        catch (InterruptedException interruptedException) {
            if (JRLog.isTrace(5)) {
                JRLog.trace(5, "InterruptedException on ufLock.read in FontSets");
            }
            throw new JRInterruptedException();
        }
        try {
            String string2 = assembleFontFile.get(string);
            return string2;
        }
        finally {
            containsKey.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isTrueType(String string) throws JRInterruptedException {
        try {
            createFont.readLock().lockInterruptibly();
        }
        catch (InterruptedException interruptedException) {
            if (JRLog.isTrace(5)) {
                JRLog.trace(5, "InterruptedException on ufnlLock.read in FontSets");
            }
            throw new JRInterruptedException();
        }
        try {
            boolean bl = userFontNames_FileNames.containsKey(string);
            return bl;
        }
        finally {
            createFont.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isTrueType(Font font) throws JRInterruptedException {
        try {
            containsKey.readLock().lockInterruptibly();
        }
        catch (InterruptedException interruptedException) {
            if (JRLog.isTrace(5)) {
                JRLog.trace(5, "InterruptedException on ufLock.read in FontSets");
            }
            throw new JRInterruptedException();
        }
        try {
            boolean bl = assembleFontFile.containsKey(font.getName());
            return bl;
        }
        finally {
            containsKey.readLock().unlock();
        }
    }

    static void setFontPath(String string) {
        SEDU = string;
    }

    static int getTrueTypeFontStyle(String string) {
        int n = 0;
        if (string == null || string.trim().length() == 0) {
            return n;
        }
        if (string.indexOf(42) == 0) {
            n = 0;
            if (string.toUpperCase().lastIndexOf("BOLD") != -1 || string.lastIndexOf("Negreta") != -1) {
                n |= 1;
            }
            if (string.toUpperCase().lastIndexOf("ITALIC") != -1 || string.toUpperCase().lastIndexOf("CURSIVA") != -1) {
                n |= 2;
            }
            return n;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Font getFont(String string, int n, float f) throws FontFormatException, IOException, JRInterruptedException {
        Font font = null;
        if (string == null || string.trim().length() == 0) {
            Font font2 = new Font("Dialog", n, 0);
            return font2.deriveFont(f);
        }
        String string2 = FontSets.getMapFontNameForUser(string, n);
        int n2 = FontSets.getMapFontStyleForUser(string, n);
        if (string2 != null && string2.indexOf(42) == 0) {
            block43: {
                if (string.toUpperCase().lastIndexOf("BOLD") != -1 || string.lastIndexOf("Negreta") != -1) {
                    n |= 1;
                }
                if (string.toUpperCase().lastIndexOf("ITALIC") != -1 || string.toUpperCase().lastIndexOf("CURSIVA") != -1 || string.toUpperCase().lastIndexOf("OBLIQUE") != -1) {
                    n |= 2;
                }
                try {
                    containsKey.readLock().lockInterruptibly();
                }
                catch (InterruptedException interruptedException) {
                    if (JRLog.isTrace(5)) {
                        JRLog.trace(5, "InterruptedException on ufLock.read in FontSets");
                    }
                    throw new JRInterruptedException();
                }
                try {
                    if (string2 != null && !string2.equals(string)) {
                        string = string2;
                    }
                    font = append.get(string);
                }
                finally {
                    containsKey.readLock().unlock();
                }
                if (font == null) {
                    String string3 = null;
                    try {
                        createFont.readLock().lockInterruptibly();
                    }
                    catch (InterruptedException interruptedException) {
                        if (JRLog.isTrace(5)) {
                            JRLog.trace(5, "InterruptedException on ufnlLock.read in FontSets");
                        }
                        throw new JRInterruptedException();
                    }
                    try {
                        string3 = userFontNames_FileNames.get(string);
                    }
                    finally {
                        createFont.readLock().unlock();
                    }
                    if (string3 == null) {
                        try {
                            createFont.writeLock().lockInterruptibly();
                        }
                        catch (InterruptedException interruptedException) {
                            if (JRLog.isTrace(5)) {
                                JRLog.trace(5, "InterruptedException on ufnlLock.write in FontSets");
                            }
                            throw new JRInterruptedException();
                        }
                        try {
                            string3 = userFontNames_FileNames.get(string);
                            if (string3 == null) {
                                FontSet.SEDU();
                                string3 = userFontNames_FileNames.get(string);
                                if (string3 == null) {
                                    FontSet.initJFonts(string);
                                    string3 = userFontNames_FileNames.get(string);
                                }
                            }
                        }
                        finally {
                            createFont.writeLock().unlock();
                        }
                    }
                    if (string3 != null) {
                        File file = new File(string3);
                        if (file.exists()) {
                            FileInputStream fileInputStream = new FileInputStream(file);
                            try {
                                font = Font.createFont(0, fileInputStream);
                                try {
                                    containsKey.writeLock().lockInterruptibly();
                                }
                                catch (InterruptedException interruptedException) {
                                    if (JRLog.isTrace(5)) {
                                        JRLog.trace(5, "InterruptedException on ufLock.write in FontSets");
                                    }
                                    throw new JRInterruptedException();
                                }
                                try {
                                    append.put(string, font);
                                    assembleFontFile.put(font.getName(), string);
                                    break block43;
                                }
                                finally {
                                    containsKey.writeLock().unlock();
                                }
                            }
                            finally {
                                fileInputStream.close();
                                FontSets.deleteTempFile("+~JF", "tmp");
                            }
                        }
                        Font font3 = new Font(FontSet.getFontNameForBrowser(string), n, 0);
                        return font3.deriveFont(f);
                    }
                    Font font4 = new Font(FontSet.getFontNameForBrowser(string), n, 0);
                    return font4.deriveFont(f);
                }
            }
            font = font.deriveFont(f);
        } else {
            if (string2 != null && !string2.equals(string)) {
                string = string2;
            }
            Font font5 = new Font(string, n2, 0);
            font = font5.deriveFont(f);
        }
        return font;
    }

    static void initJFonts(String string) {
        try {
            String string2 = ReportEnv.homePath + "font" + File.separator;
            File file = new File(string2);
            String[] stringArray = file.list(new WildcardMatcher("*.ttf", false));
            String string3 = string.substring(1);
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    JFont jFont;
                    String string4 = string2 + stringArray[i];
                    String string5 = string;
                    if (userFontNames_FileNames.get(string) != null || (jFont = JMFont.prepareName(string2 + stringArray[i])) == null) continue;
                    String string6 = jFont.getBaseName();
                    if (string3.equalsIgnoreCase(string6)) {
                        userFontNames_FileNames.put(string5, string4);
                    }
                    if (FontSet.fullToHalfCharAgain(string3).equalsIgnoreCase(string6) || FontSet.fullToHalfChar(string3).equalsIgnoreCase(string6)) {
                        userFontNames_FileNames.put(string5, string4);
                    }
                    if (!string3.equalsIgnoreCase(FontSet.fullToHalfChar(string6)) && !string3.equalsIgnoreCase(FontSet.fullToHalfCharAgain(string6))) continue;
                    userFontNames_FileNames.put(string5, string4);
                }
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    protected static String fullToHalfChar(String string) {
        String string2 = "";
        if (string != null) {
            char[] cArray = string.toCharArray();
            int n = cArray.length;
            for (int i = 0; i < n; ++i) {
                char c = cArray[i];
                cArray[i] = (char)(c - 41856);
            }
            string2 = new String(cArray);
        }
        return string2;
    }

    protected static String fullToHalfCharAgain(String string) {
        String string2 = "";
        if (string != null) {
            char[] cArray = string.toCharArray();
            int n = cArray.length;
            for (int i = 0; i < n; ++i) {
                char c = cArray[i];
                cArray[i] = (char)(c - 41856 - 23392);
            }
            string2 = new String(cArray);
        }
        return string2;
    }

    static {
        FontSet.SEDU();
    }
}

