/*
 * Decompiled with CFR 0.152.
 */
package jet.util;

import com.jinfonet.api.objectmanager.CatalogKey;
import com.jinfonet.util.JRLog;
import java.rmi.RemoteException;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import jet.connect.DbChar;
import jet.connect.DbDate;
import jet.connect.DbTime;
import jet.controls.QueryInfoImpl;
import jet.dataengine.api.DSException;
import jet.dataengine.api.expression.set.ISortExpression;
import jet.dataengine.api.query.JDataSourceQuery;
import jet.dataengine.api.query.JRawDataQuery;
import jet.dataengine.api.query.ParameterValueList;
import jet.dataengine.api.query.RawDataQueryOption;
import jet.dataengine.api.query.SpecialFields;
import jet.dataservice.api.JQueryFactory;
import jet.exception.InvalidParameterException;
import jet.formula.JavaFormula;
import jet.formula.JetRptFormula;
import jet.formula.ParamDesc;
import jet.icontrols.QueryInfo;
import jet.rptservice.api.IDynamicQueryInfo;
import jet.rptservice.api.IRuntimeQueryInfoProvider;
import jet.rptservice.api.RawDataQueryCreator;
import jet.rptservice.api.exception.JRScheduleException;
import jet.rptservice.pub.RuntimeQueryInfoContainer;
import jet.rptservice.util.QueryParameterProvider;
import jet.rptservice.util.RawDataQueryEnv;
import jet.rptservice.util.ReportTools;
import jet.server.api.ServerInfo;
import jet.server.intf.engine.ConnectionInfoProvider;
import jet.universe.JetUConnection;
import jet.universe.JetUDatabase;
import jet.universe.JetUFormula;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUUniverse;
import jet.universe.tools.UniverseTools;
import jet.util.ScheduleTools;

public class GeneralRawDataQueryCreator
implements RawDataQueryCreator {
    RawDataQueryEnv rawQueryEnv;
    protected String[] mappingNames;
    private String add;
    private java.util.Date addElement;
    private Properties addParameterValue;
    private boolean append;
    protected IRuntimeQueryInfoProvider rqInfoProvider;

    protected GeneralRawDataQueryCreator(RawDataQueryEnv rawDataQueryEnv, String[] stringArray) {
        this.rawQueryEnv = rawDataQueryEnv;
        this.mappingNames = stringArray;
    }

    public GeneralRawDataQueryCreator(JetUUniverse jetUUniverse, String string, String string2, String[] stringArray, String string3, java.util.Date date, Properties properties, boolean bl, ConnectionInfoProvider connectionInfoProvider) {
        this(RawDataQueryEnv.getDefaultEnv(jetUUniverse, new QueryInfoImpl("", string, string2, null, 0)), stringArray);
        this.add = string3;
        this.addElement = date;
        this.addParameterValue = properties;
        this.append = bl;
        RuntimeQueryInfoContainer runtimeQueryInfoContainer = this.SEDU(jetUUniverse, string, connectionInfoProvider);
        if (runtimeQueryInfoContainer != null) {
            this.rqInfoProvider = runtimeQueryInfoContainer.getRuntimeQueryInfoProvider(jetUUniverse);
        }
    }

    protected RawDataQueryEnv getRawDataQueryEnv() {
        return this.rawQueryEnv;
    }

    private RuntimeQueryInfoContainer SEDU(JetUUniverse jetUUniverse, String string, ConnectionInfoProvider connectionInfoProvider) {
        if (connectionInfoProvider == null) {
            return null;
        }
        JetUDatabase jetUDatabase = jetUUniverse.getDatabase(string);
        if (jetUDatabase == null) {
            return null;
        }
        Vector vector = jetUDatabase.getConnections();
        if (vector == null || vector.isEmpty()) {
            return null;
        }
        RuntimeQueryInfoContainer runtimeQueryInfoContainer = null;
        for (JetUConnection jetUConnection : vector) {
            Properties properties = null;
            String string2 = jetUConnection.getResourceName();
            try {
                properties = connectionInfoProvider.getConnectionInfo(string2);
            }
            catch (RemoteException remoteException) {
                JRLog.error(5, remoteException);
            }
            if (properties == null) continue;
            if (runtimeQueryInfoContainer == null) {
                runtimeQueryInfoContainer = new RuntimeQueryInfoContainer();
            }
            runtimeQueryInfoContainer.setConnectionInfo(string, string2, properties);
        }
        return runtimeQueryInfoContainer;
    }

    @Override
    public JRawDataQuery createRawDataQuery(JQueryFactory jQueryFactory, CatalogKey catalogKey, ISortExpression iSortExpression) throws JRScheduleException {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "GeneralRawDataQueryCreator.createRawDataQuery()..., this: " + this + " queryFactory: " + jQueryFactory + " catKey: " + catalogKey + " sorter: " + iSortExpression);
        }
        Hashtable<String, JetUFormula> hashtable = this.getReportFormulas();
        JDataSourceQuery jDataSourceQuery = null;
        try {
            jDataSourceQuery = this.add(jQueryFactory, catalogKey);
            if (this.isAllConstantFormula(hashtable)) {
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "all constant formula, prepare DataDescription for constant formulas.");
                }
                ScheduleTools.prepareDataDescripionForConstFml(jDataSourceQuery, this.addElement());
            } else if (this.rqInfoProvider != null) {
                String string;
                JetUUniverse jetUUniverse = this.rawQueryEnv.getUniverse();
                QueryInfo queryInfo = this.rawQueryEnv.getQueryInfo();
                String string2 = queryInfo.getDatasourceName();
                IDynamicQueryInfo iDynamicQueryInfo = this.rqInfoProvider.getDynamicQueryInfo(string2, string = this.rawQueryEnv.getQueryName());
                if (ScheduleTools.isValid(iDynamicQueryInfo)) {
                    ScheduleTools.prepareDynamicQueryInfo(jDataSourceQuery, jetUUniverse, string2, string, this.mappingNames, iDynamicQueryInfo);
                }
                ScheduleTools.prepareDynamicConnectionInfo(jDataSourceQuery, jetUUniverse, string2, string, this.rqInfoProvider);
            }
        }
        catch (DSException dSException) {
            throw new JRScheduleException(dSException);
        }
        catch (SQLException sQLException) {
            throw new JRScheduleException(sQLException);
        }
        if (jDataSourceQuery != null) {
            try {
                jDataSourceQuery.setMappingNames(this.mappingNames);
                if (hashtable != null && !hashtable.isEmpty()) {
                    jDataSourceQuery.setReportFormulas(hashtable);
                }
                jDataSourceQuery.setJavaFormula(this.getJavaFormula());
                jDataSourceQuery.setBatchRun(true);
                try {
                    jDataSourceQuery.setParameterValues(this.getParamValues());
                }
                catch (InvalidParameterException invalidParameterException) {
                    throw new JRScheduleException(invalidParameterException);
                }
                jDataSourceQuery.setSpecialFields(this.getSpecialFields());
                if (iSortExpression != null) {
                    jDataSourceQuery.setSorter(iSortExpression);
                }
            }
            catch (DSException dSException) {
                throw new JRScheduleException(dSException);
            }
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of GeneralRawDataQueryCreator.createRawDataQuery(), return: " + jDataSourceQuery);
        }
        return jDataSourceQuery;
    }

    private JDataSourceQuery add(JQueryFactory jQueryFactory, CatalogKey catalogKey) throws DSException {
        JDataSourceQuery jDataSourceQuery = jQueryFactory.createDataSourceQuery(catalogKey);
        QueryInfo queryInfo = this.rawQueryEnv.getQueryInfo();
        int n = queryInfo.getDataResoureType();
        String string = n == 0 ? queryInfo.getQueryName() : queryInfo.getBLName();
        int n2 = n == 0 ? 2 : 1;
        jDataSourceQuery.setDataSourceName(queryInfo.getDatasourceName());
        jDataSourceQuery.setBVQueryName(string, n2);
        jDataSourceQuery.setOption(this.addParameterValue());
        return jDataSourceQuery;
    }

    private JetRptFormula[] addElement() {
        JetUUniverse jetUUniverse = this.rawQueryEnv.getUniverse();
        QueryInfo queryInfo = this.rawQueryEnv.getQueryInfo();
        String string = queryInfo.getDatasourceName();
        JetUDatabase jetUDatabase = jetUUniverse.getDatabase(string);
        ArrayList<JetRptFormula> arrayList = new ArrayList<JetRptFormula>();
        for (int i = 0; i < this.mappingNames.length; ++i) {
            JetUFormula jetUFormula = jetUDatabase.getFormulaByResourceName(this.mappingNames[i]);
            arrayList.add(jetUFormula.getRptFormula());
        }
        return arrayList.toArray(new JetRptFormula[0]);
    }

    protected ServerInfo getServerInfo() {
        return null;
    }

    private RawDataQueryOption addParameterValue() throws DSException {
        RawDataQueryOption rawDataQueryOption = new RawDataQueryOption();
        ServerInfo serverInfo = this.getServerInfo();
        if (serverInfo != null) {
            rawDataQueryOption.setServerInfo(serverInfo);
        }
        rawDataQueryOption.setErrorlisteners(null);
        rawDataQueryOption.setFastPass(false);
        boolean bl = false;
        rawDataQueryOption.setLazyRun(bl);
        rawDataQueryOption.setMaxRecords(-1L);
        rawDataQueryOption.setMaxPageNumber(-1L);
        rawDataQueryOption.setRecordsPerPage(-1L);
        rawDataQueryOption.setSingleThread(this.append);
        rawDataQueryOption.setNoRecord(false);
        return rawDataQueryOption;
    }

    protected Hashtable<String, JetUFormula> getReportFormulas() {
        return null;
    }

    protected JavaFormula getJavaFormula() throws JRScheduleException {
        Object var1_1 = null;
        JetUUniverse jetUUniverse = this.rawQueryEnv.getUniverse();
        QueryInfo queryInfo = this.rawQueryEnv.getQueryInfo();
        String string = queryInfo.getDatasourceName();
        return ReportTools.loadJavaFormula(string, jetUUniverse);
    }

    protected ParameterValueList getParamValues() throws DSException, InvalidParameterException {
        Vector<ParamDesc> vector = this.append();
        if (vector == null) {
            return null;
        }
        ParameterValueList parameterValueList = new ParameterValueList();
        for (int i = 0; i < vector.size(); ++i) {
            ParamDesc paramDesc = vector.elementAt(i);
            this.contains(paramDesc, this.addParameterValue);
            parameterValueList.addParameterValue(paramDesc);
        }
        return parameterValueList;
    }

    private Vector<ParamDesc> append() throws DSException {
        Object object;
        Vector<ParamDesc> vector = new Vector<ParamDesc>();
        JetUUniverse jetUUniverse = this.rawQueryEnv.getUniverse();
        QueryInfo queryInfo = this.rawQueryEnv.getQueryInfo();
        String string = queryInfo.getDatasourceName();
        String string2 = this.rawQueryEnv.getQueryName();
        String[] stringArray = null;
        if (string2 != null) {
            object = new QueryParameterProvider(null, true);
            stringArray = object.getQueryParamNames(jetUUniverse, string, string2);
        }
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        object = new Vector();
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i].toUpperCase();
            if (((Vector)object).contains(string3)) continue;
            ((Vector)object).addElement(string3);
            vector.addElement(UniverseTools.getParamDesc(string3, jetUUniverse, string));
        }
        return vector;
    }

    private void contains(ParamDesc paramDesc, Properties properties) throws InvalidParameterException {
        if (properties == null || properties.isEmpty()) {
            return;
        }
        String string = paramDesc.getName();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.equalsIgnoreCase(string)) continue;
            String string3 = (String)properties.get(string2);
            paramDesc.setValue(string3, Locale.getDefault());
            break;
        }
    }

    protected SpecialFields getSpecialFields() {
        SpecialFields specialFields = new SpecialFields();
        specialFields.setUserName(new DbChar(this.add));
        java.util.Date date = new java.util.Date();
        specialFields.setModifiedDate(new DbDate(new Date(this.addElement.getTime())));
        specialFields.setModifiedTime(new DbTime(new Time(this.addElement.getTime())));
        specialFields.setPrintDate(new DbDate(new Date(date.getTime())));
        specialFields.setPrintTime(new DbTime(new Time(date.getTime())));
        return specialFields;
    }

    protected boolean isAllConstantFormula(Hashtable<String, JetUFormula> hashtable) {
        return false;
    }

    protected final boolean isAllConstantFormula(JetUUniverse jetUUniverse, String string, String string2, Hashtable<String, JetUFormula> hashtable, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            JetUFormula jetUFormula = this.containsKey(jetUUniverse, string, string2, hashtable, stringArray[i]);
            if (jetUFormula != null && jetUFormula.isConstant()) continue;
            return false;
        }
        return true;
    }

    private JetUFormula containsKey(JetUUniverse jetUUniverse, String string, String string2, Hashtable<String, JetUFormula> hashtable, String string3) {
        if (hashtable != null && hashtable.containsKey(string3)) {
            return hashtable.get(string3);
        }
        JetUDatabase jetUDatabase = jetUUniverse.getDatabase(string);
        JetUResourceEntity jetUResourceEntity = jetUDatabase.getResourceByName(string3);
        return jetUResourceEntity != null && jetUResourceEntity instanceof JetUFormula ? (JetUFormula)jetUResourceEntity : null;
    }
}

