/*
 * Decompiled with CFR 0.152.
 */
package jet.util;

import java.util.Vector;
import jet.util.IntKeyHashNode;
import jet.util.IntVector;

public class IntKeyHashtable {
    private transient IntKeyHashNode[] SEDU;
    private transient int addElement;
    private int append;
    private float clone;

    public IntKeyHashtable(int n, float f) {
        if (n <= 0 || (double)f <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.clone = f;
        this.SEDU = new IntKeyHashNode[n];
        this.append = (int)((float)n * f);
    }

    public IntKeyHashtable(int n) {
        this(n, 0.618f);
    }

    public IntKeyHashtable() {
        this(103, 0.618f);
    }

    public int size() {
        return this.addElement;
    }

    public boolean isEmpty() {
        return this.addElement == 0;
    }

    public synchronized boolean contains(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        for (int i = 0; i < this.SEDU.length; ++i) {
            IntKeyHashNode intKeyHashNode = this.SEDU[i];
            while (intKeyHashNode != null) {
                if (intKeyHashNode.value.equals(object)) {
                    return true;
                }
                intKeyHashNode = intKeyHashNode.next;
            }
        }
        return false;
    }

    public synchronized IntVector getKeys(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        IntVector intVector = new IntVector(5);
        for (int i = 0; i < this.SEDU.length; ++i) {
            IntKeyHashNode intKeyHashNode = this.SEDU[i];
            while (intKeyHashNode != null) {
                if (intKeyHashNode.value.equals(object)) {
                    intVector.addElement(intKeyHashNode.key);
                }
                intKeyHashNode = intKeyHashNode.next;
            }
        }
        return intVector;
    }

    public synchronized boolean containsKey(int n) {
        int n2 = (n & Integer.MAX_VALUE) % this.SEDU.length;
        IntKeyHashNode intKeyHashNode = this.SEDU[n2];
        while (intKeyHashNode != null) {
            if (intKeyHashNode.key == n) {
                return true;
            }
            intKeyHashNode = intKeyHashNode.next;
        }
        return false;
    }

    public synchronized Object get(int n) {
        int n2 = (n & Integer.MAX_VALUE) % this.SEDU.length;
        IntKeyHashNode intKeyHashNode = this.SEDU[n2];
        while (intKeyHashNode != null) {
            if (intKeyHashNode.key == n) {
                return intKeyHashNode.value;
            }
            intKeyHashNode = intKeyHashNode.next;
        }
        return null;
    }

    protected void rehash() {
        int n = this.SEDU.length;
        IntKeyHashNode[] intKeyHashNodeArray = this.SEDU;
        int n2 = n * 2 + 1;
        IntKeyHashNode[] intKeyHashNodeArray2 = new IntKeyHashNode[n2];
        this.append = (int)((float)n2 * this.clone);
        this.SEDU = intKeyHashNodeArray2;
        for (int i = 0; i < n; ++i) {
            IntKeyHashNode intKeyHashNode = intKeyHashNodeArray[i];
            while (intKeyHashNode != null) {
                IntKeyHashNode intKeyHashNode2 = intKeyHashNode;
                intKeyHashNode = intKeyHashNode.next;
                int n3 = (intKeyHashNode2.key & Integer.MAX_VALUE) % n2;
                intKeyHashNode2.next = intKeyHashNodeArray2[n3];
                intKeyHashNodeArray2[n3] = intKeyHashNode2;
            }
        }
    }

    public synchronized Object put(int n, Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        int n2 = (n & Integer.MAX_VALUE) % this.SEDU.length;
        IntKeyHashNode intKeyHashNode = this.SEDU[n2];
        while (intKeyHashNode != null) {
            if (intKeyHashNode.key == n) {
                Object object2 = intKeyHashNode.value;
                intKeyHashNode.value = object;
                return object2;
            }
            intKeyHashNode = intKeyHashNode.next;
        }
        if (this.addElement >= this.append) {
            this.rehash();
            return this.put(n, object);
        }
        intKeyHashNode = new IntKeyHashNode();
        intKeyHashNode.key = n;
        intKeyHashNode.value = object;
        intKeyHashNode.next = this.SEDU[n2];
        this.SEDU[n2] = intKeyHashNode;
        ++this.addElement;
        return null;
    }

    public synchronized Object remove(int n) {
        int n2 = (n & Integer.MAX_VALUE) % this.SEDU.length;
        IntKeyHashNode intKeyHashNode = this.SEDU[n2];
        IntKeyHashNode intKeyHashNode2 = null;
        while (intKeyHashNode != null) {
            if (intKeyHashNode.key == n) {
                if (intKeyHashNode2 != null) {
                    intKeyHashNode2.next = intKeyHashNode.next;
                } else {
                    this.SEDU[n2] = intKeyHashNode.next;
                }
                --this.addElement;
                return intKeyHashNode.value;
            }
            intKeyHashNode2 = intKeyHashNode;
            intKeyHashNode = intKeyHashNode.next;
        }
        return null;
    }

    public synchronized void clear() {
        for (int i = 0; i < this.SEDU.length; ++i) {
            this.SEDU[i] = null;
        }
        this.addElement = 0;
    }

    public synchronized Object clone() {
        IntKeyHashtable intKeyHashtable = new IntKeyHashtable(this.SEDU.length, this.clone);
        for (int i = 0; i < this.SEDU.length; ++i) {
            intKeyHashtable.SEDU[i] = this.SEDU[i] != null ? (IntKeyHashNode)this.SEDU[i].clone() : null;
        }
        return intKeyHashtable;
    }

    public synchronized IntVector keys() {
        IntVector intVector = null;
        if (this.addElement != 0) {
            intVector = new IntVector();
            for (int i = 0; i < this.SEDU.length; ++i) {
                IntKeyHashNode intKeyHashNode = this.SEDU[i];
                if (intKeyHashNode == null) continue;
                do {
                    intVector.addElement(intKeyHashNode.key);
                } while ((intKeyHashNode = intKeyHashNode.next) != null);
            }
        }
        return intVector;
    }

    public synchronized Vector elements() {
        Vector<Object> vector = null;
        if (this.addElement != 0) {
            vector = new Vector<Object>();
            for (int i = 0; i < this.SEDU.length; ++i) {
                IntKeyHashNode intKeyHashNode = this.SEDU[i];
                if (intKeyHashNode == null) continue;
                do {
                    vector.addElement(intKeyHashNode.value);
                } while ((intKeyHashNode = intKeyHashNode.next) != null);
            }
        }
        return vector;
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.addElement != 0) {
            stringBuffer.append("[");
            for (int i = 0; i < this.SEDU.length; ++i) {
                IntKeyHashNode intKeyHashNode = this.SEDU[i];
                if (intKeyHashNode == null) continue;
                do {
                    stringBuffer.append("[").append(intKeyHashNode.key).append(",").append(intKeyHashNode.value == this ? super.toString() : intKeyHashNode.value).append("],");
                } while ((intKeyHashNode = intKeyHashNode.next) != null);
            }
            stringBuffer.append("]");
        }
        return stringBuffer.toString();
    }
}

