/*
 * Decompiled with CFR 0.152.
 */
package jet.util;

import java.util.StringTokenizer;
import java.util.Vector;
import jet.exception.JURLExecuterException;
import jet.util.EngineExecuter;
import jet.util.JURLEngineExecuter;
import jet.util.JURLException;
import jet.util.JURLExecuter;

public class JURL {
    public static final String schemeDelimiter = ":/";
    public static final String strParameterDelimiter = ";";
    public static final char pathPrefix = '/';
    public static final String strPackageDelimiter = ".";
    String strScheme;
    String strClassName;
    EngineExecuter engineExcuter = null;
    String[] strParams = new String[0];
    String clientName;

    public JURL(String string) throws JURLException {
        this.parseURL(string);
    }

    public JURL(String string, EngineExecuter engineExecuter) throws JURLException {
        this(string);
        this.engineExcuter = engineExecuter;
    }

    public void setURL(String string) throws JURLException {
        this.parseURL(string);
    }

    public String getURL() {
        return this.buildURL();
    }

    public void setScheme(String string) {
        this.strScheme = string;
    }

    public String getScheme() {
        return this.strScheme;
    }

    public void setClassName(String string) {
        this.strClassName = string;
    }

    public String getClassName() {
        return this.strClassName;
    }

    public void setParams(String[] stringArray) {
        this.strParams = stringArray;
    }

    public String[] getParams() {
        return this.strParams;
    }

    public void setParamsString(String string) {
        this.parseParamsString(string);
    }

    public String getParamsString() {
        return this.buildParamsString();
    }

    public void setClientName(String string) {
        this.clientName = string;
    }

    protected void parseURL(String string) throws JURLException {
        int n = string.indexOf(schemeDelimiter);
        if (n < 0) {
            throw new JURLException("No class name found");
        }
        this.strScheme = string.substring(0, n);
        String string2 = null;
        int n2 = string.indexOf(strParameterDelimiter, n + schemeDelimiter.length());
        if (n2 < 0) {
            this.strClassName = string.substring(n + schemeDelimiter.length(), string.length());
        } else {
            this.strClassName = string.substring(n + schemeDelimiter.length(), n2);
            string2 = string.substring(n2 + 1, string.length());
        }
        if (this.strClassName == null || this.strClassName.length() == 0) {
            throw new JURLException("No class name found");
        }
        if (!JURL.isValidClassName(this.strClassName)) {
            throw new JURLException(this.strClassName);
        }
        if (string2 != null && string2.length() != 0) {
            this.setParamsString(string2);
        }
    }

    public static boolean isValidClassName(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, strPackageDelimiter);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (JURL.isIdentifier(string2)) continue;
            return false;
        }
        return true;
    }

    public static boolean isIdentifier(String string) {
        int n = string.length();
        char c = string.charAt(0);
        if (!Character.isJavaIdentifierStart(c)) {
            return false;
        }
        for (int i = 1; i < n; ++i) {
            c = string.charAt(i);
            if (Character.isJavaIdentifierPart(c)) continue;
            return false;
        }
        return true;
    }

    protected String buildURL() {
        String string = "";
        if (this.strScheme != null && this.strScheme.length() != 0) {
            string = string + this.strScheme;
            if (this.strClassName != null && this.strClassName.length() != 0) {
                string = string + schemeDelimiter + this.strClassName;
                String string2 = this.getParamsString();
                if (string2 != null && string2.length() != 0) {
                    string = string + strParameterDelimiter + string2;
                }
            }
        }
        return string;
    }

    protected void parseParamsString(String string) {
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, strParameterDelimiter);
            Vector<String> vector = new Vector<String>();
            while (stringTokenizer.hasMoreTokens()) {
                vector.addElement(stringTokenizer.nextToken());
            }
            int n = vector.size();
            this.strParams = new String[n];
            for (int i = 0; i < n; ++i) {
                this.strParams[i] = (String)vector.elementAt(i);
            }
        }
    }

    protected String buildParamsString() {
        String string = "";
        int n = this.strParams.length;
        for (int i = 0; i < n; ++i) {
            string = string + this.strParams[i];
            if (i + 1 >= n) continue;
            string = string + strParameterDelimiter;
        }
        return string;
    }

    public String toString() {
        return this.buildURL();
    }

    public boolean exec() throws ClassNotFoundException, InstantiationException, IllegalAccessException, JURLExecuterException {
        String[] stringArray;
        if (this.clientName != null && this.clientName.length() > 0) {
            int n = this.strParams.length;
            stringArray = new String[n + 1];
            System.arraycopy(this.strParams, 0, stringArray, 0, n);
            stringArray[n] = this.clientName;
        } else {
            stringArray = this.strParams;
        }
        JURLExecuter jURLExecuter = (JURLExecuter)Class.forName(this.strClassName).newInstance();
        if (jURLExecuter instanceof JURLEngineExecuter) {
            return ((JURLEngineExecuter)jURLExecuter).exec(stringArray, this.engineExcuter);
        }
        return jURLExecuter.exec(stringArray);
    }
}

