/*
 * Decompiled with CFR 0.152.
 */
package jet.util;

import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import jet.util.DCT;
import jet.util.Huffman;
import jet.util.JpegInfo;

public class JpegEncoder
extends Panel {
    BufferedOutputStream outStream;
    JpegInfo JpegObj;
    Huffman Huf;
    DCT dct;
    int imageHeight;
    int imageWidth;
    int Quality;
    public static int[] jpegNaturalOrder = new int[]{0, 1, 8, 16, 9, 2, 3, 10, 17, 24, 32, 25, 18, 11, 4, 5, 12, 19, 26, 33, 40, 48, 41, 34, 27, 20, 13, 6, 7, 14, 21, 28, 35, 42, 49, 56, 57, 50, 43, 36, 29, 22, 15, 23, 30, 37, 44, 51, 58, 59, 52, 45, 38, 31, 39, 46, 53, 60, 61, 54, 47, 55, 62, 63};

    public JpegEncoder(Image image, int n, OutputStream outputStream) {
        MediaTracker mediaTracker = new MediaTracker(this);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.Quality = n;
        this.JpegObj = new JpegInfo(image);
        this.imageHeight = this.JpegObj.imageHeight;
        this.imageWidth = this.JpegObj.imageWidth;
        this.outStream = new BufferedOutputStream(outputStream);
        this.dct = new DCT(this.Quality);
        this.Huf = new Huffman(this.imageWidth, this.imageHeight);
    }

    public void setQuality(int n) {
        this.dct = new DCT(n);
    }

    public int getQuality() {
        return this.Quality;
    }

    public void Compress() {
        this.WriteHeaders(this.outStream);
        this.WriteCompressedData(this.outStream);
        this.WriteEOI(this.outStream);
        try {
            this.outStream.flush();
        }
        catch (IOException iOException) {
            System.out.println("IO Error: " + iOException.getMessage());
        }
    }

    public void WriteCompressedData(BufferedOutputStream bufferedOutputStream) {
        int n;
        boolean bl = false;
        float[][] fArray2 = new float[8][8];
        double[][] dArray = new double[8][8];
        int[] nArray = new int[64];
        int[] nArray2 = new int[this.JpegObj.NumberOfComponents];
        int[] nArray3 = new int[64];
        int n2 = 0;
        int n3 = 0;
        boolean bl2 = false;
        int n4 = this.imageWidth % 8 != 0 ? (int)(Math.floor((double)this.imageWidth / 8.0) + 1.0) * 8 : this.imageWidth;
        int n5 = this.imageHeight % 8 != 0 ? (int)(Math.floor((double)this.imageHeight / 8.0) + 1.0) * 8 : this.imageHeight;
        for (n = 0; n < this.JpegObj.NumberOfComponents; ++n) {
            n4 = Math.min(n4, this.JpegObj.BlockWidth[n]);
            n5 = Math.min(n5, this.JpegObj.BlockHeight[n]);
        }
        int n6 = 0;
        for (int i = 0; i < n5; ++i) {
            for (int j = 0; j < n4; ++j) {
                n6 = j * 8;
                int n7 = i * 8;
                for (n = 0; n < this.JpegObj.NumberOfComponents; ++n) {
                    n2 = this.JpegObj.BlockWidth[n];
                    n3 = this.JpegObj.BlockHeight[n];
                    float[][] fArray3 = (float[][])this.JpegObj.Components[n];
                    for (int k = 0; k < this.JpegObj.VsampFactor[n]; ++k) {
                        for (int i2 = 0; i2 < this.JpegObj.HsampFactor[n]; ++i2) {
                            int n8 = i2 * 8;
                            int n9 = k * 8;
                            for (int i3 = 0; i3 < 8; ++i3) {
                                for (int i4 = 0; i4 < 8; ++i4) {
                                    fArray2[i3][i4] = fArray3[n7 + n9 + i3][n6 + n8 + i4];
                                }
                            }
                            dArray = this.dct.forwardDCT(fArray2);
                            nArray = this.dct.quantizeBlock(dArray, this.JpegObj.QtableNumber[n]);
                            this.Huf.HuffmanBlockEncoder(bufferedOutputStream, nArray, nArray2[n], this.JpegObj.DCtableNumber[n], this.JpegObj.ACtableNumber[n]);
                            nArray2[n] = nArray[0];
                        }
                    }
                }
            }
        }
        this.Huf.flushBuffer(bufferedOutputStream);
    }

    public void WriteEOI(BufferedOutputStream bufferedOutputStream) {
        byte[] byArray = new byte[]{-1, -39};
        this.WriteMarker(byArray, bufferedOutputStream);
    }

    public void WriteHeaders(BufferedOutputStream bufferedOutputStream) {
        int n;
        int n2;
        byte[] byArray = new byte[]{-1, -40};
        this.WriteMarker(byArray, bufferedOutputStream);
        byte[] byArray2 = new byte[]{-1, -32, 0, 16, 74, 70, 73, 70, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0};
        this.WriteArray(byArray2, bufferedOutputStream);
        String string = new String();
        string = this.JpegObj.getComment();
        int n3 = string.length();
        byte[] byArray3 = new byte[n3 + 4];
        byArray3[0] = -1;
        byArray3[1] = -2;
        byArray3[2] = (byte)(n3 >> 8 & 0xFF);
        byArray3[3] = (byte)(n3 & 0xFF);
        System.arraycopy(this.JpegObj.Comment.getBytes(), 0, byArray3, 4, this.JpegObj.Comment.length());
        this.WriteArray(byArray3, bufferedOutputStream);
        byte[] byArray4 = new byte[134];
        byArray4[0] = -1;
        byArray4[1] = -37;
        byArray4[2] = 0;
        byArray4[3] = -124;
        int n4 = 4;
        for (n2 = 0; n2 < 2; ++n2) {
            byArray4[n4++] = (byte)(0 + n2);
            int[] nArray = (int[])this.dct.quantum[n2];
            for (n = 0; n < 64; ++n) {
                byArray4[n4++] = (byte)nArray[jpegNaturalOrder[n]];
            }
        }
        this.WriteArray(byArray4, bufferedOutputStream);
        byte[] byArray5 = new byte[19];
        byArray5[0] = -1;
        byArray5[1] = -64;
        byArray5[2] = 0;
        byArray5[3] = 17;
        byArray5[4] = (byte)this.JpegObj.Precision;
        byArray5[5] = (byte)(this.JpegObj.imageHeight >> 8 & 0xFF);
        byArray5[6] = (byte)(this.JpegObj.imageHeight & 0xFF);
        byArray5[7] = (byte)(this.JpegObj.imageWidth >> 8 & 0xFF);
        byArray5[8] = (byte)(this.JpegObj.imageWidth & 0xFF);
        byArray5[9] = (byte)this.JpegObj.NumberOfComponents;
        int n5 = 10;
        for (n2 = 0; n2 < byArray5[9]; ++n2) {
            byArray5[n5++] = (byte)this.JpegObj.CompID[n2];
            byArray5[n5++] = (byte)((this.JpegObj.HsampFactor[n2] << 4) + this.JpegObj.VsampFactor[n2]);
            byArray5[n5++] = (byte)this.JpegObj.QtableNumber[n2];
        }
        this.WriteArray(byArray5, bufferedOutputStream);
        n3 = 2;
        n5 = 4;
        int n6 = 4;
        byte[] byArray6 = new byte[17];
        byte[] byArray7 = new byte[4];
        byArray7[0] = -1;
        byArray7[1] = -60;
        for (n2 = 0; n2 < 4; ++n2) {
            int n7 = 0;
            byArray6[n5++ - n6] = (byte)((int[])this.Huf.bits.elementAt(n2))[0];
            for (n = 1; n < 17; ++n) {
                int n8 = ((int[])this.Huf.bits.elementAt(n2))[n];
                byArray6[n5++ - n6] = (byte)n8;
                n7 += n8;
            }
            int n9 = n5;
            byte[] byArray8 = new byte[n7];
            for (n = 0; n < n7; ++n) {
                byArray8[n5++ - n9] = (byte)((int[])this.Huf.val.elementAt(n2))[n];
            }
            byte[] byArray9 = new byte[n5];
            System.arraycopy(byArray7, 0, byArray9, 0, n6);
            System.arraycopy(byArray6, 0, byArray9, n6, 17);
            System.arraycopy(byArray8, 0, byArray9, n6 + 17, n7);
            byArray7 = byArray9;
            n6 = n5;
        }
        byArray7[2] = (byte)(n5 - 2 >> 8 & 0xFF);
        byArray7[3] = (byte)(n5 - 2 & 0xFF);
        this.WriteArray(byArray7, bufferedOutputStream);
        byte[] byArray10 = new byte[14];
        byArray10[0] = -1;
        byArray10[1] = -38;
        byArray10[2] = 0;
        byArray10[3] = 12;
        byArray10[4] = (byte)this.JpegObj.NumberOfComponents;
        n5 = 5;
        for (n2 = 0; n2 < byArray10[4]; ++n2) {
            byArray10[n5++] = (byte)this.JpegObj.CompID[n2];
            byArray10[n5++] = (byte)((this.JpegObj.DCtableNumber[n2] << 4) + this.JpegObj.ACtableNumber[n2]);
        }
        byArray10[n5++] = (byte)this.JpegObj.Ss;
        byArray10[n5++] = (byte)this.JpegObj.Se;
        byArray10[n5++] = (byte)((this.JpegObj.Ah << 4) + this.JpegObj.Al);
        this.WriteArray(byArray10, bufferedOutputStream);
    }

    void WriteMarker(byte[] byArray, BufferedOutputStream bufferedOutputStream) {
        try {
            bufferedOutputStream.write(byArray, 0, 2);
        }
        catch (IOException iOException) {
            System.out.println("IO Error: " + iOException.getMessage());
        }
    }

    void WriteArray(byte[] byArray, BufferedOutputStream bufferedOutputStream) {
        try {
            int n = ((byArray[2] & 0xFF) << 8) + (byArray[3] & 0xFF) + 2;
            bufferedOutputStream.write(byArray, 0, n);
        }
        catch (IOException iOException) {
            System.out.println("IO Error: " + iOException.getMessage());
        }
    }
}

