/*
 * Decompiled with CFR 0.152.
 */
package jet.util;

import com.jinfonet.util.JRLog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import jet.export.xml.FormatInfoToXML;
import jet.export.xml.LoadXSDException;
import jet.export.xml.XMLToFormatInfo;
import jet.icontrols.PropValueInfo;
import jet.jetc.ReadFailureException;
import jet.jetc.WriteFailureException;
import jet.naming.EnumerationConstant;
import jet.naming.PropertyNames;
import jet.report.JetRptArea;
import jet.report.JetRptAreaDBText;
import jet.report.JetRptAreaText;
import jet.reportLogic.objectInfo.AreaInfo;
import jet.reportLogic.objectInfo.AreaTextInfo;
import jet.reportLogic.objectInfo.GeometryObjInfo;
import jet.reportLogic.objectInfo.MapInfo;
import jet.reportLogic.objectLogic.BasicComponentLogic;
import jet.reportLogic.objectLogic.MapLogic;
import jet.reportLogic.objectLogic.ObjectLogicFactory;
import jet.reportLogic.objectLogic.SimpleComponentLogic;
import jet.util.ValueToUnit;

public class MapUtil {
    public static final int AREA_IMPORT_LIST = 0;
    public static final int AREA_IMPORT_MAXWIDTH = 1;
    public static final int AREA_IMPORT_MAXHEIGHT = 2;
    private static final int ALIGNMENT_HOR_STR_NAMES = 0;
    private static final int ALIGNMENT_VER_STR_NAMES = 1;
    private static final int AREATYPE_DEFAULT = 2;
    private static final int HorizontalAlignment = 3;
    private static final int SEDU = 2;
    private static final int VerticalAlignment = 2;
    private static final int abs = 3;
    private static Font add = null;

    public static List LoadAreaObjsFromSHP() throws IOException {
        throw new UnsupportedOperationException("Right now");
    }

    public static List LoadAreaInfosFromSHP() throws IOException {
        throw new UnsupportedOperationException("Right now");
    }

    public static void saveAreaObjsToXML(List<JetRptArea> list, boolean bl, OutputStream outputStream) throws WriteFailureException, LoadXSDException {
        Vector<AreaInfo> vector = new Vector<AreaInfo>(list.size());
        MapLogic mapLogic = ObjectLogicFactory.getMapLogic();
        for (int i = 0; i < list.size(); ++i) {
            AreaInfo areaInfo = mapLogic.getAreaInfo(null, list.get(i));
            if (bl && areaInfo.isDefaultArea()) continue;
            vector.add(areaInfo);
        }
        MapUtil.saveAreaInfosToXML(vector, false, outputStream);
    }

    public static void saveAreaInfosToXML(List<AreaInfo> list, boolean bl, OutputStream outputStream) throws WriteFailureException, LoadXSDException {
        int n = list.size();
        int[] nArray = new int[]{0, 0};
        for (int i = 0; i < n; ++i) {
            AreaInfo areaInfo = list.get(i);
            if (bl && areaInfo.isDefaultArea() || areaInfo.isDefaultArea()) continue;
            int[] nArray2 = MapUtil.ALIGNMENT_HOR_STR_NAMES(areaInfo);
            if (nArray2[0] > nArray[0]) {
                nArray[0] = nArray2[0];
            }
            if (nArray2[1] <= nArray[1]) continue;
            nArray[1] = nArray2[1];
        }
        MapUtil.saveAreaInfosToXML(list, bl, nArray[0], nArray[1], outputStream);
    }

    public static void saveAreaObjsToXML(List<JetRptArea> list, boolean bl, int n, int n2, OutputStream outputStream) throws WriteFailureException, LoadXSDException {
        Vector<AreaInfo> vector = new Vector<AreaInfo>(list.size());
        MapLogic mapLogic = ObjectLogicFactory.getMapLogic();
        for (int i = 0; i < list.size(); ++i) {
            AreaInfo areaInfo = mapLogic.getAreaInfo(null, list.get(i));
            if (bl && areaInfo.isDefaultArea()) continue;
            vector.add(areaInfo);
        }
        MapUtil.saveAreaInfosToXML(vector, false, n, n2, outputStream);
    }

    public static void saveAreaInfosToXML(List<AreaInfo> list, boolean bl, int n, int n2, OutputStream outputStream) throws WriteFailureException, LoadXSDException {
        Vector<AreaInfo> vector = new Vector<AreaInfo>(list.size());
        if (bl) {
            int n3 = list.size();
            for (int i = 0; i < n3; ++i) {
                AreaInfo areaInfo = list.get(i);
                if (areaInfo.isDefaultArea()) continue;
                vector.add(areaInfo);
            }
        } else {
            vector.addAll(list);
        }
        MapInfo mapInfo = new MapInfo();
        mapInfo.setActualSize(n, n2);
        mapInfo.resetAreaInfos(vector);
        FormatInfoToXML formatInfoToXML = new FormatInfoToXML();
        formatInfoToXML.storeTo(mapInfo, outputStream);
    }

    public static Object[] loadAreaInfosFromXML(File file, boolean bl, List list) throws ReadFailureException, LoadXSDException {
        XMLToFormatInfo xMLToFormatInfo = new XMLToFormatInfo();
        MapInfo mapInfo = (MapInfo)xMLToFormatInfo.loadFrom(file.getAbsolutePath());
        List list2 = mapInfo.getAreaInfos();
        boolean bl2 = false;
        for (int i = 0; i < list2.size(); ++i) {
            AreaInfo areaInfo = (AreaInfo)list2.get(i);
            areaInfo.setPropertyValue("UseDefault", false, "false");
            MapUtil.correctEmptyAreaInfo(areaInfo, list);
            bl2 = bl2 || areaInfo.isDefaultArea();
        }
        if (bl && !bl2) {
            list2.add(0, new AreaInfo(AreaInfo.AREATYPE_DEFAULT, null));
        }
        int[] nArray = mapInfo.getActualSize();
        return new Object[]{list2, nArray[0], nArray[1]};
    }

    public static Object[] loadAreaObjsFromXML(File file, boolean bl, List list) throws ReadFailureException, LoadXSDException {
        Object[] objectArray = MapUtil.loadAreaInfosFromXML(file, bl, list);
        List list2 = (List)objectArray[0];
        Vector<JetRptArea> vector = new Vector<JetRptArea>();
        MapLogic mapLogic = ObjectLogicFactory.getMapLogic();
        for (int i = 0; i < list2.size(); ++i) {
            AreaInfo areaInfo = (AreaInfo)list2.get(i);
            vector.add(mapLogic.createAreaObject(areaInfo));
        }
        objectArray[0] = vector;
        return objectArray;
    }

    private static int[] ALIGNMENT_HOR_STR_NAMES(AreaInfo areaInfo) {
        if (areaInfo.isDefaultArea() || areaInfo.isFromDataBase()) {
            return new int[]{0, 0};
        }
        int[][] nArray = MapUtil.parseAreaShapeCoordinate(areaInfo.getAreaType(), areaInfo.getCoordinates(), areaInfo.getCoordinateParts());
        switch (areaInfo.getAreaType()) {
            case 2: {
                return new int[]{nArray[0][0] + nArray[0][2], nArray[0][1] + nArray[0][2]};
            }
            case 3: 
            case 4: {
                int n = 0;
                int n2 = 0;
                for (int i = 0; i < nArray.length; ++i) {
                    for (int j = 0; j < nArray.length; j += 2) {
                        if (n < nArray[i][j]) {
                            n = nArray[i][j];
                        }
                        if (n2 >= nArray[i][j + 1]) continue;
                        n2 = nArray[i][j + 1];
                    }
                }
                return new int[]{n, n2};
            }
            case 1: {
                return new int[]{nArray[0][0] + nArray[0][2], nArray[0][1] + nArray[0][3]};
            }
        }
        throw new IllegalArgumentException();
    }

    public static final int correctEmptyAreaObj(JetRptArea jetRptArea, List<String> list) {
        int n;
        double[][] dArray;
        if (jetRptArea.isDefaultTypeArea()) {
            return 0;
        }
        JetRptAreaDBText[] jetRptAreaDBTextArray = jetRptArea.getAllAreaDBTexts();
        JetRptAreaText jetRptAreaText = jetRptArea.getAreaText();
        if (jetRptAreaDBTextArray.length > 0 || jetRptAreaText != null) {
            return -1;
        }
        BasicComponentLogic basicComponentLogic = ObjectLogicFactory.getBasicComponentLogic();
        SimpleComponentLogic simpleComponentLogic = ObjectLogicFactory.getSimpleComponentLogic();
        if (jetRptArea.coords.isChangeByOther()) {
            AreaTextInfo areaTextInfo = MapUtil.abs(320, jetRptArea.name.get(), jetRptArea.name.isChangeByOther(), 0, 0, 6000, 1037, false, -1, -1, -1, -1);
            basicComponentLogic.add(jetRptArea, simpleComponentLogic.createAreaText(areaTextInfo));
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    areaTextInfo = MapUtil.abs(321, list.get(i), false, 0, 0, 3000, 1037, false, -1, -1, -1, -1);
                    basicComponentLogic.add(jetRptArea, simpleComponentLogic.createAreaDBText(areaTextInfo));
                }
                return 1 + list.size();
            }
            return 1;
        }
        int n2 = jetRptArea.type.intValue();
        double[] dArray2 = MapUtil.getGeomertyCenterWithoutEmpty(n2, (dArray = MapUtil.getLargestShapeResult(n2, jetRptArea.coords.get(), jetRptArea.coordParts.get()))[0][0], dArray[1]);
        if (dArray2[2] <= 0.0) {
            dArray2 = MapUtil.getNearestPointToGCenter(dArray[1], dArray2);
        }
        int n3 = (int)dArray2[0];
        int n4 = (int)dArray2[1];
        jetRptArea.forbidenEditOnProps();
        int n5 = -1;
        n5 = jetRptArea.name.isChangeByOther() ? MapUtil.add((String)jetRptArea.name.getChangeByObject()) : MapUtil.add(jetRptArea.name.get());
        int n6 = (int)(dArray2[0] - (double)(n5 / 2));
        if (n6 < 0) {
            n6 = 0;
        }
        if ((n = (int)(dArray2[1] - 518.0)) < 0) {
            n = 0;
        }
        boolean bl = (double)(n5 * 1037) > dArray[0][0];
        int n7 = 0;
        AreaTextInfo areaTextInfo = null;
        areaTextInfo = jetRptArea.name.isChangeByOther() ? MapUtil.abs(320, (String)jetRptArea.name.getChangeByObject(), true, n6, n, n5, 1037, bl, n3, n4, n6 + n5 / 2, n) : MapUtil.abs(320, jetRptArea.name.get(), false, n6, n, n5, 1037, bl, n3, n4, n6 + n5 / 2, n);
        JetRptAreaText jetRptAreaText2 = simpleComponentLogic.createAreaText(areaTextInfo);
        jetRptAreaText2.forbidenEditFlagOnProps();
        basicComponentLogic.add(jetRptArea, jetRptAreaText2);
        ++n7;
        n6 = (int)(dArray2[0] - 1500.0);
        if (n6 < 0) {
            n6 = 0;
        }
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                areaTextInfo = MapUtil.abs(321, list.get(i), false, n6, n += 1037, 3000, 1037, bl, n3, n4, n6 + 1500, n);
                JetRptAreaDBText jetRptAreaDBText = simpleComponentLogic.createAreaDBText(areaTextInfo);
                jetRptAreaDBText.forbidenEditOnProps();
                basicComponentLogic.add(jetRptArea, jetRptAreaDBText);
                ++n7;
            }
        }
        return n7;
    }

    public static final double[][] getLargestShapeResult(int n, String string, String string2) {
        Object object;
        int n2;
        int[][] nArray = MapUtil.parseAreaShapeCoordinate(n, string, string2);
        double d = 0.0;
        int n3 = 0;
        if (n == 2) {
            d = Math.PI * (double)nArray[0][2] * (double)nArray[0][2];
            n3 = 0;
        } else if (n == 1) {
            d = nArray[0][2] * nArray[0][3];
            n3 = 0;
        } else {
            for (n2 = 0; n2 < nArray.length; ++n2) {
                object = MapUtil.HorizontalAlignment(nArray[n2]);
                double d2 = MapUtil.ALIGNMENT_VER_STR_NAMES(object);
                if (!(d < d2)) continue;
                d = d2;
                n3 = n2;
            }
        }
        n2 = nArray[n3].length;
        object = new double[2][];
        object[0] = new double[1];
        object[0][0] = d;
        object[1] = new double[n2];
        for (int i = 0; i < n2; ++i) {
            object[1][i] = nArray[n3][i];
        }
        return object;
    }

    private static final double ALIGNMENT_VER_STR_NAMES(double[][] dArray) {
        int n = dArray.length - 1;
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += dArray[i][0] * dArray[i + 1][1] - dArray[i + 1][0] * dArray[i][1];
        }
        d = d + dArray[n][0] * dArray[0][1] - dArray[0][0] * dArray[n][1];
        return Math.abs(d / 2.0);
    }

    private static final double[][] AREATYPE_DEFAULT(double[] dArray) {
        int n = dArray.length / 2;
        double[][] dArray2 = new double[n][2];
        for (int i = 0; i < n; ++i) {
            dArray2[i][0] = dArray[2 * i];
            dArray2[i][1] = dArray[2 * i + 1];
        }
        return dArray2;
    }

    private static final double[][] HorizontalAlignment(int[] nArray) {
        int n = nArray.length / 2;
        double[][] dArray = new double[n][2];
        for (int i = 0; i < n; ++i) {
            dArray[i][0] = nArray[2 * i];
            dArray[i][1] = nArray[2 * i + 1];
        }
        return dArray;
    }

    public static double[] getGeomertyCenterWithoutEmpty(int n, double d, double[] dArray) {
        if (n == 2) {
            return new double[]{dArray[0], dArray[1], 1.0};
        }
        if (n == 1) {
            return new double[]{dArray[0] + dArray[2] / 2.0, dArray[1] + dArray[3] / 2.0, 1.0};
        }
        double[][] dArray2 = MapUtil.AREATYPE_DEFAULT(dArray);
        int n2 = dArray2.length - 1;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = 0; i < n2; ++i) {
            d4 = dArray2[i][0] * dArray2[i + 1][1] - dArray2[i + 1][0] * dArray2[i][1];
            d2 += (dArray2[i][0] + dArray2[i + 1][0]) * d4;
            d3 += (dArray2[i][1] + dArray2[i + 1][1]) * d4;
        }
        d4 = dArray2[n2][0] * dArray2[0][1] - dArray2[0][0] * dArray2[n2][1];
        double[] dArray3 = new double[]{Math.abs((d2 += (dArray2[n2][0] + dArray2[0][0]) * d4) / (6.0 * d)), Math.abs((d3 += (dArray2[n2][1] + dArray2[0][1]) * d4) / (6.0 * d))};
        return new double[]{dArray3[0], dArray3[1], MapUtil.SEDU(dArray2, dArray3) ? 1.0 : 0.0};
    }

    public static double[] getNearestPointToGCenter(double[] dArray, double[] dArray2) {
        double[][] dArray3 = MapUtil.AREATYPE_DEFAULT(dArray);
        double d = Double.MAX_VALUE;
        double[] dArray4 = new double[2];
        for (int i = 0; i < dArray3.length; ++i) {
            double d2 = MapUtil.VerticalAlignment(dArray3[i], dArray2);
            if (!(d2 < d)) continue;
            dArray4 = dArray3[i];
            d = d2;
        }
        return new double[]{dArray4[0], dArray4[1]};
    }

    protected static final int correctEmptyAreaInfo(AreaInfo areaInfo, List<String> list) {
        List list2;
        block12: {
            int n;
            double[][] dArray;
            block11: {
                if (areaInfo.isDefaultArea()) {
                    return 0;
                }
                list2 = areaInfo.getAreaTextInfos();
                if (list2.size() > 0) {
                    return -1;
                }
                if (!areaInfo.isFromDataBase()) break block11;
                PropValueInfo propValueInfo = areaInfo.getPropertyValue("Name");
                if (propValueInfo.getValueType() == -1) {
                    list2.add(MapUtil.abs(320, propValueInfo.toUnitString(), false, 0, 0, 6000, 1037, false, -1, -1, -1, -1));
                } else {
                    list2.add(MapUtil.abs(320, (String)propValueInfo.getValueObj(), true, 0, 0, 6000, 1037, false, -1, -1, -1, -1));
                }
                if (list == null) break block12;
                for (int i = 0; i < list.size(); ++i) {
                    list2.add(MapUtil.abs(321, list.get(i), false, 0, 0, 3000, 1037, false, -1, -1, -1, -1));
                }
                break block12;
            }
            int n2 = areaInfo.getAreaType();
            double[] dArray2 = MapUtil.getGeomertyCenterWithoutEmpty(n2, (dArray = MapUtil.getLargestShapeResult(n2, areaInfo.getCoordinates(), areaInfo.getCoordinateParts()))[0][0], dArray[1]);
            if (dArray2[2] <= 0.0) {
                dArray2 = MapUtil.getNearestPointToGCenter(dArray[1], dArray2);
            }
            int n3 = (int)dArray2[0];
            int n4 = (int)dArray2[1];
            PropValueInfo propValueInfo = areaInfo.getPropertyValue("Name");
            int n5 = MapUtil.add(propValueInfo.toUnitString());
            int n6 = (int)(dArray2[0] - (double)(n5 / 2));
            if (n6 < 0) {
                n6 = 0;
            }
            if ((n = (int)(dArray2[1] - 518.0)) < 0) {
                n = 0;
            }
            boolean bl = (double)(n5 * 1037) > dArray[0][0];
            list2.add(MapUtil.abs(320, areaInfo.getPropertyValue("Name").toUnitString(), areaInfo.isPropertyChangeBy("Name"), n6, n, n5, 1037, bl, n3, n4, n6 + n5 / 2, n));
            n6 = (int)(dArray2[0] - 1500.0);
            if (n6 < 0) {
                n6 = 0;
            }
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    list2.add(MapUtil.abs(321, list.get(i), false, n6, n += 1037, 3000, 1037, bl, n3, n4, n6 + 1500, n));
                }
            }
        }
        return list2.size();
    }

    public static int[][] parseAreaShapeCoordinate(int n, String string, String string2) {
        int[][] nArrayArray;
        block7: {
            int n2 = 2;
            StringTokenizer stringTokenizer = new StringTokenizer(string2, new String(","));
            int n3 = stringTokenizer.countTokens();
            int[] nArray = new int[n3];
            int n4 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                nArray[n4] = Integer.valueOf(string3.trim());
                ++n4;
            }
            nArrayArray = new int[n3][];
            stringTokenizer = new StringTokenizer(string, new String(","));
            int n5 = 0;
            n3 = stringTokenizer.countTokens();
            try {
                int n6 = 0;
                int n7 = 0;
                do {
                    int n8 = 0;
                    n8 = n6 < nArray.length - 1 ? (nArray[n6 + 1] - nArray[n6]) * n2 : n3 - n7;
                    nArrayArray[n6] = new int[n8];
                    int n9 = 0;
                    while (n9 < n8) {
                        try {
                            int n10;
                            String string4 = stringTokenizer.nextToken();
                            ++n5;
                            nArrayArray[n6][n9] = n10 = Integer.valueOf(string4.trim()).intValue();
                        }
                        catch (Throwable throwable) {
                            throw new RuntimeException(throwable);
                        }
                        ++n9;
                        ++n7;
                    }
                    ++n6;
                } while (n7 < n3);
            }
            catch (NumberFormatException numberFormatException) {
                if (!JRLog.isError(2)) break block7;
                JRLog.error(2, numberFormatException);
            }
        }
        return nArrayArray;
    }

    /*
     * Unable to fully structure code
     */
    private static boolean SEDU(double[][] var0, double[] var1_1) {
        var2_2 = 0;
        var3_3 = var0.length;
        var4_4 = var0[var3_3 - 1][0];
        var6_5 = var0[var3_3 - 1][1];
        for (var12_6 = 0; var12_6 < var3_3; ++var12_6) {
            block7: {
                block10: {
                    block11: {
                        block9: {
                            block8: {
                                var8_8 = var0[var12_6][0];
                                var10_9 = var0[var12_6][1];
                                if (var10_9 == var6_5) break block7;
                                if (!(var8_8 < var4_4)) break block8;
                                if (var1_1[0] >= var4_4) break block7;
                                var13_10 = var8_8;
                                break block9;
                            }
                            if (var1_1[0] >= var8_8) break block7;
                            var13_10 = var4_4;
                        }
                        if (!(var10_9 < var6_5)) break block10;
                        if (var1_1[1] < var10_9 || var1_1[1] >= var6_5) break block7;
                        if (!(var1_1[0] < var13_10)) break block11;
                        ++var2_2;
                        break block7;
                    }
                    var15_11 = var1_1[0] - var8_8;
                    var17_7 = var1_1[1] - var10_9;
                    ** GOTO lbl33
                }
                if (var1_1[1] < var6_5 || var1_1[1] >= var10_9) break block7;
                if (var1_1[0] < var13_10) {
                    ++var2_2;
                } else {
                    var15_11 = var1_1[0] - var4_4;
                    var17_7 = var1_1[1] - var6_5;
lbl33:
                    // 2 sources

                    if (var15_11 < var17_7 / (var6_5 - var10_9) * (var4_4 - var8_8)) {
                        ++var2_2;
                    }
                }
            }
            var4_4 = var8_8;
            var6_5 = var10_9;
        }
        return (var2_2 & true) != false;
    }

    private static double VerticalAlignment(double[] dArray, double[] dArray2) {
        double d = dArray[0] - dArray2[0];
        double d2 = dArray[1] - dArray2[1];
        double d3 = d * d + d2 * d2;
        return Math.sqrt(d3);
    }

    private static AreaTextInfo abs(int n, String string, boolean bl, int n2, int n3, int n4, int n5, boolean bl2, int n6, int n7, int n8, int n9) {
        AreaTextInfo areaTextInfo = null;
        if (n == 320) {
            areaTextInfo = new AreaTextInfo(n, null);
            areaTextInfo.setTexture(string, bl);
        } else {
            areaTextInfo = new AreaTextInfo(n, string);
        }
        areaTextInfo.setLocation(n2, n3);
        areaTextInfo.setSize(n4, n5);
        areaTextInfo.setPropertyValue("Invisible", bl2, String.valueOf(bl2));
        areaTextInfo.setPropertyValue("UseDefault", false, "false");
        areaTextInfo.setPropertyValue(PropertyNames.getDefinitionName(PropertyNames.HorizontalAlignment), 2, EnumerationConstant.ALIGNMENT_HOR_STR_NAMES[2]);
        areaTextInfo.setPropertyValue(PropertyNames.getDefinitionName(PropertyNames.VerticalAlignment), 0, EnumerationConstant.ALIGNMENT_VER_STR_NAMES[0]);
        GeometryObjInfo geometryObjInfo = new GeometryObjInfo(322);
        geometryObjInfo.appendAttachPos(null, n6, n7);
        geometryObjInfo.appendAttachPos(null, n8, n9);
        Vector<GeometryObjInfo> vector = new Vector<GeometryObjInfo>();
        vector.add(geometryObjInfo);
        areaTextInfo.setGeometryInfos(vector);
        return areaTextInfo;
    }

    private static int add(String string) {
        if (add == null) {
            add = new Font(null, 0, ValueToUnit.convertInchToPixel(0.125));
        }
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(add);
        return ValueToUnit.convertPixelToUnit(fontMetrics.stringWidth(string));
    }
}

