/*
 * Decompiled with CFR 0.152.
 */
package jet.util;

import com.jinfonet.util.JRLog;
import java.awt.Image;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import jet.util.ByteArrayConsumer;

public class MessageDigestMaker {
    public static String DEFAULT_ALG = "SHA-1";
    private static final int SEDU = 0x1900000;
    MessageDigest maker;

    public MessageDigestMaker() {
        this(DEFAULT_ALG);
    }

    public MessageDigestMaker(String string) {
        try {
            this.maker = MessageDigest.getInstance(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }

    public int gen(byte[] byArray) {
        byte[] byArray2 = null;
        this.maker.update(byArray);
        byArray2 = this.maker.digest();
        int n = 0;
        for (int i = 0; i < byArray2.length; ++i) {
            n = 31 * n + byArray2[i++];
        }
        return n;
    }

    public Integer generate(byte[] byArray) {
        return new Integer(this.gen(byArray));
    }

    private int DEFAULT_ALG(Image image) {
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        return this.gen(new ByteArrayConsumer(image, 0, 0, n, n2).getPixels());
    }

    private Integer SEDU(Image image) {
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        return this.generate(new ByteArrayConsumer(image, 0, 0, n, n2).getPixels());
    }

    public String generateString(Image image) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = image.getWidth(null);
        if (n2 * (n = image.getHeight(null)) > 0x1900000) {
            int n3;
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "MessageDigestMaker.getnerateString(Image): The image size exceeds the threadhold (26214400). w: " + n2 + ", h: " + n + ".");
            }
            if ((n3 = 0x1900000 / n2) == 0) {
                n3 = 1;
            }
            int n4 = 0;
            for (int i = 0; i < n; i += n3) {
                long l = System.currentTimeMillis();
                if (i + n3 > n) {
                    n3 = n - i;
                }
                byte[] byArray = new ByteArrayConsumer(image, n4, i, n2, n3).getPixels();
                if (stringBuffer.length() > 0) {
                    stringBuffer.append('_');
                }
                stringBuffer.append(String.valueOf(this.gen(byArray)));
                if (!JRLog.isTrace(6)) continue;
                JRLog.trace(6, "Getting pixels from the image. Time cost: " + (System.currentTimeMillis() - l));
            }
        } else {
            byte[] byArray = new ByteArrayConsumer(image, 0, 0, n2, n).getPixels();
            stringBuffer.append(String.valueOf(this.gen(byArray)));
        }
        return stringBuffer.toString();
    }
}

