/*
 * Decompiled with CFR 0.152.
 */
package jet.util;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.util.Vector;
import jet.util.RandomInputOutputable;

public class RandomByteArrayInputOutput
implements RandomInputOutputable {
    public static final int CACHE_SIZE = 40960;
    Vector bytearrays;
    long curpos = 0L;
    byte[] cache = new byte[40960];
    long cachePos = 0L;
    int cacheLen = 0;

    public RandomByteArrayInputOutput() {
        this.bytearrays = new Vector();
        this.bytearrays.addElement(new byte[0]);
    }

    @Override
    public int read() throws IOException {
        int n;
        int n2;
        if (this.curpos >= this.cachePos && this.curpos < this.cachePos + (long)this.cacheLen) {
            ++this.curpos;
            return this.cache[(int)(this.cachePos - this.curpos)];
        }
        if (this.cacheLen != 0) {
            throw new Error();
        }
        if (this.curpos >= Integer.MAX_VALUE) {
            n2 = (int)(this.curpos / Integer.MAX_VALUE);
            n = (int)(this.curpos % Integer.MAX_VALUE);
        } else {
            n2 = 0;
            n = (int)this.curpos;
        }
        byte[] byArray = (byte[])this.bytearrays.elementAt(n2);
        ++this.curpos;
        return byArray[n] & 0xFF;
    }

    private int SEDU(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4;
        if (this.curpos >= this.cachePos && this.curpos + (long)n2 < this.cachePos + (long)this.cacheLen) {
            this.curpos += (long)n2;
            System.arraycopy(this.cache, (int)(this.curpos - this.cachePos), byArray, n, n2);
            return n2;
        }
        if (this.cacheLen != 0) {
            throw new Error();
        }
        if (this.curpos >= Integer.MAX_VALUE) {
            n4 = (int)(this.curpos / Integer.MAX_VALUE);
            n3 = (int)(this.curpos % Integer.MAX_VALUE);
        } else {
            n4 = 0;
            n3 = (int)this.curpos;
        }
        byte[] byArray2 = (byte[])this.bytearrays.elementAt(n4);
        if (n2 > Integer.MAX_VALUE - n3 && n4 + 1 < this.bytearrays.size()) {
            System.arraycopy(byArray2, n3, byArray, n, Integer.MAX_VALUE - n3);
            byArray2 = (byte[])this.bytearrays.elementAt(n4 + 1);
            n2 = n2 > Integer.MAX_VALUE - n3 + byArray2.length - n3 ? Integer.MAX_VALUE - n3 + byArray2.length - n3 : n2;
            System.arraycopy(byArray2, 0, byArray, n + Integer.MAX_VALUE - n3, n2 - (Integer.MAX_VALUE - n3));
        } else {
            n2 = n2 > byArray2.length - n3 ? byArray2.length - n3 : n2;
            System.arraycopy(byArray2, n3, byArray, n, n2);
        }
        this.curpos += (long)n2;
        return n2;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.SEDU(byArray, n, n2);
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.SEDU(byArray, 0, byArray.length);
    }

    @Override
    public final void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    @Override
    public final void readFully(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4 = 0;
        do {
            if ((n3 = this.read(byArray, n + n4, n2 - n4)) >= 0) continue;
            throw new EOFException();
        } while ((n4 += n3) < n2);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        long l;
        if (n <= 0) {
            return 0;
        }
        long l2 = this.getPosition();
        long l3 = l2 + (long)n;
        if (l3 > (l = this.length())) {
            l3 = l;
        }
        this.seek(l3);
        return (int)(l3 - l2);
    }

    @Override
    public void write(int n) throws IOException {
        if (this.cacheLen == 0) {
            this.cachePos = this.curpos;
        }
        if (this.cacheLen < this.cache.length) {
            this.cache[this.cacheLen++] = (byte)n;
            return;
        }
        this.append();
        this.write(n);
    }

    private void addElement(byte[] byArray, int n, int n2) throws IOException {
        if (this.cacheLen == 0) {
            this.cachePos = this.curpos;
        }
        if (this.cache.length - this.cacheLen > n2) {
            System.arraycopy(byArray, n, this.cache, this.cacheLen, n2);
            this.cacheLen += n2;
            return;
        }
        this.append();
        if (n2 > this.cache.length) {
            this.arraycopy(byArray, n, n2);
        } else {
            this.addElement(byArray, n, n2);
        }
    }

    private final void append() throws IOException {
        this.arraycopy(this.cache, 0, this.cacheLen);
        this.cacheLen = 0;
    }

    private final void arraycopy(byte[] byArray, int n, int n2) throws IOException {
        byte[] byArray2;
        int n3;
        int n4;
        if (this.curpos >= Integer.MAX_VALUE) {
            n4 = (int)(this.curpos / Integer.MAX_VALUE);
            n3 = (int)(this.curpos % Integer.MAX_VALUE);
        } else {
            n4 = 0;
            n3 = (int)this.curpos;
        }
        if (n4 > this.bytearrays.size()) {
            this.bytearrays.addElement(new byte[0]);
        }
        if ((byArray2 = (byte[])this.bytearrays.elementAt(n4)).length <= n3) {
            int n5 = n3 + n2;
            byte[] byArray3 = new byte[n5 < 0 ? Integer.MAX_VALUE : n5];
            System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
            this.bytearrays.setElementAt(byArray3, n4);
            byArray2 = byArray3;
            if (n5 < 0 && ++n4 > this.bytearrays.size()) {
                byArray3 = new byte[n2 - (Integer.MAX_VALUE - n3)];
                this.bytearrays.addElement(byArray3);
                System.arraycopy(byArray, Integer.MAX_VALUE - n3, byArray3, 0, byArray3.length);
            }
        }
        System.arraycopy(byArray, n, byArray2, n3, byArray2.length - n3 > n2 ? n2 : byArray2.length - n3);
        this.curpos += (long)n2;
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.addElement(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.addElement(byArray, n, n2);
    }

    @Override
    public void seek(long l) throws IOException {
        long l2;
        if (this.cacheLen != 0) {
            this.append();
        }
        if (l >= (l2 = this.length())) {
            int n;
            int n2;
            if (l >= Integer.MAX_VALUE) {
                n2 = (int)(l / Integer.MAX_VALUE);
                n = (int)(l % Integer.MAX_VALUE);
            } else {
                n2 = 0;
                n = (int)l;
            }
            if (n2 > this.bytearrays.size()) {
                byte[] byArray = (byte[])this.bytearrays.lastElement();
                if (byArray.length < Integer.MAX_VALUE) {
                    byte[] byArray2 = new byte[Integer.MAX_VALUE];
                    System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                    this.bytearrays.removeElement(byArray);
                    this.bytearrays.addElement(byArray2);
                }
                for (int i = 0; i < n2 - this.bytearrays.size() - 1; ++i) {
                    this.bytearrays.addElement(new byte[Integer.MAX_VALUE]);
                }
                this.bytearrays.addElement(new byte[n + 1]);
            }
        }
        this.curpos = l;
    }

    @Override
    public long length() throws IOException {
        return (long)(this.bytearrays.size() - 1) * Integer.MAX_VALUE + (long)((byte[])this.bytearrays.lastElement()).length + (long)this.cacheLen;
    }

    @Override
    public void close() throws IOException {
        this.bytearrays.removeAllElements();
    }

    @Override
    public final boolean readBoolean() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n != 0;
    }

    @Override
    public final byte readByte() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return (byte)n;
    }

    @Override
    public final int readUnsignedByte() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n;
    }

    @Override
    public final short readShort() throws IOException {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (short)((n2 << 8) + (n << 0));
    }

    @Override
    public final int readUnsignedShort() throws IOException {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (n2 << 8) + (n << 0);
    }

    @Override
    public final char readChar() throws IOException {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (char)((n2 << 8) + (n << 0));
    }

    @Override
    public final int readInt() throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = this.read();
        if ((n4 | (n3 = this.read()) | (n2 = this.read()) | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (n4 << 24) + (n3 << 16) + (n2 << 8) + (n << 0);
    }

    @Override
    public final long readLong() throws IOException {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    @Override
    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public final String readLine() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = -1;
        boolean bl = false;
        block4: while (!bl) {
            n = this.read();
            switch (n) {
                case -1: 
                case 10: {
                    bl = true;
                    continue block4;
                }
                case 13: {
                    bl = true;
                    long l = this.getPosition();
                    if (this.read() == 10) continue block4;
                    this.seek(l);
                    continue block4;
                }
            }
            stringBuffer.append((char)n);
        }
        if (n == -1 && stringBuffer.length() == 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    @Override
    public final String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    @Override
    public final void writeBoolean(boolean bl) throws IOException {
        this.write(bl ? 1 : 0);
    }

    @Override
    public final void writeByte(int n) throws IOException {
        this.write(n);
    }

    @Override
    public final void writeShort(int n) throws IOException {
        this.write(n >>> 8 & 0xFF);
        this.write(n >>> 0 & 0xFF);
    }

    @Override
    public final void writeChar(int n) throws IOException {
        this.write(n >>> 8 & 0xFF);
        this.write(n >>> 0 & 0xFF);
    }

    @Override
    public final void writeInt(int n) throws IOException {
        this.write(n >>> 24 & 0xFF);
        this.write(n >>> 16 & 0xFF);
        this.write(n >>> 8 & 0xFF);
        this.write(n >>> 0 & 0xFF);
    }

    @Override
    public final void writeLong(long l) throws IOException {
        this.write((int)(l >>> 56) & 0xFF);
        this.write((int)(l >>> 48) & 0xFF);
        this.write((int)(l >>> 40) & 0xFF);
        this.write((int)(l >>> 32) & 0xFF);
        this.write((int)(l >>> 24) & 0xFF);
        this.write((int)(l >>> 16) & 0xFF);
        this.write((int)(l >>> 8) & 0xFF);
        this.write((int)(l >>> 0) & 0xFF);
    }

    @Override
    public final void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    @Override
    public final void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    @Override
    public final void writeBytes(String string) throws IOException {
        int n = string.length();
        byte[] byArray = new byte[n];
        string.getBytes(0, n, byArray, 0);
        this.addElement(byArray, 0, n);
    }

    @Override
    public final void writeChars(String string) throws IOException {
        int n = string.length();
        int n2 = 2 * n;
        byte[] byArray = new byte[n2];
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            byArray[n3++] = (byte)(cArray[i] >>> 8);
            byArray[n3++] = (byte)(cArray[i] >>> 0);
        }
        this.addElement(byArray, 0, n2);
    }

    @Override
    public final void writeUTF(String string) throws IOException {
        char c;
        int n;
        int n2 = string.length();
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            c = string.charAt(n);
            if (c >= '\u0001' && c <= '\u007f') {
                ++n3;
                continue;
            }
            if (c > '\u07ff') {
                n3 += 3;
                continue;
            }
            n3 += 2;
        }
        if (n3 > 65535) {
            throw new UTFDataFormatException();
        }
        this.write(n3 >>> 8 & 0xFF);
        this.write(n3 >>> 0 & 0xFF);
        for (n = 0; n < n2; ++n) {
            c = string.charAt(n);
            if (c >= '\u0001' && c <= '\u007f') {
                this.write(c);
                continue;
            }
            if (c > '\u07ff') {
                this.write(0xE0 | c >> 12 & 0xF);
                this.write(0x80 | c >> 6 & 0x3F);
                this.write(0x80 | c >> 0 & 0x3F);
                continue;
            }
            this.write(0xC0 | c >> 6 & 0x1F);
            this.write(0x80 | c >> 0 & 0x3F);
        }
    }

    @Override
    public long getPosition() {
        if (this.cacheLen != 0) {
            return this.cachePos + (long)this.cacheLen;
        }
        return this.curpos;
    }

    @Override
    public void saveTo(String string) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        for (int i = 0; i < this.bytearrays.size(); ++i) {
            byte[] byArray = (byte[])this.bytearrays.elementAt(i);
            fileOutputStream.write(byArray);
        }
        fileOutputStream.close();
    }
}

