/*
 * Decompiled with CFR 0.152.
 */
package jet.util;

import com.jinfonet.util.JRLog;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import jet.controls.QueryInfoImpl;
import jet.dataengine.api.DSException;
import jet.dataengine.api.query.DataDescription;
import jet.dataengine.api.query.JDSQuery;
import jet.dataengine.api.query.JDataSourceQuery;
import jet.dataengine.api.query.MappingNameBindInfo;
import jet.formula.JavaFormula;
import jet.formula.JetRptFormula;
import jet.icontrols.QueryInfo;
import jet.ireport.IDataContainer;
import jet.reportLogic.objectLogic.DataContainerLogic;
import jet.reportset.JetRptDataSet;
import jet.reportset.JetRptQueryDataSet;
import jet.reportset.JetRptReportSet;
import jet.rptservice.api.EngineEnv;
import jet.rptservice.api.IDynamicConnectionInfo;
import jet.rptservice.api.IDynamicQueryInfo;
import jet.rptservice.api.IRuntimeQueryInfoProvider;
import jet.rptservice.api.ResultSetProvidor;
import jet.rptservice.api.exception.JRScheduleException;
import jet.rptservice.pub.KeyDataSourceQuery;
import jet.rptservice.pub.RuntimeQueryInfoContainer;
import jet.rptservice.util.DataTools;
import jet.rptservice.util.ReportTools;
import jet.rptservice.util.Tools;
import jet.server.intf.engine.ConnectionInfoProvider;
import jet.universe.JetUConnection;
import jet.universe.JetUDemandQuery;
import jet.universe.JetUJDBCConnection;
import jet.universe.JetUUniverse;
import jet.universe.businesslogic.impl.UnifiedBusinessView;
import jet.universe.dsdriver.UDSDriver;
import jet.universe.dsdriver.UDSDriverFormatException;
import jet.universe.resultfile.CachedQueryResult;
import jet.universe.tools.UniverseTools;
import jet.util.nls.NLSApplyParam;

public class ScheduleTools {
    public static final String DEFAULT_DATA_DRIVER = "CatalogQuery";
    public static final String VIRTUAL_DATA_SET_NAME = "virtual\u0007dataset\u0007name";
    public static final JetRptDataSet virtualDataSet = new JetRptQueryDataSet();
    private static final String SEDU = "virtual\u0007datasource\u0007name";

    public static boolean isValid(IDynamicQueryInfo iDynamicQueryInfo) {
        int n = iDynamicQueryInfo == null ? -1 : iDynamicQueryInfo.getType();
        return iDynamicQueryInfo != null && (n == 1 || n == 3 || n == 2);
    }

    public static boolean isValid(IDynamicConnectionInfo iDynamicConnectionInfo) {
        int n = iDynamicConnectionInfo == null ? -1 : iDynamicConnectionInfo.getType();
        return iDynamicConnectionInfo != null && (n == 1 || n == 2 || n == 3);
    }

    public static final String getCachedResultFile(String string) throws UDSDriverFormatException {
        UDSDriver uDSDriver = null;
        uDSDriver = new UDSDriver(string);
        String[] stringArray = uDSDriver.getParams();
        return stringArray[stringArray.length - 1];
    }

    public static final IRuntimeQueryInfoProvider getRuntimeQueryInfoForDataDriver(String string, JetRptDataSet jetRptDataSet, JetUUniverse jetUUniverse, EngineEnv engineEnv) throws JRScheduleException {
        Object var4_4 = null;
        RuntimeQueryInfoContainer runtimeQueryInfoContainer = null;
        if (string != null && string.length() > 0 && !string.equals(DEFAULT_DATA_DRIVER)) {
            String string2 = jetRptDataSet.getName();
            String string3 = null;
            ResultSet resultSet = null;
            try {
                string3 = ScheduleTools.getCachedResultFile(string);
                resultSet = CachedQueryResult.loadResult(string3, engineEnv.getResourceStore().getDiskStore());
            }
            catch (DSException dSException) {
                throw new JRScheduleException(220011, (Object[])new String[]{string2}, (Throwable)dSException);
            }
            catch (UDSDriverFormatException uDSDriverFormatException) {
                throw new JRScheduleException(220053, (Object[])new String[]{uDSDriverFormatException.getMessage()}, (Throwable)uDSDriverFormatException);
            }
            KeyDataSourceQuery keyDataSourceQuery = ScheduleTools.getAvailableKeyDataSourceQuery(jetRptDataSet.getQueryInfo(), jetUUniverse);
            if (keyDataSourceQuery == null) {
                throw new JRScheduleException(220011, (Object[])new String[]{string2}, null);
            }
            String string4 = keyDataSourceQuery.getDataSourceName();
            String string5 = keyDataSourceQuery.getQueryName();
            runtimeQueryInfoContainer = new RuntimeQueryInfoContainer();
            runtimeQueryInfoContainer.setResultSet(string4, string5, resultSet);
            try {
                runtimeQueryInfoContainer.setBindInfos(string4, string5, DataTools.getMappingNameBindInfos(DataTools.getBindInfoWithMappingNames(resultSet), resultSet));
            }
            catch (DSException dSException) {
                throw new JRScheduleException(220011, (Object[])new String[]{string2}, (Throwable)dSException);
            }
            catch (SQLException sQLException) {
                throw new JRScheduleException(220011, (Object[])new String[]{string2}, (Throwable)sQLException);
            }
        }
        return runtimeQueryInfoContainer == null ? null : runtimeQueryInfoContainer.getRuntimeQueryInfoProvider(jetUUniverse);
    }

    public static List<IDynamicQueryInfo> getValidDynamicQueryInfos(IRuntimeQueryInfoProvider iRuntimeQueryInfoProvider, JetUUniverse jetUUniverse, String string, String string2) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "ScheduleTools.getValidDynamicQueryInfos()..., rqiProvider: " + iRuntimeQueryInfoProvider + " unv: " + jetUUniverse + " dataSourceName: " + string + " queryName: " + string2);
        }
        if (iRuntimeQueryInfoProvider == null) {
            return null;
        }
        ArrayList<IDynamicQueryInfo> arrayList = new ArrayList<IDynamicQueryInfo>();
        List<String> list = UniverseTools.getConnections(jetUUniverse, string, string2);
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "connection names: " + list);
        }
        if (list != null && !list.isEmpty()) {
            for (String string3 : list) {
                IDynamicQueryInfo iDynamicQueryInfo = iRuntimeQueryInfoProvider.getDynamicQueryInfo(string, string3);
                if (iDynamicQueryInfo == null || !ScheduleTools.isValid(iDynamicQueryInfo)) continue;
                arrayList.add(iDynamicQueryInfo);
            }
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of ScheduleTools.getValidDynamicQueryInfos(), return: " + arrayList);
        }
        return arrayList;
    }

    public static void prepareDataDescripionForConstFml(JDataSourceQuery jDataSourceQuery, JetRptFormula[] jetRptFormulaArray) throws DSException {
        DataDescription dataDescription = DataDescription.create(jetRptFormulaArray);
        jDataSourceQuery.getDynamicConnections().put("", dataDescription);
    }

    public static void prepareDynamicQueryInfo(JDataSourceQuery jDataSourceQuery, JetUUniverse jetUUniverse, String string, String string2, String[] stringArray, IDynamicQueryInfo iDynamicQueryInfo) throws DSException, SQLException, JRScheduleException {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "ScheduleTools.prepareDynamicQueryInfo()..., query: " + jDataSourceQuery + " unv: " + jetUUniverse + " dataSourceName: " + string + " queryName: " + string2 + " mappingNames: " + Tools.toString(stringArray) + " dqInfo: " + iDynamicQueryInfo);
        }
        int n = iDynamicQueryInfo.getType();
        switch (n) {
            case 1: {
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "TYPE_RESULT_SET, resultSet: " + iDynamicQueryInfo.getResultSet() + "bindInfo: " + iDynamicQueryInfo.getBindInfo());
                }
                ResultSet resultSet = iDynamicQueryInfo.getResultSet();
                MappingNameBindInfo[] mappingNameBindInfoArray = iDynamicQueryInfo.getBindInfo();
                if (mappingNameBindInfoArray == null) {
                    mappingNameBindInfoArray = DataTools.getMappingNameBindInfos(resultSet, stringArray, jetUUniverse, string, string2);
                }
                jDataSourceQuery.setResultSet(resultSet);
                jDataSourceQuery.setMappingNameBindInfos(mappingNameBindInfoArray);
                break;
            }
            case 3: {
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "TYPE_RESULT_SET_PROVIDER, resultSetProvider: " + iDynamicQueryInfo.getResultSetProvider());
                }
                ResultSetProvidor resultSetProvidor = iDynamicQueryInfo.getResultSetProvider();
                ResultSet resultSet = resultSetProvidor.getResultSet();
                String[][] stringArray2 = resultSetProvidor.getBindInfo();
                if (resultSet == null || stringArray2 == null) {
                    throw new JRScheduleException();
                }
                MappingNameBindInfo[] mappingNameBindInfoArray = DataTools.getMappingNameBindInfos(stringArray2, resultSet);
                jDataSourceQuery.setResultSet(resultSet);
                jDataSourceQuery.setMappingNameBindInfos(mappingNameBindInfoArray);
                break;
            }
            case 2: {
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "TYPE_RUNNER, runner: " + iDynamicQueryInfo.getExternalQueryRunner());
                }
                jDataSourceQuery.setExternalQueryRunner(iDynamicQueryInfo.getExternalQueryRunner());
                break;
            }
            default: {
                if (!JRLog.isTrace(6)) break;
                JRLog.trace(6, "invalid type: " + n);
            }
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of ScheduleTools.prepareDynamicQueryInfo().");
        }
    }

    public static void prepareDynamicConnectionInfo(JDSQuery jDSQuery, JetUUniverse jetUUniverse, String string, String string2, IRuntimeQueryInfoProvider iRuntimeQueryInfoProvider) throws DSException {
        List<String> list = UniverseTools.getConnections(jetUUniverse, string, string2);
        if (list != null && !list.isEmpty()) {
            for (String string3 : list) {
                Object object;
                IDynamicConnectionInfo iDynamicConnectionInfo = iRuntimeQueryInfoProvider.getDynamicConnectionInfo(string, string3);
                if (ScheduleTools.isValid(iDynamicConnectionInfo)) {
                    object = ScheduleTools.getConnectionInfo(iDynamicConnectionInfo, jetUUniverse, string, string3);
                    if (iDynamicConnectionInfo.getType() != 3 || object != null) {
                        ScheduleTools.SEDU(jDSQuery, jetUUniverse, string, string3, iDynamicConnectionInfo);
                    }
                }
                if ((object = iRuntimeQueryInfoProvider.getDatabaseMetadataInfo(string, string3)) == null) continue;
                jDSQuery.getDynamicDatabaseMetadataInfos().put(string3, object);
            }
        }
    }

    private static void SEDU(JDSQuery jDSQuery, JetUUniverse jetUUniverse, String string, String string2, IDynamicConnectionInfo iDynamicConnectionInfo) throws DSException {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "ScheduleTools.prepareDynamicConnectionInfo()..., query: " + jDSQuery + " unv: " + jetUUniverse + " dataSourceName: " + string + " connName: " + string2 + " dcInfo: " + iDynamicConnectionInfo);
        }
        JetUConnection jetUConnection = jetUUniverse.getDatabase(string).getConnectionByResourceName(string2);
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "connection: " + jetUConnection);
        }
        if (!(jetUConnection instanceof JetUJDBCConnection)) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "The specified connection is not JetUJDBCConnection, ignore it.");
                JRLog.trace(6, "End of ScheduleTools.prepareDynamicConnectionInfo().");
            }
            return;
        }
        JetUJDBCConnection jetUJDBCConnection = (JetUJDBCConnection)jetUConnection;
        DataDescription dataDescription = null;
        int n = iDynamicConnectionInfo.getType();
        switch (n) {
            case 1: {
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "TYPE_CONNECTION, connection: " + iDynamicConnectionInfo.getConnection());
                }
                Connection connection = iDynamicConnectionInfo.getConnection();
                dataDescription = DataDescription.create(connection);
                break;
            }
            case 2: {
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "TYPE_DRIVER_URL," + new StringBuffer().append(" jdbcDriver: " + iDynamicConnectionInfo.getJdbcDriver()).append(" url: " + iDynamicConnectionInfo.getUrl()).append(" userId: ******").append(" passwd: ******").toString());
                }
                String string3 = iDynamicConnectionInfo.getJdbcDriver();
                String string4 = iDynamicConnectionInfo.getUrl();
                if (string3 != null && string3.trim().length() == 0) {
                    string3 = null;
                }
                if (string4 != null && string4.trim().length() == 0) {
                    string4 = null;
                }
                if (string3 == null) {
                    string3 = jetUJDBCConnection.getJdbcDriver();
                }
                if (string4 == null) {
                    string4 = jetUJDBCConnection.getURL();
                }
                dataDescription = DataDescription.create(string3, string4, iDynamicConnectionInfo.getUserId(), iDynamicConnectionInfo.getPassword());
                break;
            }
            case 3: {
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "TYPE_CONNECTION_INFO_PROVIDER");
                }
                dataDescription = DataDescription.create(ScheduleTools.getConnectionInfo(iDynamicConnectionInfo, jetUUniverse, string, string2));
                break;
            }
            default: {
                if (!JRLog.isTrace(6)) break;
                JRLog.trace(6, "invalid type: " + n);
            }
        }
        if (dataDescription != null) {
            jDSQuery.getDynamicConnections().put(string2, dataDescription);
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of ScheduleTools.prepareDynamicConnectionInfo().");
        }
    }

    public static void prepareWhereString(JDataSourceQuery jDataSourceQuery, String string, String string2) throws DSException {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "set where string: " + string);
        }
        jDataSourceQuery.setWherePortion(string);
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "set security where string: " + string2);
        }
        jDataSourceQuery.setPolicy(string2);
    }

    public static Properties getConnectionInfo(IDynamicConnectionInfo iDynamicConnectionInfo, JetUUniverse jetUUniverse, String string, String string2) {
        Properties properties;
        block4: {
            properties = null;
            if (iDynamicConnectionInfo.getType() == 3) {
                ConnectionInfoProvider connectionInfoProvider = iDynamicConnectionInfo.getConnectionInfoProvider();
                JetUConnection jetUConnection = jetUUniverse.getDatabase(string).getConnectionByResourceName(string2);
                if (jetUConnection != null) {
                    String string3 = jetUConnection.getResourceName();
                    try {
                        properties = connectionInfoProvider.getConnectionInfo(string3);
                    }
                    catch (RemoteException remoteException) {
                        if (!JRLog.isError(2)) break block4;
                        JRLog.error(2, remoteException);
                    }
                }
            }
        }
        return properties;
    }

    public static JetRptDataSet getRawQueryDataSet(IDataContainer iDataContainer) {
        DataContainerLogic dataContainerLogic = ReportTools.getDataContainerLogic(iDataContainer);
        JetRptDataSet jetRptDataSet = (JetRptDataSet)dataContainerLogic.getUsedDataSet(iDataContainer);
        if (jetRptDataSet == null) {
            jetRptDataSet = virtualDataSet;
        }
        return jetRptDataSet;
    }

    public static JetRptDataSet getRawQueryDataSet(String string, JetRptReportSet jetRptReportSet) {
        if (VIRTUAL_DATA_SET_NAME.equals(string)) {
            return virtualDataSet;
        }
        return jetRptReportSet.getDataSet(string);
    }

    public static HashMap<String, String>[] getDataMapping(NLSApplyParam nLSApplyParam, JetUUniverse jetUUniverse, QueryInfo queryInfo) {
        Object object;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "ScheduleTools.getDataMapping()..., nlsParam: " + nLSApplyParam + " QueryInfo: [dataSouceName:" + queryInfo.getDatasourceName() + " queryName: " + queryInfo.getQueryName() + " dataResourceType: " + queryInfo.getDataResoureType() + " blName: " + queryInfo.getBLName() + "]");
        }
        if (SEDU.equals(queryInfo.getDatasourceName())) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "virtual data source, doesn't set data mapping.");
                JRLog.trace(6, "End of ScheduleTools.setDataMapping().");
            }
            return null;
        }
        HashMap<String, String> hashMap = null;
        HashMap<String, String> hashMap2 = null;
        if (jetUUniverse != null && queryInfo.getDataResoureType() != 3 && nLSApplyParam.getNLSModel() == 1) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "enable apply nls.");
            }
            if (queryInfo.getDataResoureType() == 2) {
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "prepare to getDataMappingBundlePrefix,  businessType: BV");
                }
                if ((object = ScheduleTools.getAvailableKeyDataSourceQuery(queryInfo, jetUUniverse)) != null) {
                    String string = ((KeyDataSourceQuery)object).getDataSourceName();
                    String string2 = ((KeyDataSourceQuery)object).getQueryName();
                    String string3 = queryInfo.getBLName();
                    Map<String, String> map = jetUUniverse.getDataMappingBundlePrefix(string, string3, 1);
                    Map<String, String> map2 = jetUUniverse.getDataMappingBundlePrefix(string, string2, 2);
                    hashMap = new HashMap();
                    if (map != null) {
                        ScheduleTools.add(map, hashMap);
                    }
                    if (map2 != null) {
                        ScheduleTools.add(map2, hashMap);
                    }
                }
            } else {
                object = jetUUniverse.getDataMappingBundlePrefix(queryInfo.getDatasourceName(), queryInfo.getQueryName(), 2);
                if (object != null) {
                    hashMap = new HashMap<String, String>();
                    ScheduleTools.add((Map<String, String>)object, hashMap);
                }
            }
            object = jetUUniverse.getParameterDataMappingBundlePrefix(queryInfo.getDatasourceName());
            if (object != null) {
                hashMap2 = new HashMap<String, String>();
                ScheduleTools.add((Map<String, String>)object, hashMap2);
            }
        }
        object = null;
        if (hashMap != null || hashMap2 != null) {
            object = new HashMap[]{hashMap, hashMap2};
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of ScheduleTools.getDataMapping(), return: " + Tools.toString(object));
        }
        return object;
    }

    public static void setDataMapping(JavaFormula javaFormula, NLSApplyParam nLSApplyParam, JetUUniverse jetUUniverse, QueryInfo queryInfo) {
        HashMap<String, String>[] hashMapArray;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "ScheduleTools.setDataMapping()..., + jf: " + javaFormula + " nlsParam: " + nLSApplyParam + " QueryInfo: [dataSouceName:" + queryInfo.getDatasourceName() + " queryName: " + queryInfo.getQueryName() + " dataResourceType: " + queryInfo.getDataResoureType() + " blName: " + queryInfo.getBLName() + "]");
        }
        if ((hashMapArray = ScheduleTools.getDataMapping(nLSApplyParam, jetUUniverse, queryInfo)) != null) {
            HashMap<String, String> hashMap = hashMapArray[0];
            HashMap<String, String> hashMap2 = hashMapArray[1];
            if (hashMap != null) {
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "apply field data mapping...");
                }
                javaFormula.setFieldDataMapping(hashMap);
            }
            if (hashMap2 != null) {
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "apply parameter data mapping...");
                }
                javaFormula.setParamDataMapping(hashMap2);
            }
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of ScheduleTools.setDataMapping().");
        }
    }

    private static void add(Map<String, String> map, Map<String, String> map2) {
        if (map != null && map2 != null) {
            Set<String> set = map.keySet();
            for (String string : set) {
                String string2 = map.get(string);
                if (string2 == null || !string2.trim().equals("")) {
                    // empty if block
                }
                map2.put(string, string2);
            }
        }
    }

    public static KeyDataSourceQuery getAvailableKeyDataSourceQuery(QueryInfo queryInfo, JetUUniverse jetUUniverse) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "ScheduleTools.getAvailableKeyDataSourceQuery()..., queryInfo: " + queryInfo + "dataSourceName: " + queryInfo.getDatasourceName() + " queryName: " + queryInfo.getQueryName() + " blName: " + queryInfo.getBLName() + " dataResourceType: " + queryInfo.getDataResoureType());
        }
        KeyDataSourceQuery keyDataSourceQuery = null;
        QueryInfo queryInfo2 = ScheduleTools.getAvailableQueryInfo(queryInfo, jetUUniverse);
        if (queryInfo2 != null) {
            keyDataSourceQuery = new KeyDataSourceQuery(queryInfo2.getDatasourceName(), queryInfo2.getQueryName());
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of ScheduleTools.getAvailableKeyDataSourceQuery(), return: " + keyDataSourceQuery);
        }
        return keyDataSourceQuery;
    }

    public static QueryInfo getAvailableQueryInfo(QueryInfo queryInfo, JetUUniverse jetUUniverse) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "ScheduleTools.getAvailableQueryInfo()..., queryInfo: " + queryInfo + "dataSourceName: " + queryInfo.getDatasourceName() + " queryName: " + queryInfo.getQueryName() + " blName: " + queryInfo.getBLName() + " dataResourceType: " + queryInfo.getDataResoureType());
        }
        QueryInfo queryInfo2 = null;
        String string = queryInfo.getDatasourceName();
        int n = queryInfo.getDataResoureType();
        switch (n) {
            case 0: {
                queryInfo2 = queryInfo;
                break;
            }
            case 2: {
                UnifiedBusinessView unifiedBusinessView = jetUUniverse.getBV(string, queryInfo.getBLName());
                if (unifiedBusinessView != null) {
                    JetUDemandQuery jetUDemandQuery = unifiedBusinessView.getQuery();
                    queryInfo2 = new QueryInfoImpl(queryInfo.getCatalogName(), queryInfo.getDatasourceName(), jetUDemandQuery.getResourceName(), queryInfo.getBLName(), queryInfo.getDataResoureType());
                    break;
                }
                if (!JRLog.isTrace(6)) break;
                JRLog.trace(6, "bv doesn't exist.");
                break;
            }
            default: {
                if (!JRLog.isTrace(6)) break;
                JRLog.trace(6, "invalid data resource type: " + n);
            }
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of ScheduleTools.getAvailableQueryInfo(), return: " + queryInfo2);
        }
        return queryInfo2;
    }

    static {
        virtualDataSet.setInstNameDirectly(VIRTUAL_DATA_SET_NAME);
        virtualDataSet.setDataSourceName(SEDU);
        virtualDataSet.setQueryName("virtual\u0007query\u0007name");
    }
}

