/*
 * Decompiled with CFR 0.152.
 */
package jet.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import jet.log.JRLogger;
import jet.util.JStringBuffer;
import jet.util.StringToolKit;

public class StringFormatCheck {
    private static final char SEDU = '_';
    private static final char append = '%';
    private static final char charAt = '[';
    private static final char clear = ']';
    private static final char compile = '?';
    private static JRLogger equals = JRLogger.getLogger(StringFormatCheck.class.getName());

    public static boolean checkString(String string, String string2) {
        if (string == null || string.equals("") || string2 == null || string2.equals("")) {
            return true;
        }
        try {
            string = StringFormatCheck.SEDU(string);
            Pattern pattern = Pattern.compile(string);
            Matcher matcher = pattern.matcher(string2);
            return matcher.matches();
        }
        catch (PatternSyntaxException patternSyntaxException) {
            if (equals.isErrorEnabled()) {
                equals.error("Invalid user defined format " + patternSyntaxException + "!");
            }
            return false;
        }
    }

    private static String SEDU(String string) {
        string = StringFormatCheck.append(string, '_');
        string = StringFormatCheck.append(string, '?');
        string = StringToolKit.replaceAll(string, "*", ".*");
        string = StringToolKit.replaceAll(string, "%", ".*");
        return string;
    }

    private static String append(String string, char c) {
        int n = 0;
        JStringBuffer jStringBuffer = new JStringBuffer();
        int n2 = string.indexOf(c);
        while (n2 != -1) {
            if (n2 < string.length() && string.charAt(n2) == c) {
                ++n2;
                ++n;
                jStringBuffer.append(c);
                continue;
            }
            string = StringToolKit.replaceAll(string, jStringBuffer.toString(), ".{" + n + "}");
            jStringBuffer.clear();
            n = 0;
            n2 = string.indexOf(c);
        }
        return string;
    }

    public static int formatCount(String string) {
        if (string.equals("")) {
            return 0;
        }
        int n = 0;
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            String string2;
            char c = cArray[i];
            if (c == '%') continue;
            if (c == '[' && (string2 = string.substring(i)).indexOf(93) != -1) {
                string2 = string2.substring(0, string2.indexOf(93));
                i += string2.length();
            }
            ++n;
        }
        return n;
    }
}

