/*
 * Decompiled with CFR 0.152.
 */
package jet.util;

import com.jinfonet.util.JRLog;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Hashtable;
import java.util.Vector;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import jet.naming.EnumerationConstant;
import jet.report.JetRptObject;
import jet.report.JetRptPicture;
import jet.report.JetRptTextBox;
import jet.report.JetTxtFieldImpl;
import jet.report.paragraph.build.JetRptParagraph;
import jet.reportLogic.objectLogic.BasicComponentLogic;
import jet.reportLogic.objectLogic.ObjectLogicFactory;
import jet.reportLogic.objectLogic.ParagraphLogic;
import jet.reportLogic.objectLogic.paragraphLogic.ParagraphConstant;
import jet.reportLogic.objectLogic.paragraphLogic.StyleTypeDef;
import jet.textobj.ChrObj;
import jet.textobj.DblLinkable;
import jet.textobj.DestVect;
import jet.textobj.DocObj;
import jet.textobj.FieldDest;
import jet.textobj.KwdObj;
import jet.textobj.Obj;
import jet.textobj.ObjVect;
import jet.textobj.ParObj;
import jet.textobj.PictDest;
import jet.textobj.RtfDest;
import jet.textobj.SecObj;
import jet.textobj.rtf.ParseException;
import jet.textobj.rtf.RTFParser;
import jet.util.ValueToUnit;

public class TextBoxUitl {
    private ParagraphLogic SEDU = ObjectLogicFactory.getParagraphLogic();
    private BasicComponentLogic STRIKETHROUGH_NAME = ObjectLogicFactory.getBasicComponentLogic();
    public static final int IMPORT_TEXTFILE = 1;
    public static final int IMPORT_RTFFILE = 2;
    private static TextBoxUitl SUPERSUBSCRIPT_NAME;

    public static TextBoxUitl getTextBoxUtilInstance() {
        if (SUPERSUBSCRIPT_NAME == null) {
            SUPERSUBSCRIPT_NAME = new TextBoxUitl();
        }
        return SUPERSUBSCRIPT_NAME;
    }

    public JetRptTextBox buildTextBoxInImport(InputStream inputStream, int n) throws IOException {
        JetRptParagraph[] jetRptParagraphArray;
        JetRptTextBox jetRptTextBox = new JetRptTextBox();
        jetRptTextBox.setEditable();
        if (n == 2) {
            RtfDest rtfDest;
            block8: {
                RTFParser rTFParser = new RTFParser(inputStream, null);
                rtfDest = null;
                try {
                    rtfDest = rTFParser.rtf();
                }
                catch (ParseException parseException) {
                    if (JRLog.isError(3)) {
                        JRLog.error(3, 2210500, parseException.getMessage());
                    }
                    throw new IOException(parseException.getMessage());
                }
                catch (NullPointerException nullPointerException) {
                    if (!JRLog.isError(3)) break block8;
                    JRLog.error(3, 2210500, nullPointerException.getMessage());
                }
            }
            jetRptParagraphArray = this.paragraphesInRtf(rtfDest);
            if (rtfDest != null) {
                this.afterSpacing(jetRptTextBox, (DocObj)rtfDest.getHead(), this.STRIKETHROUGH_NAME(rtfDest));
            }
        } else {
            jetRptParagraphArray = this.paragraphesInImport(inputStream, n);
        }
        for (int i = 0; i < jetRptParagraphArray.length; ++i) {
            this.STRIKETHROUGH_NAME.add(jetRptTextBox, jetRptParagraphArray[i]);
        }
        return jetRptTextBox;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JetRptParagraph[] paragraphesInImport(InputStream inputStream, int n) throws IOException {
        JetRptParagraph[] jetRptParagraphArray = null;
        switch (n) {
            case 1: {
                try {
                    return this.paragraphesInText(new InputStreamReader(inputStream));
                }
                catch (NullPointerException nullPointerException) {
                    if (!JRLog.isError(3)) return jetRptParagraphArray;
                    JRLog.error(3, 2210500, nullPointerException.getMessage());
                }
                return jetRptParagraphArray;
            }
            case 2: {
                RTFParser rTFParser = new RTFParser(inputStream, null);
                RtfDest rtfDest = null;
                try {
                    rtfDest = rTFParser.rtf();
                    return this.paragraphesInRtf(rtfDest);
                }
                catch (ParseException parseException) {
                    if (!JRLog.isError(3)) throw new IOException(parseException.getMessage());
                    JRLog.error(3, 2210500, parseException.getMessage());
                    throw new IOException(parseException.getMessage());
                }
                catch (NullPointerException nullPointerException) {
                    if (!JRLog.isError(3)) return this.paragraphesInRtf(rtfDest);
                    JRLog.error(3, 2210500, nullPointerException.getMessage());
                }
                return this.paragraphesInRtf(rtfDest);
            }
            default: {
                return new JetRptParagraph[0];
            }
        }
    }

    public JetRptParagraph[] paragraphesInText(Reader reader) throws IOException {
        JetRptParagraph[] jetRptParagraphArray;
        BufferedReader bufferedReader = new BufferedReader(reader);
        String string = "";
        Vector<JetRptParagraph[]> vector = new Vector<JetRptParagraph[]>();
        while ((string = bufferedReader.readLine()) != null) {
            jetRptParagraphArray = this.SEDU.createParagraphObject();
            this.SEDU.insertText((JetRptParagraph)jetRptParagraphArray, 0, string);
            vector.add(jetRptParagraphArray);
        }
        jetRptParagraphArray = new JetRptParagraph[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            jetRptParagraphArray[i] = (JetRptParagraph)vector.get(i);
        }
        vector.clear();
        return jetRptParagraphArray;
    }

    public JetRptParagraph[] paragraphesInRtf(RtfDest rtfDest) {
        Object object;
        if (rtfDest == null) {
            return new JetRptParagraph[0];
        }
        Vector<JetRptParagraph> vector = new Vector<JetRptParagraph>();
        Hashtable hashtable = this.SEDU(rtfDest);
        Vector vector2 = this.STRIKETHROUGH_NAME(rtfDest);
        for (DocObj docObj = (DocObj)rtfDest.getHead(); docObj != null; docObj = (DocObj)docObj.getNext()) {
            for (SecObj secObj = (SecObj)docObj.getHead(); secObj != null; secObj = (SecObj)secObj.getNext()) {
                object = (JetRptParagraph[])secObj.getHead();
                while (object != null) {
                    JetRptParagraph jetRptParagraph = this.SEDU.createParagraphObject();
                    this.SUPERSUBSCRIPT_NAME(jetRptParagraph, rtfDest, hashtable);
                    this.TRUE(jetRptParagraph, docObj, vector2);
                    this.TYPE_NAME(jetRptParagraph, secObj);
                    this.UNDERLINE_STYLE_NAME(jetRptParagraph, (ParObj)object);
                    DblLinkable dblLinkable = object.getHead();
                    this.abs(jetRptParagraph, dblLinkable, vector2, hashtable);
                    vector.add(jetRptParagraph);
                    dblLinkable = object.getNext();
                    if (dblLinkable instanceof ParObj) {
                        object = (ParObj)dblLinkable;
                        continue;
                    }
                    object = null;
                }
            }
        }
        hashtable.clear();
        hashtable = null;
        vector2.clear();
        vector2 = null;
        int n = vector.size();
        object = new JetRptParagraph[n];
        for (int i = 0; i < n; ++i) {
            object[i] = (JetRptParagraph)vector.get(i);
        }
        vector.clear();
        return object;
    }

    private Hashtable SEDU(RtfDest rtfDest) {
        DestVect destVect = (DestVect)rtfDest.getObjValue("fonttbl");
        int n = destVect.size();
        Hashtable<Integer, String> hashtable = new Hashtable<Integer, String>();
        for (int i = 0; i < n; ++i) {
            Obj obj = destVect.getSubProp(i);
            Integer n2 = obj.getIntValue("f");
            String string = obj.getCharsValue("fontname").toString();
            if (string.endsWith(";") && string.length() > 1) {
                string = string.substring(0, string.length() - 1);
            }
            hashtable.put(n2, string);
        }
        return hashtable;
    }

    private Vector STRIKETHROUGH_NAME(RtfDest rtfDest) {
        DestVect destVect = (DestVect)rtfDest.getObjValue("colortbl");
        int n = destVect.size();
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < n; ++i) {
            Obj obj = destVect.getSubProp(i);
            String string = Integer.toHexString(obj.getIntValue("red"));
            String string2 = Integer.toHexString(obj.getIntValue("green"));
            String string3 = Integer.toHexString(obj.getIntValue("blue"));
            if (string.length() < 2) {
                string = '0' + string;
            }
            if (string2.length() < 2) {
                string2 = '0' + string2;
            }
            if (string3.length() < 2) {
                string3 = '0' + string3;
            }
            vector.add("0x" + string + string2 + string3);
        }
        return vector;
    }

    private void SUPERSUBSCRIPT_NAME(JetRptParagraph jetRptParagraph, RtfDest rtfDest, Hashtable hashtable) {
        if (rtfDest.hasProp("deff")) {
            int n = (Integer)rtfDest.getPropValue("deff");
            jetRptParagraph.fontFace.set((String)hashtable.get(n));
        }
    }

    private void TRUE(JetRptParagraph jetRptParagraph, DocObj docObj, Vector vector) {
        int n;
        int n2 = -1;
        if (docObj.hasValue("docfmt.deftab") && (n2 = (int)ValueToUnit.convertTwipToUnit(docObj.getIntValue("docfmt.deftab"))) != 0) {
            jetRptParagraph.tabDefaultStop.setUnitValue(n2);
        }
        if (docObj.hasValue("docfmt.margb")) {
            n2 = (int)ValueToUnit.convertTwipToUnit(docObj.getIntValue("docfmt.margb"));
            jetRptParagraph.bottomMargin.setUnitValue(n2);
        }
        if (docObj.hasValue("docfmt.margl")) {
            n2 = (int)ValueToUnit.convertTwipToUnit(docObj.getIntValue("docfmt.margl"));
            jetRptParagraph.leftMargin.setUnitValue(n2);
        }
        if (docObj.hasValue("docfmt.margr")) {
            n2 = (int)ValueToUnit.convertTwipToUnit(docObj.getIntValue("docfmt.margr"));
            jetRptParagraph.rightMargin.setUnitValue(n2);
        }
        if (docObj.hasValue("docfmt.margt")) {
            n2 = (int)ValueToUnit.convertTwipToUnit(docObj.getIntValue("docfmt.margt"));
            jetRptParagraph.topMargin.setUnitValue(n2);
        }
        if (docObj.hasValue("docfmt.docbk") && (n = docObj.getIntValue("docfmt.docbk")) >= 0 && n < vector.size()) {
            String string = (String)vector.get(n);
            jetRptParagraph.backColor.set(string);
        }
    }

    private void TYPE_NAME(JetRptParagraph jetRptParagraph, SecObj secObj) {
    }

    private void UNDERLINE_STYLE_NAME(JetRptParagraph jetRptParagraph, ParObj parObj) {
        int n;
        if (parObj.hasValue("parfmt.paraalign")) {
            switch (parObj.getIntValue("parfmt.paraalign")) {
                case 0: {
                    jetRptParagraph.horiAlignment.set(0);
                    break;
                }
                case 1: {
                    jetRptParagraph.horiAlignment.set(1);
                    break;
                }
                case 3: {
                    jetRptParagraph.horiAlignment.set(2);
                    break;
                }
                default: {
                    jetRptParagraph.horiAlignment.set(3);
                }
            }
        }
        if (parObj.hasValue("parfmt.fi")) {
            n = (int)ValueToUnit.convertTwipToUnit(parObj.getIntValue("parfmt.fi"));
            if (n >= 0) {
                jetRptParagraph.lineIndentation.setUnitValue(n);
            } else {
                jetRptParagraph.hangIndentation.setUnitValue(Math.abs(n));
            }
        }
        if (parObj.hasValue("parfmt.li")) {
            n = (int)ValueToUnit.convertTwipToUnit(parObj.getIntValue("parfmt.li"));
            jetRptParagraph.leftIndentation.setUnitValue(n);
        }
        if (parObj.hasValue("parfmt.ri")) {
            n = (int)ValueToUnit.convertTwipToUnit(parObj.getIntValue("parfmt.ri"));
            jetRptParagraph.rightIndentation.setUnitValue(n);
        }
        if (parObj.hasValue("parfmt.sl")) {
            n = (int)ValueToUnit.convertTwipToUnit(parObj.getIntValue("parfmt.sl"));
            jetRptParagraph.lineSpacing.setUnitValue(n);
        }
        if (parObj.hasValue("parfmt.slmult")) {
            switch (parObj.getIntValue("parfmt.slmult")) {
                case 0: {
                    jetRptParagraph.lineSpacingType.set(false);
                    break;
                }
                case 1: {
                    jetRptParagraph.lineSpacingType.set(true);
                    break;
                }
            }
        }
        if (parObj.hasValue("parfmt.sa")) {
            n = (int)ValueToUnit.convertTwipToUnit(parObj.getIntValue("parfmt.sa"));
            jetRptParagraph.afterSpacing.setUnitValue(n);
        }
        if (parObj.hasValue("parfmt.sb")) {
            n = (int)ValueToUnit.convertTwipToUnit(parObj.getIntValue("parfmt.sb"));
            jetRptParagraph.beforeSpacing.setUnitValue(n);
        }
        if (parObj.hasValue("parfmt.tabdefs")) {
            ObjVect objVect = (ObjVect)parObj.getObjValue("parfmt.tabdefs");
            int n2 = objVect.size();
            for (int i = 0; i < n2; ++i) {
                Obj obj = objVect.getSubProp(i);
                int n3 = obj.getIntValue("tabstyle");
                double d = obj.getFlagValue("tabstyle");
                int n4 = obj.getIntValue("tablead");
                if (n3 == 1) {
                    n3 = 0;
                } else if (n3 == 2) {
                    n3 = 0;
                }
                d = ValueToUnit.convertTwipToUnit(d);
                switch (n4) {
                    case 1: {
                        n4 = 1;
                        break;
                    }
                    case 2: {
                        n4 = 0;
                        break;
                    }
                    case 3: {
                        n4 = 3;
                        break;
                    }
                    case 4: {
                        n4 = 2;
                        break;
                    }
                    case 5: {
                        n4 = 4;
                    }
                }
                jetRptParagraph.tabAlignmentSet.add("" + n3);
                jetRptParagraph.tabStopPosition.add("" + (int)d);
                jetRptParagraph.tabLeaderSet.add("" + n4);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void abs(JetRptParagraph jetRptParagraph, DblLinkable dblLinkable, Vector vector, Hashtable hashtable) {
        int n = 0;
        while (dblLinkable != null) {
            block28: {
                if (dblLinkable instanceof ChrObj) {
                    Object object;
                    ChrObj chrObj = (ChrObj)dblLinkable;
                    if (chrObj.getHead() instanceof PictDest) {
                        try {
                            Object object2;
                            object = new JetRptPicture();
                            ((JetRptPicture)object).setEditable();
                            Image image = ((PictDest)chrObj.getHead()).getImg();
                            if (image == null) {
                                if (!JRLog.isTrace(5)) continue;
                                JRLog.trace(5, "image null, may be img can not be decode");
                                continue;
                            }
                            BufferedImage bufferedImage = null;
                            int n2 = image.getWidth(null);
                            int n3 = image.getHeight(null);
                            if (image instanceof BufferedImage) {
                                bufferedImage = (BufferedImage)image;
                            } else {
                                bufferedImage = new BufferedImage(n2, n3, 1);
                                object2 = bufferedImage.createGraphics();
                                ((Graphics)object2).drawImage(image, 0, 0, null);
                                image.flush();
                            }
                            object2 = ImageIO.getImageWritersByMIMEType("image/jpeg");
                            ImageWriter imageWriter = object2.hasNext() ? (ImageWriter)object2.next() : null;
                            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                            ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(byteArrayOutputStream);
                            try {
                                imageWriter.setOutput(imageOutputStream);
                                imageOutputStream.flush();
                                imageWriter.write(new IIOImage(bufferedImage, null, null));
                                imageOutputStream.flush();
                                imageWriter.dispose();
                                imageWriter = null;
                            }
                            finally {
                                if (imageWriter != null) {
                                    imageWriter.dispose();
                                }
                                try {
                                    imageOutputStream.close();
                                }
                                catch (Throwable throwable) {
                                }
                                finally {
                                    imageOutputStream = null;
                                }
                            }
                            byte[] byArray = byteArrayOutputStream.toByteArray();
                            ((JetRptPicture)object).setEmbedImage(byArray);
                            if (n2 == 0 || n3 == 0) {
                                ((JetRptPicture)object).autosize.set(true);
                            } else {
                                float f = (float)((PictDest)chrObj.getHead()).getIntValue("picscalex") / 100.0f;
                                float f2 = (float)((PictDest)chrObj.getHead()).getIntValue("picscaley") / 100.0f;
                                int n4 = ((PictDest)chrObj.getHead()).getIntValue("picwgoal");
                                int n5 = ((PictDest)chrObj.getHead()).getIntValue("pichgoal");
                                ((JetRptPicture)object).width.setUnitValue((int)ValueToUnit.convertTwipToUnit((float)n4 * f));
                                ((JetRptPicture)object).height.setUnitValue((int)ValueToUnit.convertTwipToUnit((float)n5 * f2));
                            }
                            ((JetRptPicture)object).position.set("static");
                            this.SEDU.insertReplaceElement(jetRptParagraph, n, (JetRptObject)object);
                            ++n;
                        }
                        catch (IOException iOException) {
                            if (JRLog.isError(2)) {
                                JRLog.error(2, 2210501, iOException.getMessage());
                            }
                            break block28;
                        }
                    }
                    object = chrObj.getText().toString();
                    int n6 = ((String)object).length();
                    int n7 = this.SEDU.getParagraphSize(jetRptParagraph);
                    this.SEDU.insertText(jetRptParagraph, n7, (String)object);
                    this.add(jetRptParagraph, n, n + n6, chrObj, vector, hashtable);
                    n += n6;
                } else {
                    if (((KwdObj)dblLinkable).isKwd(630)) break;
                    if (((KwdObj)dblLinkable).isKwd(895)) {
                        this.SEDU.insertText(jetRptParagraph, n, "\t");
                        ++n;
                    }
                }
            }
            dblLinkable = ((Obj)dblLinkable).getNextLeaf();
        }
    }

    private void add(JetRptParagraph jetRptParagraph, int n, int n2, ChrObj chrObj, Vector vector, Hashtable hashtable) {
        int n3;
        String string = "";
        String string2 = "";
        if (chrObj.hasValue("chrfmt.b")) {
            string2 = StyleTypeDef.TYPE_NAME[1];
            string = "" + chrObj.getBooleanValue("chrfmt.b");
            this.SEDU.applyTextStyle(jetRptParagraph, n, n2, string2, string);
        }
        if (chrObj.hasValue("chrfmt.i")) {
            string2 = StyleTypeDef.TYPE_NAME[2];
            string = "" + chrObj.getBooleanValue("chrfmt.i");
            this.SEDU.applyTextStyle(jetRptParagraph, n, n2, string2, string);
        }
        if (chrObj.hasValue("chrfmt.f") && (string = (String)hashtable.get(n3 = chrObj.getIntValue("chrfmt.f"))) != null) {
            string2 = StyleTypeDef.TYPE_NAME[0];
            this.SEDU.applyTextStyle(jetRptParagraph, n, n2, string2, string);
        }
        if (chrObj.hasValue("chrfmt.fs")) {
            double d = chrObj.getIntValue("chrfmt.fs") / 2;
            string = "" + ValueToUnit.convertPointToUnit(d);
            string2 = StyleTypeDef.TYPE_NAME[3];
            this.SEDU.applyTextStyle(jetRptParagraph, n, n2, string2, string);
        }
        if (chrObj.hasValue("chrfmt.cb") && (n3 = chrObj.getIntValue("chrfmt.cb")) >= 0 && n3 < vector.size()) {
            string = (String)vector.get(n3);
            if (string == null) {
                string = "Transparent";
            }
            string2 = StyleTypeDef.TYPE_NAME[4];
            this.SEDU.applyTextStyle(jetRptParagraph, n, n2, string2, string);
        }
        if (chrObj.hasValue("chrfmt.cf") && (n3 = chrObj.getIntValue("chrfmt.cf")) < vector.size() && n3 >= 0 && (string = (String)vector.get(n3)) != null) {
            string2 = StyleTypeDef.TYPE_NAME[5];
            this.SEDU.applyTextStyle(jetRptParagraph, n, n2, string2, string);
        }
        if (chrObj.hasValue("chrfmt.chcbpat") && (n3 = chrObj.getIntValue("chrfmt.chcbpat")) >= 0 && n3 < vector.size()) {
            string = (String)vector.get(n3);
            if (string == null) {
                string = "Transparent";
            }
            string2 = StyleTypeDef.TYPE_NAME[4];
            this.SEDU.applyTextStyle(jetRptParagraph, n, n2, string2, string);
        }
        if (chrObj.hasValue("chrfmt.highlight") && (n3 = chrObj.getIntValue("chrfmt.highlight")) >= 0 && n3 < vector.size()) {
            string = (String)vector.get(n3);
            if (string == null) {
                string = "Transparent";
            }
            string2 = StyleTypeDef.TYPE_NAME[4];
            this.SEDU.applyTextStyle(jetRptParagraph, n, n2, string2, string);
        }
        if (!chrObj.hasValue("chrfmt.nosupersub")) {
            if (chrObj.hasValue("chrfmt.super") || chrObj.hasValue("chrfmt.up")) {
                string2 = StyleTypeDef.TYPE_NAME[13];
                string = ParagraphConstant.SUPERSUBSCRIPT_NAME[1];
                this.SEDU.applyTextStyle(jetRptParagraph, n, n2, string2, string);
            } else if (chrObj.hasValue("chrfmt.sub") || chrObj.hasValue("chrfmt.dn")) {
                string2 = StyleTypeDef.TYPE_NAME[13];
                string = ParagraphConstant.SUPERSUBSCRIPT_NAME[2];
                this.SEDU.applyTextStyle(jetRptParagraph, n, n2, string2, string);
            }
        }
        if (chrObj.hasValue("chrfmt.ul") && chrObj.getBooleanValue("chrfmt.ul") || chrObj.hasValue("chrfmt.ulstyle") && chrObj.getIntValue("chrfmt.ulstyle") != 0) {
            n3 = 1;
            int n4 = 1;
            if (chrObj.hasValue("chrfmt.ulstyle")) {
                switch (chrObj.getIntValue("chrfmt.ulstyle")) {
                    case 0: {
                        n4 = 1;
                        break;
                    }
                    case 1: {
                        n4 = 4;
                        break;
                    }
                    case 2: {
                        n4 = 2;
                        break;
                    }
                    case 3: {
                        n4 = 0;
                        break;
                    }
                    case 4: {
                        n4 = 6;
                        break;
                    }
                    case 5: {
                        n4 = 10;
                        break;
                    }
                    case 6: {
                        n4 = 12;
                        break;
                    }
                    case 7: {
                        n4 = 15;
                        break;
                    }
                    case 8: {
                        n4 = 8;
                        break;
                    }
                    case 9: {
                        n3 = 0;
                        break;
                    }
                    case 10: {
                        n4 = 3;
                        break;
                    }
                    case 11: {
                        n4 = 5;
                        break;
                    }
                    case 12: {
                        n4 = 7;
                        break;
                    }
                    case 13: {
                        n4 = 11;
                        break;
                    }
                    case 14: {
                        n4 = 13;
                        break;
                    }
                    case 15: {
                        n4 = 9;
                        break;
                    }
                    case 16: {
                        n4 = 16;
                        break;
                    }
                    case 17: {
                        n4 = 14;
                        break;
                    }
                    default: {
                        n3 = 0;
                    }
                }
            }
            if (n3 != 0) {
                string2 = StyleTypeDef.TYPE_NAME[8];
                string = Boolean.TRUE.toString();
                this.SEDU.applyTextStyle(jetRptParagraph, n, n2, string2, string);
                string2 = StyleTypeDef.TYPE_NAME[9];
                string = ParagraphConstant.UNDERLINE_STYLE_NAME[n4];
                this.SEDU.applyTextStyle(jetRptParagraph, n, n2, string2, string);
            }
        }
        if (chrObj.hasValue("chrfmt.ulc") && (n3 = chrObj.getIntValue("chrfmt.ulc")) >= 0 && n3 < vector.size()) {
            string = (String)vector.get(n3);
            if (string == null) {
                string = "0x000000";
            }
            string2 = StyleTypeDef.TYPE_NAME[6];
            this.SEDU.applyTextStyle(jetRptParagraph, n, n2, string2, string);
        }
        if (chrObj.hasValue("chrfmt.strike")) {
            string2 = StyleTypeDef.TYPE_NAME[10];
            string = String.valueOf(chrObj.getBooleanValue("chrfmt.strike"));
            this.SEDU.applyTextStyle(jetRptParagraph, n, n2, string2, string);
            string2 = StyleTypeDef.TYPE_NAME[11];
            string = EnumerationConstant.STRIKETHROUGH_NAME[0];
            this.SEDU.applyTextStyle(jetRptParagraph, n, n2, string2, string);
        }
        if (chrObj.hasValue("chrfmt.strikedl")) {
            string2 = StyleTypeDef.TYPE_NAME[10];
            string = "true";
            this.SEDU.applyTextStyle(jetRptParagraph, n, n2, string2, string);
            string2 = StyleTypeDef.TYPE_NAME[11];
            string = EnumerationConstant.STRIKETHROUGH_NAME[0];
            this.SEDU.applyTextStyle(jetRptParagraph, n, n2, string2, string);
        }
    }

    private void afterSpacing(JetRptTextBox jetRptTextBox, DocObj docObj, Vector vector) {
        int n;
        if (docObj.hasValue("docfmt.txtvalign")) {
            switch (docObj.getIntValue("docfmt.txtvalign")) {
                case 0: {
                    jetRptTextBox.vAlignment.set(1);
                    break;
                }
                case 1: {
                    jetRptTextBox.vAlignment.set(0);
                    break;
                }
                case 2: {
                    jetRptTextBox.vAlignment.set(2);
                    break;
                }
            }
        }
        if (docObj.hasValue("docfmt.docbk") && (n = docObj.getIntValue("docfmt.docbk")) >= 0 && n < vector.size()) {
            String string = (String)vector.get(n);
            jetRptTextBox.backColor.set(string);
        }
    }

    static {
        FieldDest.setFieldImpl(new JetTxtFieldImpl());
        SUPERSUBSCRIPT_NAME = null;
    }
}

