/*
 * Decompiled with CFR 0.152.
 */
package jet.util.expression;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import jet.dataengine.api.expression.ConditionException;
import jet.dataengine.api.expression.IExpression;
import jet.dataengine.api.expression.IExpressionFactory;
import jet.dataengine.api.expression.variable.IConstant;
import jet.dataengine.api.expression.variable.IParameter;
import jet.dataengine.api.expression.variable.IVariableExpression;
import jet.dataengine.api.expression.variable.IVariableList;
import jet.util.expression.Element;
import jet.util.expression.ElementFactory;
import jet.util.expression.ExpParserException;
import jet.util.expression.FilterAnalysis;
import jet.util.expression.IExpParser;
import jet.util.expression.ListLexer;
import jet.util.expression.lexer.LexerException;
import jet.util.expression.node.Start;
import jet.util.expression.node.TOperand;
import jet.util.expression.parser.Parser;
import jet.util.expression.parser.ParserException;

public class ExpressionUtil {
    public static final int LeftPar = -2;
    public static final int RightPar = 3;
    public static final int Unkown = -4;
    public static final int EOF = -5;
    public static final int SPECIALFIELD = -6;

    public static IExpression getFilterExpression(List list, IExpressionFactory iExpressionFactory, boolean bl) throws ConditionException, ParserException, LexerException {
        if (list == null || list.size() <= 0) {
            return null;
        }
        Parser parser = new Parser(new ListLexer(list));
        FilterAnalysis filterAnalysis = null;
        filterAnalysis = new FilterAnalysis();
        filterAnalysis.setExpFactory(iExpressionFactory);
        filterAnalysis.setIsQualify(bl);
        Start start = parser.parse();
        start.apply(filterAnalysis);
        return filterAnalysis.getFilterExpression();
    }

    public static IExpression getFilterExpression(List list, IExpressionFactory iExpressionFactory) throws ConditionException, ParserException, LexerException {
        return ExpressionUtil.getFilterExpression(list, iExpressionFactory, true);
    }

    public static IVariableExpression buildOperand(TOperand tOperand, IExpressionFactory iExpressionFactory, boolean bl) throws ConditionException {
        IVariableExpression iVariableExpression = null;
        if (tOperand != null) {
            switch (tOperand.getType()) {
                case 32772: {
                    iVariableExpression = iExpressionFactory.createFormula(tOperand.getTextValue());
                    break;
                }
                case 32769: {
                    boolean bl2 = bl;
                    if (tOperand.getFlag() == 0) {
                        bl2 = false;
                    }
                    iVariableExpression = iExpressionFactory.createReference(tOperand.getTextValue(), bl2);
                    break;
                }
                case 32770: {
                    iVariableExpression = iExpressionFactory.createConstant(tOperand.getTextValue());
                    break;
                }
                case -6: {
                    iVariableExpression = iExpressionFactory.createConstant(tOperand.getTextValue(), true);
                    break;
                }
                case 32776: {
                    iVariableExpression = iExpressionFactory.createParameter(tOperand.getTextValue(), false);
                    break;
                }
                case 32784: {
                    IVariableList iVariableList = null;
                    List list = tOperand.getChildren();
                    if (tOperand.getTextValue() == null) {
                        tOperand.setTextValue("");
                    }
                    iVariableExpression = iExpressionFactory.createVariableList(tOperand.getTextValue());
                    iVariableList = (IVariableList)iVariableExpression;
                    IVariableExpression iVariableExpression2 = null;
                    for (int i = 0; i < list.size(); ++i) {
                        TOperand tOperand2 = (TOperand)list.get(i);
                        if (tOperand2.getType() == 32770) {
                            iVariableExpression2 = iExpressionFactory.createConstant(tOperand2.getTextValue());
                            iVariableList.addConstant((IConstant)iVariableExpression2);
                            continue;
                        }
                        if (tOperand2.getType() == 32769) {
                            iVariableExpression2 = iExpressionFactory.createReference(tOperand2.getTextValue());
                            continue;
                        }
                        if (tOperand2.getType() == 32776) {
                            iVariableExpression2 = iExpressionFactory.createParameter(tOperand2.getTextValue(), false);
                            iVariableList.addParameter((IParameter)iVariableExpression2);
                            continue;
                        }
                        if (tOperand2.getType() != -6) continue;
                        iVariableExpression2 = iExpressionFactory.createConstant(tOperand2.getTextValue(), true);
                        iVariableList.addConstant((IConstant)iVariableExpression2);
                    }
                    break;
                }
            }
        }
        return iVariableExpression;
    }

    public static List getIExpressionList(IExpression iExpression) throws ConditionException {
        if (iExpression == null) {
            return new ArrayList();
        }
        IExpParser iExpParser = new IExpParser();
        List list = iExpParser.parser(iExpression);
        return list;
    }

    public static String getStringValue(List list, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        if (list != null) {
            block6: for (int i = 0; i < list.size(); ++i) {
                Element element = (Element)list.get(i);
                string = element.getTextValue();
                if (element == null) continue;
                switch (element.getType()) {
                    case 32770: {
                        String string2 = "";
                        for (int j = 0; j < string.length(); ++j) {
                            string2 = string.charAt(j) == '\'' ? string2 + "\\'" : string2 + string.charAt(j);
                        }
                        if (n != 1) {
                            string2 = "'" + string2 + "'";
                        }
                        stringBuffer.append(string2).append(",");
                        continue block6;
                    }
                    case 32769: {
                        stringBuffer.append(string).append(",");
                        continue block6;
                    }
                    case 32776: {
                        stringBuffer.append("@").append(string).append(",");
                        continue block6;
                    }
                    case -6: 
                    case 32772: {
                        stringBuffer.append("@'").append(string).append("',");
                    }
                }
            }
        }
        if (stringBuffer.toString().endsWith(",")) {
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    public static List parseStringValue(String string) throws ExpParserException {
        Vector<Element> vector = new Vector<Element>();
        char[] cArray = string.toCharArray();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        String string2 = "";
        int n = 32770;
        block8: for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (bl) {
                if (bl2) {
                    string2 = string2 + String.valueOf(c);
                    bl2 = false;
                    continue;
                }
                if (c == '\'') {
                    bl = false;
                    if (bl3) {
                        n = 32772;
                        continue;
                    }
                    n = 32770;
                    continue;
                }
                if (c == '\\') {
                    bl2 = true;
                    continue;
                }
                string2 = string2 + String.valueOf(c);
                continue;
            }
            if (bl2) {
                throw new ExpParserException("error escape!");
            }
            if (c >= '0' && c <= '9' || c == '.') {
                if (string2.length() <= 0) {
                    n = 32770;
                }
                string2 = string2 + String.valueOf(c);
                continue;
            }
            switch (c) {
                case '\'': {
                    bl = true;
                    continue block8;
                }
                case '\\': {
                    continue block8;
                }
                case ',': {
                    vector.add(ElementFactory.createElement(n, string2));
                    string2 = "";
                    bl3 = false;
                    n = 32770;
                    continue block8;
                }
                case '@': {
                    if (string2.length() > 0) {
                        throw new ExpParserException("error char");
                    }
                    bl3 = true;
                    continue block8;
                }
                case ' ': {
                    if (n != 32776 && n != 32769) continue block8;
                    string2 = string2 + " ";
                    continue block8;
                }
                case '\t': {
                    continue block8;
                }
                default: {
                    n = bl3 ? 32776 : 32769;
                    string2 = string2 + String.valueOf(c);
                }
            }
        }
        if (string2 != null) {
            vector.add(ElementFactory.createElement(n, string2));
        }
        return vector;
    }
}

