/*
 * Decompiled with CFR 0.152.
 */
package jet.util.expression;

import java.util.ArrayList;
import java.util.List;
import jet.dataengine.api.expression.ConditionException;
import jet.dataengine.api.expression.IExpression;
import jet.dataengine.api.expression.tuple.IBinaryConditionExpression;
import jet.dataengine.api.expression.tuple.IBinaryLogicExpression;
import jet.dataengine.api.expression.tuple.IMultiLogicExpression;
import jet.dataengine.api.expression.tuple.ISingleConditionExpression;
import jet.dataengine.api.expression.tuple.ITripleConditionExpression;
import jet.dataengine.api.expression.variable.IConstant;
import jet.dataengine.api.expression.variable.IVariableExpression;
import jet.dataengine.api.expression.variable.IVariableList;
import jet.util.expression.Element;
import jet.util.expression.ElementFactory;

public class IExpParser {
    private List SEDU = null;

    public List parser(IExpression iExpression) throws ConditionException {
        this.SEDU = new ArrayList();
        this.apply(iExpression);
        return this.SEDU;
    }

    private void apply(IExpression iExpression) throws ConditionException {
        int n = iExpression.expressionType();
        boolean bl = iExpression.isParenthesized();
        if (bl) {
            this.SEDU.add(ElementFactory.createElement(-2));
        }
        switch (n) {
            case 0x141001: {
                this.caseIBinaryLogicExpression((IBinaryLogicExpression)iExpression);
                break;
            }
            case 0x301001: {
                this.SEDU((IMultiLogicExpression)iExpression);
                break;
            }
            case 1314818: {
                this.caseIBinaryConditionExpression((IBinaryConditionExpression)iExpression);
                break;
            }
            case 32768: {
                this.caseIVariableExpression((IVariableExpression)iExpression);
                break;
            }
            case 1576962: {
                this.caseITripleConditionExpression((ITripleConditionExpression)iExpression);
                break;
            }
            case 0x121002: {
                this.caseISingleConditionExpression((ISingleConditionExpression)iExpression);
                break;
            }
            case 32769: 
            case 32770: 
            case 32772: 
            case 32776: {
                this.caseIVariableExpression((IVariableExpression)iExpression);
                break;
            }
            case 32784: {
                this.caseIVariableList((IVariableList)iExpression);
                break;
            }
            default: {
                System.err.println("unkown Expression Types=" + n);
                throw new ConditionException(0);
            }
        }
        if (bl) {
            this.SEDU.add(ElementFactory.createElement(3));
        }
    }

    private void SEDU(IMultiLogicExpression iMultiLogicExpression) throws ConditionException {
        IExpression[] iExpressionArray = iMultiLogicExpression.getExpressions();
        IExpression iExpression = iExpressionArray[1];
        if (iExpression.expressionType() == 0x121001) {
            throw new ConditionException(0);
        }
        int n = iMultiLogicExpression.getOperator().operatorType();
        for (int i = 0; i < iExpressionArray.length; ++i) {
            IExpression iExpression2 = iExpressionArray[i];
            if (iExpression2.expressionType() == 0x121001) {
                throw new ConditionException(0);
            }
            this.apply(iExpression2);
            if (i == iExpressionArray.length - 1) continue;
            this.SEDU.add(ElementFactory.createElement(n));
        }
    }

    void caseIBinaryLogicExpression(IBinaryLogicExpression iBinaryLogicExpression) throws ConditionException {
        IExpression iExpression = iBinaryLogicExpression.getExpression1();
        this.apply(iExpression);
        int n = iBinaryLogicExpression.getOperator().operatorType();
        this.SEDU.add(ElementFactory.createElement(n));
        IExpression iExpression2 = iBinaryLogicExpression.getExpression2();
        this.apply(iExpression2);
    }

    void caseISingleConditionExpression(ISingleConditionExpression iSingleConditionExpression) throws ConditionException {
        IExpression iExpression = iSingleConditionExpression.getExpression();
        this.apply(iExpression);
        int n = iSingleConditionExpression.getOperator().operatorType();
        this.SEDU.add(ElementFactory.createElement(n));
    }

    void caseITripleConditionExpression(ITripleConditionExpression iTripleConditionExpression) throws ConditionException {
        IExpression iExpression = iTripleConditionExpression.getExpression1();
        this.apply(iExpression);
        int n = iTripleConditionExpression.getOperator().operatorType();
        this.SEDU.add(ElementFactory.createElement(n));
        int n2 = this.SEDU.size();
        IExpression iExpression2 = iTripleConditionExpression.getExpression2();
        this.apply(iExpression2);
        IExpression iExpression3 = iTripleConditionExpression.getExpression3();
        this.apply(iExpression3);
        if (this.SEDU.size() == n2 + 2) {
            ArrayList arrayList = new ArrayList();
            arrayList.add(this.SEDU.remove(this.SEDU.size() - 2));
            arrayList.add(this.SEDU.remove(this.SEDU.size() - 1));
            this.SEDU.add(ElementFactory.createElement(32784, iTripleConditionExpression.getName(), arrayList));
        }
    }

    void caseIBinaryConditionExpression(IBinaryConditionExpression iBinaryConditionExpression) throws ConditionException {
        IExpression iExpression = iBinaryConditionExpression.getExpression1();
        this.apply(iExpression);
        int n = iBinaryConditionExpression.getOperator().operatorType();
        this.SEDU.add(ElementFactory.createElement(n));
        IExpression iExpression2 = iBinaryConditionExpression.getExpression2();
        this.apply(iExpression2);
    }

    void caseIVariableExpression(IVariableExpression iVariableExpression) throws ConditionException {
        if (iVariableExpression.expressionType() == 32770 && iVariableExpression instanceof IConstant && ((IConstant)iVariableExpression).isSpecialField()) {
            this.SEDU.add(ElementFactory.createElement(-6, iVariableExpression.getName()));
        } else {
            this.SEDU.add(ElementFactory.createElement(iVariableExpression.expressionType(), iVariableExpression.getName()));
        }
    }

    void caseIVariableList(IVariableList iVariableList) throws ConditionException {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        if (iVariableList != null && iVariableList.size() > 0) {
            for (int i = 0; i < iVariableList.size(); ++i) {
                IVariableExpression iVariableExpression = iVariableList.getVariableExp(i);
                if (iVariableExpression == null) continue;
                int n = iVariableExpression.expressionType();
                if (n == 32770 && iVariableExpression instanceof IConstant && ((IConstant)iVariableExpression).isSpecialField()) {
                    n = -6;
                }
                arrayList.add(ElementFactory.createElement(n, iVariableExpression.getName()));
            }
        }
        this.SEDU.add(ElementFactory.createElement(iVariableList.expressionType(), iVariableList.getName(), arrayList));
    }
}

