/*
 * Decompiled with CFR 0.152.
 */
package jet.util.image;

import com.jinfonet.util.JRLog;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import jet.connect.DbValue;
import jet.datastream.JRObjectResult;
import jet.report.JetRptPicture;
import jet.util.FileUtil;
import jet.util.ImageListPropertiable;
import jet.util.ImagePropertiable;
import jet.util.JRInterruptedException;
import jet.util.image.ImageProvider;
import jet.util.image.ImageResource;
import jet.util.image.ImageResourceUtil;

public class ImageTable {
    private static final String BLANK_IMAGERES = "IMGCHGBY_HEADER";
    private static final String SEDU = "IMAGEDATA";
    private Hashtable<String, ImageResource> add = new Hashtable();
    private final ReentrantReadWriteLock append = new ReentrantReadWriteLock(true);

    public ImageTable() {
    }

    public ImageTable(String string, List<String> list) {
        if (new File(string).isFile()) {
            string = new File(string).getParent();
        }
        int n = list == null ? 0 : list.size();
        Vector<String> vector = new Vector<String>(n);
        for (int i = 0; i < n; ++i) {
            int n2;
            String string2;
            File file;
            String string3 = list.get(i);
            if (!FileUtil.isFileFormat(string3) || !(file = new File(string2 = FileUtil.getFilePath(string, string3))).exists() || !file.isFile() || (n2 = vector.indexOf(string2)) >= 0) continue;
            vector.add(string2);
            try {
                ImageResource imageResource = ImageResourceUtil.loadImageResourceFromFile(file);
                this.add.put(string3, imageResource);
                continue;
            }
            catch (IOException iOException) {
                if (!JRLog.isTrace(6)) continue;
                JRLog.trace(6, "Can not fill image content to IA :" + string3);
            }
        }
        vector.clear();
        vector = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeTo(OutputStream outputStream) throws IOException, JRInterruptedException {
        Object object;
        Object object2;
        int n = this.add.size();
        Vector<ImageResource> vector = new Vector<ImageResource>(n);
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        try {
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, "REQ on lock.read in ImageTable");
            }
            this.append.readLock().lockInterruptibly();
        }
        catch (InterruptedException interruptedException) {
            if (JRLog.isTrace(5)) {
                JRLog.trace(5, "InterruptedException on lock.read in ImageTable");
            }
            throw new JRInterruptedException();
        }
        try {
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, "DOING on lock.read in ImageTable");
            }
            object2 = this.add.entrySet().iterator();
            int n2 = 0;
            while (object2.hasNext()) {
                object = object2.next();
                hashtable.put(object.getKey(), n2);
                vector.add(object.getValue());
                ++n2;
            }
        }
        finally {
            this.append.readLock().unlock();
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, "RELEASE on lock.read in ImageTable");
            }
        }
        object2 = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream((OutputStream)object2);
            objectOutputStream.writeInt(n);
            objectOutputStream.writeObject(hashtable);
            objectOutputStream.flush();
        }
        finally {
            if (objectOutputStream != null) {
                try {
                    objectOutputStream.close();
                }
                catch (Throwable throwable) {
                }
                finally {
                    objectOutputStream = null;
                }
            }
        }
        object = ((ByteArrayOutputStream)object2).toByteArray();
        ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
        zipOutputStream.putNextEntry(new ZipEntry(BLANK_IMAGERES));
        zipOutputStream.write((byte[])object);
        zipOutputStream.flush();
        zipOutputStream.closeEntry();
        for (int i = 0; i < n; ++i) {
            zipOutputStream.putNextEntry(new ZipEntry(SEDU + i));
            try {
                ImageResource imageResource = (ImageResource)vector.get(i);
                if (imageResource == null || imageResource.getImage() == null) {
                    zipOutputStream.write(new byte[0]);
                } else {
                    byte[] byArray = ImageResourceUtil.imageToByte(imageResource.getImage(), imageResource.getImageType());
                    zipOutputStream.write(byArray, 0, byArray.length);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            zipOutputStream.flush();
            zipOutputStream.closeEntry();
        }
        zipOutputStream.finish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFrom(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("Error parameter inputted");
        }
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        String string = zipEntry.getName();
        if (string.equals(BLANK_IMAGERES)) {
            Hashtable hashtable;
            Hashtable<String, ImageResource> hashtable2 = new Hashtable<String, ImageResource>();
            byte[] byArray = this.BLANK_IMAGERES(zipInputStream);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream = null;
            int n = 0;
            try {
                objectInputStream = new ObjectInputStream(byteArrayInputStream);
                n = objectInputStream.readInt();
                try {
                    hashtable = (Hashtable)objectInputStream.readObject();
                }
                catch (Exception exception) {
                    hashtable = new Hashtable();
                }
            }
            finally {
                if (objectInputStream != null) {
                    try {
                        objectInputStream.close();
                    }
                    catch (Throwable throwable) {
                    }
                    finally {
                        objectInputStream = null;
                    }
                }
                try {
                    byteArrayInputStream.close();
                }
                catch (Throwable throwable) {
                }
                finally {
                    byteArrayInputStream = null;
                }
            }
            if (n == 0) {
                return;
            }
            Vector<ImageResource> vector = new Vector<ImageResource>(n);
            for (int i = 0; i < n; ++i) {
                zipEntry = zipInputStream.getNextEntry();
                try {
                    byArray = this.BLANK_IMAGERES(zipInputStream);
                    ImageResource iOException = ImageResourceUtil.loadImageResourceFromBytes(byArray);
                    vector.add(iOException);
                    continue;
                }
                catch (IOException interruptedException) {
                    vector.add(ImageResource.BLANK_IMAGERES);
                }
            }
            for (Map.Entry entry : hashtable.entrySet()) {
                String string2 = (String)entry.getKey();
                ImageResource imageResource = (ImageResource)vector.get((Integer)entry.getValue());
                hashtable2.put(string2, imageResource);
            }
            try {
                if (JRLog.isTrace(7)) {
                    JRLog.trace(7, "REQ on lock.write in ImageTable");
                }
                this.append.writeLock().lockInterruptibly();
            }
            catch (InterruptedException interruptedException) {
                if (JRLog.isTrace(5)) {
                    JRLog.trace(5, "InterruptedException on lock.write in ImageTable");
                }
                throw new JRInterruptedException();
            }
            try {
                this.add.putAll(hashtable2);
            }
            finally {
                this.append.writeLock().unlock();
                if (JRLog.isTrace(7)) {
                    JRLog.trace(7, "RELEASE on lock.write in ImageTable");
                }
                hashtable2.clear();
                hashtable2 = null;
            }
        }
        throw new UnsupportedOperationException("Can not open inner-test rsd/rst structure:" + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] BLANK_IMAGERES(ZipInputStream zipInputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byte[] byArray = new byte[1024];
            int n = 0;
            while ((n = zipInputStream.read(byArray, 0, 1024)) >= 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byteArrayOutputStream.flush();
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            return byArray2;
        }
        finally {
            try {
                byteArrayOutputStream.close();
            }
            catch (Throwable throwable) {
            }
            finally {
                byteArrayOutputStream = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mergeWith(ImageTable imageTable) {
        try {
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, "REQ on lock.write in ImageTable");
            }
            this.append.writeLock().lockInterruptibly();
        }
        catch (InterruptedException interruptedException) {
            if (JRLog.isTrace(5)) {
                JRLog.trace(5, "InterruptedException on lock.write in ImageTable");
            }
            throw new JRInterruptedException();
        }
        try {
            if (imageTable != null) {
                this.add.putAll(imageTable.add);
            }
        }
        finally {
            this.append.writeLock().unlock();
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, "RELEASE on lock.write in ImageTable");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ImageResource getImageResource(String string) {
        try {
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, "REQ on lock.read in ImageTable");
            }
            this.append.readLock().lockInterruptibly();
        }
        catch (InterruptedException interruptedException) {
            if (JRLog.isTrace(5)) {
                JRLog.trace(5, "InterruptedException on lock.read in ImageTable");
            }
            throw new JRInterruptedException();
        }
        try {
            if (string == null) {
                ImageResource imageResource = ImageResource.BLANK_IMAGERES;
                return imageResource;
            }
            ImageResource imageResource = this.add.get(string);
            if (imageResource == null) {
                ImageResource imageResource2 = ImageResource.BLANK_IMAGERES;
                return imageResource2;
            }
            ImageResource imageResource3 = imageResource;
            return imageResource3;
        }
        finally {
            this.append.readLock().unlock();
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, "RELEASE on lock.read in ImageTable");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clear() {
        try {
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, "REQ on lock.write in ImageTable");
            }
            this.append.writeLock().lockInterruptibly();
        }
        catch (InterruptedException interruptedException) {
            if (JRLog.isTrace(5)) {
                JRLog.trace(5, "InterruptedException on lock.write in ImageTable");
            }
            throw new JRInterruptedException();
        }
        try {
            this.add.clear();
        }
        finally {
            this.append.writeLock().unlock();
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, "RELEASE on lock.write in ImageTable");
            }
        }
    }

    protected ImageProvider allocImageProvider() {
        return new DefaultImageTableProvider(this);
    }

    class DefaultImageTableProvider
    implements ImageProvider {
        ImageTable imageTbl;

        DefaultImageTableProvider(ImageTable imageTable2) {
            this.imageTbl = imageTable2;
        }

        @Override
        public <T extends ImagePropertiable> ImageResource getImageResource(T t) {
            if (t.isEmbed()) {
                return t.getEmbedImageResource();
            }
            String string = t.get();
            return this.imageTbl.getImageResource(string);
        }

        @Override
        public <T extends ImageListPropertiable> List<ImageResource> getImageResources(T t) {
            if (t.isEmbed()) {
                return t.getEmbedImageResources();
            }
            List<String> list = t.get();
            Vector<ImageResource> vector = new Vector<ImageResource>(list.size());
            for (String string : list) {
                if ("\t".equals(string)) {
                    vector.add(ImageResource.BLANK_IMAGERES);
                    continue;
                }
                vector.add(this.imageTbl.getImageResource(string));
            }
            return vector;
        }

        @Override
        public ImageResource getImageResource(JetRptPicture jetRptPicture, JRObjectResult jRObjectResult) {
            DbValue dbValue;
            if (jetRptPicture.isEmbed()) {
                return jetRptPicture.pictureName.getEmbedImageResource();
            }
            if (jetRptPicture.bFPictureName && jRObjectResult != null && (dbValue = jRObjectResult.getDbValue(jetRptPicture.cFPictureName, null)) != null && !dbValue.isNull()) {
                return this.imageTbl.getImageResource(dbValue.toString());
            }
            return this.imageTbl.getImageResource(jetRptPicture.sNPictureName);
        }
    }
}

