/*
 * Decompiled with CFR 0.152.
 */
package jet.util.image;

import com.jinfonet.resstore.MemoryStore;
import com.jinfonet.resstore.ResourceLoadException;
import com.jinfonet.resstore.ResourceNotFoundException;
import com.jinfonet.resstore.loader.ImageIDImpl;
import com.jinfonet.util.JRLog;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import jet.connect.DbValue;
import jet.datastream.JRObjectResult;
import jet.report.JetRptPicture;
import jet.util.FileUtil;
import jet.util.ImageListPropertiable;
import jet.util.ImagePropertiable;
import jet.util.image.ImageProvider;
import jet.util.image.ImageResource;
import jet.util.image.ImageResourceLoader;
import jet.util.image.ImageResourceUtil;

class PathCacherImageProvider
implements ImageProvider {
    private String BLANK_IMAGERES = "";
    private File SEDU;
    private ImageResourceLoader Z = null;
    private MemoryStore add;

    PathCacherImageProvider(File file, MemoryStore memoryStore) {
        this.BLANK_IMAGERES(file);
        this.add = memoryStore;
    }

    PathCacherImageProvider(File file) {
        this.BLANK_IMAGERES(file);
    }

    private void BLANK_IMAGERES(File file) {
        if (file == null) {
            this.SEDU = new File("");
            this.BLANK_IMAGERES = "";
        } else if (file.isFile()) {
            this.SEDU = file;
            this.BLANK_IMAGERES = file.getParentFile().getAbsolutePath();
        } else {
            this.SEDU = file;
            this.BLANK_IMAGERES = file.getAbsolutePath();
        }
    }

    @Override
    public <T extends ImagePropertiable> ImageResource getImageResource(T t) {
        if (t.isEmbed()) {
            return t.getEmbedImageResource();
        }
        String string = t.get();
        return this.SEDU(string);
    }

    private ImageResource SEDU(String string) {
        ImageResource imageResource = ImageResource.BLANK_IMAGERES;
        if (string != null && string.trim().length() != 0) {
            try {
                if (this.add != null) {
                    imageResource = this.add.loadImage(this.SEDU, string);
                } else if (this.Z != null) {
                    ImageIDImpl imageIDImpl = new ImageIDImpl(this.SEDU, string);
                    imageResource = this.Z.load(imageIDImpl, false);
                } else if (FileUtil.isFileFormat(string)) {
                    String string2 = FileUtil.getFilePath(this.BLANK_IMAGERES, string);
                    imageResource = ImageResourceUtil.loadImageResourceFromFile(new File(string2));
                } else {
                    imageResource = ImageResourceUtil.loadImageResourceFromURL(string);
                }
            }
            catch (ResourceLoadException resourceLoadException) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, 2200013, new Object[]{this.BLANK_IMAGERES, string}, (Throwable)resourceLoadException);
                }
                imageResource = ImageResource.BLANK_IMAGERES;
            }
            catch (ResourceNotFoundException resourceNotFoundException) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, 2200013, new Object[]{this.BLANK_IMAGERES, string}, (Throwable)resourceNotFoundException);
                }
                imageResource = ImageResource.BLANK_IMAGERES;
            }
            catch (IOException iOException) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, 2200013, new Object[]{this.BLANK_IMAGERES, string}, (Throwable)iOException);
                }
                imageResource = ImageResource.BLANK_IMAGERES;
            }
        }
        return imageResource;
    }

    @Override
    public <T extends ImageListPropertiable> List<ImageResource> getImageResources(T t) {
        if (t.isEmbed()) {
            return t.getEmbedImageResources();
        }
        List<String> list = t.get();
        Vector<ImageResource> vector = new Vector<ImageResource>(list.size());
        for (String string : list) {
            if ("\t".equals(string)) {
                vector.add(ImageResource.BLANK_IMAGERES);
                continue;
            }
            vector.add(this.SEDU(string));
        }
        return vector;
    }

    @Override
    public ImageResource getImageResource(JetRptPicture jetRptPicture, JRObjectResult jRObjectResult) {
        DbValue dbValue;
        Object var3_3 = null;
        if (jetRptPicture.isEmbed()) {
            return jetRptPicture.pictureName.getEmbedImageResource();
        }
        if (jetRptPicture.bFPictureName && jRObjectResult != null && (dbValue = jRObjectResult.getDbValue(jetRptPicture.cFPictureName, null)) != null && !dbValue.isNull()) {
            return this.SEDU(dbValue.toString());
        }
        return this.SEDU(jetRptPicture.sNPictureName);
    }
}

