/*
 * Decompiled with CFR 0.152.
 */
package jet.util.loader;

import com.jinfonet.resstore.loader.CachedObject;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import jet.util.JRInterruptedException;
import jet.util.MemoryCounter;
import jet.util.loader.AbsCacherKey;

public abstract class AbsCacherValue<K, V, T extends AbsCacherKey<K>>
implements CachedObject<K, V> {
    protected T keyInst;
    protected V valueObj = null;
    private long doEstimateLength = 0L;
    private boolean estimate = false;
    private long estimateLength = 0L;
    private boolean fireValueIsCached = false;
    private ReadWriteLock foreceLoadValue;

    public AbsCacherValue(T t) {
        this.keyInst = t;
        this.foreceLoadValue = new ReentrantReadWriteLock(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void updateContent() throws Throwable {
        try {
            this.foreceLoadValue.writeLock().lockInterruptibly();
        }
        catch (InterruptedException interruptedException) {
            throw new JRInterruptedException();
        }
        try {
            if (this.valueObj == null) {
                this.valueObj = this.foreceLoadValue();
                this.doEstimateLength = this.estimateLength();
            } else if (this.isNeedReload()) {
                this.fireValueIsCached(false);
                this.valueObj = this.foreceLoadValue();
                this.doEstimateLength = this.estimateLength();
            } else {
                this.updateValueNeedNotReload();
            }
        }
        finally {
            this.foreceLoadValue.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final V getValueObject() {
        try {
            this.foreceLoadValue.readLock().lockInterruptibly();
        }
        catch (InterruptedException interruptedException) {
            throw new JRInterruptedException();
        }
        try {
            V v = this.valueObj;
            return v;
        }
        finally {
            this.foreceLoadValue.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final long getValueLength() {
        try {
            this.foreceLoadValue.readLock().lockInterruptibly();
        }
        catch (InterruptedException interruptedException) {
            throw new JRInterruptedException();
        }
        try {
            long l = this.doEstimateLength;
            return l;
        }
        finally {
            this.foreceLoadValue.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setIsCached(boolean bl, long l) {
        try {
            this.foreceLoadValue.writeLock().lockInterruptibly();
        }
        catch (InterruptedException interruptedException) {
            throw new JRInterruptedException();
        }
        try {
            this.estimateLength = bl ? l : 0L;
            this.fireValueIsCached = bl;
            this.fireValueIsCached(bl);
        }
        finally {
            this.foreceLoadValue.writeLock().unlock();
        }
    }

    protected final long getLengthInCacher() {
        return this.estimateLength;
    }

    protected final void resetItemLocked(boolean bl) {
        this.estimate = bl;
    }

    protected final boolean isCahed() {
        return this.fireValueIsCached;
    }

    protected final boolean isItemLocked() {
        return this.estimate;
    }

    protected long estimateLength() {
        return this.doEstimateLength(this.valueObj);
    }

    protected final long doEstimateLength(Object object) {
        if (object == null) {
            return 0L;
        }
        return new MemoryCounter().estimate(object);
    }

    protected boolean sureCanPutInfoCacher() {
        return true;
    }

    protected abstract void updateValueNeedNotReload();

    protected abstract boolean isNeedReload();

    protected abstract V foreceLoadValue() throws Throwable;

    protected abstract void fireValueIsCached(boolean var1);

    public K key() {
        return ((AbsCacherKey)this.keyInst).getOuterUsedID();
    }

    public V value() {
        return this.getValueObject();
    }

    @Override
    public boolean isLocked() {
        return this.isItemLocked();
    }

    @Override
    public long length() {
        return this.getValueLength();
    }
}

