/*
 * Decompiled with CFR 0.152.
 */
package jet.util.nls;

import com.jinfonet.util.JRLog;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Locale;
import jet.controls.JetContainable;
import jet.ie.RSTNLSMap;
import jet.report.conditionalFormatting.JetRptConditionalFormat;
import jet.report.conditionalFormatting.JetRptConditionalFormatSet;
import jet.reportset.JetRptReport;
import jet.reportset.JetRptReportSet;
import jet.util.NLSBundleInfo;
import jet.util.ValueToUnit;
import jet.util.nls.INLSMap;
import jet.util.nls.NLSApplyParam;
import jet.util.nls.NLSBundle;
import jet.util.nls.NLSDictionary;
import jet.util.nls.NLSFontMap;
import jet.util.nls.NLSFontValue;
import jet.util.nls.NLSFontValueImpl;
import jet.util.nls.NLSValue;
import jet.util.nls.NLSValueImpl;

final class DefaultNLSMapImpl
implements INLSMap {
    private final NLSApplyParam SEDU;
    private final JetRptReportSet add;

    DefaultNLSMapImpl(NLSApplyParam nLSApplyParam, JetRptReportSet jetRptReportSet) {
        this.SEDU = nLSApplyParam;
        this.add = jetRptReportSet;
    }

    private <T extends NLSValue> T SEDU(T t, T t2) {
        if (t == null || t.isEmptyValue()) {
            return t2;
        }
        if (t2 == null || t2.isEmptyValue()) {
            return t;
        }
        if (t.getValuePrority() <= t2.getValuePrority()) {
            return t;
        }
        return t2;
    }

    @Override
    public final NLSValue getTextValue(int n, String string) {
        if (string == null || string.isEmpty()) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, 6205030, new Object[]{n});
            }
            return null;
        }
        Locale locale = this.SEDU.getLocale();
        NLSBundleInfo nLSBundleInfo = this.SEDU.getBundInfo();
        if (nLSBundleInfo != null) {
            String string2 = this.add(nLSBundleInfo, n, string);
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, 6205031, new Object[]{n, string, locale, string2, "NLSBundleInfo"});
            }
            if (string2 == null) {
                return new NLSValueImpl(null);
            }
            return new NLSValueImpl(string2);
        }
        NLSValue nLSValue = null;
        NLSValue nLSValue2 = null;
        NLSValue nLSValue3 = null;
        NLSBundle nLSBundle = this.SEDU.getReportNLSBundle();
        if (nLSBundle != null) {
            nLSValue = n != 2 ? nLSBundle.getText(n, string) : nLSBundle.getFormat(string);
        }
        if ((nLSBundle = this.SEDU.getCatalogNLSBundle()) != null) {
            nLSValue2 = n != 2 ? nLSBundle.getText(n, string) : nLSBundle.getFormat(string);
        }
        nLSValue = this.SEDU(nLSValue, nLSValue2);
        NLSDictionary nLSDictionary = this.SEDU.getDictionary();
        if (nLSDictionary != null) {
            nLSValue3 = n != 2 ? nLSDictionary.getText(this.SEDU.getLocale(), n, string) : nLSDictionary.getFormat(this.SEDU.getLocale(), string);
        }
        nLSValue = this.SEDU(nLSValue, nLSValue3);
        if (JRLog.isTrace(6)) {
            if (nLSValue == null || nLSValue.isEmptyValue()) {
                JRLog.trace(6, 6205031, new Object[]{n, string, locale, "null(or empty)", "All"});
            } else if (nLSValue == nLSValue3) {
                JRLog.trace(6, 6205031, new Object[]{n, string, locale, nLSValue.getStringValue(), "GNLS"});
            } else if (nLSValue == nLSValue2) {
                JRLog.trace(6, 6205031, new Object[]{n, string, locale, nLSValue.getStringValue(), "CNLS"});
            } else {
                JRLog.trace(6, 6205031, new Object[]{n, string, locale, nLSValue.getStringValue(), "RNLS"});
            }
        }
        return nLSValue;
    }

    private String add(NLSBundleInfo nLSBundleInfo, int n, String string) {
        if ((nLSBundleInfo.getBundleUsage() & 0x100) != 256) {
            return string;
        }
        switch (n) {
            case 1: {
                return nLSBundleInfo.getTextReplace(261, string);
            }
            case 0: {
                return nLSBundleInfo.getTextReplace(257, string);
            }
            case 5: {
                return nLSBundleInfo.getTextReplace(259, string);
            }
            case 6: {
                return nLSBundleInfo.getTextReplace(258, string);
            }
            case 7: {
                return nLSBundleInfo.getTextReplace(262, string);
            }
            case 2: {
                return nLSBundleInfo.getTextReplace(260, string);
            }
        }
        return string;
    }

    @Override
    public final NLSFontValue getFontValue(String string, double d) {
        if (string == null) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, 6205032, "FontFace is null");
            }
            throw new NullPointerException();
        }
        if (d < 0.0) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, 6205032, "FontSize is negative");
            }
            throw new IllegalArgumentException();
        }
        Locale locale = this.SEDU.getLocale();
        NLSBundleInfo nLSBundleInfo = this.SEDU.getBundInfo();
        if (nLSBundleInfo != null) {
            if ((nLSBundleInfo.getBundleUsage() & 0x100) != 256) {
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, 6205033, new Object[]{string, d, locale, "null", "null", "NLSBundleInfo"});
                }
                return null;
            }
            double d2 = ValueToUnit.convertPointToInch(d);
            String[] stringArray = nLSBundleInfo.getFontStyleReplace(string, d2);
            if (stringArray == null) {
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, 6205033, new Object[]{string, d, locale, "null", "null", "NLSBundleInfo"});
                }
                return null;
            }
            try {
                double d3 = Double.parseDouble(stringArray[1]) * 72.0;
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, 6205033, new Object[]{string, d, locale, stringArray[0], d3, "NLSBundleInfo"});
                }
                return new NLSFontValueImpl(stringArray[0], d3, locale);
            }
            catch (NumberFormatException numberFormatException) {
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, 6205033, new Object[]{string, d, locale, "null", "error", "NLSBundleInfo"});
                }
                return null;
            }
        }
        NLSBundle nLSBundle = this.SEDU.getReportNLSBundle();
        NLSFontValue nLSFontValue = null;
        NLSFontValue nLSFontValue2 = null;
        NLSFontValue nLSFontValue3 = null;
        NLSFontValue nLSFontValue4 = null;
        if (nLSBundle != null) {
            nLSFontValue4 = nLSBundle.getFont(string, d);
        }
        if ((nLSBundle = this.SEDU.getCatalogNLSBundle()) != null) {
            nLSFontValue = nLSBundle.getFont(string, d);
        }
        nLSFontValue4 = this.SEDU(nLSFontValue4, nLSFontValue);
        NLSFontMap nLSFontMap = this.SEDU.getFontmap();
        if (nLSFontMap != null) {
            nLSFontValue2 = nLSFontMap.getFont(string, d);
        }
        nLSFontValue4 = this.SEDU(nLSFontValue4, nLSFontValue2);
        NLSDictionary nLSDictionary = this.SEDU.getDictionary();
        if (nLSDictionary != null) {
            nLSFontValue3 = nLSDictionary.getFont(locale, string, d);
        }
        nLSFontValue4 = this.SEDU(nLSFontValue4, nLSFontValue3);
        if (JRLog.isTrace(6)) {
            if (nLSFontValue4 == null || nLSFontValue4.isEmptyValue()) {
                JRLog.trace(6, 6205033, new Object[]{string, d, locale, "null(or empty)", "null(or empty)", "All"});
            } else {
                String string2 = nLSFontValue4.getFontName();
                double d4 = nLSFontValue4.getFontSize();
                if (nLSFontValue4 == nLSFontValue3) {
                    JRLog.trace(6, 6205033, new Object[]{string, d, locale, string2, d4, "GNLS"});
                } else if (nLSFontValue4 == nLSFontValue) {
                    JRLog.trace(6, 6205033, new Object[]{string, d, locale, string2, d4, "FNLS"});
                } else if (nLSFontValue4 == nLSFontValue) {
                    JRLog.trace(6, 6205033, new Object[]{string, d, locale, string2, d4, "CNLS"});
                } else {
                    JRLog.trace(6, 6205033, new Object[]{string, d, locale, string2, d4, "RNLS"});
                }
            }
        }
        return nLSFontValue4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveToRST(OutputStream outputStream) throws IOException {
        Hashtable<String, Object[]> hashtable = new Hashtable<String, Object[]>();
        if (this.add != null) {
            LinkedList<JetRptConditionalFormatSet> linkedList = new LinkedList<JetRptConditionalFormatSet>(this.add.getReports().getChildren());
            while (!linkedList.isEmpty()) {
                Object e = linkedList.removeFirst();
                if (e instanceof JetRptConditionalFormat) {
                    String string = ((JetRptConditionalFormat)e).getFontFace();
                    int n = ((JetRptConditionalFormat)e).getFontSize();
                    hashtable.put(string + '@' + n, new Object[]{string, ValueToUnit.convertUnitToPoint(n)});
                    continue;
                }
                if (e instanceof JetRptReport) {
                    linkedList.add(((JetRptReport)e).getConditionalFormatSet());
                    continue;
                }
                if (!(e instanceof JetContainable)) continue;
                linkedList.addAll(((JetContainable)e).getChildren());
            }
        }
        try {
            RSTNLSMap.saveToRST(this, outputStream, hashtable.values());
        }
        finally {
            hashtable.clear();
            hashtable = null;
        }
    }
}

