/*
 * Decompiled with CFR 0.152.
 */
package jet.util.nls.meta;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import jet.controls.JetObject;
import jet.formula.ParamDesc;
import jet.icontrols.QueryInfo;
import jet.ireport.IReport;
import jet.ireport.osf.OSFField;
import jet.ireport.osf.OnScreenFilter;
import jet.lc.impl.JetLCObject;
import jet.report.JRObjectTemplate;
import jet.report.JetRptFilterControl;
import jet.report.formula.JetRptAbstractFormula;
import jet.report.onTheFlyFormula.JetRptFlyFormula;
import jet.report.onTheFlyFormula.JetRptFlyMeasure;
import jet.report.onTheFlyFormula.Scope;
import jet.reportLogic.objectLogic.BasicComponentLogic;
import jet.reportLogic.objectLogic.ObjectLogicFactory;
import jet.reportLogic.objectLogic.OnTheFlyFormulaMeasureLogic;
import jet.reportLogic.objectLogic.OnTheFlyParameterLogic;
import jet.reportset.DataSet;
import jet.reportset.JetRptReport;
import jet.reportset.JetRptReportSet;
import jet.universe.JetUDBTreeNode;
import jet.universe.JetUFldQueryField;
import jet.universe.JetUParameter;
import jet.universe.JetUQueriable;
import jet.universe.JetUQueriableField;
import jet.universe.JetUUniverse;
import jet.universe.businesslogic.BLNode;
import jet.universe.businesslogic.CategoryInfo;
import jet.universe.businesslogic.impl.BLContainerImpl;
import jet.universe.businesslogic.impl.BLNodeImpl;
import jet.universe.businesslogic.impl.UnifiedBusinessView;
import jet.util.NLSBundleInfo;
import jet.util.nls.INLSMap;
import jet.util.nls.NLSApplyParam;
import jet.util.nls.NLSBundle;
import jet.util.nls.NLSDictionary;
import jet.util.nls.NLSValue;

public class MetaNLSKit {
    public static String KEYWORD_DR = "Dynamic Resources";
    public static String KEYWORD_FORMULAS = "Formulas";
    public static String KEYWORD_ADDFORMULA = "Add Formula";
    public static String KEYWORD_AGGS = "Aggregations";
    public static String KEYWORD_ADDAGG = "Add Aggregation";
    public static String KEYWORD_LOCPARAMS = "Local Parameters";
    public static String KEYWORD_GLOPARAMS = "Global Parameters";
    public static String KEYWORD_PARAMS = "Parameters";
    public static String KEYWORD_ADDPARAM = "Add Parameter";
    public static String[] CLSKEYWORDS = new String[]{KEYWORD_DR, KEYWORD_FORMULAS, KEYWORD_ADDFORMULA, KEYWORD_AGGS, KEYWORD_ADDAGG, KEYWORD_LOCPARAMS, KEYWORD_GLOPARAMS, KEYWORD_PARAMS, KEYWORD_ADDPARAM};
    public static String[] WLSKEYWORDS = new String[]{KEYWORD_DR, KEYWORD_FORMULAS, KEYWORD_ADDFORMULA, KEYWORD_AGGS, KEYWORD_ADDAGG, KEYWORD_LOCPARAMS, KEYWORD_GLOPARAMS, KEYWORD_PARAMS, KEYWORD_ADDPARAM};

    public static String getMetaDataNLS(String string, NLSApplyParam nLSApplyParam) {
        if (string == null || string.length() == 0) {
            return string;
        }
        if (MetaNLSKit.isEmptyMetaDataNLS(nLSApplyParam)) {
            return string;
        }
        INLSMap iNLSMap = nLSApplyParam.createNLSTable(null);
        return MetaNLSKit.getMetaDataNLS(string, iNLSMap);
    }

    public static String getMetaDataNLS(String string, INLSMap iNLSMap) {
        if (string == null || string.length() == 0 || iNLSMap == null) {
            return string;
        }
        NLSValue nLSValue = iNLSMap.getTextValue(9, string);
        if (nLSValue == null) {
            return string;
        }
        return nLSValue.isEmptyValue() ? string : nLSValue.getStringValue();
    }

    public static boolean isEmptyMetaDataNLS(NLSApplyParam nLSApplyParam) {
        boolean bl;
        if (nLSApplyParam == null) {
            return true;
        }
        boolean bl2 = bl = nLSApplyParam.getNLSModel() == 2;
        if (!bl) {
            NLSBundleInfo nLSBundleInfo = nLSApplyParam.getBundInfo();
            if (nLSBundleInfo == null) {
                NLSBundle nLSBundle = nLSApplyParam.getReportNLSBundle();
                boolean bl3 = nLSBundle == null;
                boolean bl4 = true;
                if (bl3) {
                    nLSBundle = nLSApplyParam.getCatalogNLSBundle();
                    bl4 = nLSBundle == null;
                }
                boolean bl5 = true;
                if (bl3 && bl4) {
                    NLSDictionary nLSDictionary = nLSApplyParam.getDictionary();
                    boolean bl6 = bl5 = nLSDictionary == null;
                    if (!bl5) {
                        Locale locale = nLSApplyParam.getLocale();
                        bl5 = nLSDictionary.isEmpty(locale);
                    }
                }
                bl = bl3 && bl4 && bl5;
            } else {
                bl = nLSBundleInfo.getIsEmptyBundle();
            }
        }
        return bl;
    }

    public static List<String[]> getNLS(JetRptReportSet[] jetRptReportSetArray, JetUUniverse jetUUniverse, NLSApplyParam nLSApplyParam) {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        if (jetRptReportSetArray == null || jetRptReportSetArray.length == 0 || jetUUniverse == null) {
            return arrayList;
        }
        if (MetaNLSKit.isEmptyMetaDataNLS(nLSApplyParam)) {
            return arrayList;
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (JetRptReportSet jetRptReportSet : jetRptReportSetArray) {
            Object object;
            Object object3;
            Object object4;
            Object object5;
            Iterator iterator;
            Object object6;
            INLSMap iNLSMap = nLSApplyParam.createNLSTable(jetRptReportSet);
            Vector vector = jetRptReportSet.getReports().getChildren();
            for (int i = 0; i < vector.size(); ++i) {
                object6 = (JetRptReport)vector.get(i);
                iterator = ((JetRptReport)object6).getUsedDataSet();
                object5 = iterator.iterator();
                while (object5.hasNext()) {
                    String[] stringArray = (String[])object5.next();
                    object4 = stringArray.getDataSourceName();
                    MetaNLSKit.CLSKEYWORDS((String)object4, iNLSMap, arrayList, arrayList2);
                    object3 = stringArray.getQueryName();
                    String string = stringArray.getBlName();
                    int n = stringArray.getDataResourceType();
                    Scope scope = MetaNLSKit.buildBusinessScope(jetUUniverse, (IReport)object6, (String)object4, (String)object3, string, n);
                    if (n == 0) {
                        object = jetUUniverse.getQueriableByResourceName((String)object4, (String)object3);
                        if (object == null) continue;
                        MetaNLSKit.KEYWORD_ADDFORMULA((JetUQueriable)object, iNLSMap, arrayList, arrayList2);
                        continue;
                    }
                    object = jetUUniverse.getBV((String)object4, string);
                    if (object == null) continue;
                    MetaNLSKit.CLSKEYWORDS(((BLNodeImpl)object).getDisplayName(), iNLSMap, arrayList, arrayList2);
                    MetaNLSKit.KEYWORD_ADDAGG(((BLContainerImpl)object).getBLChildren(), iNLSMap, arrayList, arrayList2);
                    MetaNLSKit.getFlyFormulas(scope, iNLSMap, arrayList, arrayList2);
                    MetaNLSKit.getFlyMeasure(scope, iNLSMap, arrayList, arrayList2);
                    MetaNLSKit.getFlyParameters(scope, iNLSMap, arrayList, arrayList2);
                }
            }
            BasicComponentLogic basicComponentLogic = ObjectLogicFactory.getBasicComponentLogic();
            object6 = new ArrayList();
            basicComponentLogic.getAllPosterityComponentByClass((JetObject)jetRptReportSet, JetRptFilterControl.class, (List)object6);
            if (object6.size() > 0) {
                iterator = object6.iterator();
                while (iterator.hasNext()) {
                    BLNode bLNode;
                    object5 = (JetRptFilterControl)iterator.next();
                    boolean bl = (Boolean)((JRObjectTemplate)object5).getPropertyByName("TitleMapName").getObject();
                    if (bl) continue;
                    object4 = ((JetRptFilterControl)object5).getFilterEntries();
                    object3 = (OnScreenFilter.OSFEntry)object4.get(0);
                    OSFField oSFField = object3.getFieldAt(0);
                    QueryInfo queryInfo = oSFField.getQueryInfo();
                    int n = queryInfo.getDataResoureType();
                    if (n == 0) {
                        object = jetUUniverse.getResourceByName(queryInfo.getDatasourceName(), queryInfo.getQueryName(), oSFField.getFieldName());
                        if (object == null) continue;
                        MetaNLSKit.CLSKEYWORDS(((JetUDBTreeNode)object).getResourceName(), iNLSMap, arrayList, arrayList2);
                        continue;
                    }
                    object = jetUUniverse.getBV(queryInfo.getDatasourceName(), queryInfo.getBLName());
                    if (object == null || (bLNode = ((UnifiedBusinessView)object).getByDisplayName(oSFField.getFieldName())) == null) continue;
                    MetaNLSKit.CLSKEYWORDS(bLNode.getDisplayName(), iNLSMap, arrayList, arrayList2);
                }
            }
            if (((Hashtable)(object5 = (iterator = ObjectLogicFactory.getReportSetLogic()).getUsedParameters(jetUUniverse, jetRptReportSet, false))).size() > 0) {
                Iterator iterator2 = ((Hashtable)object5).values().iterator();
                while (iterator2.hasNext()) {
                    MetaNLSKit.CLSKEYWORDS(((ParamDesc)iterator2.next()).getName(), iNLSMap, arrayList, arrayList2);
                }
            }
            for (String string : CLSKEYWORDS) {
                MetaNLSKit.CLSKEYWORDS(string, iNLSMap, arrayList, arrayList2);
            }
        }
        return arrayList;
    }

    private static void CLSKEYWORDS(String string, INLSMap iNLSMap, List<String[]> list, List<String> list2) {
        String[] stringArray;
        if (string == null || string.length() == 0) {
            return;
        }
        if (list2.contains(string)) {
            return;
        }
        NLSValue nLSValue = iNLSMap.getTextValue(9, string);
        if (nLSValue != null && !nLSValue.isEmptyValue() && !(stringArray = new String[]{string, nLSValue.getStringValue()})[0].equals(stringArray[1])) {
            list.add(stringArray);
            list2.add(string);
        }
    }

    private static void KEYWORD_ADDAGG(BLNode[] bLNodeArray, INLSMap iNLSMap, List<String[]> list, List<String> list2) {
        for (BLNode bLNode : bLNodeArray) {
            MetaNLSKit.CLSKEYWORDS(bLNode.getDisplayName(), iNLSMap, list, list2);
            if (bLNode.getElementType() != 3) continue;
            MetaNLSKit.KEYWORD_ADDAGG(((CategoryInfo)bLNode).getBLChildren(), iNLSMap, list, list2);
        }
    }

    private static void KEYWORD_ADDFORMULA(JetUQueriable jetUQueriable, INLSMap iNLSMap, List<String[]> list, List<String> list2) {
        MetaNLSKit.CLSKEYWORDS(jetUQueriable.getResourceName(), iNLSMap, list, list2);
        Vector vector = jetUQueriable.getFields();
        int n = vector == null ? 0 : vector.size();
        for (int i = 0; i < n; ++i) {
            JetUQueriableField jetUQueriableField = (JetUQueriableField)vector.get(i);
            if (jetUQueriableField instanceof JetUFldQueryField) {
                String string = ((JetUFldQueryField)jetUQueriableField).getTableName();
                MetaNLSKit.CLSKEYWORDS(string, iNLSMap, list, list2);
            }
            MetaNLSKit.CLSKEYWORDS(jetUQueriableField.getResourceName(), iNLSMap, list, list2);
        }
    }

    static Scope buildBusinessScope(JetUUniverse jetUUniverse, IReport iReport, String string, String string2, String string3, int n) {
        if (string == null) {
            QueryInfo queryInfo = null;
            return new Scope(iReport, jetUUniverse, queryInfo);
        }
        return new Scope(iReport, jetUUniverse, string, string2, string3, n);
    }

    static void getFlyFormulas(Scope scope, INLSMap iNLSMap, List<String[]> list, List<String> list2) {
        OnTheFlyFormulaMeasureLogic onTheFlyFormulaMeasureLogic = ObjectLogicFactory.getOnTheFlyFormulaMeasureLogic();
        List list3 = onTheFlyFormulaMeasureLogic.getJetRptFlyFormulaList(scope);
        if (list3 != null && list3.size() > 0) {
            for (JetRptAbstractFormula jetRptAbstractFormula : list3) {
                if (jetRptAbstractFormula.isAnonymousFormula() || !(jetRptAbstractFormula instanceof JetRptFlyFormula)) continue;
                MetaNLSKit.CLSKEYWORDS(((JetRptFlyFormula)jetRptAbstractFormula).getQualifiedDisplayName(), iNLSMap, list, list2);
            }
        }
    }

    static void getFlyMeasure(Scope scope, INLSMap iNLSMap, List<String[]> list, List<String> list2) {
        OnTheFlyFormulaMeasureLogic onTheFlyFormulaMeasureLogic = ObjectLogicFactory.getOnTheFlyFormulaMeasureLogic();
        List list3 = onTheFlyFormulaMeasureLogic.getJetRptFlyMeasureList(scope);
        if (list3 != null && list3.size() > 0) {
            for (JetRptFlyMeasure jetRptFlyMeasure : list3) {
                MetaNLSKit.CLSKEYWORDS(jetRptFlyMeasure.getQualifyDisplayName(), iNLSMap, list, list2);
            }
        }
    }

    static void getFlyParameters(Scope scope, INLSMap iNLSMap, List<String[]> list, List<String> list2) {
        OnTheFlyParameterLogic onTheFlyParameterLogic = ObjectLogicFactory.getOnTheFlyParameterLogic();
        List list3 = onTheFlyParameterLogic.getDynamicParameterList(scope);
        if (list3 != null && list3.size() > 0) {
            for (JetUParameter jetUParameter : list3) {
                MetaNLSKit.CLSKEYWORDS(jetUParameter.getResourceName(), iNLSMap, list, list2);
            }
        }
    }

    public static List<String> getMetaNLSKeys(JetRptReportSet jetRptReportSet, JetUUniverse jetUUniverse, boolean bl) {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        Vector vector = jetRptReportSet.getReports().getChildren();
        for (int i = 0; i < vector.size(); ++i) {
            String[] stringArray2 = (String[])vector.get(i);
            List list = stringArray2.getUsedDataSet();
            for (DataSet object : list) {
                MetaNLSKit.genDataSetMetaNLSKeys(object, arrayList, (IReport)stringArray2, jetUUniverse);
            }
        }
        for (String string : stringArray = bl ? CLSKEYWORDS : WLSKEYWORDS) {
            arrayList.add(string);
        }
        return arrayList;
    }

    static void getFlyFormulas(Scope scope, List<String> list) {
        OnTheFlyFormulaMeasureLogic onTheFlyFormulaMeasureLogic = ObjectLogicFactory.getOnTheFlyFormulaMeasureLogic();
        List list2 = onTheFlyFormulaMeasureLogic.getJetRptFlyFormulaList(scope);
        if (list2 != null && list2.size() > 0) {
            for (JetRptAbstractFormula jetRptAbstractFormula : list2) {
                String string;
                if (jetRptAbstractFormula.isAnonymousFormula() || !(jetRptAbstractFormula instanceof JetRptFlyFormula) || list.contains(string = ((JetRptFlyFormula)jetRptAbstractFormula).getQualifiedDisplayName())) continue;
                list.add(string);
            }
        }
    }

    static void getFlyMeasure(Scope scope, List<String> list) {
        OnTheFlyFormulaMeasureLogic onTheFlyFormulaMeasureLogic = ObjectLogicFactory.getOnTheFlyFormulaMeasureLogic();
        List list2 = onTheFlyFormulaMeasureLogic.getJetRptFlyMeasureList(scope);
        if (list2 != null && list2.size() > 0) {
            for (JetRptFlyMeasure jetRptFlyMeasure : list2) {
                String string = jetRptFlyMeasure.getQualifyDisplayName();
                if (list.contains(string)) continue;
                list.add(string);
            }
        }
    }

    static void getFlyParameters(Scope scope, List<String> list) {
        OnTheFlyParameterLogic onTheFlyParameterLogic = ObjectLogicFactory.getOnTheFlyParameterLogic();
        List list2 = onTheFlyParameterLogic.getDynamicParameterList(scope);
        if (list2 != null && list2.size() > 0) {
            for (JetUParameter jetUParameter : list2) {
                String string = jetUParameter.getResourceName();
                if (list.contains(string)) continue;
                list.add(string);
            }
        }
    }

    public static List<String> getMetaNLSKeys(JetLCObject jetLCObject, JetUUniverse jetUUniverse) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Vector vector = jetLCObject.getContent().getDataSource().getChildren();
        int n = vector == null ? 0 : vector.size();
        for (int i = 0; i < n; ++i) {
            JetObject jetObject = (JetObject)vector.get(i);
            if (!(jetObject instanceof DataSet)) continue;
            MetaNLSKit.genDataSetMetaNLSKeys((DataSet)((Object)jetObject), arrayList, jetLCObject, jetUUniverse);
        }
        for (String string : WLSKEYWORDS) {
            arrayList.add(string);
        }
        return arrayList;
    }

    static void genDataSetMetaNLSKeys(DataSet dataSet, List<String> list, IReport iReport, JetUUniverse jetUUniverse) {
        int n = dataSet.getDataResourceType();
        String string = dataSet.getDataSourceName();
        String string2 = dataSet.getQueryName();
        Scope scope = MetaNLSKit.buildBusinessScope(jetUUniverse, iReport, string, string2, dataSet.getBlName(), n);
        MetaNLSKit.getFlyFormulas(scope, list);
        MetaNLSKit.getFlyMeasure(scope, list);
        MetaNLSKit.getFlyParameters(scope, list);
    }
}

