/*
 * Decompiled with CFR 0.152.
 */
package jet.va.layoutImpl.tools;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.util.List;
import jet.connect.DbBigInt;
import jet.connect.DbDecimal;
import jet.connect.DbDouble;
import jet.connect.DbInteger;
import jet.connect.DbReal;
import jet.connect.DbSmallInt;
import jet.connect.DbTinyInt;
import jet.connect.DbValue;
import jet.util.DbValueFormat;
import jet.util.JFieldValueNLSManager;
import jet.va.layout.VA_Env;
import jet.va.layout.middleResult.cellContent.TextElement;
import jet.va.layout.middleResult.cellContent.TextObj;
import jet.va.layoutImpl.VA_EnvImpl;
import jet.va.layoutImpl.middleResultImpl.cellContentImpl.TextElementImpl;
import jet.va.layoutImpl.middleResultImpl.cellContentImpl.TextObjImpl;
import jet.va.layoutImpl.middleResultImpl.cellContentImpl.geomImpl.TextSegmentImpl;

public class VATools {
    public static double[] calculateAxisMinAndMaxValueWithGap(double d, double d2, double d3) {
        double[] dArray = new double[2];
        double d4 = 0.0;
        dArray[1] = d2;
        dArray[0] = d;
        if (d >= 0.0) {
            d4 = 1.0 - 2.0 * d3 == 0.0 ? d2 : Math.abs((d2 - d) * d3 / (1.0 - 2.0 * d3));
            if (d4 >= d) {
                dArray[1] = d2 + d4;
                dArray[0] = d - d4;
            } else if (d4 >= 0.0) {
                dArray[0] = d;
                d4 = d3 == 1.0 ? d2 : d3 * d2 / (1.0 - d3);
                dArray[1] = d2 + d4;
            } else {
                dArray[1] = d2;
                dArray[0] = d;
            }
        } else if (d2 >= 0.0) {
            d4 = 1.0 - 2.0 * d3 == 0.0 ? d2 : Math.abs((d2 - d) * d3 / (1.0 - 2.0 * d3));
            dArray[1] = d2 + d4;
            dArray[0] = d - d4;
        } else {
            d4 = 1.0 - 2.0 * d3 == 0.0 ? Math.abs(d) : Math.abs((d2 - d) * d3 / (1.0 - 2.0 * d3));
            if (d4 >= Math.abs(d2)) {
                dArray[1] = d2 + d4;
                dArray[0] = d - d4;
            } else if (d4 >= 0.0) {
                dArray[1] = d2;
                d4 = d3 == 1.0 ? -d : d3 * Math.abs(d) / (1.0 - d3);
                dArray[0] = d - d4;
            }
        }
        return dArray;
    }

    public static double[] calculateAxisMinAndMaxValueWithGap(double d, double d2, double d3, boolean bl) {
        double[] dArray = new double[2];
        if (!bl) {
            dArray = VATools.calculateAxisMinAndMaxValueWithGap(d, d2, d3);
        } else if (d > 0.0) {
            dArray[0] = d;
            dArray[1] = d2 + d2 * d3 * 2.0;
        } else if (d2 < 0.0) {
            dArray[0] = d + d * d3 * 2.0;
            dArray[1] = d2;
        } else {
            dArray[0] = d + d * d3;
            dArray[1] = d2 + d2 * d3;
        }
        return dArray;
    }

    public static double getDoubleValueOfMeasureValue(DbValue dbValue) {
        double d = 0.0;
        int n = dbValue.getSqlType();
        if (dbValue.isNull()) {
            return d;
        }
        switch (n) {
            case -5: {
                d = ((DbBigInt)dbValue).get();
                break;
            }
            case 4: {
                d = ((DbInteger)dbValue).get();
                break;
            }
            case 5: {
                d = ((DbSmallInt)dbValue).get();
                break;
            }
            case -6: {
                d = ((DbTinyInt)dbValue).get();
                break;
            }
            case 2: 
            case 3: {
                d = ((DbDecimal)dbValue).get().floatValue();
                break;
            }
            case 6: 
            case 8: {
                d = ((DbDouble)dbValue).get();
                break;
            }
            case 7: {
                d = ((DbReal)dbValue).get();
            }
        }
        return d;
    }

    public static long getLongValueOfMeasureValue(DbValue dbValue) {
        long l = 0L;
        int n = dbValue.getSqlType();
        if (dbValue.isNull()) {
            return l;
        }
        switch (n) {
            case -5: {
                l = ((DbBigInt)dbValue).get();
                break;
            }
            case 4: {
                l = ((DbInteger)dbValue).get();
                break;
            }
            case 5: {
                l = ((DbSmallInt)dbValue).get();
                break;
            }
            case -6: {
                l = ((DbTinyInt)dbValue).get();
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 6: 
            case 8: {
                break;
            }
        }
        return l;
    }

    public static boolean isLongValue(DbValue dbValue) {
        boolean bl = false;
        int n = dbValue.getSqlType();
        switch (n) {
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                bl = true;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: {
                bl = false;
                break;
            }
        }
        return bl;
    }

    public static boolean isOverLap(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        boolean bl = false;
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        Rectangle rectangle2 = new Rectangle(n5, n6, n7, n8);
        if (rectangle.intersects(rectangle2)) {
            bl = true;
        }
        return bl;
    }

    public static boolean isOverLap(GeneralPath generalPath, int n, int n2, int n3, int n4) {
        boolean bl = false;
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        if (generalPath.intersects(rectangle)) {
            bl = true;
        }
        return bl;
    }

    public static boolean isOutTheRange(boolean bl, boolean bl2, int n, int n2, int n3, int n4) {
        boolean bl3 = false;
        if (bl && n4 > n2) {
            bl3 = true;
            return bl3;
        }
        if (bl2 && n3 > n) {
            bl3 = true;
            return bl3;
        }
        return bl3;
    }

    public static int adjustWholePixel(int n, int n2) {
        int n3;
        int n4;
        if (n2 == 0) {
            n2 = 96;
        }
        if ((n4 = n) % (n3 = 5760 / n2) == 0) {
            return n4;
        }
        return n4 + (n3 - n4 % n3);
    }

    public static int reduceToWholePixel(int n, int n2) {
        if (n2 == 0) {
            n2 = 96;
        }
        int n3 = 5760 / n2;
        int n4 = n;
        return n4 / n3;
    }

    public static void rotationTextObject(int n, TextObj textObj) {
        if (n == 90) {
            int n2 = textObj.getWidth();
            int n3 = textObj.getHeight();
            ((TextObjImpl)textObj).setHeight(n2);
            ((TextObjImpl)textObj).setWidth(n3);
            List list = textObj.getTextElements();
            int n4 = list.size();
            int n5 = 0;
            for (int i = 0; i < n4; ++i) {
                ((TextElementImpl)list.get(i)).setDirect(2);
                List list2 = ((TextElement)list.get(i)).getSegments();
                for (int j = 0; j < list2.size(); ++j) {
                    TextSegmentImpl textSegmentImpl = (TextSegmentImpl)list2.get(j);
                    int n6 = textSegmentImpl.getWidth();
                    int n7 = textSegmentImpl.getHeight();
                    int n8 = n5;
                    int n9 = n2 - n6;
                    textSegmentImpl.setX(n8);
                    textSegmentImpl.setY(n9);
                    textSegmentImpl.setWidth(n7);
                    textSegmentImpl.setHeight(n6);
                    n5 += n7;
                }
            }
        }
    }

    public static void setTextObjColor(Color color, TextObj textObj) {
        List list = textObj.getTextElements();
        int n = list.size();
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            ((TextElementImpl)list.get(i)).setColor(color);
        }
    }

    public static boolean outRange(int n, int n2, int n3, int n4, int n5, int n6) {
        boolean bl = true;
        if (n3 <= n && n <= n3 + n5 && n4 <= n2 && n2 <= n2 + n6) {
            bl = false;
        }
        return bl;
    }

    public static String formatValueToString(DbValue dbValue, DbValueFormat dbValueFormat, VA_Env vA_Env, String string) {
        if (dbValue != null && dbValue.isNull()) {
            return "";
        }
        String string2 = null;
        if (dbValueFormat != null && dbValueFormat.getPattern().length() > 0) {
            try {
                string2 = dbValueFormat.format(dbValue);
            }
            catch (Exception exception) {
                string2 = dbValue.toString();
            }
        } else {
            string2 = dbValue.toString();
        }
        if (string != null) {
            String string3;
            String string4 = null;
            JFieldValueNLSManager jFieldValueNLSManager = ((VA_EnvImpl)vA_Env).getCatalogNLSManager();
            if (jFieldValueNLSManager != null && (string3 = ((VA_EnvImpl)vA_Env).getDataMappingBundlePrefix(string)) != null) {
                string4 = jFieldValueNLSManager.getFieldBindNLSValue(string3, string2);
            }
            if (string4 != null) {
                string2 = string4;
            }
        }
        return string2;
    }
}

