/*
 * Decompiled with CFR 0.152.
 */
package jet.viewerchart1;

import chart.ChartComponent;
import chart.ChartCoordinatePaper;
import chart.ChartDefinition;
import chart.ChartLabel;
import chart.ChartLegend;
import chart.ChartPlatform;
import chart.ChartPropertyValues;
import chart.ChartShowValueConditionControl;
import chart.chart2d.Chart2DPaper;
import chart.chart3d.Chart3DPaper;
import chart.chart3d.ChartMatrix;
import chart.data.ChartDataFilter;
import chart.data.ChartDataSetInfo;
import chart.data.ChartDataSetModel;
import chart.data.ChartDefaultValueMap;
import chart.data.ChartTypeInfo;
import chart.graphics.ChartBackground;
import chart.graphics.ChartColorPattern;
import chart.graphics.ChartCustomizedPattern;
import chart.graphics.ChartFillPattern;
import chart.graphics.ChartGradientPattern;
import chart.graphics.ChartIcon;
import chart.graphics.ChartLineStyle;
import chart.graphics.ChartPenStyle;
import chart.graphics.ChartTextStyle;
import chart.graphics.ChartTexturePattern;
import chart.properties.ChartAxisProperties;
import chart.properties.ChartCoordinatePaperProperties;
import chart.properties.ChartGraphProperties;
import chart.properties.ChartLabelProperties;
import chart.properties.ChartLegendProperties;
import chart.properties.ChartNodeProperties;
import chart.properties.ChartNumericAxisProperties;
import chart.properties.ChartPlatformProperties;
import chart.properties.ChartWallProperties;
import chart.util.ChartRenderTools;
import guitools.toolkit.Unit;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;

public class ChartAppletPropertiesLoader {
    public ChartPlatformProperties platformP;
    public ChartCoordinatePaperProperties paperP;
    public ChartLegendProperties legendP;
    private List BUILTINICON;
    private Rectangle CategoryKey;
    private Rectangle I;
    private Rectangle SEDU;
    private List SeriesKey;
    protected HashMap appletProperties;
    private boolean VALUELABEL_POSITION_ENUMERATIONS = false;
    protected final String NO_COLOR = "No_Color";
    protected final String AXIS_PREFIX = "Axis";
    protected final String WALL_PREFIX = "Wall";
    protected final String BACKGROUND_PREFIX = "Background";
    protected final String TEXTSTYLE_PREFIX = "Text";
    protected final String PENSTYLE_PREFIX = "Pen";
    protected final String FILLPATTERN_PREFIX = "Pattern";
    boolean is3DEffect = false;
    protected ChartDefinition def;
    float[] scrollInfo = null;
    int legendScrollId = 0;
    int roundModeEnum = 6;
    int res = 96;
    String timeZoneID = null;
    String localeLan = null;
    public boolean interactive = true;
    public ChartShowValueConditionControl control;

    public ChartAppletPropertiesLoader(Map map) {
        this.appletProperties = (HashMap)map;
        this.def = new ChartDefinition();
    }

    public void init() {
        Cloneable cloneable;
        HashMap hashMap = (HashMap)this.appletProperties.get(ChartRenderTools.platformKey);
        Object v = this.appletProperties.get(ChartRenderTools.labelKey);
        ArrayList arrayList = v == null ? null : (ArrayList)v;
        HashMap hashMap2 = (HashMap)this.appletProperties.get(ChartRenderTools.legendKey);
        HashMap hashMap3 = (HashMap)this.appletProperties.get(ChartRenderTools.paperKey);
        this.CategoryKey = this.getObjectBounds(this.appletProperties, null);
        this.platformP = this.getChartPlatformProperties(this.appletProperties);
        if (this.appletProperties.get("RoundingMode") != null) {
            this.roundModeEnum = (Integer)this.appletProperties.get("RoundingMode");
        }
        if (this.appletProperties.get("Resolution") != null) {
            this.res = (Integer)this.appletProperties.get("Resolution");
        }
        if (this.appletProperties.get("TimeZoneID") != null) {
            this.timeZoneID = this.appletProperties.get("TimeZoneID").toString();
        }
        if (arrayList != null) {
            this.BUILTINICON = new ArrayList();
            this.SeriesKey = new ArrayList();
            for (int i = 0; i < arrayList.size(); ++i) {
                cloneable = (HashMap)arrayList.get(i);
                this.SeriesKey.add(this.getObjectBounds((HashMap)cloneable, ChartRenderTools.labelKey));
                this.BUILTINICON.add(this.getChartLabelProperties((HashMap)cloneable));
            }
        } else {
            this.SeriesKey = null;
            this.BUILTINICON = null;
        }
        this.SEDU = this.getObjectBounds(this.appletProperties, ChartRenderTools.legendKey);
        this.legendP = this.getChartLegendProperties(hashMap2);
        this.I = this.getObjectBounds(this.appletProperties, ChartRenderTools.paperKey);
        this.paperP = this.getChartPaperProperties(hashMap3);
        cloneable = (ArrayList)this.appletProperties.get(ChartRenderTools.lineNodeKey);
        ArrayList arrayList2 = this.AXIS_PREFIX((List)((Object)cloneable));
        this.paperP.getGraphProperties().setLineNodeList(arrayList2);
        if (this.appletProperties.get("ScrollInfoStart") != null && this.appletProperties.get("ScrollInfoEnd") != null) {
            this.scrollInfo = new float[2];
            this.scrollInfo[0] = Float.parseFloat((String)this.appletProperties.get("ScrollInfoStart"));
            this.scrollInfo[1] = Float.parseFloat((String)this.appletProperties.get("ScrollInfoEnd"));
        }
        if (this.appletProperties.get("LegendScrollLabelIndex") != null) {
            this.legendScrollId = Integer.parseInt((String)this.appletProperties.get("LegendScrollLabelIndex"));
        }
        this.control = this.getConditionalControl((HashMap)this.appletProperties.get(ChartRenderTools.conditionalKey));
        if (hashMap3.get("Interactive") != null) {
            this.interactive = (Boolean)hashMap3.get("Interactive");
        }
        this.VALUELABEL_POSITION_ENUMERATIONS = true;
    }

    private ArrayList AXIS_PREFIX(List list) {
        ArrayList<ChartNodeProperties> arrayList = new ArrayList<ChartNodeProperties>();
        for (int i = 0; i < list.size(); ++i) {
            HashMap hashMap = (HashMap)list.get(i);
            ChartNodeProperties chartNodeProperties = new ChartNodeProperties();
            chartNodeProperties.setShapeStyle(((Number)hashMap.get("LineNodeStyle")).intValue());
            chartNodeProperties.setShapeWidth(((Number)hashMap.get("LineNodeWidth")).intValue());
            chartNodeProperties.setShapeHeight(((Number)hashMap.get("LineNodeHeight")).intValue());
            chartNodeProperties.setCusNFill((Boolean)hashMap.get("CusNormalPointFillColor"));
            chartNodeProperties.setNFillClr(this.mapStringToColor((String)hashMap.get("NormalPointFillColor")));
            chartNodeProperties.setNFillClrTrans(((Number)hashMap.get("NormalFillColorTransparency")).floatValue());
            chartNodeProperties.setCusLFill((Boolean)hashMap.get("CusLowestPointFillColor"));
            chartNodeProperties.setLFillClr(this.mapStringToColor((String)hashMap.get("LowestPointFillColor")));
            chartNodeProperties.setCusHFill((Boolean)hashMap.get("CusHighestPointFillColor"));
            chartNodeProperties.setHFillClr(this.mapStringToColor((String)hashMap.get("HighestPointFillColor")));
            chartNodeProperties.setBorderClr(this.mapStringToColor((String)hashMap.get("LineNodeBorderPenColor")));
            chartNodeProperties.setBorderClrTrans(((Number)hashMap.get("LineNodeBorderPenTransparency")).intValue());
            chartNodeProperties.setBorderStyle(((Number)hashMap.get("LineNodeBorderPenStyle")).intValue());
            chartNodeProperties.setBorderThickness(((Number)hashMap.get("LineNodeBorderPenThickness")).intValue());
            if (hashMap.get("ShowHighLightNode") != null) {
                chartNodeProperties.setShowHighLightNode(this.FILLPATTERN_PREFIX(hashMap.get("ShowHighLightNode").toString()));
            }
            if (hashMap.get("HighLightNodeColor") != null) {
                chartNodeProperties.setHighLightNodeClr(this.mapStringToColor(hashMap.get("HighLightNodeColor").toString()));
            }
            arrayList.add(chartNodeProperties);
        }
        return arrayList;
    }

    protected Rectangle getObjectBounds(HashMap hashMap, String string) {
        HashMap hashMap2 = string == null ? hashMap : (string == ChartRenderTools.labelKey ? hashMap : (HashMap)hashMap.get(string));
        int n = ((Number)hashMap2.get("X")).intValue();
        int n2 = ((Number)hashMap2.get("Y")).intValue();
        int n3 = ((Number)hashMap2.get("Width")).intValue();
        int n4 = ((Number)hashMap2.get("Height")).intValue();
        return new Rectangle(n, n2, n3, n4);
    }

    protected ChartPlatformProperties getChartPlatformProperties(HashMap hashMap) {
        ChartPlatformProperties chartPlatformProperties = new ChartPlatformProperties();
        chartPlatformProperties.setTopMargin(((Number)hashMap.get("TopMargin")).intValue());
        chartPlatformProperties.setLeftMargin(((Number)hashMap.get("LeftMargin")).intValue());
        chartPlatformProperties.setRightMargin(((Number)hashMap.get("RightMargin")).intValue());
        chartPlatformProperties.setBottomMargin(((Number)hashMap.get("BottomMargin")).intValue());
        chartPlatformProperties.setBackground(this.getBackground("Platform", hashMap));
        chartPlatformProperties.setAutoLayout((Boolean)hashMap.get("AutoLayout"));
        chartPlatformProperties.setShowLegend((Boolean)hashMap.get("ShowLegend"));
        chartPlatformProperties.setPatterns(ChartRenderTools.mapPatterns((String)hashMap.get("PatternList")));
        chartPlatformProperties.setAntiAliasing((Boolean)hashMap.get("AntiAliasing"));
        chartPlatformProperties.setBindedPatterns(this.BACKGROUND_PREFIX(hashMap));
        chartPlatformProperties.setBindedLineStyles(ChartAppletPropertiesLoader.BUILTINICON(hashMap));
        if (hashMap.get("MinSpaceInTickMarks") != null) {
            chartPlatformProperties.setMinTickMarkerSpace(ChartRenderTools.convertPixelToUnit(((Number)hashMap.get("MinSpaceInTickMarks")).intValue(), this.res));
        }
        return chartPlatformProperties;
    }

    private Map BACKGROUND_PREFIX(HashMap hashMap) {
        Hashtable<Object, ChartFillPattern> hashtable = new Hashtable<Object, ChartFillPattern>();
        StringTokenizer stringTokenizer = new StringTokenizer((String)hashMap.get("BindedValues"), "\u0007");
        String string = (String)hashMap.get("BindedPatterns");
        ChartFillPattern[] chartFillPatternArray = ChartRenderTools.mapPatterns(string);
        int n = 0;
        while (stringTokenizer.hasMoreElements()) {
            if (chartFillPatternArray[n] != null) {
                hashtable.put(stringTokenizer.nextElement(), chartFillPatternArray[n]);
            } else {
                ChartColorPattern chartColorPattern = new ChartColorPattern();
                chartColorPattern.setNoFill(true);
                hashtable.put(stringTokenizer.nextElement(), chartColorPattern);
            }
            ++n;
        }
        return hashtable;
    }

    private static Map BUILTINICON(Map map) {
        Hashtable<Object, ChartLineStyle> hashtable = new Hashtable<Object, ChartLineStyle>();
        StringTokenizer stringTokenizer = new StringTokenizer((String)map.get("BindedLineValues"), "\u0007");
        StringTokenizer stringTokenizer2 = new StringTokenizer((String)map.get("BindedLineStyles"), "\u0007");
        Object object = null;
        Object object2 = null;
        while (stringTokenizer.hasMoreTokens() && stringTokenizer2.hasMoreElements()) {
            object = stringTokenizer.nextElement();
            object2 = stringTokenizer2.nextElement();
            if (object == null || object2 == null) continue;
            hashtable.put(object, ChartAppletPropertiesLoader.mapChartLineStyle((String)object2));
        }
        return hashtable;
    }

    static ChartLineStyle mapChartLineStyle(String string) {
        if (string == null) {
            return null;
        }
        String[] stringArray = string.split(",");
        int n = Integer.parseInt(stringArray[0]);
        int n2 = Integer.parseInt(stringArray[1]);
        int n3 = 0;
        if (stringArray.length > 2) {
            n3 = Unit.convertUnitToPixel(Integer.parseInt(stringArray[2]));
        }
        ChartLineStyle chartLineStyle = new ChartLineStyle(n, n2, n3);
        return chartLineStyle;
    }

    protected ChartCoordinatePaperProperties getChartPaperProperties(HashMap hashMap) {
        Object object;
        ChartCoordinatePaperProperties chartCoordinatePaperProperties = new ChartCoordinatePaperProperties();
        chartCoordinatePaperProperties.setTopMargin(((Number)hashMap.get("TopMargin")).intValue());
        chartCoordinatePaperProperties.setLeftMargin(((Number)hashMap.get("LeftMargin")).intValue());
        chartCoordinatePaperProperties.setRightMargin(((Number)hashMap.get("RightMargin")).intValue());
        chartCoordinatePaperProperties.setBottomMargin(((Number)hashMap.get("BottomMargin")).intValue());
        chartCoordinatePaperProperties.setBackground(this.getBackground("Paper", hashMap));
        chartCoordinatePaperProperties.setScaleX((float)((Number)hashMap.get("ScaleX")).intValue() / 100.0f);
        chartCoordinatePaperProperties.setScaleY((float)((Number)hashMap.get("ScaleY")).intValue() / 100.0f);
        chartCoordinatePaperProperties.setScaleZ((float)((Number)hashMap.get("ScaleZ")).intValue() / 100.0f);
        chartCoordinatePaperProperties.setAngleX(((Number)hashMap.get("AngleX")).intValue());
        chartCoordinatePaperProperties.setAngleY(((Number)hashMap.get("AngleY")).intValue());
        chartCoordinatePaperProperties.setAngleZ(((Number)hashMap.get("AngleZ")).intValue());
        ChartMatrix chartMatrix = new ChartMatrix();
        chartMatrix._xrot(chartCoordinatePaperProperties.getAngleX());
        chartMatrix.yrot(chartCoordinatePaperProperties.getAngleY());
        chartMatrix.zrot(chartCoordinatePaperProperties.getAngleZ());
        chartCoordinatePaperProperties.setRotationMatrix(chartMatrix.getMatrix());
        chartCoordinatePaperProperties.setGraphPosition(((Number)hashMap.get("GraphPosition")).intValue());
        chartCoordinatePaperProperties.setReversePaintingOrder((Boolean)hashMap.get("ReversePaintingOrder"));
        chartCoordinatePaperProperties.setPerspective(((Number)hashMap.get("Perspective")).intValue());
        chartCoordinatePaperProperties.setValueLabelPositionList(this.mapValueLabelPositions((String)hashMap.get("ValueLabelPositionList")));
        chartCoordinatePaperProperties.setHintTextStyle(this.getTextStyle("Hint", hashMap));
        chartCoordinatePaperProperties.setShowTips((Boolean)hashMap.get("ShowTips"));
        chartCoordinatePaperProperties.setShadowContents((Boolean)hashMap.get("ShadowContents"));
        chartCoordinatePaperProperties.setShowWall((Boolean)hashMap.get("ShowWall"));
        chartCoordinatePaperProperties.setWallProperties(this.getWallProperties("Wall", hashMap));
        chartCoordinatePaperProperties.setShowFloor((Boolean)hashMap.get("ShowFloor"));
        chartCoordinatePaperProperties.setFloorProperties(this.getWallProperties("Floor", hashMap));
        chartCoordinatePaperProperties.setShowAxisX((Boolean)hashMap.get("ShowAxisX"));
        chartCoordinatePaperProperties.setAxisXProperties(this.getChartAxisProperties(hashMap, "X", true));
        chartCoordinatePaperProperties.setShowAxisY((Boolean)hashMap.get("ShowAxisY"));
        chartCoordinatePaperProperties.setAxisYProperties((ChartNumericAxisProperties)this.getChartAxisProperties(hashMap, "Y", true));
        chartCoordinatePaperProperties.setShowAxisY2((Boolean)hashMap.get("ShowAxisY2"));
        chartCoordinatePaperProperties.setAxisY2Properties((ChartNumericAxisProperties)this.getChartAxisProperties(hashMap, "Y2", true));
        chartCoordinatePaperProperties.setShowAxisZ((Boolean)hashMap.get("ShowAxisZ"));
        chartCoordinatePaperProperties.setAxisZProperties(this.getChartAxisProperties(hashMap, "Z", false));
        chartCoordinatePaperProperties.setShowCategoryAndSeries((Boolean)hashMap.get("ShowCategoryAndSeries"));
        if (hashMap.get("ValueLabelSmartShowList") != null) {
            object = (String)hashMap.get("ValueLabelSmartShowList");
            chartCoordinatePaperProperties.setValueLabelSmartShow(this.mapStringToIntArray((String)object));
        }
        object = chartCoordinatePaperProperties.getGraphProperties();
        ((ChartGraphProperties)object).setContour((Boolean)hashMap.get("Contour"));
        ((ChartGraphProperties)object).setContourPen(this.getPen("Contour", hashMap));
        ((ChartGraphProperties)object).setBarWidth((float)((Number)hashMap.get("BarWidth")).intValue() / 100.0f);
        ((ChartGraphProperties)object).setDepth(((Number)hashMap.get("BarDepth")).intValue());
        ((ChartGraphProperties)object).setUseDepth((Boolean)hashMap.get("UseDepth"));
        ((ChartGraphProperties)object).setDepthDirection(((Number)hashMap.get("BarDepthDirection")).intValue());
        ((ChartGraphProperties)object).setVaryColorbyValues((Boolean)hashMap.get("VaryColorByValues"));
        ((ChartGraphProperties)object).setBarGap((float)((Number)hashMap.get("BarGap")).intValue() / 100.0f);
        ((ChartGraphProperties)object).setBarStyle(((Number)hashMap.get("BarStyle")).intValue());
        ((ChartGraphProperties)object).setUseDropline((Boolean)hashMap.get("UseDropline"));
        ((ChartGraphProperties)object).setLineThickness(((Number)hashMap.get("LineThickness")).intValue());
        ((ChartGraphProperties)object).setLineNodeStyle(((Number)hashMap.get("LineNodeStyle")).intValue());
        ((ChartGraphProperties)object).setLineNodeWidth(((Number)hashMap.get("LineNodeWidth")).intValue());
        ((ChartGraphProperties)object).setLineNodeHeight(((Number)hashMap.get("LineNodeHeight")).intValue());
        ((ChartGraphProperties)object).setLineNodePen(this.getPen("LineNodeBorder", hashMap));
        ((ChartGraphProperties)object).setLineNodeColor(this.mapStringToColor((String)hashMap.get("LineNodeFillColor")));
        ((ChartGraphProperties)object).setLineNodeFillTransparency(((Number)hashMap.get("LineNodeFillColorTransparency")).floatValue());
        ((ChartGraphProperties)object).setRadarIsFill((Boolean)hashMap.get("RadarIsFill"));
        ((ChartGraphProperties)object).setRadarFillTransparence((float)((Number)hashMap.get("RadarFillTransparence")).intValue() / 100.0f);
        ((ChartGraphProperties)object).setRadarIsShowColumnName((Boolean)hashMap.get("RadarIsShowColumnName"));
        ((ChartGraphProperties)object).setRadarArrowStyle(((Number)hashMap.get("RadarArrowStyle")).intValue());
        ((ChartGraphProperties)object).setValueLabelType(((Number)hashMap.get("ValueLabelType")).intValue());
        ((ChartGraphProperties)object).setPieGap(((Number)hashMap.get("PieGap")).intValue());
        ((ChartGraphProperties)object).setPieExplodeDistance(((Number)hashMap.get("SectionExplodeGap")).intValue());
        ((ChartGraphProperties)object).setShowPieName((Boolean)hashMap.get("ShowPieName"));
        ((ChartGraphProperties)object).setSuppressZeroLabel((Boolean)hashMap.get("SuppressZeroLabel"));
        ((ChartGraphProperties)object).setDonutWidth(((Number)hashMap.get("PieDoughnutPercent")).intValue());
        if (hashMap.get("MotionSpeedControl") != null) {
            ((ChartGraphProperties)object).setMotionControlSpeed(((Number)hashMap.get("MotionSpeedControl")).intValue());
        }
        ((ChartGraphProperties)object).setStockUpBarColor(this.mapStringToColor((String)hashMap.get("StockUpBarColor")));
        ((ChartGraphProperties)object).setStockDownBarColor(this.mapStringToColor((String)hashMap.get("StockDownBarColor")));
        ((ChartGraphProperties)object).setStockLineColor(this.mapStringToColor((String)hashMap.get("StockLineColor")));
        ((ChartGraphProperties)object).setCutBubble((Boolean)hashMap.get("CutBubbleBasedOnXYArea"));
        ((ChartGraphProperties)object).setGaugeNormalValueMin(((Number)hashMap.get("GaugeNormalValueMin")).doubleValue());
        ((ChartGraphProperties)object).setGaugeNormalValueMax(((Number)hashMap.get("GaugeNormalValueMax")).doubleValue());
        ((ChartGraphProperties)object).setGaugeAlertValueMin(((Number)hashMap.get("GaugeAlertValueMin")).doubleValue());
        ((ChartGraphProperties)object).setGaugeAlertValueMax(((Number)hashMap.get("GaugeAlertValueMax")).doubleValue());
        ((ChartGraphProperties)object).setGaugeErrorValueMin(((Number)hashMap.get("GaugeErrorValueMin")).doubleValue());
        ((ChartGraphProperties)object).setGaugeErrorValueMax(((Number)hashMap.get("GaugeErrorValueMax")).doubleValue());
        ((ChartGraphProperties)object).setGuagePatterns(this.getFillPatternNoFill("GaugeNormal", hashMap), this.getFillPatternNoFill("GaugeAlert", hashMap), this.getFillPatternNoFill("GaugeError", hashMap));
        ((ChartGraphProperties)object).setGaugeDialStartAngle(((Number)hashMap.get("GaugeDialStartAngle")).intValue());
        ((ChartGraphProperties)object).setGaugeDialStopAngle(((Number)hashMap.get("GaugeDialStopAngle")).intValue());
        ((ChartGraphProperties)object).setGaugeDialLineStyle(((Number)hashMap.get("GaugeDialLineStyle")).intValue());
        ((ChartGraphProperties)object).setGaugeDialLineArrowStyle(((Number)hashMap.get("GaugeDialLineArrowStyle")).intValue());
        ((ChartGraphProperties)object).setGaugeDialCurveIsFill((Boolean)hashMap.get("GaugeDialCurveIsFill"));
        ((ChartGraphProperties)object).setGaugeDialOuterInnerGap(((Number)hashMap.get("GaugeDialOuterInnerGap")).intValue());
        ((ChartGraphProperties)object).setGaugeDialCurveStyle(((Number)hashMap.get("GaugeDialCurveStyle")).intValue());
        ((ChartGraphProperties)object).setRadiusRange(((Number)hashMap.get("RadiusRange")).floatValue() / 100.0f);
        ((ChartGraphProperties)object).setHorizonalMargin(((Number)hashMap.get("HorizontalMargin")).intValue());
        ((ChartGraphProperties)object).setVerticalMargin(((Number)hashMap.get("VerticalMargin")).intValue());
        ((ChartGraphProperties)object).setGaugeBarLayout(((Number)hashMap.get("GaugeBarLayout")).intValue());
        ((ChartGraphProperties)object).setGaugeBarPen(this.getPen("GaugeBar", hashMap));
        ((ChartGraphProperties)object).setShowThresholdLine((Boolean)hashMap.get("ShowThresholdLine"));
        ((ChartGraphProperties)object).setThresholdValue(((Number)hashMap.get("ThresholdValue")).doubleValue());
        ((ChartGraphProperties)object).setThresholdLineColor(this.mapStringToColor((String)hashMap.get("ThresholdLineColor")));
        ((ChartGraphProperties)object).setFillThreshold((Boolean)hashMap.get("FillThreshold"));
        ((ChartGraphProperties)object).setShowThresholdLine2((Boolean)hashMap.get("ShowThresholdLine2"));
        ((ChartGraphProperties)object).setThresholdValue2(((Number)hashMap.get("ThresholdValue2")).doubleValue());
        ((ChartGraphProperties)object).setThresholdLineColor2(this.mapStringToColor((String)hashMap.get("ThresholdLineColor2")));
        ((ChartGraphProperties)object).setFillThreshold2((Boolean)hashMap.get("FillThreshold2"));
        ((ChartGraphProperties)object).setThresholdLineStyle(((Number)hashMap.get("ThresholdLineStyle")).intValue());
        ((ChartGraphProperties)object).setThresholdFillTransparency((float)((Number)hashMap.get("FillTransparent")).intValue() / 100.0f);
        ((ChartGraphProperties)object).setShowMeanLine((Boolean)hashMap.get("ShowMeanLine"));
        ((ChartGraphProperties)object).setMeanLineColor(this.mapStringToColor((String)hashMap.get("MeanLineColor")));
        ((ChartGraphProperties)object).setMeanLineNodeStyle(((Number)hashMap.get("MeanLineNodeStyle")).intValue());
        ((ChartGraphProperties)object).setMeanLineType(((Number)hashMap.get("MeanLineType")).intValue());
        ((ChartGraphProperties)object).setUse3DEffect((Boolean)hashMap.get("Use3DEffect"));
        ((ChartGraphProperties)object).setAreaPatternList(ChartRenderTools.mapPatterns((String)hashMap.get("AreaPatternList")));
        ((ChartGraphProperties)object).setLineStyleList(hashMap.get("LineStyleList").toString());
        ((ChartGraphProperties)object).setBulletDataSize(hashMap.get("BulletData").toString());
        ((ChartGraphProperties)object).setIsHorizontal((Boolean)hashMap.get("IsHorizontal"));
        ((ChartGraphProperties)object).setSpecialFeatureMeasureType(((Number)hashMap.get("SpecialFeatureMeasureType")).intValue());
        ((ChartGraphProperties)object).setSpecialFeatureMeasureWidth(((Number)hashMap.get("FeatureMeasureWidth")).intValue());
        ((ChartGraphProperties)object).setFeatureMeasureColor(this.mapStringToColor((String)hashMap.get("FeatureMeasureColor")));
        ((ChartGraphProperties)object).setComparativeMeasureWidth(((Number)hashMap.get("ComparativeMeasureWidth")).intValue());
        ((ChartGraphProperties)object).setQualitativeRangesColorList(ChartRenderTools.mapPatterns((String)hashMap.get("QualitativeRangesColorList")));
        ((ChartGraphProperties)object).setComparativeMeasureColorList(ChartRenderTools.mapPatterns((String)hashMap.get("ComparativeMeasureColorList")));
        ((ChartGraphProperties)object).setQualitativeRangesWidth(((Number)hashMap.get("QualitativeRangesWidth")).intValue());
        if (hashMap.get("PieSlimLegPatternColor") != null) {
            ((ChartGraphProperties)object).setPieSlimLegColor(ChartRenderTools.mapStringToColor(hashMap.get("PieSlimLegPatternColor").toString()));
        }
        if (hashMap.get("PieAngleX") != null) {
            ((ChartGraphProperties)object).setPieXRotation(((Number)hashMap.get("PieAngleX")).floatValue());
        }
        if (hashMap.get("PieAngleY") != null) {
            ((ChartGraphProperties)object).setPieYRotation(((Number)hashMap.get("PieAngleY")).floatValue());
        }
        if (hashMap.get("LEDChartMaxValues") != null) {
            // empty if block
        }
        if (hashMap.get("LEDChartMinValues") != null) {
            // empty if block
        }
        if (hashMap.get("LEDChartColorItems") != null) {
            // empty if block
        }
        if (hashMap.get("LEDChartImageItems") != null) {
            // empty if block
        }
        if (hashMap.get("LEDChartNameItems") != null) {
            // empty if block
        }
        if (hashMap.get("LEDChartOtherColor") != null) {
            // empty if block
        }
        if (hashMap.get("LEDChartOtherImage") != null) {
            // empty if block
        }
        if (hashMap.get("LEDChartOtherName") != null) {
            // empty if block
        }
        if (hashMap.get("LEDChartUseImage") != null) {
            // empty if block
        }
        if (hashMap.get("LEDChartBorderStyle") != null) {
            // empty if block
        }
        ((ChartGraphProperties)object).setLineStyleList(hashMap.get("LineStyleList").toString());
        if (hashMap.get("IgnoreNullValue") != null && hashMap.get("IgnoreNullValue") instanceof Boolean) {
            ((ChartGraphProperties)object).setIgnoreNullValue((Boolean)hashMap.get("IgnoreNullValue"));
        }
        return chartCoordinatePaperProperties;
    }

    protected ChartLegendProperties getChartLegendProperties(HashMap hashMap) {
        ChartLegendProperties chartLegendProperties = new ChartLegendProperties();
        chartLegendProperties.setTopMargin(((Number)hashMap.get("TopMargin")).intValue());
        chartLegendProperties.setLeftMargin(((Number)hashMap.get("LeftMargin")).intValue());
        chartLegendProperties.setRightMargin(((Number)hashMap.get("RightMargin")).intValue());
        chartLegendProperties.setBottomMargin(((Number)hashMap.get("BottomMargin")).intValue());
        chartLegendProperties.setBackground(this.getBackground("Legend", hashMap));
        chartLegendProperties.setAutoSize((Boolean)hashMap.get("AutoSize"));
        chartLegendProperties.setPlacement(((Number)hashMap.get("Placement")).intValue());
        chartLegendProperties.setLabelFilterSource(((Number)hashMap.get("LabelFilterSource")).intValue());
        chartLegendProperties.setLegendFilter(ChartRenderTools.mapChartDataFilter((String)hashMap.get("LegendFilter")));
        chartLegendProperties.setLabelVSpacing(((Number)hashMap.get("LabelVSpacing")).intValue());
        chartLegendProperties.setLabelHSpacing(((Number)hashMap.get("LabelHSpacing")).intValue());
        chartLegendProperties.setSubPlacement(((Number)hashMap.get("SubPlacement")).intValue());
        chartLegendProperties.setIconStyleList(this.mapIconStyles((String)hashMap.get("IconStyleList")));
        chartLegendProperties.setReverseLabels((Boolean)hashMap.get("ReverseLabels"));
        chartLegendProperties.setShowTips((Boolean)hashMap.get("ShowTips"));
        chartLegendProperties.setShowValues((Boolean)hashMap.get("ShowValues"));
        String string = hashMap.get("ValueFormat") != null ? (String)hashMap.get("ValueFormat") : null;
        ChartDataFilter chartDataFilter = null;
        if (string != null) {
            chartDataFilter = ChartRenderTools.mapChartDataFilter(string);
            if (chartDataFilter != null) {
                chartDataFilter.setRoundMode(this.roundModeEnum);
                if (this.timeZoneID != null) {
                    chartDataFilter.setTimeZone(TimeZone.getTimeZone(this.timeZoneID));
                }
            }
            chartLegendProperties.setValueFormat(chartDataFilter);
        }
        boolean bl = (Boolean)hashMap.get("ShowPercent");
        chartLegendProperties.setShowPercent(bl);
        if (bl) {
            string = hashMap.get("PercentFormat") != null ? (String)hashMap.get("PercentFormat") : null;
            ChartDataFilter chartDataFilter2 = null;
            if (string != null && (chartDataFilter2 = ChartRenderTools.mapChartDataFilter(string)) != null) {
                chartDataFilter2.setRoundMode(this.roundModeEnum);
            }
            chartLegendProperties.setPercentFormat(chartDataFilter2);
        }
        if (hashMap.get("MarkNodeUsage") != null) {
            int n = ((Number)hashMap.get("MarkNodeUsage")).intValue();
            switch (n) {
                case 0: {
                    chartLegendProperties.setShowLineForLineChart(false);
                    chartLegendProperties.setInheritShapeFromNode(false);
                    break;
                }
                case 1: {
                    chartLegendProperties.setShowLineForLineChart(true);
                    chartLegendProperties.setInheritShapeFromNode(false);
                    break;
                }
                case 2: {
                    chartLegendProperties.setShowLineForLineChart(false);
                    chartLegendProperties.setInheritShapeFromNode(true);
                }
            }
        }
        ChartLabelProperties chartLabelProperties = chartLegendProperties.getLabelStyle();
        chartLabelProperties.setTextStyle(this.getTextStyle("Label", hashMap));
        chartLabelProperties.setTextAlignment(((Number)hashMap.get("TextAlignment")).intValue());
        chartLabelProperties.setIconAlignment(((Number)hashMap.get("IconAlignment")).intValue());
        chartLabelProperties.setIconTextGap(((Number)hashMap.get("IconTextGap")).intValue());
        ChartIcon chartIcon = new ChartIcon();
        chartIcon.setIconWidth(((Number)hashMap.get("IconWidth")).intValue());
        chartIcon.setIconHeight(((Number)hashMap.get("IconHeight")).intValue());
        chartIcon.setPen(this.getPen("IconBorder", hashMap));
        chartIcon.setColor(this.getFillPattern("IconFill", hashMap));
        chartLabelProperties.setIcon(chartIcon);
        if (hashMap.get("ShowScrollbar") != null) {
            chartLegendProperties.setIsScroll((Boolean)hashMap.get("ShowScrollbar"));
        }
        if (hashMap.get("Truncate") != null) {
            chartLegendProperties.setIsTruncate((Boolean)hashMap.get("Truncate"));
        }
        if (hashMap.get("TotalValueText") != null) {
            chartLegendProperties.setCustomerTotalLabel(hashMap.get("TotalValueText").toString());
        }
        return chartLegendProperties;
    }

    protected ChartLabelProperties getChartLabelProperties(HashMap hashMap) {
        ChartLabelProperties chartLabelProperties = new ChartLabelProperties();
        chartLabelProperties.setTopMargin(((Number)hashMap.get("TopMargin")).intValue());
        chartLabelProperties.setLeftMargin(((Number)hashMap.get("LeftMargin")).intValue());
        chartLabelProperties.setRightMargin(((Number)hashMap.get("RightMargin")).intValue());
        chartLabelProperties.setBottomMargin(((Number)hashMap.get("BottomMargin")).intValue());
        chartLabelProperties.setBackground(this.getBackground("Label", hashMap));
        chartLabelProperties.setText((String)hashMap.get("Text"));
        chartLabelProperties.setTextStyle(this.getTextStyle("Label", hashMap));
        chartLabelProperties.setTextAlignment(((Number)hashMap.get("TextAlignment")).intValue());
        chartLabelProperties.setIconAlignment(((Number)hashMap.get("IconAlignment")).intValue());
        chartLabelProperties.setIconTextGap(((Number)hashMap.get("IconTextGap")).intValue());
        ChartIcon chartIcon = new ChartIcon();
        int n = ((Number)hashMap.get("IconStyle")).intValue();
        n = n == 0 ? ChartIcon.BUILTINICON.length : --n;
        chartIcon.setIconStyle(n);
        chartIcon.setIconWidth(((Number)hashMap.get("IconWidth")).intValue());
        chartIcon.setIconHeight(((Number)hashMap.get("IconHeight")).intValue());
        chartIcon.setPen(this.getPen("IconBorder", hashMap));
        chartIcon.setColor(this.getFillPattern("IconFill", hashMap));
        chartLabelProperties.setIcon(chartIcon);
        chartLabelProperties.setTitleType(((Number)hashMap.get("TitleType")).intValue());
        return chartLabelProperties;
    }

    protected ChartAxisProperties getChartAxisProperties(HashMap hashMap, String string, boolean bl) {
        String string2 = "Axis" + string;
        ChartAxisProperties chartAxisProperties = bl ? new ChartNumericAxisProperties() : new ChartAxisProperties();
        chartAxisProperties.setAxisPen(this.getPen(string2, hashMap));
        chartAxisProperties.setShowGrid((Boolean)hashMap.get(string2 + "ShowGrid"));
        chartAxisProperties.setGridPen(this.getPen(string2 + "Grid", hashMap));
        chartAxisProperties.setShowTickMarkLabels((Boolean)hashMap.get(string2 + "ShowTickMarkLabels"));
        chartAxisProperties.setTickMarkPen(this.getPen(string2 + "TickMark", hashMap));
        chartAxisProperties.setTickMarkType(((Number)hashMap.get(string2 + "TickMarkType")).intValue());
        chartAxisProperties.setTickMarkLength(((Number)hashMap.get(string2 + "TickMarkLength")).intValue());
        chartAxisProperties.setMinorTickMarkType(((Number)hashMap.get(string2 + "MinorTickMarkType")).intValue());
        chartAxisProperties.setMinorTickMarkLength(((Number)hashMap.get(string2 + "MinorTickMarkLength")).intValue());
        chartAxisProperties.setLabelTextStyle(this.getTextStyle(string2 + "Label", hashMap));
        chartAxisProperties.setLabelEveryNTickMarks(((Number)hashMap.get(string2 + "LabelEveryNTickMarks")).intValue());
        chartAxisProperties.setNumOfLabels(((Number)hashMap.get(string2 + "NumOfLabels")).intValue());
        chartAxisProperties.setBestEffort((Boolean)hashMap.get(string2 + "IsBestEffort"));
        chartAxisProperties.setLabelAxisGap(((Number)hashMap.get(string2 + "LabelAxisGap")).intValue());
        chartAxisProperties.setPlacement(((Number)hashMap.get(string2 + "Placement")).intValue());
        chartAxisProperties.setLabelPosition(((Number)hashMap.get(string2 + "LabelPosition")).intValue());
        chartAxisProperties.setLabelFontAutomaticOrientation((Boolean)hashMap.get(string2 + "LabelFontAutomaticOrientation"));
        chartAxisProperties.setShowLabelTips((Boolean)hashMap.get(string2 + "ShowLabelTips"));
        chartAxisProperties.setPositionAxis(((Number)hashMap.get(string2 + "Position")).intValue());
        if (hashMap.get(string2 + "ScrollableChart") != null) {
            chartAxisProperties.setScrollableChart((Boolean)hashMap.get(string2 + "ScrollableChart"));
        }
        if (hashMap.get(string2 + "ScrollableVisibleValue") != null) {
            chartAxisProperties.setScrollableVisibleValue(((Number)hashMap.get(string2 + "ScrollableVisibleValue")).intValue());
        }
        if (hashMap.get(string2 + "DisplayAreaPercentage") != null) {
            chartAxisProperties.setDisplayAreaPercent(((Number)hashMap.get(string2 + "DisplayAreaPercentage")).intValue());
        }
        if (hashMap.get(string2 + "CorrelateAxisInMajorTickMark") != null) {
            chartAxisProperties.getMajorTickMarkProperties().setCorrelateTickMark((Boolean)hashMap.get(string2 + "CorrelateAxisInMajorTickMark"));
        }
        if (hashMap.get(string2 + "CorrelateAxisInMinorTickMark") != null) {
            chartAxisProperties.getMinorTickMarkProperties().setCorrelateTickMark((Boolean)hashMap.get(string2 + "CorrelateAxisInMinorTickMark"));
        }
        if (hashMap.get(string2 + "CorrelateFontInMinorTickMark") != null) {
            chartAxisProperties.getMinorTickMarkProperties().setCorrelateLabel((Boolean)hashMap.get(string2 + "CorrelateFontInMinorTickMark"));
        }
        if (hashMap.get(string2 + "MinorTickMarkPenStyle") != null) {
            chartAxisProperties.getMinorTickMarkProperties().setTickMarkPen(this.getPen(string2 + "MinorTickMark", hashMap));
        }
        if (hashMap.get(string2 + "ShowMinorTickMarkLabels") != null) {
            chartAxisProperties.getMinorTickMarkProperties().setShowTickMarkLabels((Boolean)hashMap.get(string2 + "ShowMinorTickMarkLabels"));
        }
        if (hashMap.get(string2 + "NumOfMinorTickMarkLabels") != null) {
            chartAxisProperties.getMinorTickMarkProperties().setLabelNumber(((Number)hashMap.get(string2 + "NumOfMinorTickMarkLabels")).intValue());
        }
        if (hashMap.get(string2 + "LabelEveryNMinorTickMarks") != null) {
            chartAxisProperties.getMinorTickMarkProperties().setLabelEveryTickMark(((Number)hashMap.get(string2 + "LabelEveryNMinorTickMarks")).intValue());
        }
        chartAxisProperties.getMinorTickMarkProperties().setTickMarkLabel(this.getTextStyle(string2 + "MinorLabel", hashMap));
        if (hashMap.get(string2 + "MinorLabelFontAutomaticOrientation") != null) {
            chartAxisProperties.getMinorTickMarkProperties().setAutoRotate((Boolean)hashMap.get(string2 + "MinorLabelFontAutomaticOrientation"));
        }
        if (hashMap.get(string2 + "ScaleUseConstant") != null) {
            chartAxisProperties.getUnitProperties().setUseConstantInterval((Boolean)hashMap.get(string2 + "ScaleUseConstant"));
        }
        if (hashMap.get(string2 + "ScaleMinValue") != null) {
            chartAxisProperties.getUnitProperties().setStart((Boolean)hashMap.get(string2 + "ScaleMinValueAuto"), hashMap.get(string2 + "ScaleMinValue").toString());
        }
        if (hashMap.get(string2 + "ScaleMaxValue") != null) {
            chartAxisProperties.getUnitProperties().setEnd((Boolean)hashMap.get(string2 + "ScaleMaxValueAuto"), hashMap.get(string2 + "ScaleMaxValue").toString());
        }
        if (hashMap.get(string2 + "ScaleMajorInterval") != null) {
            chartAxisProperties.getUnitProperties().setMajorUnit((Boolean)hashMap.get(string2 + "ScaleMajorUnitAuto"), hashMap.get(string2 + "ScaleMajorInterval").toString());
        }
        if (hashMap.get(string2 + "ScaleMinorInterval") != null) {
            chartAxisProperties.getUnitProperties().setMinorUnit((Boolean)hashMap.get(string2 + "ScaleMinorUnitAuto"), hashMap.get(string2 + "ScaleMinorInterval").toString());
        }
        if (hashMap.get(string2 + "ScaleValueSQLType") != null) {
            chartAxisProperties.getUnitProperties().setDataType(((Number)hashMap.get(string2 + "ScaleValueSQLType")).intValue());
        }
        if (hashMap.get(string2 + "ScaleMajorIntervalUnit") != null) {
            chartAxisProperties.getUnitProperties().setMajorUnitDateType(((Number)hashMap.get(string2 + "ScaleMajorIntervalUnit")).intValue());
        }
        if (hashMap.get(string2 + "ScaleMinorIntervalUnit") != null) {
            chartAxisProperties.getUnitProperties().setMinorUnitDateType(((Number)hashMap.get(string2 + "ScaleMinorIntervalUnit")).intValue());
        }
        if (hashMap.get(string2 + "DataFilterInMinorTickMark") != null) {
            chartAxisProperties.setMinorDataFilter(this.mapChartDataFilter(hashMap.get(string2 + "DataFilterInMinorTickMark").toString()));
        }
        if (hashMap.get(string2 + "CorrelateDataFilterInMinorTickMark") != null) {
            chartAxisProperties.getMinorTickMarkProperties().setCorelateLabelFormat((Boolean)hashMap.get(string2 + "CorrelateDataFilterInMinorTickMark"));
        }
        if (hashMap.get(string2 + "ShowChartInScroll") != null) {
            chartAxisProperties.setIsShowChartInScroll((Boolean)hashMap.get(string2 + "ShowChartInScroll"));
        }
        if (hashMap.get(string2 + "AutoNumOfMinorTickMarkLabels") != null) {
            chartAxisProperties.getMinorTickMarkProperties().setAutoLabelNumber((Boolean)hashMap.get(string2 + "AutoNumOfMinorTickMarkLabels"));
        }
        if (bl) {
            ((ChartNumericAxisProperties)chartAxisProperties).setMaxValue(((Number)hashMap.get(string2 + "MaxValue")).doubleValue());
            ((ChartNumericAxisProperties)chartAxisProperties).setMinValue(((Number)hashMap.get(string2 + "MinValue")).doubleValue());
            ((ChartNumericAxisProperties)chartAxisProperties).setNumOfTickMarks(((Number)hashMap.get(string2 + "NumOfTickMarks")).intValue());
            ((ChartNumericAxisProperties)chartAxisProperties).setAxisIncrement(((Number)hashMap.get(string2 + "Increment")).doubleValue());
            ((ChartNumericAxisProperties)chartAxisProperties).setLabelStartValue(((Number)hashMap.get(string2 + "LabelStartValue")).doubleValue());
            ((ChartNumericAxisProperties)chartAxisProperties).setUseLabelStartValue((Boolean)hashMap.get(string2 + "UseLabelStartValue"));
            ((ChartNumericAxisProperties)chartAxisProperties).setIsShowPercent((Boolean)hashMap.get(string2 + "ShowPercent"));
        }
        if (hashMap.get("AutoScaleYAxis") != null && hashMap.get("AutoScaleYAxis") instanceof Boolean) {
            chartAxisProperties.setAutoScaleYAxis((Boolean)hashMap.get("AutoScaleYAxis"));
        }
        return chartAxisProperties;
    }

    protected ChartWallProperties getWallProperties(String string, HashMap hashMap) {
        String string2 = string;
        ChartWallProperties chartWallProperties = new ChartWallProperties();
        chartWallProperties.setBorder(this.getPen(string2 + "Border", hashMap));
        chartWallProperties.setPattern1(this.getFillPattern(string2 + "Fill", hashMap));
        chartWallProperties.setPattern2(this.getFillPattern(string2 + "BoundFill", hashMap));
        return chartWallProperties;
    }

    protected ChartFillPattern getFillPattern(String string, HashMap hashMap) {
        String string2 = string + "Pattern";
        ChartFillPattern chartFillPattern = null;
        switch (((Number)hashMap.get(string2 + "Type")).intValue()) {
            case 1: {
                chartFillPattern = new ChartColorPattern(this.mapStringToColor((String)hashMap.get(string2 + "Color")));
                ((ChartColorPattern)chartFillPattern).setAlpha((float)((Number)hashMap.get(string2 + "Transparency")).intValue() / 100.0f);
                break;
            }
            case 2: {
                chartFillPattern = new ChartTexturePattern(((Number)hashMap.get(string2 + "TextureStyle")).intValue(), new ChartColorPattern(this.mapStringToColor((String)hashMap.get(string2 + "TextureForeColor"))), new ChartColorPattern(this.mapStringToColor((String)hashMap.get(string2 + "TextureBackColor"))));
                ((ChartTexturePattern)chartFillPattern).setAlpha((float)((Number)hashMap.get(string2 + "Transparency")).intValue() / 100.0f);
                break;
            }
            case 3: {
                chartFillPattern = new ChartGradientPattern(((Number)hashMap.get(string2 + "GradientStyle")).intValue());
                ((ChartGradientPattern)chartFillPattern).setStartColor(new ChartColorPattern(this.mapStringToColor((String)hashMap.get(string2 + "GradientStartColor"))));
                ((ChartGradientPattern)chartFillPattern).setEndColor(new ChartColorPattern(this.mapStringToColor((String)hashMap.get(string2 + "GradientEndColor"))));
                ((ChartGradientPattern)chartFillPattern).setStartPoint(new Point2D.Float((float)((Number)hashMap.get(string2 + "GradientStartX")).intValue() / 100.0f, 1.0f - (float)((Number)hashMap.get(string2 + "GradientStartY")).intValue() / 100.0f));
                ((ChartGradientPattern)chartFillPattern).setEndPoint(new Point2D.Float((float)((Number)hashMap.get(string2 + "GradientEndX")).intValue() / 100.0f, 1.0f - (float)((Number)hashMap.get(string2 + "GradientEndY")).intValue() / 100.0f));
                ((ChartGradientPattern)chartFillPattern).setAlpha((float)((Number)hashMap.get(string2 + "Transparency")).intValue() / 100.0f);
                break;
            }
            case 4: {
                String string3 = (String)hashMap.get(string2 + "ImageFile");
                if (string3 == null || string3.length() <= 0) break;
                chartFillPattern = new ChartCustomizedPattern(string3);
            }
        }
        return chartFillPattern;
    }

    protected ChartPenStyle getPen(String string, HashMap hashMap) {
        String string2 = string + "Pen";
        ChartPenStyle chartPenStyle = new ChartPenStyle();
        chartPenStyle.setDashPattern(((Number)hashMap.get(string2 + "Style")).intValue());
        chartPenStyle.setPenWidth(((Number)hashMap.get(string2 + "Thickness")).intValue());
        chartPenStyle.setEndCaps(((Number)hashMap.get(string2 + "EndCaps")).intValue());
        chartPenStyle.setLineJoints(((Number)hashMap.get(string2 + "LineJoint")).intValue());
        chartPenStyle.setOutlined((Boolean)hashMap.get(string2 + "Outlined"));
        chartPenStyle.setVariabledDash((Boolean)hashMap.get(string2 + "VariabledDash"));
        ChartColorPattern chartColorPattern = new ChartColorPattern();
        chartColorPattern.setColor(this.mapStringToColor((String)hashMap.get(string2 + "Color")));
        chartColorPattern.setAlpha((float)((Number)hashMap.get(string2 + "Transparency")).intValue() / 100.0f);
        chartPenStyle.setPenColor(chartColorPattern);
        if (string.equals("PlatformBackgroundBorder")) {
            chartPenStyle.setJointRadiusPixel(((Number)hashMap.get(string2 + "LineJointRadius")).intValue());
        }
        return chartPenStyle;
    }

    protected ChartTextStyle getTextStyle(String string, HashMap hashMap) {
        String string2 = string + "Text";
        ChartTextStyle chartTextStyle = new ChartTextStyle();
        chartTextStyle.setFontName((String)hashMap.get(string2 + "FontName"));
        chartTextStyle.setFontSize(((Number)hashMap.get(string2 + "FontSize")).intValue());
        chartTextStyle.setFontStyle(((Number)hashMap.get(string2 + "FontStyle")).intValue());
        chartTextStyle.setUnderline(((Number)hashMap.get(string2 + "Underline")).intValue());
        chartTextStyle.setStrikethrough(((Number)hashMap.get(string2 + "Strikethrough")).intValue());
        chartTextStyle.setShearing((float)((Number)hashMap.get(string2 + "Shearing")).intValue() / 100.0f);
        chartTextStyle.setRotation(((Number)hashMap.get(string2 + "Rotation")).doubleValue() * Math.PI / 180.0);
        chartTextStyle.setFontPen(this.getPen(string2, hashMap));
        chartTextStyle.setFontColor(this.getFillPattern(string2, hashMap));
        ChartRenderTools.setFontSpecialEffect1(chartTextStyle, ((Number)hashMap.get(string2 + "SpecialEffect1")).intValue());
        ChartRenderTools.setFontSpecialEffect2(chartTextStyle, ((Number)hashMap.get(string2 + "SpecialEffect2")).intValue());
        chartTextStyle.setWordWrapper((Boolean)hashMap.get(string2 + "WordWrap"));
        return chartTextStyle;
    }

    protected ChartBackground getBackground(String string, HashMap hashMap) {
        String string2 = string + "Background";
        ChartBackground chartBackground = new ChartBackground();
        chartBackground.setBorderStyle(((Number)hashMap.get(string2 + "BorderStyle")).intValue());
        chartBackground.setPen(this.getPen(string2 + "Border", hashMap));
        chartBackground.setPattern(this.getFillPattern(string2 + "Fill", hashMap));
        chartBackground.setTop((float)((Number)hashMap.get(string2 + "Top")).intValue() / 100.0f);
        chartBackground.setLeft((float)((Number)hashMap.get(string2 + "Left")).intValue() / 100.0f);
        chartBackground.setRight((float)((Number)hashMap.get(string2 + "Right")).intValue() / 100.0f);
        chartBackground.setBottom((float)((Number)hashMap.get(string2 + "Bottom")).intValue() / 100.0f);
        return chartBackground;
    }

    public ChartPlatform getChartPlatform() {
        if (!this.VALUELABEL_POSITION_ENUMERATIONS) {
            this.init();
        }
        if (this.appletProperties.get("Version") == null) {
            this.def.readFromString((String)this.appletProperties.get("ChartDefinition"));
        }
        if (this.CategoryKey(this.def)) {
            this.platformP.setShowLegend(false);
        }
        if (this.def.isSparklineChart()) {
            this.platformP.setShowLegend(false);
            if (this.I != null && this.paperP.getAxisXProperties() != null) {
                this.paperP.getAxisXProperties().setShowGrid(false);
                this.paperP.setShowAxisX(false);
            }
            if (this.I != null && this.paperP.getAxisYProperties() != null) {
                this.paperP.getAxisYProperties().setShowGrid(false);
                this.paperP.setShowAxisY(false);
            }
        }
        ChartDataSetModel chartDataSetModel = this.createChartDataSetModel(this.def, this.appletProperties);
        ChartPlatform chartPlatform = new ChartPlatform(this.def, chartDataSetModel, this.platformP);
        chartPlatform.setBounds(this.CategoryKey);
        ChartCoordinatePaper chartCoordinatePaper = this.def.is3DEffect() ? new Chart3DPaper(chartPlatform, this.paperP) : new Chart2DPaper(chartPlatform, this.paperP);
        chartCoordinatePaper.setBounds(this.I);
        if (this.legendP != null) {
            ChartLegend chartLegend = new ChartLegend(chartPlatform, this.legendP);
            chartLegend.setBounds(this.SEDU);
            chartPlatform.add(chartLegend);
        }
        chartPlatform.add(chartCoordinatePaper);
        if (this.BUILTINICON != null) {
            for (int i = 0; i < this.BUILTINICON.size(); ++i) {
                ChartLabel chartLabel = new ChartLabel((ChartLabelProperties)this.BUILTINICON.get(i));
                chartLabel.setBounds((Rectangle)this.SeriesKey.get(i));
                chartPlatform.add((ChartComponent)chartLabel, 1);
            }
        }
        if (this.scrollInfo != null) {
            chartPlatform.setScrollbarInfo(this.scrollInfo);
        }
        chartPlatform.setLegendLabelStart(this.legendScrollId);
        chartPlatform.resolution = this.res;
        this.VALUELABEL_POSITION_ENUMERATIONS = false;
        return chartPlatform;
    }

    protected ChartDataSetModel createChartDataSetModel(ChartDefinition chartDefinition, HashMap hashMap) {
        int n;
        Object object;
        ArrayList arrayList = (ArrayList)hashMap.get(ChartRenderTools.CategoryKey);
        ArrayList arrayList2 = (ArrayList)hashMap.get(ChartRenderTools.SeriesKey);
        ArrayList arrayList3 = (ArrayList)hashMap.get(ChartRenderTools.ValueKey);
        ChartDefaultValueMap chartDefaultValueMap = new ChartDefaultValueMap();
        ChartDataSetModel chartDataSetModel = new ChartDataSetModel(arrayList, arrayList2, arrayList3, chartDefaultValueMap, chartDefinition.getChartDataSetInfos(), chartDefinition.getSeparatingIndex());
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        n2 = ((Number)hashMap.get("CategoryStartOffset")).intValue();
        n3 = ((Number)hashMap.get("CategoryEndOffset")).intValue();
        n4 = ((Number)hashMap.get("SeriesStartOffset")).intValue();
        n5 = ((Number)hashMap.get("SeriesEndOffset")).intValue();
        int n6 = ChartDefinition.version;
        if (n6 >= 257) {
            chartDataSetModel.setIndexValueTypes(chartDefinition.getIndexedValueTypes());
            chartDataSetModel.setAllShowValue(chartDefinition.getAllShowValues());
            chartDataSetModel.initSpecialValue();
        }
        chartDataSetModel.setDataWindow(n2, n4, n3, n5);
        boolean bl = (Boolean)hashMap.get("IsBVData");
        if (bl) {
            object = (List)hashMap.get("ValueName");
            n = object.size();
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = (String)object.get(i);
            }
            chartDataSetModel.setValuesName(stringArray);
        } else {
            object = (List)hashMap.get("ValueName");
            if (object != null && object.size() > 0) {
                n = object.size();
                String[] stringArray = new String[n];
                for (int i = 0; i < n; ++i) {
                    stringArray[i] = (String)object.get(i);
                }
                chartDataSetModel.setValuesName(stringArray);
            } else {
                chartDataSetModel.setValuesName(chartDefinition.getIndexedValueNames());
            }
        }
        if (n6 >= 257) {
            chartDataSetModel.addValueNames();
            if (bl) {
                chartDataSetModel.replaceShowValueNames();
            }
        }
        chartDataSetModel.setReverseSeries((Boolean)hashMap.get("ReverseSeries"));
        chartDataSetModel.setReverseCategory((Boolean)hashMap.get("ReverseCategory"));
        if (hashMap.get("RoundingMode") != null) {
            this.roundModeEnum = (Integer)hashMap.get("RoundingMode");
        }
        try {
            object = null;
            object = ChartRenderTools.mapChartDataFilter((String)hashMap.get("CategoryFilter"));
            if (object != null) {
                ((ChartDataFilter)object).setRoundMode(this.roundModeEnum);
                if (this.timeZoneID != null) {
                    ((ChartDataFilter)object).setTimeZone(TimeZone.getTimeZone(this.timeZoneID));
                }
            }
            chartDataSetModel.setCategoryFilter((ChartDataFilter)object);
            object = ChartRenderTools.mapChartDataFilter((String)hashMap.get("SeriesFilter"));
            if (object != null) {
                ((ChartDataFilter)object).setRoundMode(this.roundModeEnum);
                if (this.timeZoneID != null) {
                    ((ChartDataFilter)object).setTimeZone(TimeZone.getTimeZone(this.timeZoneID));
                }
            }
            chartDataSetModel.setSeriesFilter((ChartDataFilter)object);
            object = ChartRenderTools.mapChartDataFilter((String)hashMap.get("PrimaryDataFilter"));
            if (object != null) {
                ((ChartDataFilter)object).setRoundMode(this.roundModeEnum);
                if (this.timeZoneID != null) {
                    ((ChartDataFilter)object).setTimeZone(TimeZone.getTimeZone(this.timeZoneID));
                }
            }
            chartDataSetModel.setPrimFilter((ChartDataFilter)object);
            object = ChartRenderTools.mapChartDataFilter((String)hashMap.get("SecondaryDataFilter"));
            if (object != null) {
                ((ChartDataFilter)object).setRoundMode(this.roundModeEnum);
                if (this.timeZoneID != null) {
                    ((ChartDataFilter)object).setTimeZone(TimeZone.getTimeZone(this.timeZoneID));
                }
            }
            chartDataSetModel.setSecFilter((ChartDataFilter)object);
            object = ChartRenderTools.mapChartDataFilter((String)hashMap.get("HintFilter"));
            if (object != null) {
                ((ChartDataFilter)object).setRoundMode(this.roundModeEnum);
                if (this.timeZoneID != null) {
                    ((ChartDataFilter)object).setTimeZone(TimeZone.getTimeZone(this.timeZoneID));
                }
            } else {
                object = new ChartDataFilter();
                ChartDataFilter.setDefaultNumberFormat((ChartDataFilter)object);
            }
            if (object != null) {
                ((ChartDataFilter)object).setRoundMode(this.roundModeEnum);
                if (this.timeZoneID != null) {
                    ((ChartDataFilter)object).setTimeZone(TimeZone.getTimeZone(this.timeZoneID));
                }
            }
            chartDataSetModel.setHintFilter((ChartDataFilter)object);
            object = ChartRenderTools.mapChartDataFilter((String)hashMap.get("HintPercentFilter"));
            if (object != null) {
                ((ChartDataFilter)object).setRoundMode(this.roundModeEnum);
                if (this.timeZoneID != null) {
                    ((ChartDataFilter)object).setTimeZone(TimeZone.getTimeZone(this.timeZoneID));
                }
            }
            chartDataSetModel.setHintPercentFilter((ChartDataFilter)object);
        }
        catch (Exception exception) {
            // empty catch block
        }
        chartDataSetModel.setSwapGroup((Boolean)hashMap.get("SwapGroup"));
        object = null;
        String string = null;
        if (bl) {
            if (hashMap.get("CategoryDisplayName") != null) {
                object = (String)hashMap.get("CategoryDisplayName");
            }
            if (hashMap.get("SeriesDisplayName") != null) {
                string = (String)hashMap.get("SeriesDisplayName");
            }
        } else {
            object = hashMap.get("CategoryDisplayName") != null ? (String)hashMap.get("CategoryDisplayName") : chartDefinition.getCategory();
            string = hashMap.get("SeriesDisplayName") != null ? (String)hashMap.get("SeriesDisplayName") : chartDefinition.getSeries();
        }
        if (chartDataSetModel.isSwapGroup() && !chartDefinition.isDetail()) {
            chartDataSetModel.setCategoryNmae(string);
            chartDataSetModel.setSeriesN((String)object);
        } else {
            chartDataSetModel.setCategoryNmae((String)object);
            chartDataSetModel.setSeriesN(string);
        }
        chartDataSetModel.init();
        return chartDataSetModel;
    }

    protected Color mapStringToColor(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string;
        if (string.length() > 2 && string.substring(0, 2).equals("0x")) {
            return new Color(Integer.parseInt(string.substring(2), 16));
        }
        return new Color(Integer.parseInt(string));
    }

    protected ChartFillPattern[] mapStringToPatterns(String string) {
        String[] stringArray = string.split("\u0007");
        ChartFillPattern[] chartFillPatternArray = new ChartFillPattern[stringArray.length];
        for (int i = 0; i < chartFillPatternArray.length; ++i) {
            try {
                chartFillPatternArray[i] = ChartRenderTools.mapFillPattern(stringArray[i]);
                continue;
            }
            catch (Exception exception) {
                chartFillPatternArray[i] = null;
            }
        }
        return chartFillPatternArray;
    }

    protected int[] mapValueLabelPositions(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\u0007");
        int n = stringTokenizer.countTokens();
        int[] nArray = new int[n];
        if (string != null && n > 0) {
            for (int i = 0; i < n; ++i) {
                nArray[i] = (Integer)ChartPropertyValues.VALUELABEL_POSITION_ENUMERATIONS.get(stringTokenizer.nextToken());
            }
        }
        return nArray;
    }

    protected int[] mapListToIntArray(List list) {
        int[] nArray = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            nArray[i] = Integer.parseInt(list.get(i).toString());
        }
        return nArray;
    }

    protected int[] mapIconStyles(String string) {
        int n = string.length() / 2;
        int[] nArray = null;
        if (n > 0) {
            nArray = new int[n];
        }
        for (int i = 0; i < n; ++i) {
            String string2 = string.substring(i * 2, i * 2 + 2);
            nArray[i] = Integer.valueOf(string2);
        }
        return nArray;
    }

    public String getHyperLink() {
        return (String)this.appletProperties.get("HyperLink");
    }

    public String getXHyperLink() {
        return (String)this.appletProperties.get("XHyperLink");
    }

    public String getZHyperLink() {
        return (String)this.appletProperties.get("ZHyperLink");
    }

    private boolean CategoryKey(ChartDefinition chartDefinition) {
        ChartDataSetInfo[] chartDataSetInfoArray = chartDefinition.getChartDataSetInfos();
        int n = chartDataSetInfoArray.length;
        for (int i = 0; i < n; ++i) {
            if (ChartTypeInfo.getPrimType(chartDataSetInfoArray[i].getChartType()) == 10) continue;
            return false;
        }
        return true;
    }

    protected ChartFillPattern getFillPatternNoFill(String string, HashMap hashMap) {
        String string2 = string;
        ChartFillPattern chartFillPattern = null;
        switch (((Number)hashMap.get(string2 + "Type")).intValue()) {
            case 1: {
                chartFillPattern = new ChartColorPattern(this.mapStringToColor((String)hashMap.get(string2 + "Color")));
                ((ChartColorPattern)chartFillPattern).setAlpha((float)((Number)hashMap.get(string2 + "Transparency")).intValue() / 100.0f);
                break;
            }
            case 2: {
                chartFillPattern = new ChartTexturePattern(((Number)hashMap.get(string2 + "TextureStyle")).intValue(), new ChartColorPattern(this.mapStringToColor((String)hashMap.get(string2 + "TextureForeColor"))), new ChartColorPattern(this.mapStringToColor((String)hashMap.get(string2 + "TextureBackColor"))));
                ((ChartTexturePattern)chartFillPattern).setAlpha((float)((Number)hashMap.get(string2 + "Transparency")).intValue() / 100.0f);
                break;
            }
            case 3: {
                chartFillPattern = new ChartGradientPattern(((Number)hashMap.get(string2 + "GradientStyle")).intValue());
                ((ChartGradientPattern)chartFillPattern).setStartColor(new ChartColorPattern(this.mapStringToColor((String)hashMap.get(string2 + "GradientStartColor"))));
                ((ChartGradientPattern)chartFillPattern).setEndColor(new ChartColorPattern(this.mapStringToColor((String)hashMap.get(string2 + "GradientEndColor"))));
                ((ChartGradientPattern)chartFillPattern).setStartPoint(new Point2D.Float((float)((Number)hashMap.get(string2 + "GradientStartX")).intValue() / 100.0f, 1.0f - (float)((Number)hashMap.get(string2 + "GradientStartY")).intValue() / 100.0f));
                ((ChartGradientPattern)chartFillPattern).setEndPoint(new Point2D.Float((float)((Number)hashMap.get(string2 + "GradientEndX")).intValue() / 100.0f, 1.0f - (float)((Number)hashMap.get(string2 + "GradientEndY")).intValue() / 100.0f));
                ((ChartGradientPattern)chartFillPattern).setAlpha((float)((Number)hashMap.get(string2 + "Transparency")).intValue() / 100.0f);
                break;
            }
            case 4: {
                String string3 = (String)hashMap.get(string2 + "ImageFile");
                if (string3 == null || string3.length() <= 0) break;
                chartFillPattern = new ChartCustomizedPattern(string3);
            }
        }
        return chartFillPattern;
    }

    public ChartShowValueConditionControl getConditionalControl(HashMap hashMap) {
        ChartShowValueConditionControl chartShowValueConditionControl = null;
        if (hashMap != null) {
            chartShowValueConditionControl = new ChartShowValueConditionControl();
            chartShowValueConditionControl.initAppletP(hashMap);
        }
        return chartShowValueConditionControl;
    }

    protected int[] mapStringToIntArray(String string) {
        String[] stringArray = string.split("[^0-9]");
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = Integer.parseInt(stringArray[i]);
        }
        return nArray;
    }

    public ChartDataFilter mapChartDataFilter(String string) {
        ChartDataFilter chartDataFilter = null;
        if (string != null) {
            String[] stringArray = string.split("\u0007");
            chartDataFilter = new ChartDataFilter();
            Vector<Object[]> vector = new Vector<Object[]>();
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                Object[] objectArray = new Object[2];
                if (string2.length() < 2) {
                    vector.add(null);
                    continue;
                }
                objectArray[0] = new Integer(Integer.valueOf(string2.substring(0, 1)));
                objectArray[1] = string2.substring(1);
                vector.add(objectArray);
            }
            chartDataFilter.setFilters(vector);
        }
        return chartDataFilter;
    }

    protected Vector toStringVector(String string) {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = string.split("\u0007");
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            vector.add(string2);
        }
        return vector;
    }

    private boolean FILLPATTERN_PREFIX(String string) {
        return string.equalsIgnoreCase("true");
    }

    private int I(String string, String string2) {
        try {
            int n = Integer.parseInt(string);
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    private float NO_COLOR(String string, String string2) {
        try {
            float f = Float.parseFloat(string);
            return f;
        }
        catch (NumberFormatException numberFormatException) {
            return 0.0f;
        }
    }

    private double PENSTYLE_PREFIX(String string, String string2) {
        try {
            double d = Double.parseDouble(string);
            return d;
        }
        catch (NumberFormatException numberFormatException) {
            return 0.0;
        }
    }
}

