/*
 * Decompiled with CFR 0.152.
 */
package jet.xml;

import java.io.File;
import java.io.PrintStream;
import java.io.PrintWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import jet.log.JRLogger;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.ParserAdapter;
import org.xml.sax.helpers.ParserFactory;
import org.xml.sax.helpers.XMLReaderFactory;

public class Validate {
    private PrintWriter C;
    private int SEDU = 0;
    private final String append = "  ";
    private String createXMLReader = null;
    private String err = null;
    private static JRLogger error = JRLogger.getLogger(Validate.class.getName());
    public String parserName = null;
    protected static final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";
    protected static final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";
    protected static final String SCHEMA_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/schema";
    protected static final String SCHEMA_FULL_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";

    public Validate(String string) {
        this(string + ".xml", string + ".xsd");
    }

    public Validate(String string, String string2) {
        this.createXMLReader = string;
        this.err = string2;
    }

    public boolean JAXPDOMCheck() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setValidating(true);
            try {
                documentBuilderFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                System.err.println("Error: JAXP DocumentBuilderFactory attribute not recognized: http://java.sun.com/xml/jaxp/properties/schemaLanguage");
                System.err.println("Check to see if parser conforms to JAXP 1.2 spec.");
                System.exit(1);
            }
            if (this.err != null) {
                documentBuilderFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", new File(this.err));
            }
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setErrorHandler(new MyErrorHandler(System.err));
            Document document = documentBuilder.parse(new File(this.createXMLReader));
            return document != null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean JAXPSAXCheck() {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            sAXParserFactory.setValidating(true);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            try {
                sAXParser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                System.err.println("Error: JAXP SAXParser property not recognized: http://java.sun.com/xml/jaxp/properties/schemaLanguage");
                System.err.println("Check to see if parser conforms to JAXP 1.2 spec.");
                System.exit(1);
            }
            if (this.err != null) {
                sAXParser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaSource", new File(this.err));
            }
            XMLReader xMLReader = sAXParser.getXMLReader();
            xMLReader.setContentHandler(new DefaultHandler());
            xMLReader.setErrorHandler(new MyErrorHandler(System.err));
            xMLReader.parse(Validate.C(this.createXMLReader));
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private static String C(String string) {
        String string2 = new File(string).getAbsolutePath();
        if (File.separatorChar != '/') {
            string2 = string2.replace(File.separatorChar, '/');
        }
        if (!string2.startsWith("/")) {
            string2 = "/" + string2;
        }
        return "file:" + string2;
    }

    public boolean xercesSAXCheck() {
        XMLReader xMLReader = null;
        if (this.parserName != null) {
            try {
                xMLReader = XMLReaderFactory.createXMLReader(this.parserName);
            }
            catch (Exception exception) {
                try {
                    Parser parser = ParserFactory.makeParser(this.parserName);
                    xMLReader = new ParserAdapter(parser);
                    System.err.println("warning: Features and properties not supported on SAX1 parsers.");
                }
                catch (Exception exception2) {
                    xMLReader = null;
                    System.err.println("error: Unable to instantiate parser (" + this.parserName + ")");
                }
            }
        }
        try {
            if (xMLReader == null) {
                xMLReader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            }
            xMLReader.setFeature(VALIDATION_FEATURE_ID, true);
            xMLReader.setFeature(SCHEMA_VALIDATION_FEATURE_ID, true);
            xMLReader.setFeature(SCHEMA_FULL_CHECKING_FEATURE_ID, true);
            xMLReader.setProperty("http://java.sun.com/xml/jaxp/properties/schemaSource", this.err);
            xMLReader.setContentHandler(new DefaultHandler());
            xMLReader.setErrorHandler(new MyErrorHandler(System.err));
            xMLReader.parse(this.createXMLReader);
            return true;
        }
        catch (Exception exception) {
            if (error.isErrorEnabled()) {
                error.error(exception.toString());
            }
            return false;
        }
    }

    public boolean xercesDomCheck() {
        try {
            DOMParser dOMParser = new DOMParser();
            dOMParser.setFeature(VALIDATION_FEATURE_ID, true);
            dOMParser.setFeature(SCHEMA_VALIDATION_FEATURE_ID, true);
            dOMParser.setFeature(SCHEMA_FULL_CHECKING_FEATURE_ID, true);
            dOMParser.parse(this.createXMLReader);
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private static void SEDU() {
        System.err.println("Usage: Validate <file>.xml");
        System.err.println("Do not add .xml!");
        System.exit(1);
    }

    private static class MyErrorHandler
    implements ErrorHandler {
        private PrintStream SEDU;

        MyErrorHandler(PrintStream printStream) {
            this.SEDU = printStream;
        }

        private String SEDU(SAXParseException sAXParseException) {
            String string = sAXParseException.getSystemId();
            if (string == null) {
                string = "null";
            }
            String string2 = "URI=" + string + " Line=" + sAXParseException.getLineNumber() + ": " + sAXParseException.getMessage();
            return string2;
        }

        @Override
        public void warning(SAXParseException sAXParseException) throws SAXException {
            this.SEDU.println("Warning: " + this.SEDU(sAXParseException));
        }

        @Override
        public void error(SAXParseException sAXParseException) throws SAXException {
            String string = "Error: " + this.SEDU(sAXParseException);
            throw new SAXException(string);
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            String string = "Fatal Error: " + this.SEDU(sAXParseException);
            throw new SAXException(string);
        }
    }
}

