/*
 * Decompiled with CFR 0.152.
 */
package timer;

import java.io.PrintStream;
import jet.log.JRLogger;

public class Clocker {
    private long SEDU;
    private long append;
    private static int currentTimeMillis = -1;
    private String debug = "";
    boolean indented = false;
    boolean paused = false;
    private static JRLogger destroy = JRLogger.getLogger(Clocker.class.getName());

    public Clocker() {
        this.reset();
        this.indent();
    }

    public Clocker(String string) {
        this();
        this.setPrompt(string);
    }

    public void unindent() {
        this.indented = false;
        --currentTimeMillis;
    }

    public void indent() {
        this.indented = true;
        ++currentTimeMillis;
    }

    public void destroy() {
        if (this.indented) {
            this.unindent();
        }
    }

    protected void finalize() {
        this.destroy();
    }

    public void reset() {
        this.SEDU = System.currentTimeMillis();
        this.paused = false;
    }

    public void pause() {
        this.append = System.currentTimeMillis();
        this.paused = true;
    }

    public void restart() {
        if (this.paused) {
            this.SEDU += System.currentTimeMillis() - this.append;
            this.paused = false;
        }
    }

    public long elapsed() {
        if (this.paused) {
            return this.append - this.SEDU;
        }
        return System.currentTimeMillis() - this.SEDU;
    }

    public void setPrompt(String string) {
        this.debug = string;
    }

    public void output(PrintStream printStream) {
        this.output(printStream, this.debug);
    }

    public void output(PrintStream printStream, String string) {
        if (destroy.isDebugEnabled()) {
            destroy.debug("Timer\n" + string + " ELAPSED: " + this.elapsed());
        }
    }

    public void output() {
        this.output(System.out, this.debug);
    }

    public void output(String string) {
        this.output(System.out, string);
    }
}

